#ifndef __ARCH_AC_H
#define __ARCH_AC_H

#include <ARCH/SPL.H>

#include <ARCH/SETUP.H>
#include <ARCH/ACDEF.H>

#include <SYS/TYPES.H>

#include <SPAD/SPLDEF.H>

__BEGIN_DECLS

#define SPLX_BELOW __SPLX_BELOW
#define SPL_X __SPL_X
#define SPL_BUSY __SPL_BUSY
#define SPLX_BUSY __SPLX_BUSY
#define RAISE_SPL __RAISE_SPL
#define RAISE_SPLX __RAISE_SPLX
#define LOWER_SPL __LOWER_SPL
#define LOWER_SPLX __LOWER_SPLX
#define TEST_SPL __TEST_SPL
#define TEST_SPLX __TEST_SPLX
#define SPLX_MIN __SPLX_MIN
#define SPLX_MAX __SPLX_MAX

/*
 * AST
 */

typedef struct __AST_STUB AST_STUB(void);

#define AST_HEAD		\
	AST_STUB *fn;		\
	unsigned long __next

typedef struct {
	AST_HEAD;
} AST;

#define DECL_AST(NAME, PL, STRUC)\
\
__u64 __attribute__((ret(".IF "__stringify(__DEBUG)">=2\nPOPL KERNEL$BPL\n.ENDIF\nJMP *%EDX"),cdecl)) __FN_##NAME (STRUC *RQ);\
\
extern AST_STUB NAME;\
\
__asm__ ("							\n\
.SECTION .text							\n\
.GLOBAL "#\NAME"						\n\
	.ALIGN	32						\n\
	MOVL	$KERNEL$SPL, %EDX				\n\
	MOVL	$(-1) << (("#\PL") + 1), %ECX			\n\
	CMPL	%ECX, %ESI					\n\
	JBE	8f						\n\
	MOVL	%ECX, (%EDX)					\n\
	STI							\n\
	JMP	7f						\n\
	.SPACE	5						\n\
	.LONG	"#\PL"						\n\
"#\NAME":							\n\
	MOVL	$KERNEL$SPL, %EDX				\n\
	MOVL	$(-1) << (("#\PL") + 1), %ECX			\n\
	CMPL	%ECX, %ESI					\n\
	JBE	9f						\n\
	MOVL	%ECX, (%EDX)					\n\
7:	TESTL	%ECX, 4(%EDX)					\n\
	JNZ	9f						\n\
	.IF	"__stringify(__DEBUG)" >= 2			\n\
	MOVL	$KERNEL$BPL, %EDX				\n\
	PUSHL	(%EDX)						\n\
	MOVL	%ECX, (%EDX)					\n\
	.ENDIF							\n\
.PREVIOUS							\n\
.SECTION .text.end						\n\
	.ALIGN	4						\n\
9:	MOVL	$1 << ("#\PL"), %ECX				\n\
	MOVL	$("#\PL") * 8 + KERNEL$AST_QUEUES, %EDX		\n\
	JMP	KERNEL$QUEUE_AST				\n\
	.ALIGN	4						\n\
8:	MOVL	$1 << ("#\PL"), %ECX				\n\
	MOVL	$("#\PL") * 8 + KERNEL$AST_QUEUES, %EDX		\n\
	JMP	KERNEL$QUEUE_IRQ_AST				\n\
.PREVIOUS							\n\
");\
\
__u64 __attribute__((ret(".IF "__stringify(__DEBUG)">=2\nPOPL KERNEL$BPL\n.ENDIF\nJMP *%EDX"),cdecl)) __FN_##NAME (STRUC *RQ)

#define AST_STUB_SPL(as, special)	(((unsigned long *)(as))[-1] + ((special) << 5))

#define CALL_AST(RQ)			\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"((RQ)->fn),"a"(RQ),"S"(KERNEL$SPL):"cc","memory");	\
} while (0)

#define RETURN_AST(RQ)				\
do {						\
	/*__debug_printf("AST: %s:%d->%p ", __FILE__, __LINE__, (RQ)->fn);*/\
	return __make64((__u32)(RQ), (__u32)(RQ)->fn);	\
} while (0)

#define RETURN					\
do {						\
	return __make64hi((__u32)KERNEL$PROCESS_PENDING_AST);\
} while (0)

/*
 * IORQ
 */

typedef struct __IO_STUB IO_STUB(void);

/* HARDCODED IN ASM.S IN "WAIT QUEUES" SECTION */

#define IORQ_HEAD		\
	AST_STUB *fn;		\
	unsigned long tmp1;	\
	unsigned long tmp2;	\
	unsigned long tmp3;	\
	long status

typedef struct __IORQ {
	IORQ_HEAD;
} IORQ;

#define __IORQ2WQ(RQ) ((WQ *)&(RQ)->tmp2)
#define __WQ2IORQ(WQ) ((IORQ *)((char *)(WQ) - (int)&((IORQ *)0)->tmp2))

#define CALL_IORQ_EXPR(RQ, OP)		\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	unsigned __spl;			\
	(RQ)->status = RQS_PROCESSING;	\
	__spl = KERNEL$SPL;		\
	RAISE_SPL(SPL_TOP);		\
	__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
} while (0)

#define CALL_IORQ(RQ, OP)		\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	unsigned __spl;			\
	(RQ)->status = RQS_PROCESSING;	\
	__spl = KERNEL$SPL;		\
	RAISE_SPL(SPL_TOP);		\
	__asm__ volatile ("CALL "#\OP:"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"a"(RQ),"S"(__spl):"cc","memory");	\
} while (0)

#define CALL_IORQ_LSTAT_EXPR(RQ, OP)	\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	unsigned __spl;			\
	__spl = KERNEL$SPL;		\
	RAISE_SPL(SPL_TOP);		\
	__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
} while (0)

#define CALL_IORQ_LSTAT(RQ, OP)		\
do {					\
	int __tmp1;			\
	int __tmp2;			\
	int __tmp3;			\
	unsigned __spl;			\
	__spl = KERNEL$SPL;		\
	RAISE_SPL(SPL_TOP);		\
	__asm__ volatile ("CALL "#\OP:"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"a"(RQ),"S"(__spl):"cc","memory");	\
} while (0)

#define CALL_IORQ_CANCELABLE_EXPR(RQ, OP, PRQ)		\
do {							\
	int __tmp1;					\
	int __tmp2;					\
	int __tmp3;					\
	unsigned __spl;					\
	(RQ)->status = RQS_PROCESSING;			\
	__spl = KERNEL$SPL;				\
	RAISE_SPL(SPL_TOP);				\
	if (__likely((PRQ)->status != RQS_WANTCANCEL)) {\
		(PRQ)->status = RQS_CHAINCANCELABLE;	\
		(PRQ)->tmp2 = (unsigned long)(RQ);	\
		__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"(OP),"a"(RQ),"S"(__spl):"cc","memory");	\
	} else {					\
		(RQ)->status = -EINTR;			\
		__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"((RQ)->fn),"a"(RQ),"S"(__spl):"cc","memory");	\
	}						\
} while (0)

#define CALL_IORQ_CANCELABLE(RQ, OP, PRQ)		\
do {							\
	int __tmp1;					\
	int __tmp2;					\
	int __tmp3;					\
	unsigned __spl;					\
	(RQ)->status = RQS_PROCESSING;			\
	__spl = KERNEL$SPL;				\
	RAISE_SPL(SPL_TOP);				\
	if (__likely((PRQ)->status != RQS_WANTCANCEL)) {\
		(PRQ)->status = RQS_CHAINCANCELABLE;	\
		(PRQ)->tmp2 = (unsigned long)(RQ);	\
		__asm__ volatile ("CALL "#\OP:"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"a"(RQ),"S"(__spl):"cc","memory");	\
	} else {					\
		(RQ)->status = -EINTR;			\
		__asm__ volatile ("CALL *%3":"=a"(__tmp1),"=c"(__tmp2),"=d"(__tmp3):"rm"((RQ)->fn),"a"(RQ),"S"(__spl):"cc","memory");	\
	}						\
} while (0)

#define RETURN_IORQ(RQ, OP)				\
do {							\
	/*__debug_printf("IORQ: %s:%d->%p ", __FILE__, __LINE__, (OP));*/\
	(RQ)->status = RQS_PROCESSING;			\
	RAISE_SPL(SPL_TOP);				\
	return __make64((__u32)(RQ), (__u32)(OP));	\
} while (0)

#define RETURN_IORQ_LSTAT(RQ, OP)			\
do {							\
	/*__debug_printf("IORQ: %s:%d->%p ", __FILE__, __LINE__, (OP));*/\
	RAISE_SPL(SPL_TOP);				\
	return __make64((__u32)(RQ), (__u32)(OP));	\
} while (0)

#define RETURN_IORQ_CANCELABLE(RQ, OP, PRQ)		\
do {							\
	/*__debug_printf("IORQ: %s:%d->%p ", __FILE__, __LINE__, (OP));*/\
	(RQ)->status = RQS_PROCESSING;			\
	RAISE_SPL(SPL_TOP);				\
	if (__likely((PRQ)->status != RQS_WANTCANCEL)) {\
		(PRQ)->status = RQS_CHAINCANCELABLE;	\
		(PRQ)->tmp2 = (unsigned long)(RQ);	\
		return __make64((__u32)(RQ), (__u32)(OP));\
	}						\
	(RQ)->status = -EINTR;				\
	RETURN_AST(RQ);					\
} while (0)

#define DECL_IOCALL(NAME, PL, STRUC)\
\
__u64 __attribute__((ret(".IF "__stringify(__DEBUG)">=2\nPOPL KERNEL$BPL\n.ENDIF\nJMP *%EDX"),cdecl)) __FN_##NAME (STRUC *RQ);\
\
extern IO_STUB NAME;\
\
__asm__ ("							\n\
.SECTION .text							\n\
.ALIGN	16							\n\
.GLOBAL "#\NAME"						\n\
"#\NAME":							\n\
	MOVL	$KERNEL$SPL, %EDX				\n\
	MOVL	$(-1) << (("#\PL") + 1), %ECX			\n\
	CMPL	%ECX, %ESI					\n\
	JBE	9f						\n\
	MOVL	%ECX, (%EDX)					\n\
	TESTL	%ECX, 4(%EDX)					\n\
	JNZ	9f						\n\
	.IF	"__stringify(__DEBUG)" >= 2			\n\
	MOVL	$KERNEL$BPL, %EDX				\n\
	PUSHL	(%EDX)						\n\
	MOVL	%ECX, (%EDX)					\n\
	.ENDIF							\n\
.PREVIOUS							\n\
.SECTION .text.end						\n\
	.ALIGN	4						\n\
9:	MOVL	$7f, 4(%EAX)					\n\
	ADDL	$4, %EAX					\n\
	MOVL	$1 << ("#\PL"), %ECX				\n\
	MOVL	$("#\PL") * 8 + KERNEL$AST_QUEUES, %EDX		\n\
	JMP	KERNEL$QUEUE_AST				\n\
	.ALIGN	4						\n\
7:	MOVL	$"#\NAME", (%EAX)				\n\
	SUBL	$4, %EAX					\n\
	.IF	"__stringify(__DEBUG)" >= 2			\n\
	PUSHL	KERNEL$BPL					\n\
	MOVL	$(-1) << (("#\PL") + 1), KERNEL$BPL		\n\
	.ENDIF							\n\
	JMP	__FN_"#\NAME"					\n\
.PREVIOUS							\n\
");\
\
__u64 __attribute__((ret(".IF "__stringify(__DEBUG)">=2\nPOPL KERNEL$BPL\n.ENDIF\nJMP *%EDX"),cdecl)) __FN_##NAME (STRUC *RQ)

extern IORQ KERNEL$DUMMY_IORQ;

extern void *KERNEL$AST_QUEUES[];

static __finline__ void __CLEAR_ASTS(void **q, void **d)
{
	unsigned long diff = (unsigned long)d - (unsigned long)q;
	int i;
	for (i = 0; i < 32; i++) {
		q[1] = q[0] = (void *)((unsigned long)q + diff);
		q += 2;
	}
}

__END_DECLS

#endif
