#ifndef __ARCH_BARRIER_H
#define __ARCH_BARRIER_H

#include <SYS/TYPES.H>
#include <ARCH/CPUDEF.H>

static __finline__ void __barrier(void)
{
	__asm__ volatile ("": : :"memory");
}

static __finline__ void __barrier_ptr(void *p)
{
	__asm__ volatile ("": :"r"(p):"memory");
}

static __finline__ void __read_barrier(void)
{
#if 0		/* not needed */
#ifndef __NO_SSE
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(CPU_HAS_SSE2)", 0, 0, 0\n\
		.PREVIOUS						\n\
	41:	LOCK; ADDL $0, (%%ESP)					\n\
	42:	.SECTION .text.end					\n\
	43:	LFENCE							\n\
	44:	.PREVIOUS						\n\
	":::"memory","cc");
#else
	__asm__ volatile ("						\n\
		LOCK; ADDL $0, (%%ESP)					\n\
	":::"memory","cc");
#endif
#endif
}

static __finline__ void __write_barrier(void)
{
	__asm__ volatile ("": : :"memory");
}

static __finline__ void __write_barrier2(void)
{
#ifndef __NO_SSE
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(CPU_HAS_SSE)", 0, 0, 0\n\
		.PREVIOUS						\n\
	41:	LOCK; ADDL $0, (%%ESP)					\n\
	42:	.SECTION .text.end					\n\
	43:	SFENCE							\n\
	44:	.PREVIOUS						\n\
	":::"memory","cc");
#else
	__asm__ volatile ("						\n\
		LOCK; ADDL $0, (%%ESP)					\n\
	":::"memory","cc");
#endif
}

static __finline__ void __rw_barrier(void)
{
#ifndef __NO_SSE
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 43f, 44f, "__stringify(CPU_HAS_SSE2)", 0, 0, 0\n\
		.PREVIOUS						\n\
	41:	LOCK; ADDL $0, (%%ESP)					\n\
	42:	.SECTION .text.end					\n\
	43:	MFENCE							\n\
	44:	.PREVIOUS						\n\
	":::"memory","cc");
#else
	__asm__ volatile ("						\n\
		LOCK; ADDL $0, (%%ESP)					\n\
	":::"memory","cc");
#endif
}

#endif
