#ifndef __ARCH_BIOS16_H
#define __ARCH_BIOS16_H

#include <SYS/TYPES.H>

__BEGIN_DECLS

struct bios_regs {
	__u32 eax, ecx, edx, ebx, ebp, esi, edi;
	__u16 es, ds, fs, gs;
	__u8 flags;
};

#define P_FLAGS_CF	0
#define P_FLAGS_PF	2
#define P_FLAGS_AF	4
#define P_FLAGS_ZF	6
#define P_FLAGS_SF	7

#define FLAGS_CF	0x01
#define FLAGS_PF	0x04
#define FLAGS_AF	0x10
#define FLAGS_ZF	0x40
#define FLAGS_SF	0x80

#define BIOS_PTR_BASE	0x8000UL
#define BIOS_MAX_LEN	0x8000UL

int BIOS16$REAL_INT(int intnum, struct bios_regs *regs, void *ptr, unsigned len, int flags);
/* must not be called from real-time interrupt (trashes fs and gs in syscall entry points) */

#define BIOS_DATA_PUT		1
#define BIOS_DATA_GET		2
#define BIOS_DATA_PUT_GET	3

__END_DECLS

#endif
