#ifndef __ARCH_BITOPS_H
#define __ARCH_BITOPS_H

#include <ARCH/CPU.H>
#include <SYS/TYPES.H>

#if defined(__GNUC__) && (__GNUC__ < 3 || (__GNUC__ == 3 && __GNUC_MINOR__ < 3))
/* older GCC can't join constraint strings in __asm__ statement */
#define __ASM_I
#else
#define __ASM_I		"i"
#endif

#define __GEN_BITOPS(type, asm_pfx, asm_sfx, reg, pfx, sfx)		\
									\
static __finline__ void __##pfx##OR##sfx(type *__ptr, type __val)	\
{									\
	__asm__ volatile (asm_pfx"OR"#asm_sfx" %1, %0" : "+m"(*__ptr) : #reg __ASM_I(__val) : "cc");							\
}									\
									\
static __finline__ void __##pfx##XOR##sfx(type *__ptr, type __val)	\
{									\
	__asm__ volatile (asm_pfx"XOR"#asm_sfx" %1, %0" : "+m"(*__ptr) : #reg __ASM_I(__val) : "cc");							\
}									\
									\
static __finline__ void __##pfx##AND##sfx(type *__ptr, type __val)	\
{									\
	__asm__ volatile (asm_pfx"AND"#asm_sfx" %1, %0" : "+m"(*__ptr) : #reg __ASM_I(__val) : "cc");							\
}									\
									\
static __finline__ void __##pfx##ADD##sfx(type *__ptr, type __val)	\
{									\
	__asm__ volatile (asm_pfx"ADD"#asm_sfx" %1, %0" : "+m"(*__ptr) : #reg __ASM_I(__val) : "cc");							\
}									\
									\
static __finline__ void __##pfx##SUB##sfx(type *__ptr, type __val)	\
{									\
	__asm__ volatile (asm_pfx"SUB"#asm_sfx" %1, %0" : "+m"(*__ptr) : #reg __ASM_I(__val) : "cc");							\
}									\
									\
static __finline__ int __##pfx##ADD##sfx##C(type *__ptr, type __val)	\
{									\
	unsigned char __ret;						\
	__asm__ volatile (asm_pfx"ADD"#asm_sfx" %2, %0; SETC %b1" : "+m"(*__ptr), "=q"(__ret) : #reg __ASM_I(__val) : "cc");				\
	return __ret;							\
}									\
									\
static __finline__ int __##pfx##SUB##sfx##C(type *__ptr, type __val)	\
{									\
	unsigned char __ret;						\
	__asm__ volatile (asm_pfx"SUB"#asm_sfx" %2, %0; SETC %b1" : "+m"(*__ptr), "=q"(__ret) : #reg __ASM_I(__val) : "cc");				\
	return __ret;							\
}									\
									\
static __finline__ int __##pfx##SUB##sfx##NZ(type *__ptr, type __val)	\
{									\
	unsigned char __ret;						\
	__asm__ volatile (asm_pfx"SUB"#asm_sfx" %2, %0; SETNE %b1" : "+m"(*__ptr), "=q"(__ret) : #reg __ASM_I(__val) : "cc");				\
	return __ret;							\
}									\
									\
static __finline__ int __##pfx##SUB##sfx##S(type *__ptr, type __val)	\
{									\
	unsigned char __ret;						\
	__asm__ volatile (asm_pfx"SUB"#asm_sfx" %2, %0; SETS %b1" : "+m"(*__ptr), "=q"(__ret) : #reg __ASM_I(__val) : "cc");				\
	return __ret;							\
}									\
									\
static __finline__ long __##pfx##CMPXCHG##sfx(type *__ptr, type __old, type __new)									\
{									\
	unsigned long __ret;						\
	__asm__ volatile (asm_pfx"CMPXCHG"#asm_sfx" %2, %1" : "=a"(__ret), "+m"(*__ptr) : #reg(__new), "a"(__old) : "cc");				\
	return (unsigned long)__ret - (unsigned long)__old;		\
}									\

__GEN_BITOPS(char, , B, q, , C)
__GEN_BITOPS(char, "LOCK;", B, q, LOCK_, C)
__GEN_BITOPS(int, , L, r, , I)
__GEN_BITOPS(int, "LOCK;", L, r, LOCK_, I)
__GEN_BITOPS(long, , L, r, , L)
__GEN_BITOPS(long, "LOCK;", L, r, LOCK_, L)
__GEN_BITOPS(__u32, , L, r, , 32)
__GEN_BITOPS(__u32, "LOCK;", L, r, LOCK_, 32)

#define __CMPXCHG64_AVAILABLE	(__likely(KERNEL$CPU_FEATURES & CPU_HAS_CMPXCHG8B))

static __finline__ long __CMPXCHG64(__u64 *__ptr, __u64 __old, __u64 __new)
{
	long __dummy, __ret;
	__asm__ volatile ("CMPXCHG8B %2; SETNZ %b0" : "=a"(__ret), "=d"(__dummy), "+m"(*__ptr) : "A"(__old), "b"((__u32)__new), "c"((__u32)(__new >> 32)) : "cc");
	return __ret & 1;
}

static __finline__ long __LOCK_CMPXCHG64(__u64 *__ptr, __u64 __old, __u64 __new)
{
	long __dummy, __ret;
	__asm__ volatile ("LOCK ; CMPXCHG8B %2; SETNZ %b0" : "=a"(__ret), "=d"(__dummy), "+m"(*__ptr) : "A"(__old), "b"((__u32)__new), "c"((__u32)(__new >> 32)) : "cc");
	return __ret & 1;
}

#endif
