#ifndef __ARCH_BSF_H
#define __ARCH_BSF_H

#include <SYS/TYPES.H>

#define __BSR_MAX 32

#define __BSR_CONST(__x)	(					\
		(__x) < 0x100UL ?					\
			(__x) < 0x10UL ?				\
				(__x) < 0x4UL ? 			\
					(__x) < 0x2UL ? 0 : 1		\
				:					\
					(__x) < 0x8UL ? 2 : 3		\
			:						\
				(__x) < 0x40UL ?			\
					(__x) < 0x20UL ? 4 : 5		\
				:					\
					(__x) < 0x80UL ? 6 : 7		\
		: (__x) < 0x10000UL ?					\
			(__x) < 0x1000UL ?				\
				(__x) < 0x400UL ? 			\
					(__x) < 0x200UL ? 8 : 9		\
				:					\
					(__x) < 0x800UL ? 10 : 11	\
			:						\
				(__x) < 0x4000UL ?			\
					(__x) < 0x2000UL ? 12 : 13	\
				:					\
					(__x) < 0x8000UL ? 14 : 15	\
		: (__x) < 0x1000000UL ?					\
			(__x) < 0x100000UL ?				\
				(__x) < 0x40000UL ? 			\
					(__x) < 0x20000UL ? 16 : 17	\
				:					\
					(__x) < 0x80000UL ? 18 : 19	\
			:						\
				(__x) < 0x400000UL ?			\
					(__x) < 0x200000UL ? 20 : 21	\
				:					\
					(__x) < 0x800000UL ? 22 : 23	\
		:							\
			(__x) < 0x10000000UL ?				\
				(__x) < 0x4000000UL ? 			\
					(__x) < 0x2000000UL ? 24 : 25	\
				:					\
					(__x) < 0x8000000UL ? 26 : 27	\
			:						\
				(__x) < 0x40000000UL ?			\
					(__x) < 0x20000000UL ? 28 : 29	\
				:					\
					(__x) < 0x80000000UL ? 30 : 31	\
	)

#define __BSF_CONST(__x)	(					\
		(__x) & 0xffffUL ?					\
			(__x) & 0xffUL ?				\
				(__x) & 0xfUL ?				\
					(__x) & 0x3UL ?			\
						(__x) & 0x1UL ? 0 : 1	\
					:				\
						(__x) & 0x4UL ? 2 : 3	\
				:					\
					(__x) & 0x30UL ?		\
						(__x) & 0x10UL ? 4 : 5	\
					:				\
						(__x) & 0x40UL ? 6 : 7	\
			:						\
				(__x) & 0xf00UL ?			\
					(__x) & 0x300UL ? 		\
						(__x) & 0x100UL ? 8 : 9	\
					:				\
						(__x) & 0x400UL ? 10 : 11 \
				:					\
					(__x) & 0x3000UL ?		\
						(__x) & 0x1000UL ? 12 : 13 \
					:				\
						(__x) & 0x4000UL ? 14 : 15 \
		:							\
			(__x) & 0xff0000UL ?				\
				(__x) & 0xf0000UL ?			\
					(__x) & 0x30000UL ?		\
						(__x) & 0x10000UL ? 16 : 17 \
					:				\
						(__x) & 0x40000UL ? 18 : 19 \
				:					\
					(__x) & 0x300000UL ?		\
						(__x) & 0x100000UL ? 20 : 21 \
					:				\
						(__x) & 0x400000UL ? 22 : 23 \
			:						\
				(__x) & 0xf000000UL ?			\
					(__x) & 0x3000000UL ? 		\
						(__x) & 0x1000000UL ? 24 : 25 \
					:				\
						(__x) & 0x4000000UL ? 26 : 27 \
				:					\
					(__x) & 0x30000000UL ?		\
						(__x) & 0x10000000UL ? 28 : 29 \
					:				\
						(__x) & 0x40000000UL ? 30 : 31 \
	)

#ifndef __NO_INLINES
static __finline__ int __attribute__((__const__)) __BSR(unsigned long __x)
{
	int __r;
	if (__is_constant(__x)) {
		return __BSR_CONST(__x);
	} else {
		__asm__ ("BSRL %1, %0":"=r"(__r):"rm"(__x):"cc");
		return __r;
	}
}
#endif

#ifndef __NO_INLINES
static __finline__ int __attribute__((__const__)) __BSF(unsigned long __x)
{
	int __r;
	if (__is_constant(__x)) {
		return __BSF_CONST(__x);
	} else {
		__asm__ ("BSFL %1, %0":"=r"(__r):"rm"(__x):"cc");
		return __r;
	}
}
#endif

#endif
