#ifndef __ARCH_CPU_H
#define __ARCH_CPU_H

#include <ARCH/CPUDEF.H>
#include <STRING.H>
#include <SYS/TYPES.H>

extern int KERNEL$CPU_FEATURES;

int KERNEL$READ_MSR(__u32 idx, __u64 *val);
int KERNEL$WRITE_MSR(__u32 idx, __u64 val);

static __finline__ void INIT_FPU(unsigned char *fpu, int init)
{
	if (__likely(KERNEL$CPU_FEATURES & CPU_HAS_FXSR)) {
		if (init) memset(fpu, 0, 512);
		*(__u32 *)&fpu[0x00] = 0x037fu;
		*(__u32 *)&fpu[0x18] = 0x1f80u;
		*(__u32 *)&fpu[0x1c] = 0xffffu;
	} else {
		if (init) memset(fpu, 0, 108);
	/* 94 or 108 ??? Intel says: "Store FPU state to m94byte or m108byte" */
		*(__u32 *)&fpu[0x00] = 0xffff037fu;
		*(__u32 *)&fpu[0x04] = 0xffff0000u;
		*(__u32 *)&fpu[0x08] = 0xffffffffu;
		*(__u32 *)&fpu[0x18] = 0xffff0000u;
	}
}

extern long KERNEL$FPU_ENABLED;
void KERNEL$ENABLE_FPU(void);

/* note that this is for integer XMM (and you must restore all modified
   registers), not for FPU ! */
static __finline__ void START_XMM(void)
{
	if (__unlikely(!KERNEL$FPU_ENABLED)) KERNEL$ENABLE_FPU();
}

#endif
