#ifndef __ARCH_CPUDEF_H
#define __ARCH_CPUDEF_H

#define P_CPU_FEATURE_FPU	0
#define P_CPU_FEATURE_VME	1
#define P_CPU_FEATURE_DE	2
#define P_CPU_FEATURE_PSE	3
#define P_CPU_FEATURE_TSC	4
#define P_CPU_FEATURE_MSR	5
#define P_CPU_FEATURE_PAE	6
#define P_CPU_FEATURE_MCE	7
#define P_CPU_FEATURE_CX8	8
#define P_CPU_FEATURE_APIC	9
#define P_CPU_FEATURE_SEP	11
#define P_CPU_FEATURE_MTRR	12
#define P_CPU_FEATURE_PGE	13
#define P_CPU_FEATURE_MCA	14
#define P_CPU_FEATURE_CMOV	15
#define P_CPU_FEATURE_FGPAT	16
#define P_CPU_FEATURE_PSE_36	17
#define P_CPU_FEATURE_PN	18
#define P_CPU_FEATURE_CLFLUSH	19
#define P_CPU_FEATURE_ACPI	20
#define P_CPU_FEATURE_DS	21
#define P_CPU_FEATURE_MMX	23
#define P_CPU_FEATURE_FXSR	24
#define P_CPU_FEATURE_SSE	25
#define P_CPU_FEATURE_SSE2	26
#define P_CPU_FEATURE_SS	27
#define P_CPU_FEATURE_HTT	28
#define P_CPU_FEATURE_TM	29
#define P_CPU_FEATURE_PBE	31

#define CPU_FEATURE_FPU		0x00000001
#define CPU_FEATURE_VME		0x00000002
#define CPU_FEATURE_DE		0x00000004
#define CPU_FEATURE_PSE		0x00000008
#define CPU_FEATURE_TSC		0x00000010
#define CPU_FEATURE_MSR		0x00000020
#define CPU_FEATURE_PAE		0x00000040
#define CPU_FEATURE_MCE		0x00000080
#define CPU_FEATURE_CX8		0x00000100
#define CPU_FEATURE_APIC	0x00000200
#define CPU_FEATURE_SEP		0x00000800
#define CPU_FEATURE_MTRR	0x00001000
#define CPU_FEATURE_PGE		0x00002000
#define CPU_FEATURE_MCA		0x00004000
#define CPU_FEATURE_CMOV	0x00008000
#define CPU_FEATURE_FGPAT	0x00010000
#define CPU_FEATURE_PSE_36	0x00020000
#define CPU_FEATURE_PN		0x00040000
#define CPU_FEATURE_CLFLUSH	0x00080000
#define CPU_FEATURE_DS		0x00200000
#define CPU_FEATURE_ACPI	0x00400000
#define CPU_FEATURE_MMX		0x00800000
#define CPU_FEATURE_FXSR	0x01000000
#define CPU_FEATURE_SSE		0x02000000
#define CPU_FEATURE_SSE2	0x04000000
#define CPU_FEATURE_SS		0x08000000
#define CPU_FEATURE_HTT		0x10000000
#define CPU_FEATURE_TM		0x20000000
#define CPU_FEATURE_PBE		0x80000000

#define P_CPU_FEATURE2_SSE3	0
#define P_CPU_FEATURE2_MONITOR	3
#define P_CPU_FEATURE2_DS_CPL	4
#define P_CPU_FEATURE2_EST	7
#define P_CPU_FEATURE2_TM2	8
#define P_CPU_FEATURE2_CNXT_ID	10
#define P_CPU_FEATURE2_CX16	13

#define CPU_FEATURE2_SSE3	0x00000001
#define CPU_FEATURE2_MONITOR	0x00000008
#define CPU_FEATURE2_DS_CPL	0x00000010
#define CPU_FEATURE2_EST	0x00000080
#define CPU_FEATURE2_TM2	0x00000100
#define CPU_FEATURE2_CNXT_ID	0x00000400
#define CPU_FEATURE2_CX16	0x00002000

#define P_CPU_FEATURE_AMD_SYSCALL	11
#define P_CPU_FEATURE_AMD_64		29

#define CPU_FEATURE_AMD_SYSCALL		0x00000800
#define CPU_FEATURE_AMD_64		0x20000000

#define P_PTE_P		0
#define P_PTE_RW	1
#define P_PTE_US	2
#define P_PTE_PWT	3
#define P_PTE_PCD	4
#define P_PTE_A		5
#define P_PTE_D		6
#define P_PTE_PS	7
#define P_PTE_PAT_PTE	7
#define P_PTE_G		8
#define P_PTE_AVL1	9
#define P_PTE_AVL2	10
#define P_PTE_AVL3	11
#define P_PTE_PAT_PDE	12

#define PTE_P		1
#define PTE_RW		2
#define PTE_US		4
#define PTE_PWT		8
#define PTE_PCD		16
#define PTE_A		32
#define PTE_D		64
#define PTE_PS		128
#define PTE_PAT_PTE	128
#define PTE_G		256
#define PTE_AVL1	512
#define PTE_AVL2	1024
#define PTE_AVL3	2048
#define PTE_PAT_PDE	4096

#define P_EFLAGS_CF	0
#define P_EFLAGS_ONE	1
#define P_EFLAGS_PF	2
#define P_EFLAGS_AF	4
#define P_EFLAGS_ZF	6
#define P_EFLAGS_SF	7
#define P_EFLAGS_TF	8
#define P_EFLAGS_IF	9
#define P_EFLAGS_DF	10
#define P_EFLAGS_OF	11
#define P_EFLAGS_IOPL0	12
#define P_EFLAGS_IOPL1	13
#define P_EFLAGS_NT	14
#define P_EFLAGS_RF	16
#define P_EFLAGS_VM	17
#define P_EFLAGS_AC	18
#define P_EFLAGS_VIF	19
#define P_EFLAGS_VIP	20
#define P_EFLAGS_ID	21

#define EFLAGS_CF	0x00000001
#define EFLAGS_ONE	0x00000002
#define EFLAGS_PF	0x00000004
#define EFLAGS_AF	0x00000010
#define EFLAGS_ZF	0x00000040
#define EFLAGS_SF	0x00000080
#define EFLAGS_TF	0x00000100
#define EFLAGS_IF	0x00000200
#define EFLAGS_DF	0x00000400
#define EFLAGS_OF	0x00000800
#define EFLAGS_IOPL0	0x00001000
#define EFLAGS_IOPL1	0x00002000
#define EFLAGS_NT	0x00004000
#define EFLAGS_RF	0x00010000
#define EFLAGS_VM	0x00020000
#define EFLAGS_AC	0x00040000
#define EFLAGS_VIF	0x00080000
#define EFLAGS_VIP	0x00100000
#define EFLAGS_ID	0x00200000

#define P_CR0_PE	0
#define P_CR0_MP	1
#define P_CR0_EM	2
#define P_CR0_TS	3
#define P_CR0_ET	4
#define P_CR0_NE	5
#define P_CR0_WP	16
#define P_CR0_AM	18
#define P_CR0_NW	29
#define P_CR0_CD	30
#define P_CR0_PG	31

#define CR0_PE		0x00000001
#define CR0_MP		0x00000002
#define CR0_EM		0x00000004
#define CR0_TS		0x00000008
#define CR0_ET		0x00000010
#define CR0_NE		0x00000020
#define CR0_WP		0x00010000
#define CR0_AM		0x00040000
#define CR0_NW		0x20000000
#define CR0_CD		0x40000000
#define CR0_PG		0x80000000

#define P_CR3_PWT	3
#define P_CR3_PCD	4

#define CR3_PWT		0x00000008
#define CR3_PCD		0x00000010

#define P_CR4_VME	0
#define P_CR4_PVI	1
#define P_CR4_TSD	2
#define P_CR4_DE	3
#define P_CR4_PSE	4
#define P_CR4_PAE	5
#define P_CR4_MCE	6
#define P_CR4_PGE	7
#define P_CR4_PCE	8
#define P_CR4_OSFXSR	9
#define P_CR4_OSXMMEXCPT 10

#define CR4_VME		0x00000001
#define CR4_PVI		0x00000002
#define CR4_TSD		0x00000004
#define CR4_DE		0x00000008
#define CR4_PSE		0x00000010
#define CR4_PAE		0x00000020
#define CR4_MCE		0x00000040
#define CR4_PGE		0x00000080
#define CR4_PCE		0x00000100
#define CR4_OSFXSR	0x00000200
#define CR4_OSXMMEXCPT	0x00000400

#define XCPT_DE		0
#define XCPT_DB		1
#define XCPT_NMI	2
#define XCPT_BP		3
#define XCPT_OF		4
#define XCPT_BR		5
#define XCPT_UD		6
#define XCPT_NM		7
#define XCPT_DF		8
#define XCPT_CSO	9
#define XCPT_TS		10
#define XCPT_NP		11
#define XCPT_SS		12
#define XCPT_GP		13
#define XCPT_PF		14
#define XCPT_MF		16
#define XCPT_AC		17
#define XCPT_MC		18
#define XCPT_XF		19

/* Pentium 4 and common */
#define IA32_P5_MC_ADDR			0x00000000
#define IA32_P5_MC_TYPE			0x00000001
#define IA32_MONITOR_FILTER_LINE_SIZE	0x00000006
#define IA32_TIME_STAMP_COUNTER		0x00000010
#define IA32_PLATFORM_ID		0x00000017
#define IA32_APIC_BASE			0x0000001b
#define MSR_EBC_HARD_POWERON		0x0000002a
#define MSR_EBC_SOFT_POWERON		0x0000002b
#define MSR_EBC_FREQUENCY_ID		0x0000002c
#define IA32_BIOS_UPDT_TRIG		0x00000079
#define IA32_BIOS_SIGN_ID		0x0000008b
#define IA32_MTRRCAP			0x000000fe
#define IA32_SYSENTER_CS		0x00000174
#define IA32_SYSENTER_ESP		0x00000175
#define IA32_SYSENTER_EIP		0x00000176
#define IA32_MCG_CAP			0x00000179
#define  IA32_MCG_CAP_LO_COUNT			0x000000ff
#define  IA32_MCG_CAP_LO_MCG_CTL_P		0x00000100
#define  IA32_MCG_CAP_LO_MCG_EXT_P		0x00000200
#define  IA32_MCG_CAP_LO_MCG_EXT_CNT		0x00ff0000
#define  P_IA32_MCG_CAP_MCG_EXT_CNT		16
#define  IA32_MCG_CAP_COUNT			((__u64)IA32_MCG_CAP_LO_COUNT)
#define  IA32_MCG_CAP_MCG_CTL_P			((__u64)IA32_MCG_CAP_LO_MCG_CTL_P)
#define  IA32_MCG_CAP_MCG_EXT_P			((__u64)IA32_MCG_CAP_LO_MCG_EXT_P)
#define  IA32_MCG_CAP_MCG_EXT_CNT		((__u64)IA32_MCG_CAP_LO_MCG_EXT_CNT)
#define IA32_MCG_STATUS			0x0000017a
#define  IA32_MCG_STATUS_LO_RIPV		0x00000001
#define  IA32_MCG_STATUS_LO_EIPV		0x00000002
#define  IA32_MCG_STATUS_LO_MCIP		0x00000004
#define  IA32_MCG_STATUS_RIPV			((__u64)IA32_MCG_STATUS_LO_RIPV)
#define  IA32_MCG_STATUS_EIPV			((__u64)IA32_MCG_STATUS_LO_EIPV)
#define  IA32_MCG_STATUS_MCIP			((__u64)IA32_MCG_STATUS_LO_MCIP)
#define IA32_MCG_CTL			0x0000017b
#define IA32_MCG_EAX			0x00000180
#define IA32_MCG_EBX			0x00000181
#define IA32_MCG_ECX			0x00000182
#define IA32_MCG_EDX			0x00000183
#define IA32_MCG_ESI			0x00000184
#define IA32_MCG_EDI			0x00000185
#define IA32_MCG_EBP			0x00000186
#define IA32_MCG_ESP			0x00000187
#define IA32_MCG_EFLAGS			0x00000188
#define IA32_MCG_EIP			0x00000189
#define IA32_MCG_MISC			0x0000018a
#define IA32_CLOCK_MODULATION		0x0000019a
#define IA32_THERM_INTERRUPT		0x0000019b
#define IA32_THERM_STATUS		0x0000019c
#define IMSR_THERM2_CTL			0x0000019d
#define IA32_MISC_ENABLE		0x000001a0
#define MSR_PLATFORM_BRV		0x000001a1
#define MSR_LER_FROM_LIP		0x000001d7
#define MSR_LER_TO_LIP			0x000001d8
#define MSR_DEBUGCTLA			0x000001d9
#define MSR_LASTBRANCH_TOS		0x000001da
#define MSR_LASTBRANCH_0		0x000001db
#define MSR_LASTBRANCH_1		0x000001dc
#define MSR_LASTBRANCH_2		0x000001dd
#define MSR_LASTBRANCH_3		0x000001de
#define IA32_MTRR_PHYSBASE0		0x00000200
#define IA32_MTRR_PHYSMASK0		0x00000201
#define IA32_MTRR_PHYSBASE1		0x00000202
#define IA32_MTRR_PHYSMASK1		0x00000203
#define IA32_MTRR_PHYSBASE2		0x00000204
#define IA32_MTRR_PHYSMASK2		0x00000205
#define IA32_MTRR_PHYSBASE3		0x00000206
#define IA32_MTRR_PHYSMASK3		0x00000207
#define IA32_MTRR_PHYSBASE4		0x00000208
#define IA32_MTRR_PHYSMASK4		0x00000209
#define IA32_MTRR_PHYSBASE5		0x0000020a
#define IA32_MTRR_PHYSMASK5		0x0000020b
#define IA32_MTRR_PHYSBASE6		0x0000020c
#define IA32_MTRR_PHYSMASK6		0x0000020d
#define IA32_MTRR_PHYSBASE7		0x0000020e
#define IA32_MTRR_PHYSMASK7		0x0000020f
#define IA32_MTRR_FIX64K_00000		0x00000250
#define IA32_MTRR_FIX64K_80000		0x00000258
#define IA32_MTRR_FIX64K_A0000		0x00000259
#define IA32_MTRR_FIX4K_C0000		0x00000268
#define IA32_MTRR_FIX4K_C8000		0x00000269
#define IA32_MTRR_FIX4K_D0000		0x0000026a
#define IA32_MTRR_FIX4K_D8000		0x0000026b
#define IA32_MTRR_FIX4K_E0000		0x0000026c
#define IA32_MTRR_FIX4K_E8000		0x0000026d
#define IA32_MTRR_FIX4K_F0000		0x0000026e
#define IA32_MTRR_FIX4K_F8000		0x0000026f
#define IA32_CR_PAT			0x00000277
#define IA32_MTRR_DEF_TYPE		0x000002ff
#define  IA32_MEMORY_TYPE_UC			0
#define  IA32_MEMORY_TYPE_WC			1
#define  IA32_MEMORY_TYPE_WT			4
#define  IA32_MEMORY_TYPE_WP			5
#define  IA32_MEMORY_TYPE_WB			6
#define  IA32_MEMORY_TYPE_UC_MINUS		7
#define MSR_BPU_COUNTER0		0x00000300
#define MSR_BPU_COUNTER1		0x00000301
#define MSR_BPU_COUNTER2		0x00000302
#define MSR_BPU_COUNTER3		0x00000303
#define MSR_MS_COUNTER0			0x00000304
#define MSR_MS_COUNTER1			0x00000305
#define MSR_MS_COUNTER2			0x00000306
#define MSR_MS_COUNTER3			0x00000307
#define MSR_FLAME_COUNTER0		0x00000308
#define MSR_FLAME_COUNTER1		0x00000309
#define MSR_FLAME_COUNTER2		0x0000030a
#define MSR_FLAME_COUNTER3		0x0000030b
#define MSR_IQ_COUNTER0			0x0000030c
#define MSR_IQ_COUNTER1			0x0000030d
#define MSR_IQ_COUNTER2			0x0000030e
#define MSR_IQ_COUNTER3			0x0000030f
#define MSR_IQ_COUNTER4			0x00000310
#define MSR_IQ_COUNTER5			0x00000311
#define MSR_BPU_CCCR0			0x00000360
#define MSR_BPU_CCCR1			0x00000361
#define MSR_BPU_CCCR2			0x00000362
#define MSR_BPU_CCCR3			0x00000363
#define MSR_MS_CCCR0			0x00000364
#define MSR_MS_CCCR1			0x00000365
#define MSR_MS_CCCR2			0x00000366
#define MSR_MS_CCCR3			0x00000367
#define MSR_FLAME_CCCR0			0x00000368
#define MSR_FLAME_CCCR1			0x00000369
#define MSR_FLAME_CCCR2			0x0000036a
#define MSR_FLAME_CCCR3			0x0000036b
#define MSR_IQ_CCCR0			0x0000036c
#define MSR_IQ_CCCR1			0x0000036d
#define MSR_IQ_CCCR2			0x0000036e
#define MSR_IQ_CCCR3			0x0000036f
#define MSR_IQ_CCCR4			0x00000370
#define MSR_IQ_CCCR5			0x00000371
#define MSR_BSU_ESCR0			0x000003a0
#define MSR_BSU_ESCR1			0x000003a1
#define MSR_FSB_ESCR0			0x000003a2
#define MSR_FSB_ESCR1			0x000003a3
#define MSR_FIRM_ESCR0			0x000003a4
#define MSR_FIRM_ESCR1			0x000003a5
#define MSR_FLAME_ESCR0			0x000003a6
#define MSR_FLAME_ESCR1			0x000003a7
#define MSR_DAC_ESCR0			0x000003a8
#define MSR_DAC_ESCR1			0x000003a9
#define MSR_MOB_ESCR0			0x000003aa
#define MSR_MOB_ESCR1			0x000003ab
#define MSR_PMH_ESCR0			0x000003ac
#define MSR_PMH_ESCR1			0x000003ad
#define MSR_SAAT_ESCR0			0x000003ae
#define MSR_SAAT_ESCR1			0x000003af
#define MSR_U2L_ESCR0			0x000003b0
#define MSR_U2L_ESCR1			0x000003b1
#define MSR_BPU_ESCR0			0x000003b2
#define MSR_BPU_ESCR1			0x000003b3
#define MSR_IS_ESCR0			0x000003b4
#define MSR_IS_ESCR1			0x000003b5
#define MSR_ITLB_ESCR0			0x000003b6
#define MSR_ITLB_ESCR1			0x000003b7
#define MSR_CRU_ESCR0			0x000003b8
#define MSR_CRU_ESCR1			0x000003b9
#define MSR_IQ_ESCR0			0x000003ba
#define MSR_IQ_ESCR1			0x000003bb
#define MSR_RAT_ESCR0			0x000003bc
#define MSR_RAT_ESCR1			0x000003bd
#define MSR_SSU_ESCR0			0x000003be
#define MSR_SSU_ESCR1			0x000003bf
#define MSR_MS_ESCR0			0x000003c0
#define MSR_MS_ESCR1			0x000003c1
#define MSR_TBPU_ESCR0			0x000003c2
#define MSR_TBPU_ESCR1			0x000003c3
#define MSR_TC_ESCR0			0x000003c4
#define MSR_TC_ESCR1			0x000003c5
#define MSR_IX_ESCR0			0x000003c8
#define MSR_IX_ESCR1			0x000003c9
#define MSR_ALF_ESCR0			0x000003ca
#define MSR_ALF_ESCR1			0x000003cb
#define MSR_CRU_ESCR2			0x000003cc
#define MSR_CRU_ESCR3			0x000003cd
#define MSR_CRU_ESCR4			0x000003e0
#define MSR_CRU_ESCR5			0x000003e1
#define MSR_TC_PRECISE_EVENT		0x000003f0
#define IA32_PEBS_ENABLE		0x000003f1
#define MSR_PEBS_MATRIX_VERT		0x000003f2
#define  IA32_MC_STATUS_HI_PCC			(1 << 25)
#define  IA32_MC_STATUS_HI_ADDRV		(1 << 26)
#define  IA32_MC_STATUS_HI_MISCV		(1 << 27)
#define  IA32_MC_STATUS_HI_EN			(1 << 28)
#define  IA32_MC_STATUS_HI_UC			(1 << 29)
#define  IA32_MC_STATUS_HI_OVER			(1 << 30)
#define  IA32_MC_STATUS_HI_VAL			(1 << 31)
#define  IA32_MC_STATUS_PCC			((__u64)IA32_MC_STATUS_HI_PCC << 32)
#define  IA32_MC_STATUS_ADDRV			((__u64)IA32_MC_STATUS_HI_ADDRV << 32)
#define  IA32_MC_STATUS_MISCV			((__u64)IA32_MC_STATUS_HI_MISCV << 32)
#define  IA32_MC_STATUS_EN			((__u64)IA32_MC_STATUS_HI_EN << 32)
#define  IA32_MC_STATUS_UC			((__u64)IA32_MC_STATUS_HI_UC << 32)
#define  IA32_MC_STATUS_OVER			((__u64)IA32_MC_STATUS_HI_OVER << 32)
#define  IA32_MC_STATUS_VAL			((__u64)IA32_MC_STATUS_HI_VAL << 32)
#define IA32_MC0_CTL			0x00000400
#define IA32_MC0_STATUS			0x00000401
#define IA32_MC0_ADDR			0x00000402
#define IA32_MC0_MISC			0x00000403
#define IA32_MC1_CTL			0x00000404
#define IA32_MC1_STATUS			0x00000405
#define IA32_MC1_ADDR			0x00000406
#define IA32_MC1_MISC			0x00000407
#define IA32_MC2_CTL			0x00000408
#define IA32_MC2_STATUS			0x00000409
#define IA32_MC2_ADDR			0x0000040a
#define IA32_MC2_MISC			0x0000040b
#define IA32_MC3_CTL			0x0000040c
#define IA32_MC3_STATUS			0x0000040d
#define IA32_MC3_ADDR			0x0000040e
#define IA32_MC3_MISC			0x0000040f
#define IA32_MC4_CTL			0x00000410
#define IA32_MC4_STATUS			0x00000411
#define IA32_MC4_ADDR			0x00000412
#define IA32_MC4_MISC			0x00000413
#define IA32_DS_AREA			0x00000600
#define MSR_LASTBRANCH_0_FROM_LIP	0x00000680
#define MSR_LASTBRANCH_1_FROM_LIP	0x00000681
#define MSR_LASTBRANCH_2_FROM_LIP	0x00000682
#define MSR_LASTBRANCH_3_FROM_LIP	0x00000683
#define MSR_LASTBRANCH_4_FROM_LIP	0x00000684
#define MSR_LASTBRANCH_5_FROM_LIP	0x00000685
#define MSR_LASTBRANCH_6_FROM_LIP	0x00000686
#define MSR_LASTBRANCH_7_FROM_LIP	0x00000687
#define MSR_LASTBRANCH_8_FROM_LIP	0x00000688
#define MSR_LASTBRANCH_9_FROM_LIP	0x00000689
#define MSR_LASTBRANCH_10_FROM_LIP	0x0000068a
#define MSR_LASTBRANCH_11_FROM_LIP	0x0000068b
#define MSR_LASTBRANCH_12_FROM_LIP	0x0000068c
#define MSR_LASTBRANCH_13_FROM_LIP	0x0000068d
#define MSR_LASTBRANCH_14_FROM_LIP	0x0000068e
#define MSR_LASTBRANCH_15_FROM_LIP	0x0000068f
#define MSR_LASTBRANCH_0_TO_LIP		0x000006c0
#define MSR_LASTBRANCH_1_TO_LIP		0x000006c1
#define MSR_LASTBRANCH_2_TO_LIP		0x000006c2
#define MSR_LASTBRANCH_3_TO_LIP		0x000006c3
#define MSR_LASTBRANCH_4_TO_LIP		0x000006c4
#define MSR_LASTBRANCH_5_TO_LIP		0x000006c5
#define MSR_LASTBRANCH_6_TO_LIP		0x000006c6
#define MSR_LASTBRANCH_7_TO_LIP		0x000006c7
#define MSR_LASTBRANCH_8_TO_LIP		0x000006c8
#define MSR_LASTBRANCH_9_TO_LIP		0x000006c9
#define MSR_LASTBRANCH_10_TO_LIP	0x000006ca
#define MSR_LASTBRANCH_11_TO_LIP	0x000006cb
#define MSR_LASTBRANCH_12_TO_LIP	0x000006cc
#define MSR_LASTBRANCH_13_TO_LIP	0x000006cd
#define MSR_LASTBRANCH_14_TO_LIP	0x000006ce
#define MSR_LASTBRANCH_15_TO_LIP	0x000006cf

/* Pentium M */
#define MSR_EBL_CR_POWERON		0x0000002a
#define MSR_PENTIUM_M_LASTBRANCH_0	0x00000040
#define MSR_PENTIUM_M_LASTBRANCH_1	0x00000041
#define MSR_PENTIUM_M_LASTBRANCH_2	0x00000042
#define MSR_PENTIUM_M_LASTBRANCH_3	0x00000043
#define MSR_PENTIUM_M_LASTBRANCH_4	0x00000044
#define MSR_PENTIUM_M_LASTBRANCH_5	0x00000045
#define MSR_PENTIUM_M_LASTBRANCH_6	0x00000046
#define MSR_PENTIUM_M_LASTBRANCH_7	0x00000047
#define MSR_BBL_CR_CTL			0x00000119
#define MSR_BBL_CR_CTL3			0x0000011e
#define IA32_PERF_STATUS		0x00000198
#define MSR_PENTIUM_M_LASTBRANCH_TOS	0x000001c9
#define MSR_PENTIUM_M_LER_TO_LIP	0x000001dd
#define MSR_PENTIUM_M_LER_FROM_LIP	0x000001de

/* Pentium Pro */
#define MSR_TEST_CTL			0x00000033
#define MSR_BBL_CR_D0			0x00000088
#define MSR_BBL_CR_D1			0x00000089
#define MSR_BBL_CR_D2			0x0000008a
#define MSR_BBL_CR_D3_BIOS_SIGN		0x0000008b
#define MSR_PerfCtr0			0x000000c1
#define MSR_PerfCtr1			0x000000c2
#define MSR_BBL_CR_ADDR			0x00000116
#define MSR_BBL_CR_DECC			0x00000118
#define MSR_BBL_CR_CTL			0x00000119
#define  MSR_BBL_CR_CTL_LO_NUMBER_DISABLE	(1 << 21)
#define  MSR_BBL_CR_CTL_NUMBER_DISABLE		((__u64)MSR_BBL_CR_CTL_LO_NUMBER_DISABLE)
#define MSR_BBL_CR_TRIG			0x0000011a
#define MSR_BBL_CR_BUSY			0x0000011b
#define MSR_BBL_CR_CTL3			0x0000011e
#define MSR_PerfEvtSel0			0x00000186
#define MSR_PerfEvtSel1			0x00000187
#define MSR_DEBUGCTLMSR			0x000001d9
#define MSR_LASTBRANCHFROMIP		0x000001db
#define MSR_LASTBRANCHTOIP		0x000001dc
#define MSR_LASTINTFROMIP		0x000001dd
#define MSR_LASTINTTOIP			0x000001de
#define MSR_ROB_CR_BKUPTMPDR6		0x000001e0

/* Pentium */
#define MSR_CESR			0x00000011
#define MSR_CTR0			0x00000012
#define MSR_CTR1			0x00000013

/* AMD */
#define IA32_EFER 			0xc0000080
#define  IA32_EFER_LO_SCE			(1 << 0)
#define  IA32_EFER_LO_LME			(1 << 8)
#define  IA32_EFER_LO_LMA			(1 << 10)
#define  IA32_EFER_LO_NXE			(1 << 11)
#define  IA32_EFER_LO_SVME			(1 << 12)
#define  IA32_EFER_LO_FFXSR			(1 << 14)
#define  IA32_EFER_SCE				((__u64)IA32_EFER_LO_SCE)
#define  IA32_EFER_LME				((__u64)IA32_EFER_LO_LME)
#define  IA32_EFER_LMA				((__u64)IA32_EFER_LO_LMA)
#define  IA32_EFER_NXE				((__u64)IA32_EFER_LO_NXE)
#define  IA32_EFER_SVME				((__u64)IA32_EFER_LO_SVME)
#define  IA32_EFER_FFXSR			((__u64)IA32_EFER_LO_FFXSR)
#define IA32_STAR			0xc0000081

#define MSR_K6_EFER			0xc0000080
#define MSR_K6_STAR			0xc0000081
#define MSR_K6_WHCR			0xc0000082
#define MSR_K6_UWCCR			0xc0000085
#define MSR_K6_EPMR			0xc0000086
#define MSR_K6_PSOR			0xc0000087
#define MSR_K6_PFIR			0xc0000088

#define MSR_K7_EVNTSEL0			0xc0010000
#define MSR_K7_EVNTSEL1			0xc0010001
#define MSR_K7_EVNTSEL2			0xc0010002
#define MSR_K7_EVNTSEL3			0xc0010003
#define MSR_K7_PERFCTR0			0xc0010004
#define MSR_K7_PERFCTR1			0xc0010005
#define MSR_K7_PERFCTR2			0xc0010006
#define MSR_K7_PERFCTR3			0xc0010007
#define MSR_K7_HWCR			0xc0010015
#define MSR_K7_CLK_CTL			0xc001001b
#define MSR_K7_FID_VID_CTL		0xc0010041
#define MSR_K7_FID_VID_STATUS		0xc0010042

/* Centaur-Hauls/IDT */
#define MSR_IDT_FCR1			0x00000107
#define MSR_IDT_FCR2			0x00000108
#define MSR_IDT_FCR3			0x00000109
#define MSR_IDT_FCR4			0x0000010a
#define MSR_IDT_MCR0			0x00000110
#define MSR_IDT_MCR1			0x00000111
#define MSR_IDT_MCR2			0x00000112
#define MSR_IDT_MCR3			0x00000113
#define MSR_IDT_MCR4			0x00000114
#define MSR_IDT_MCR5			0x00000115
#define MSR_IDT_MCR6			0x00000116
#define MSR_IDT_MCR7			0x00000117
#define MSR_IDT_MCR_CTRL		0x00000120

#define CPU_HAS_CPUID			0x00000001
#define CPU_HAS_TSC			0x00000002
#define CPU_HAS_4M_PAGES		0x00000004
#define CPU_HAS_MSR			0x00000008
#define CPU_HAS_CMPXCHG8B		0x00000010
#define CPU_HAS_GLOBAL_PAGES		0x00000020
#define CPU_HAS_CMOV			0x00000040
#define CPU_HAS_SYSENTER		0x00000080
#define CPU_HAS_AMD_SYSCALL		0x00000100
#define CPU_INVLPG_BIG_PAGES		0x00000200
#define CPU_HAS_FXSR			0x00000400
#define CPU_HAS_SSE			0x00000800
#define CPU_HAS_SSE2			0x00001000
#define CPU_HAS_SSE3			0x00002000
#define CPU_PREFETCH_64			0x00004000
#define CPU_PREFETCH_128		0x00008000
#define CPU_HAS_PAT			0x00010000
#define CPU_HAS_SELF_SNOOP		0x00020000
#define CPU_FXSR_LEAK			0x00040000

#define FPU_ALIGN			16

#endif
