#ifndef __ARCH_ENDIAN_H
#define __ARCH_ENDIAN_H

#include <SYS/TYPES.H>

__BEGIN_DECLS

#ifndef __static__
#define __static__ static
#endif

#define __LITTLE_ENDIAN

#define __16CPU2BE_CONST(__x)	(((__x) >> 8) | (((__x) << 8) & 0xff00))
#define __16BE2CPU_CONST(__x)	__16CPU2BE_CONST(__x)
#define __32CPU2BE_CONST(__x)	((((__x) >> 24) | (((__x) >> 8) & 0xff00UL) | (((__x) << 8) & 0xff0000UL) | ((__x) << 24)) & 0xffffffffU)
#define __32BE2CPU_CONST(__x)	__32CPU2BE_CONST(__x)
#define __64CPU2BE_CONST(__x)	(((__u64)__32CPU2BE(__x) << 32) | __32CPU2BE((__x) >> 31 >> 1))
#define __64BE2CPU_CONST(__x)	__64CPU2BE_CONST(__x)

#ifndef __CROSS_COMPILING_LINKER

#ifdef ntohl
#undef ntohl
#endif
#ifdef htonl
#undef htonl
#endif
#ifdef ntohs
#undef ntohs
#endif
#ifdef htons
#undef htons
#endif

#ifdef __NO_INLINES
__u32 ntohl(__u32 __x);
#else
__static__ __finline__ __u32 ntohl(__u32 __x)
{
	if (__is_constant(__x)) return __32BE2CPU_CONST(__x);
	__asm__ ("BSWAP %0": "=r"(__x) : "0"(__x));
	return __x;
}
#endif

#ifdef __NO_INLINES
__u32 htonl(__u32 __x);
#else
__static__ __finline__ __u32 htonl(__u32 __x)
{
	if (__is_constant(__x)) return __32CPU2BE_CONST(__x);
	__asm__ ("BSWAP %0": "=r"(__x) : "0"(__x));
	return __x;
}
#endif

#ifdef __NO_INLINES
__u16 ntohs(__u16 __x);
#else
__static__ __finline__ __u16 ntohs(__u16 __x)
{
	if (__is_constant(__x)) return __16BE2CPU_CONST(__x);
	__asm__ ("RORW $8, %w0": "=g"(__x) : "0"(__x) : "cc");
	return __x;
}
#endif

#ifdef __NO_INLINES
__u16 htons(__u16 __x);
#else
__static__ __finline__ __u16 htons(__u16 __x)
{
	if (__is_constant(__x)) return __16CPU2BE_CONST(__x);
	__asm__ ("RORW $8, %w0": "=g"(__x) : "0"(__x) : "cc");
	return __x;
}
#endif

#endif

#ifndef __64_SWAP_DEFINED
#define __64_SWAP_DEFINED
static __finline__ __u64 __64swap(__u64 __x)
{
	__asm__ ("BSWAP %%EAX; BSWAP %%EDX; XCHGL %%EAX, %%EDX":"=A"(__x):"A"(__x));
	return __x;
}
#define __32swap htonl
#define __16swap htons
#endif

#define __16CPU2BE(__x)	(htons(__x))
#define __16BE2CPU(__x)	(ntohs(__x))
#define __32CPU2BE(__x) (htonl(__x))
#define __32BE2CPU(__x)	(ntohl(__x))
#define __64CPU2BE(__x) (__is_constant(__x) ? __64CPU2BE_CONST(__x) : __64swap(__x))
#define __64BE2CPU(__x) (__is_constant(__x) ? __64BE2CPU_CONST(__x) : __64swap(__x))

__END_DECLS

#endif
