#ifndef __ARCH_IRQ_H
#define __ARCH_IRQ_H

#include <SPAD/AC.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

typedef struct ____IRQ_STUB IRQ_STUB(void);

#define DECL_RT_IRQ_HANDLER(NAME)\
\
__u32 __FN_##NAME  (void *);\
\
extern IRQ_STUB NAME;\
\
__asm__("							\n\
.SECTION .text							\n\
.ALIGN	16							\n\
.GLOBAL	"#\NAME"						\n\
"#\NAME":							\n\
	/* Here used to be some assembler */			\n\
");\
\
__u32 __FN_##NAME (void *DATA)

#define IRQ_RETURN					\
do {							\
	return 0;					\
} while (0)

#define IRQ_POST_AST(RQ)				\
do {							\
	return (__u32)(RQ);				\
} while (0)

/*
 * REQUEST IRQ
 */

#define IRQ_LIMIT	0xff

typedef struct {
	void (*mask)(void);
	void (*eoi)(void);
} IRQ_CONTROL;

#define IRQ_EXCLUSIVE	0
#define IRQ_SHARED	1

#define IRQ_RT_HANDLER	0
#define IRQ_AST_HANDLER	2

#define IRQ_MASK	4

char *KERNEL$REQUEST_IRQ(int irq, int flags, IRQ_STUB *call, void *data, IRQ_CONTROL *ctrl, __const__ char *desc);

#define IRQ_RELEASE_MASKED	1

void KERNEL$RELEASE_IRQ(IRQ_CONTROL *ctrl, int flags);

void KERNEL$DI_HW(void);
void KERNEL$EI_HW(void);

__END_DECLS

#endif
