#ifndef __ARCH_LINK_H
#define __ARCH_LINK_H

#include <SYS/TYPES.H>

#define MACH_CURRENT	0x32334149

#define LINK_STARTUP_CODE_SIZE	5

#define SET_STARTUP_CODE(lh, off)					\
do {									\
	__u32 o_ = (off) - (__u32)&((struct link_header *)NULL)->startup_code[LINK_STARTUP_CODE_SIZE];\
	(lh)->startup_code[0] = 0xe9;					\
	(lh)->startup_code[1] = o_;					\
	(lh)->startup_code[2] = o_ >> 8;				\
	(lh)->startup_code[3] = o_ >> 16;				\
	(lh)->startup_code[4] = o_ >> 24;				\
} while (0)

#define CLEAR_STARTUP_CODE(lh)						\
do {									\
	(lh)->startup_code[0] = 0xcc;					\
	(lh)->startup_code[1] = 0;					\
	(lh)->startup_code[2] = 0;					\
	(lh)->startup_code[3] = 0;					\
	(lh)->startup_code[4] = 0;					\
} while (0)

#define RODATA_SECTION_ALIGN	64	/* this is maximum cacheline size */

#endif
