#ifndef __ARCH_MOV_H
#define __ARCH_MOV_H

#include <ARCH/CPU.H>
#include <SYS/TYPES.H>

static __finline__ void __MOVNTI32(__u32 *__dest, __u32 __src)
{
#ifndef __NO_SSE
	__asm__ ("							\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 43f, 44f, 0, 0, "__stringify(CPU_HAS_SSE2)", 0\n\
		.PREVIOUS						\n\
	41:	MOVNTI	%1, %0						\n\
	42:	.SECTION .text.end					\n\
	43:	MOVL	%1, %0						\n\
	44:	.PREVIOUS						\n\
	" : "=m"(*__dest) : "r"(__src));
#else
	*__dest = __src;
#endif
}

static __finline__ void __MOVNTI_FLUSH(void)
{
#ifndef __NO_SSE
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 42f, 42f, 0, 0, "__stringify(CPU_HAS_SSE2)", 0\n\
		.PREVIOUS						\n\
	41:	SFENCE							\n\
	42:								\n\
	");
#endif
}

static __finline__ void __MOVNTIPTR(void **__dest, void *__src)
{
	__MOVNTI32((__u32 *)__dest, (__u32)__src);
}

#ifndef __NO_SSE
#define __GEN_PREFETCH(arg, arg2, cond)					\
static __finline__ void __PREFETCH##arg##arg2(__const__ void *__ptr)	\
{									\
	__asm__ volatile ("						\n\
		.SECTION .FEATURE_FIXUP					\n\
		.LONG	41f, 42f, 42f, 42f, 0, 0, "__stringify(CPU_HAS_SSE)", 0\n\
	.IF	"__stringify(cond)" <> 0				\n\
		.LONG	41f, 42f, 42f, 42f, "__stringify(cond)", 0, 0, 0\n\
	.ENDIF								\n\
		.PREVIOUS						\n\
	41:	PREFETCH"#arg"	%0					\n\
	42:	" :: "m"(*(__u16 *)__ptr));				\
}		/* __u16 will alias least data */
#else
#define __GEN_PREFETCH(arg, arg2, cond)					\
static __finline__ void __PREFETCH##arg##arg2(__const__ void *__ptr)	\
{									\
}
#endif									\

__GEN_PREFETCH(NTA,,0)
__GEN_PREFETCH(T0,,0)
__GEN_PREFETCH(T1,,0)
__GEN_PREFETCH(T2,,0)
__GEN_PREFETCH(NTA,_IF32,CPU_PREFETCH_64)
__GEN_PREFETCH(T0,_IF32,CPU_PREFETCH_64)
__GEN_PREFETCH(T1,_IF32,CPU_PREFETCH_64)
__GEN_PREFETCH(T2,_IF32,CPU_PREFETCH_64)
__GEN_PREFETCH(NTA,_IF64,CPU_PREFETCH_128)
__GEN_PREFETCH(T0,_IF64,CPU_PREFETCH_128)
__GEN_PREFETCH(T1,_IF64,CPU_PREFETCH_128)
__GEN_PREFETCH(T2,_IF64,CPU_PREFETCH_128)

#endif
