#ifndef __ARCH_SETJMP_H
#define __ARCH_SETJMP_H

#include <SIGNAL.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

#define __JMPBUF_COMMON		\
	unsigned long __ebx;	\
	unsigned long __esp;	\
	unsigned long __ebp;	\
	unsigned long __esi;	\
	unsigned long __edi;	\
	unsigned long __eip;

typedef struct __jmp_buf {
	__JMPBUF_COMMON;
} jmp_buf[1];

typedef struct {
	__JMPBUF_COMMON;
	int __savemask;
	sigset_t __set;
} sigjmp_buf[1];

void KERNEL$THREAD_WAIT_FOR_LONGJMP(struct __jmp_buf *j);
int sigsetjmp(sigjmp_buf __env, int __savemask);
int _setjmp(jmp_buf __env);
void __NORET_ATTR__ __do_longjmp(jmp_buf __env, int __val);

static __finline__ void __NORET_ATTR__ _longjmp(jmp_buf __env, int __val)
{
	KERNEL$THREAD_WAIT_FOR_LONGJMP(__env);
	if (__unlikely(!__val)) __val = 1;
	__do_longjmp(__env, __val);
}

static __finline__ void __NORET_ATTR__ siglongjmp(sigjmp_buf __env, int __val)
{
	KERNEL$THREAD_WAIT_FOR_LONGJMP((struct __jmp_buf *)__env);
	if (__unlikely(!__val)) __val = 1;
	if (__env->__savemask) sigprocmask(SIG_SETMASK, &__env->__set, NULL);
	__do_longjmp((struct __jmp_buf *)__env, __val);
}

__END_DECLS

#endif
