#define __DEBUG			2

#define __DEBUG_INSECURE	1

/*
 * Use physical address extension. PAE allows you to access 64G physical ram.
 * PAE is slower than normal page tables, turn it on only if you have more than
 * 4G ram. When you turn it on, you must enable also CPU_HAS_PAE.
 */
#define __KERNEL_USE_PAE	0

#define __KERNEL_HIGH_IO	0

#define __KERNEL_CLUSTER_BITS	3

/*
 * Virtual memory for user space. One bank is 4M.
 */
#define __KERNEL_USER_VBANKS	768

/*
 * Timer frequency. Must be power of 2 and less than or equal to 65536.
 */
#define __KERNEL_TICK		256

/*
vim: textwidth=80
*/
