#ifndef __ARCH_SLAB_H
#define __ARCH_SLAB_H

#include <SYS/TYPES.H>
#include <ARCH/SETUP.H>
#include <ARCH/PAGE.H>
#include <ARCH/SPL.H>
#include <ARCH/BSF.H>

__BEGIN_DECLS

/*int __PRINTF_ATTR__(1,2) __critical_printf(__const__ char *__fmt, ...);*/

#ifndef __static__
#define __static__ static
#endif

#ifndef __SLHEAD_DEFINED
#define __SLHEAD_DEFINED

struct __slhead {
#ifdef __FROM_SLAB_C
	LIST_HEAD pages;
	LIST_HEAD free_pages;
	LIST_HEAD full_pages;
#else
	void *__p1, *__p2, *__p3, *__p4, *__p5, *__p6;
#endif
	struct __slpage *__current_page;
	unsigned __objsize;
	unsigned __objalign;
	int __n_pages;
	int __n_free_pages;
	long *__page_limit;
	int __alloc_type;
	void (*__ctor)(void *__g, void *__o);
	void *__g;
#ifdef __FROM_SLAB_C
	LIST_ENTRY global_list;
#else
	void *__p7, *__p8;
#endif
	int __n_reserved_pages;
	char *__name;
};

struct __slpage {
	struct __slentry *__freelist;
	struct __slhead *__head;
#ifdef __FROM_SLAB_C
	LIST_ENTRY list;
#else
	void *__p1, *__p2;
#endif
	int __n_alloc;
};

struct __slentry {
	struct __slentry *__nexte;
};

#endif

#define __SLAB_SIZE_ALIGN	4
#define __MIN_SLAB_SIZE		__SLAB_SIZE_ALIGN
#define __MALLOC_ALIGN		16

void KERNEL$SLAB_CHECK(struct __slhead *__sl, __const__ char *__msg);
void KERNEL$HEAP_CHECK(__const__ char *__msg);

#ifdef __NO_INLINES
void *__MALLOC_ATTR__ __slalloc(struct __slhead *__h);
#else
__static__ __finline__ void *__MALLOC_ATTR__ __slalloc(struct __slhead *__h)
{
	void *__r;
	void *__dummy;
	__asm__ volatile ("						\n\
	MOVL	(%2), %0						\n\
	TESTL	%0, %0							\n\
	JZ	1f							\n\
	MOVL	(%0), %3						\n\
	ADDL	$1, 16(%2)						\n\
	MOVL	%3, (%2)						\n\
5:									\n\
	.SECTION .text.end						\n\
	.ALIGN	4							\n\
1:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	MOVL	%3, %%EAX						\n\
	PUSHL	%%EDX							\n\
	CALL	KERNEL$__SLAB_ALLOC					\n\
	MOVL	8(%%ESP), %%ECX						\n\
	MOVL	%%EAX, 8(%%ESP)						\n\
	POPL	%%EDX							\n\
	MOVL	%%ECX, %%EAX						\n\
	POPL	%%ECX							\n\
	POPL	%0							\n\
	JMP	5b							\n\
	.PREVIOUS							\n\
":"=&r"(__r),"=r"(__dummy):"r"(__h->__current_page),"1"(__h):"cc","memory");
	/*if (__unlikely(!__r)) __critical_printf("SLALLOC FAIL: %s\n", __h->__name);*/
	return __r;
}
#endif

#ifdef __NO_INLINES
void __slfree(void *__s);
#else
__static__ __finline__ void __slfree(void *__s)
{
	void *__dummy;
	struct __slpage *__p = (struct __slpage *)((unsigned long)__s & __NOT_PAGE_CLUSTER_SIZE_MINUS_1);

	__asm__ volatile ("						\n\
	SUBL	$1, 16(%1)						\n\
	MOVL	(%1), %0						\n\
	MOVL	%2, (%1)						\n\
	MOVL	%0, (%2)						\n\
	JZ	1f							\n\
	TESTL	%0, %0							\n\
	JZ	2f							\n\
5:									\n\
	.SECTION .text.end						\n\
	.ALIGN	4							\n\
1:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	PUSHL	%%EDX							\n\
	MOVL	%1, %%EAX						\n\
	CALL	KERNEL$__SLAB_FREE_PAGE					\n\
	POPL	%%EDX							\n\
	POPL	%%ECX							\n\
	POPL	%%EAX							\n\
	JMP	5b							\n\
	.ALIGN	4							\n\
2:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	PUSHL	%%EDX							\n\
	MOVL	%1, %%EAX						\n\
	CALL	KERNEL$__SLAB_PARTIAL_PAGE				\n\
	POPL	%%EDX							\n\
	POPL	%%ECX							\n\
	POPL	%%EAX							\n\
	JMP	5b							\n\
	.PREVIOUS							\n\
":"=&r"(__dummy):"r"(__p),"r"(__s):"cc","memory");
}
#endif

#ifdef __NO_INLINES
unsigned __slsize(void *__s);
#else
__static__ __finline__ unsigned __slsize(void *__s)
{
	struct __slpage *__p;
	__p = (struct __slpage *)((unsigned long)__s & __NOT_PAGE_CLUSTER_SIZE_MINUS_1);
	return __p->__head->__objsize;
}
#endif

#ifndef __COMMON_C
static __finline__ unsigned __slheadsize(struct __slhead *__h)
{
	return __h->__objsize;
}
#endif

extern void *KERNEL$__STDHEAP_TOP;

#define __nonstdheap(__p)	((__p) >= KERNEL$__STDHEAP_TOP)

void *__MALLOC_ATTR__ KERNEL$__MALLOC(size_t __s, int __spl, int __synch);
void KERNEL$__FREE(void *__s);
extern struct __slhead *KERNEL$__MALLOC_BUCKETS[__BSR_MAX];

#define __malloc_core(__synch)						\
do {									\
	void *__dummy, *__dummy2;					\
	if (!__is_constant(__size)) {					\
		__asm__ volatile ("					\n\
		MOVL	$KERNEL$SPL, %1					\n\
		ORL	$3, %2						\n\
		PUSHL	(%1)						\n\
		BSRL	%2, %0						\n\
		MOVL	$-2 << "__stringify(__SPL_MALLOC)", (%1)	\n\
		MOVL	KERNEL$__MALLOC_BUCKETS(, %0, 4), %0		\n\
		MOVL	0x18(%0), %1					\n\
		MOVL	(%1), %0					\n\
		TESTL	%0, %0						\n\
		JZ	1f						\n\
		MOVL	(%0), %2					\n\
		ADDL	$1, 16(%1)					\n\
		MOVL	%2, (%1)					\n\
	5:								\n\
		POPL	%2						\n\
		MOVL	%2, KERNEL$SPL					\n\
		TESTL	%2, KERNEL$PPL					\n\
		JNE	9f						\n\
	8:								\n\
		.SECTION .text.end					\n\
		.ALIGN	4						\n\
	1:								\n\
		PUSHL	%%EAX						\n\
		PUSHL	%%ECX						\n\
		LEAL	1(%2), %%EAX					\n\
		PUSHL	%%EDX						\n\
		MOVL	%4, %%ECX					\n\
		MOVL	12(%%ESP), %%EDX				\n\
		CALL	KERNEL$__MALLOC					\n\
		MOVL	8(%%ESP), %%ECX					\n\
		MOVL	%%EAX, 8(%%ESP)					\n\
		POPL	%%EDX						\n\
		MOVL	%%ECX, %%EAX					\n\
		POPL	%%ECX						\n\
		POPL	%0						\n\
		JMP	5b						\n\
	9:	PUSHL	%%EAX						\n\
		PUSHL	%%ECX						\n\
		PUSHL	%%EDX						\n\
		PUSHL	%%ESI						\n\
		MOVL	%2, %%ESI					\n\
		CALL	KERNEL$PROCESS_PENDING_AST			\n\
		POPL	%%ESI						\n\
		POPL	%%EDX						\n\
		POPL	%%ECX						\n\
		POPL	%%EAX						\n\
		JMP	8b						\n\
		.PREVIOUS						\n\
	":"=&a"(__r),"=&r"(__dummy),"=&r"(__dummy2):"2"(__size - 1),"i"(__synch):"cc","memory");							\
	} else {							\
		__asm__ volatile ("					\n\
		MOVL	$KERNEL$SPL, %1					\n\
		PUSHL	(%1)						\n\
		MOVL	$-2 << "__stringify(__SPL_MALLOC)", (%1)	\n\
		MOVL	%3, %0						\n\
		MOVL	0x18(%0), %1					\n\
		MOVL	(%1), %0					\n\
		TESTL	%0, %0						\n\
		JZ	1f						\n\
		MOVL	(%0), %2					\n\
		ADDL	$1, 16(%1)					\n\
		MOVL	%2, (%1)					\n\
	5:								\n\
		POPL	%2						\n\
		MOVL	%2, KERNEL$SPL					\n\
		TESTL	%2, KERNEL$PPL					\n\
		JNE	9f						\n\
	8:								\n\
		.SECTION .text.end					\n\
		.ALIGN	4						\n\
	1:								\n\
		PUSHL	%%EAX						\n\
		PUSHL	%%ECX						\n\
		MOVL	%5, %%EAX					\n\
		PUSHL	%%EDX						\n\
		MOVL	%4, %%ECX					\n\
		MOVL	12(%%ESP), %%EDX				\n\
		CALL	KERNEL$__MALLOC					\n\
		MOVL	8(%%ESP), %%ECX					\n\
		MOVL	%%EAX, 8(%%ESP)					\n\
		POPL	%%EDX						\n\
		MOVL	%%ECX, %%EAX					\n\
		POPL	%%ECX						\n\
		POPL	%0						\n\
		JMP	5b						\n\
	9:	PUSHL	%%EAX						\n\
		PUSHL	%%ECX						\n\
		PUSHL	%%EDX						\n\
		PUSHL	%%ESI						\n\
		MOVL	%2, %%ESI					\n\
		CALL	KERNEL$PROCESS_PENDING_AST			\n\
		POPL	%%ESI						\n\
		POPL	%%EDX						\n\
		POPL	%%ECX						\n\
		POPL	%%EAX						\n\
		JMP	8b						\n\
		.PREVIOUS						\n\
	":"=&a"(__r),"=&r"(__dummy),"=&r"(__dummy2):"m"(KERNEL$__MALLOC_BUCKETS[__BSR_CONST((__size - 1) | 3)]),"i"(__synch),"ri"(__size):"cc","memory");\
	}								\
} while (0)

#ifdef __NO_INLINES
void free(void *__s);
#else
__static__ __finline__ void free(void *__s)
{
	void *__dummy;
	struct __slpage *__p;
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("free");
#endif
	__p = (struct __slpage *)((unsigned long)__s & __NOT_PAGE_CLUSTER_SIZE_MINUS_1);
	__asm__ volatile ("						\n\
	MOVL	$KERNEL$SPL, %0						\n\
	CMPL	%1, %2							\n\
	PUSHL	(%0)							\n\
	MOVL	$-2 << "__stringify(__SPL_MALLOC)", (%0)		\n\
	JE	33f							\n\
	CMPL	KERNEL$__STDHEAP_TOP, %2				\n\
33:	JAE	3f							\n\
	SUBL	$1, 16(%1)						\n\
	MOVL	(%1), %0						\n\
	MOVL	%2, (%1)						\n\
	MOVL	%0, (%2)						\n\
	JZ	1f							\n\
	TESTL	%0, %0							\n\
	JZ	2f							\n\
5:									\n\
	POPL	%0							\n\
	MOVL	%0, KERNEL$SPL						\n\
	TESTL	%0, KERNEL$PPL						\n\
	JNE	9f							\n\
8:									\n\
	.SECTION .text.end						\n\
	.ALIGN	4							\n\
1:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	PUSHL	%%EDX							\n\
	MOVL	%1, %%EAX						\n\
	CALL	KERNEL$__SLAB_FREE_PAGE					\n\
	POPL	%%EDX							\n\
	POPL	%%ECX							\n\
	POPL	%%EAX							\n\
	JMP	5b							\n\
	.ALIGN	4							\n\
2:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	PUSHL	%%EDX							\n\
	MOVL	%1, %%EAX						\n\
	CALL	KERNEL$__SLAB_PARTIAL_PAGE				\n\
	POPL	%%EDX							\n\
	POPL	%%ECX							\n\
	POPL	%%EAX							\n\
	JMP	5b							\n\
	.ALIGN	4							\n\
3:									\n\
	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	PUSHL	%%EDX							\n\
	MOVL	%2, %%EAX						\n\
	CALL	KERNEL$__FREE						\n\
	POPL	%%EDX							\n\
	POPL	%%ECX							\n\
	POPL	%%EAX							\n\
	JMP	5b							\n\
9:	PUSHL	%%EAX							\n\
	PUSHL	%%ECX							\n\
	PUSHL	%%EDX							\n\
	PUSHL	%%ESI							\n\
	MOVL	%0, %%ESI						\n\
	CALL	KERNEL$PROCESS_PENDING_AST				\n\
	POPL	%%ESI							\n\
	POPL	%%EDX							\n\
	POPL	%%ECX							\n\
	POPL	%%EAX							\n\
	JMP	8b							\n\
	.PREVIOUS							\n\
":"=&r"(__dummy):"r"(__p),"r"(__s):"cc","memory");
#ifdef __HEAP_CHECK
	KERNEL$HEAP_CHECK("free-out");
#endif
}
#endif

#ifndef __COMMON_C

static __finline__ void __slow_slfree(void *__s)
{
	__asm__ volatile ("						\n\
		PUSHAL							\n\
		.IFNC	%0,%%eax					\n\
		XCHGL	%0, %%EAX					\n\
		.ENDIF							\n\
		CALL	__slfree					\n\
		POPAL							\n\
	"::"r"(__s):"cc","memory");
}

static __finline__ void __slow_free(void *__s)
{
	__asm__ volatile ("						\n\
		PUSHAL							\n\
		.IFNC	%0,%%eax					\n\
		XCHGL	%0, %%EAX					\n\
		.ENDIF							\n\
		CALL	free						\n\
		POPAL							\n\
	"::"r"(__s):"cc","memory");
}

#endif

#define __calloc_multiply						\
	unsigned __test;						\
	__asm__ ("MULL %3" : "=a"(__ss), "=d"(__test) : "a"(__n), "rm"(__size) : "cc");\
	if (__unlikely(__test)) goto __me;				\

__END_DECLS

#endif
