#ifndef __ARCH_SPL_H
#define __ARCH_SPL_H

#include <SYS/TYPES.H>
#include <ARCH/SETUP.H>

__BEGIN_DECLS

void __PRINTF_ATTR__(1,2) __NORET_ATTR__ KERNEL$SUICIDE(__const__ char *__fmt, ...);

#define __SPL_MALLOC		28

extern unsigned KERNEL$SPL;
extern volatile unsigned KERNEL$PPL;
extern unsigned KERNEL$BPL;

int __SPL_X_NOT_CONSTANT(void);
int __BAD_SPLX_BUSY_CONSTANT(void);
int __BAD_SPLX_BELOW_CONSTANT_1(void);
int __BAD_SPLX_BELOW_CONSTANT_2(void);
int __BAD_SPLX_MIN_CONSTANT_1(void);
int __BAD_SPLX_MIN_CONSTANT_2(void);
int __BAD_SPLX_MAX_CONSTANT_1(void);
int __BAD_SPLX_MAX_CONSTANT_2(void);
void __BAD_RAISE_SPLX_CONSTANT(void);
void __BAD_LOWER_SPLX_CONSTANT(void);
void __BAD_TEST_SPLX_LOW_CONSTANT(void);
void __BAD_TEST_SPLX_HIGH_CONSTANT(void);
void __BAD_TEST_SPLX_CONSTANTS(void);

#define __SPLX_OK(__spl)	(__likely(!(((__spl) | ((__spl)-1)) + 1)) && __likely(__spl))
#if defined(__GNUC__) && __GNUC__ >= 3
#define __SPLX_TEST_FAIL(__spl, __fn)	__is_constant(__spl) && !__SPLX_OK(__spl) ? __fn()
#define __SPL_TEST_CONST(__arg, __fn)	!__is_constant(__arg) || (__arg) > 30 ? __fn()
#else
#define __SPLX_TEST_FAIL(__spl, __fn)	0 ? 0
#define __SPL_TEST_CONST(__arg, __fn)	0 ? 0
#endif

#define __SPLX_BELOW(__spl1, __spl2) (__SPLX_TEST_FAIL(__spl1, __BAD_SPLX_BELOW_CONSTANT_1) : __SPLX_TEST_FAIL(__spl2, __BAD_SPLX_BELOW_CONSTANT_2) : (unsigned)(__spl1) > (unsigned)(__spl2))
#define __SPL_X(__spl)		(__SPL_TEST_CONST(__spl, __SPL_X_NOT_CONSTANT) : (-1U) << ((__spl) + 1))

#define __SPLX_BUSY(__spl)	(__SPLX_TEST_FAIL(__spl, __BAD_SPLX_BUSY_CONSTANT) : (KERNEL$PPL & (__spl)) != 0)
#define __SPL_BUSY(__spl)	__SPLX_BUSY(__SPL_X(__spl))

#define __SPLX_MIN(__s1, __s2)	(__SPLX_TEST_FAIL(__s1, __BAD_SPLX_MIN_CONSTANT_1) : __SPLX_TEST_FAIL(__s2, __BAD_SPLX_MIN_CONSTANT_2) : (__s1) | (__s2))
#define __SPLX_MAX(__s1, __s2)	(__SPLX_TEST_FAIL(__s1, __BAD_SPLX_MAX_CONSTANT_1) : __SPLX_TEST_FAIL(__s2, __BAD_SPLX_MAX_CONSTANT_2) : (__s1) & (__s2))

void KERNEL$PROCESS_PENDING_AST(void);

#define __RAISE_SPLX(__PL)						\
do {									\
	if (__is_constant(__PL)) if (!__SPLX_OK(__PL)) __BAD_RAISE_SPLX_CONSTANT();									\
	if (__DEBUG < 2 || (__is_constant(__PL) && (unsigned)__PL == 0x80000000)) __asm__ volatile ("MOVL %0, KERNEL$SPL"::"ri"(__PL):"memory");	\
	else __asm__ volatile ("					\n\
		CMPL	%0, KERNEL$SPL					\n\
	.IFC %1,$0							\n\
		JB	77f						\n\
		PUSHL	%0						\n\
		SUBL	$1, %0						\n\
		JC	771f						\n\
		ORL	(%%ESP), %0					\n\
		INCL	%0						\n\
	771:	POPL	%0						\n\
	77:	JNZ	7f						\n\
	.ELSE								\n\
		JB	7f						\n\
	.ENDIF								\n\
	6:								\n\
	.SECTION .rodata						\n\
	.IFNDEF	__RAISE_SPLX_MSG					\n\
	__RAISE_SPLX_MSG:						\n\
		.STRING	\"__RAISE_SPLX: BAD RAISE, VAL %%08X, SPL %%08X, BPL %%08X\"									\n\
	.ENDIF								\n\
	.PREVIOUS							\n\
	.SECTION .text.end						\n\
	7:	PUSHL	KERNEL$BPL					\n\
		PUSHL	KERNEL$SPL					\n\
		PUSHL	%0						\n\
		PUSHL	$__RAISE_SPLX_MSG				\n\
		PUSHL	$6b						\n\
		JMP	KERNEL$SUICIDE					\n\
	.PREVIOUS							\n\
		MOVL	%0, KERNEL$SPL					\n\
	": :"r"(__PL),"ri"(2*__builtin_constant_p(__PL)):"memory");	\
} while (0)
/* 2*__builtin_constant_p is there because of a subtle gcc bug.
   (1* doesn't work) */

#define __RAISE_SPL(__PL)	__RAISE_SPLX(__SPL_X(__PL))

#define __LOWER_SPLX(__PL)						\
do {									\
	if (__is_constant(__PL)) if (!__SPLX_OK(__PL)) __BAD_LOWER_SPLX_CONSTANT();									\
	__asm__ volatile ("						\n\
	.IF "__stringify(__DEBUG)" >= 2					\n\
		CMPL	%0, KERNEL$BPL					\n\
		JB	99f						\n\
		CMPL	%0, KERNEL$SPL					\n\
		JA	99f						\n\
	.IFC %1,$0							\n\
		PUSHL	%0						\n\
		SUBL	$1, %0						\n\
		JC	771f						\n\
		ORL	(%%ESP), %0					\n\
		INCL	%0						\n\
	771:	POPL	%0						\n\
		JNZ	99f						\n\
	.ENDIF								\n\
	6:								\n\
	.SECTION .rodata						\n\
	.IFNDEF	__LOWER_SPLX_MSG					\n\
	__LOWER_SPLX_MSG:						\n\
		.STRING	\"__LOWER_SPLX: BAD LOWER, VAL %%08X, SPL %%08X, BPL %%08X\"									\n\
	.ENDIF								\n\
	.PREVIOUS							\n\
	.ENDIF								\n\
		MOVL	%0, KERNEL$SPL					\n\
		TESTL	%0, KERNEL$PPL					\n\
	99:	JNZ	9f						\n\
	8:								\n\
	.SECTION .text.end						\n\
		.ALIGN	16						\n\
	9:								\n\
	.IF "__stringify(__DEBUG)" >= 2					\n\
		CMPL	%0, KERNEL$BPL					\n\
		JB	7f						\n\
		CMPL	%0, KERNEL$SPL					\n\
		JA	7f						\n\
	.ENDIF								\n\
		PUSHL	%%EAX						\n\
		PUSHL	%%ECX						\n\
		PUSHL	%%EDX						\n\
	.IFNC %0,%%esi							\n\
		PUSHL	%%ESI						\n\
		MOVL	%0, %%ESI					\n\
	.IF "__stringify(__DEBUG)" >= 2					\n\
	.IFC %1,$0							\n\
		SUBL	$1, %0						\n\
		JC	71f						\n\
		ORL	%%ESI, %0					\n\
		INCL	%0						\n\
		JNZ	71f						\n\
	.IFNC %0,%%eax							\n\
	.IFNC %0,%%ecx							\n\
	.IFNC %0,%%edx							\n\
		MOVL	%%ESI, %0					\n\
	.ENDIF								\n\
	.ENDIF								\n\
	.ENDIF								\n\
	.ENDIF								\n\
	.ENDIF								\n\
	.ELSE								\n\
	.IF "__stringify(__DEBUG)" >= 2					\n\
	.IFC %1,$0							\n\
		MOVL	%0, %%EAX					\n\
		SUBL	$1, %%EAX					\n\
		JC	7f						\n\
		ORL	%0, %%EAX					\n\
		INCL	%%EAX						\n\
		JNZ	7f						\n\
	.ENDIF								\n\
	.ENDIF								\n\
	.ENDIF								\n\
		CALL	KERNEL$PROCESS_PENDING_AST			\n\
	.IFNC %0,%%esi							\n\
		POPL	%%ESI						\n\
	.ENDIF								\n\
		POPL	%%EDX						\n\
		POPL	%%ECX						\n\
		POPL	%%EAX						\n\
		JMP	8b						\n\
	.IF "__stringify(__DEBUG)" >= 2					\n\
	.IFNC %0,%%esi							\n\
	.IFC %1,$0							\n\
	71:	MOVL	%%ESI, %0					\n\
	.ENDIF								\n\
	.ENDIF								\n\
	7:	PUSHL	KERNEL$BPL					\n\
		PUSHL	KERNEL$SPL					\n\
		PUSHL	%0						\n\
		PUSHL	$__LOWER_SPLX_MSG				\n\
		PUSHL	$6b						\n\
		JMP	KERNEL$SUICIDE					\n\
	.ENDIF								\n\
	.PREVIOUS							\n\
	": :"r"(__PL),"ri"(2*__builtin_constant_p(__PL)):"cc","memory");\
} while (0)
/* 2*__builtin_constant_p is there because of a subtle gcc bug.
   (1* doesn't work) */

#define __LOWER_SPL(__PL)	__LOWER_SPLX(__SPL_X(__PL))

#define __TEST_SPLX(__PL_LOW, __PL_HIGH)				\
do {									\
	if (__is_constant(__PL_LOW)) if (!__SPLX_OK(__PL_LOW)) __BAD_TEST_SPLX_LOW_CONSTANT();								\
	if (__is_constant(__PL_HIGH)) if (!__SPLX_OK(__PL_HIGH)) __BAD_TEST_SPLX_HIGH_CONSTANT();							\
	if (__is_constant(__PL_LOW) && __is_constant(__PL_HIGH)) if (__SPLX_BELOW(__PL_HIGH, __PL_LOW)) __BAD_TEST_SPLX_CONSTANTS();			\
	if (__DEBUG >= 2 && (__unlikely(!__SPLX_OK(__PL_LOW)) || __unlikely(!__SPLX_OK(__PL_HIGH)) || __unlikely(__SPLX_BELOW(__PL_HIGH, __PL_LOW)) || __unlikely(__PL_HIGH != KERNEL$SPL) || __unlikely(__SPLX_BELOW(__PL_LOW, KERNEL$BPL))))\
		KERNEL$SUICIDE("__TEST_SPLX: BAD TEST, LOW %08X, HIGH %08X, SPL %08X, BPL %08X", __PL_LOW, __PL_HIGH, KERNEL$SPL, KERNEL$BPL);		\
	__asm__ volatile ("						\n\
		TESTL	%0, KERNEL$PPL					\n\
		JNZ	9f						\n\
	8:								\n\
	.SECTION .text.end						\n\
		.ALIGN	16						\n\
	9:	PUSHL	%%EAX						\n\
		PUSHL	%%ECX						\n\
		PUSHL	%%EDX						\n\
	.IFNC %0,%%esi							\n\
		PUSHL	%%ESI						\n\
		MOVL	%0, %%ESI					\n\
	.ENDIF								\n\
		CALL	KERNEL$PROCESS_PENDING_AST			\n\
	.IFNC %0,%%esi							\n\
		POPL	%%ESI						\n\
	.ENDIF								\n\
		POPL	%%EDX						\n\
		POPL	%%ECX						\n\
		POPL	%%EAX						\n\
		MOVL	%1, KERNEL$SPL					\n\
		JMP	8b						\n\
	.PREVIOUS							\n\
	": :"ri"(__PL_LOW),"ri"(__PL_HIGH):"cc","memory");		\
} while (0)

#define __TEST_SPL(__PL_LOW, __PL_HIGH)	__TEST_SPLX(__SPL_X(__PL_LOW), __SPL_X(__PL_HIGH))

__END_DECLS

#endif
