#ifndef __ARCH_STRING_H
#define __ARCH_STRING_H

#include <SYS/TYPES.H>
#include <ARCH/BARRIER.H>

#define __MEMSET_ALIGN_LIMIT	64
#define __MEMSET_EXPAND_LIMIT	64
#define __MEMCPY_ALIGN_LIMIT	64
#define __MEMCPY_EXPAND_LIMIT	64

__BEGIN_DECLS

#ifndef __static__
#define __static__ static
#endif

	/**********
	 * memset *
	 **********/

#ifndef __NO_INLINES
static __finline__ void *__generic_memset(void *__s, __u32 __c, size_t __count)
{
	__u32 __sink1, __sink2;
	__asm__ __volatile__ ("					\n\
		TESTL	$(-"__stringify(__MEMSET_ALIGN_LIMIT)") | 3, %%ECX\n\
		JNZ	1f					\n\
		.SECTION .text.end				\n\
		.ALIGN	"__stringify(__CPU_BRANCH_ALIGN)"	\n\
	1:	TESTL	$3, %%EDI				\n\
		JNE	3f					\n\
	4:	TESTL	$1, %%ECX				\n\
		JZ	2f					\n\
		LEAL	-1(%%ECX), %%ECX			\n\
		MOVB	%%AL, (%%EDI,%%ECX)			\n\
	2:	TESTL	$2, %%ECX				\n\
		JZ	0f					\n\
		MOVW	%%AX, -2(%%EDI,%%ECX)			\n\
		JMP	0f					\n\
		.ALIGN	"__stringify(__CPU_BRANCH_ALIGN)"	\n\
	3:	MOVB	%%AL, (%%EDI)				\n\
		ADDL	$1, %%EDI				\n\
		TESTL	$3, %%EDI				\n\
		LOOPNZ	3b					\n\
		JMP	4b					\n\
		.PREVIOUS					\n\
	0:	SHRL	$2, %%ECX				\n\
		REP; STOSL					\n\
	":"=c"(__sink1),"=D"(__sink2):"a"(__c),"0"(__count),"1"(__s):"cc","memory");
	return __s;
}

static __finline__ void *__constant_memset(void *__s, __u32 __c, size_t __count)
{
	if (__count < __MEMSET_EXPAND_LIMIT) {
		if (!__count) return __s;
		if (__count == 1) {
			((__u8 *)__s)[0] = __c;
			return __s;
		}
		if (__count == 2) {
			__barrier();
			((__u16 *)__s)[0] = __c;
			__barrier();
			return __s;
		}
		if (__count == 3) {
			__barrier();
			((__u16 *)__s)[0] = __c;
			((__u8 *)__s)[2] = __c;
			__barrier();
			return __s;
		}
		if (__count == 4) {
			__barrier();
			((__u32 *)__s)[0] = __c;
			__barrier();
			return __s;
		}
		__asm__ __volatile__ ("				\n\
			_N = 0					\n\
			.REPT	%2 / 4				\n\
			.IF	_N				\n\
			MOVL	%1, _N(%0)			\n\
			.ELSE					\n\
			MOVL	%1, (%0)			\n\
			.ENDIF					\n\
			_N = _N + 4				\n\
			.ENDR					\n\
			.IF	%2 & 2				\n\
			.IF	_N				\n\
			MOVW	%w1, _N(%0)			\n\
			.ELSE					\n\
			MOVW	%w1, (%0)			\n\
			.ENDIF					\n\
			_N = _N + 2				\n\
			.ENDIF					\n\
			.IF	%2 & 1				\n\
			.IF	_N				\n\
			MOVB	%b1, _N(%0)			\n\
			.ELSE					\n\
			MOVB	%b1, (%0)			\n\
			.ENDIF					\n\
			_N = _N + 1				\n\
			.ENDIF					\n\
		"::"r"(__s),"q"(__c),"m"(*(void **)__count):"cc","memory");
		return __s;
	} else {
		/* assume that the pointer is aligned */
		__u32 __sink1, __sink2;
		__asm__ __volatile__ ("				\n\
			REP; STOSL				\n\
			.IF	(%2 & 3) == 1			\n\
			MOVB	%%AL, (%%EDI)			\n\
			.ENDIF					\n\
			.IF	(%2 & 3) == 2			\n\
			MOVW	%%AX, (%%EDI)			\n\
			.ENDIF					\n\
			.IF	(%2 & 3) == 3			\n\
			MOVW	%%AX, (%%EDI)			\n\
			MOVB	%%AL, 2(%%EDI)			\n\
			.ENDIF					\n\
		":"=c"(__sink1),"=D"(__sink2):"m"(*(void **)__count),"a"(__c),"0"(__count / 4),"1"(__s):"cc","memory");
		return __s;
	}
}
#endif

#ifdef __NO_INLINES
void *memset(void *__s, int __c, size_t __count);
#else
__static__ __finline__ void *memset(void *__s, int __c, size_t __count)
{
#if defined(__GNUC__) && __GNUC__ >= 3
	if (__is_constant(__c)) {
		__c = (__u8)__c * 0x01010101;
/* note: gcc has some bug --- after the following asm statement, it thinks that
   __count is not constant */
		if (__is_constant(__count)) return __constant_memset(__s, __c, __count);
	} else
#endif
	{
		__u32 __sink;
		__asm__ ("					\n\
			MOVB	%b1, %h1			\n\
			MOVZWL	%w1, %0				\n\
			SHLL	$16, %1				\n\
			ORL	%1, %0				\n\
		":"=&a"(__c),"=q"(__sink):"1"(__c):"cc");
	}
	return __generic_memset(__s, __c, __count);
}
#endif


	/**********
	 * memcpy *
	 **********/

#ifndef __NO_INLINES
static __finline__ void *__constant_memcpy_memmove_fwd(void *__t, __const__ void *__f, size_t __count)
{
	if (__count < __MEMCPY_EXPAND_LIMIT) {
		__u32 __sink1;
		if (!__count) return __t;
		__asm__ __volatile__ ("				\n\
			_N = 0					\n\
			.REPT	%3 / 4				\n\
			.IF	_N				\n\
			MOVL	_N(%2), %0			\n\
			MOVL	%0, _N(%1)			\n\
			.ELSE					\n\
			MOVL	(%2), %0			\n\
			MOVL	%0, (%1)			\n\
			.ENDIF					\n\
			_N = _N + 4				\n\
			.ENDR					\n\
			.IF	%3 & 2				\n\
			.IF	_N				\n\
			MOVZWL	_N(%2), %0			\n\
			MOVW	%w0, _N(%1)			\n\
			.ELSE					\n\
			MOVZWL	(%2), %0			\n\
			MOVW	%w0, (%1)			\n\
			.ENDIF					\n\
			_N = _N + 2				\n\
			.ENDIF					\n\
			.IF	%3 & 1				\n\
			.IF	_N				\n\
			MOVZBL	_N(%2), %0			\n\
			MOVB	%b0, _N(%1)			\n\
			.ELSE					\n\
			MOVZBL	(%2), %0			\n\
			MOVB	%b0, (%1)			\n\
			.ENDIF					\n\
			_N = _N + 1				\n\
			.ENDIF					\n\
		":"=&q"(__sink1):"r"(__t),"r"(__f),"m"(*(void **)__count):"cc","memory");
		return __t;
	} else {
		/* assume that the pointer is aligned */
		__u32 __sink1, __sink2, __sink3;
		__asm__ __volatile__ ("				\n\
			REP; MOVSL				\n\
			.IF	(%3 & 3) == 1			\n\
			MOVSB					\n\
			.ENDIF					\n\
			.IF	(%3 & 3) == 2			\n\
			MOVSW					\n\
			.ENDIF					\n\
			.IF	(%3 & 3) == 3			\n\
			MOVSW					\n\
			MOVSB					\n\
			.ENDIF					\n\
		":"=c"(__sink1),"=D"(__sink2),"=S"(__sink3):"m"(*(void **)__count),"0"(__count / 4),"1"(__t),"2"(__f):"cc","memory");
		return __t;
	}
}

static __finline__ void *__generic_memcpy(void *__t, __const__ void *__f, size_t __count)
{
	__u32 __sink1, __sink2, __sink3;
	__asm__ __volatile__ ("					\n\
		TESTL	$(-"__stringify(__MEMCPY_ALIGN_LIMIT)") | 3, %%ECX\n\
		JNZ	1f					\n\
		.SECTION .text.end				\n\
		.ALIGN	"__stringify(__CPU_BRANCH_ALIGN)"	\n\
	1:	TESTL	$3, %%EDI				\n\
		JNE	3f					\n\
	4:	PUSHL	%%EAX					\n\
		TESTL	$1, %%ECX				\n\
		JZ	2f					\n\
		LEAL	-1(%%ECX), %%ECX			\n\
		MOVZBL	(%%ESI,%%ECX), %%EAX			\n\
		MOVB	%%AL, (%%EDI,%%ECX)			\n\
	2:	TESTL	$2, %%ECX				\n\
		JZ	10f					\n\
		MOVZWL	-2(%%ESI,%%ECX), %%EAX			\n\
		MOVW	%%AX, -2(%%EDI,%%ECX)			\n\
	10:	POPL	%%EAX					\n\
		JMP	0f					\n\
		.ALIGN	"__stringify(__CPU_BRANCH_ALIGN)"	\n\
	3:	MOVSB						\n\
		TESTL	$3, %%EDI				\n\
		LOOPNZ	3b					\n\
		JMP	4b					\n\
		.PREVIOUS					\n\
	0:	SHRL	$2, %%ECX				\n\
		REP; MOVSL					\n\
	":"=c"(__sink1),"=D"(__sink2),"=S"(__sink3):"0"(__count),"1"(__t),"2"(__f):"cc","memory");
	return __t;
}
#endif

#ifdef __NO_INLINES
void *memcpy(void *__t, __const__ void *__f, size_t __count);
#else
__static__ __finline__ void *memcpy(void *__t, __const__ void *__f, size_t __count)
{
#if defined(__GNUC__) && __GNUC__ >= 3
	if (__is_constant(__count)) return __constant_memcpy_memmove_fwd(__t, __f, __count);
#endif
	return __generic_memcpy(__t, __f, __count);
}
#endif

#ifdef __NO_INLINES
void *mempcpy(void *__t, __const__ void *__f, size_t __count);
#else
__static__ __finline__ void *mempcpy(void *__t, __const__ void *__f, size_t __count)
{
#if defined(__GNUC__) && __GNUC__ >= 3
	if (__is_constant(__count)) return (char *)__constant_memcpy_memmove_fwd(__t, __f, __count) + __count;
#endif
	return (char *)__generic_memcpy(__t, __f, __count) + __count;
}
#endif

#define __mempcpy	mempcpy

	/***********
	 * memmove *
	 ***********/

#ifndef __NO_INLINES
static __finline__ void *__generic_memmove_fwd(void *__t, __const__ void *__f, size_t __count)
{
	__u32 __sink1, __sink2, __sink3;
	__asm__ __volatile__ ("					\n\
		TESTL	$(-"__stringify(__MEMCPY_ALIGN_LIMIT)"), %%ECX\n\
		JNZ	1f					\n\
		.SECTION .text.end				\n\
		.ALIGN	"__stringify(__CPU_BRANCH_ALIGN)"	\n\
	1:	TESTL	$3, %%EDI				\n\
		JE	0f					\n\
		.ALIGN	"__stringify(__CPU_BRANCH_ALIGN)"	\n\
	3:	MOVSB						\n\
		TESTL	$3, %%EDI				\n\
		LOOPNZ	3b					\n\
		JMP	0f					\n\
	11:	REP; MOVSB					\n\
		JMP	10f					\n\
		.PREVIOUS					\n\
	0:	PUSHL	%%ECX					\n\
		SHRL	$2, %%ECX				\n\
		REP; MOVSL					\n\
		POPL	%%ECX					\n\
		ANDL	$3, %%ECX				\n\
		JNZ	11b					\n\
	10:							\n\
	":"=c"(__sink1),"=D"(__sink2),"=S"(__sink3):"0"(__count),"1"(__t),"2"(__f):"cc","memory");
	return __t;
}

static __finline__ void *__generic_memmove_back(void *__t, __const__ void *__f, size_t __count)
{
	__u32 __sink1, __sink2;
	__asm__ __volatile__ ("					\n\
		SUBL	$4, %4					\n\
		JB	3f					\n\
		.ALIGN	"__stringify(__CPU_LOOP_ALIGN)"		\n\
	1:	MOVL	(%3, %4), %1				\n\
		MOVL	%1, (%2, %4)				\n\
		SUBL	$4, %4					\n\
		JAE	1b					\n\
	3:	ADDL	$4, %4					\n\
		JNZ	2f					\n\
	0:							\n\
		.SECTION .text.end				\n\
		.ALIGN	"__stringify(__CPU_BRANCH_ALIGN)"	\n\
	2:	MOVZBL	-1(%3, %4), %1				\n\
		MOVB	%b1, -1(%2, %4)				\n\
		SUBL	$1, %4					\n\
		JNZ	2b					\n\
		JMP	0b					\n\
		.PREVIOUS					\n\
	":"=&r"(__sink1),"=&q"(__sink2):"r"(__t),"r"(__f),"0"(__count):"cc","memory");
	return __t;
}
#endif

#ifdef __NO_INLINES
void *memmove(void *__t, __const__ void *__f, size_t __count);
#else
__static__ __finline__ void *memmove(void *__t, __const__ void *__f, size_t __count)
{
	if (__likely((unsigned long)((char *)__t - (char *)__f) >= __count)) {
#if defined(__GNUC__) && __GNUC__ >= 3
		if (__is_constant(__count)) return __constant_memcpy_memmove_fwd(__t, __f, __count);
#endif
		return __generic_memmove_fwd(__t, __f, __count);
	} else {
		return __generic_memmove_back(__t, __f, __count);
	}
}
#endif

	/************
	 * noinline *
	 ************/

size_t strlen(__const__ char *__s);
size_t strnlen(__const__ char *__s, size_t __count);
char *stpcpy(char *__dest, __const__ char *__src);
size_t strlcpy(char *__dest, __const__ char *__src, size_t __count);
char *strncpy(char *__dest, __const__ char *__src, size_t __count);
char *stpcat(char *__dest, __const__ char *__src);
char *strncat(char *__dest, __const__ char *__src, size_t __count);
char *strstr(__const__ char *__str, __const__ char *__substr);
int strcmp(__const__ char *__s1, __const__ char *__s2);
int strncmp(__const__ char *__s1, __const__ char *__s2, size_t __count);
int _strcasecmp(__const__ char *__s1, __const__ char *__s2);
void *memchr(__const__ void *__s, int __c, size_t __count);
int memcmp(__const__ void *__s1, __const__ void *__s2, size_t __count);

	/**********
	 * strcpy *
	 **********/

#ifdef __NO_INLINES
char *strcpy(char *__dest, __const__ char *__src);
#elif !defined(__COMMON_C)
static __finline__ char *strcpy(char *__dest, __const__ char *__src)
{
	stpcpy(__dest, __src);
	return __dest;
}
#endif

	/**********
	 * strcat *
	 **********/

#ifdef __NO_INLINES
char *strcat(char *__dest, __const__ char *__src);
#elif !defined(__COMMON_C)
static __finline__ char *strcat(char *__dest, __const__ char *__src)
{
	stpcat(__dest, __src);
	return __dest;
}
#endif

	/***********
	 * strlcat *
	 ***********/

#ifdef __NO_INLINES
size_t strlcat(char *__dest, __const__ char *__src, size_t __count);
#else
__static__ __finline__ size_t strlcat(char *__dest, __const__ char *__src, size_t __count)
{
	size_t __l = strnlen(__dest, __count);
	return __l + strlcpy(__dest + __l, __src, __count - __l);
}
#endif

	/**********
	 * strchr *
	 **********/

char *___strchr_alias(__const__ char *__str, int __c);
char *___strchr_const(__const__ char *__str, int __c);
#ifdef __NO_INLINES
char *strchr(__const__ char *__str, int __c);
#elif !defined(__COMMON_C)
static __finline__ char *strchr(__const__ char *__str, int __c)
{
	if (__is_constant(__c)) return ___strchr_const(__str, ((__u8)__c * 0x01010101));
	else return ___strchr_alias(__str, __c);
}
#endif

	/***********
	 * strrchr *
	 ***********/

char *___strrchr_alias(__const__ char *__str, int __c);
char *___strrchr_const(__const__ char *__str, int __c);
#ifdef __NO_INLINES
char *strrchr(__const__ char *__str, int __c);
#elif !defined(__COMMON_C)
static __finline__ char *strrchr(__const__ char *__str, int __c)
{
	if (__is_constant(__c)) return ___strrchr_const(__str, ((__u8)__c * 0x01010101));
	else return ___strrchr_alias(__str, __c);
}
#endif

	/*******
	 * ffs *
	 *******/

#ifdef __NO_INLINES
int ffs(int __x);
#else
__static__ __finline__ int ffs(int __x)
{
	int __y;
	__asm__ ("				\n\
		BSFL %1, %0			\n\
		JZ 1f				\n\
	2:	.SECTION .text.end		\n\
	1:	MOVL $-1, %0			\n\
		JMP 2b				\n\
		.PREVIOUS			\n\
	" : "=r"(__y) : "rm"(__x) : "cc");
	return __y + 1;
}
#endif

#ifdef __NO_INLINES
int ffsl(long __x);
#else
__static__ __finline__ int ffsl(long __x)
{
	return ffs(__x);
}
#endif

#ifdef __NO_INLINES
int fls(int __x);
#else
__static__ __finline__ int fls(int __x)
{
	int __y;
	__asm__ ("				\n\
		BSRL %1, %0			\n\
		JZ 1f				\n\
	2:	.SECTION .text.end		\n\
	1:	MOVL $-1, %0			\n\
		JMP 2b				\n\
		.PREVIOUS			\n\
	" : "=r"(__y) : "rm"(__x) : "cc");
	return __y + 1;
}
#endif

#ifdef __NO_INLINES
int flsl(long __x);
#else
__static__ __finline__ int flsl(long __x)
{
	return ffs(__x);
}
#endif

	/***************
	 * __upcasechr *
	 ***************/

#ifdef __NO_INLINES
char __upcasechr(char __c);
#else
__static__ __finline__ char __upcasechr(char __c)
{
	__u8 __nc, __add;
	__asm__ ("			\n\
		CMPB	$26, %0		\n\
		SETNB	%1		\n\
	":"=q"(__nc),"=q"(__add):"0"((unsigned char)(__c - 0x61)):"cc");
	return __nc + (__add << 5) + 0x41;
}
#endif

	/***************
	 * __locasechr *
	 ***************/

#ifdef __NO_INLINES
char __locasechr(char __c);
#else
__static__ __finline__ char __locasechr(char __c)
{
	__u8 __nc, __add;
	__asm__ ("			\n\
		CMPB	$26, %0		\n\
		SETB	%1		\n\
	":"=q"(__nc),"=q"(__add):"0"((unsigned char)(__c - 0x41)):"cc");
	return __nc + (__add << 5) + 0x41;
}
#endif

	/************
	 * __upcase *
	 ************/

#ifdef __NO_INLINES
void __upcase(char *__ptr);
#else
__static__ __finline__ void __upcase(char *__ptr)
{
	while (*__ptr) {
		if (__unlikely((unsigned char)(*__ptr - 0x61) < (unsigned char)26)) *__ptr -= 0x20;
		__ptr++;
	}
}
#endif

	/***************
	 * _memcasecmp *
	 ***************/

/* must not touch memory after first mismatch */
#ifdef __NO_INLINES
int _memcasecmp(__const__ void *__s1, __const__ void *__s2, size_t __count);
#else
__static__ __finline__ int _memcasecmp(__const__ void *__s1, __const__ void *__s2, size_t __count)
{
	__const__ unsigned char *__p1 = (__const__ unsigned char *)__s1, *__p2 = (__const__ unsigned char *)__s2;
	while (__count--) {
		int __diff = (unsigned char)__upcasechr(*__p1++) - (unsigned char)__upcasechr(*__p2++);
		if (__unlikely(__diff)) return __diff;
	}
	return 0;
}
#endif

	/*****************
	 * __strcasexcmp *
	 *****************/

/* compare s1 and s2
   s2 is converted to upcase; length is e2 - s2
   s1 is NULL terminated
   returns 0 - match, nonzero - mismatch
   The specification is a bit crazy - it's because of maximizing performance
   of filesystem name lookups.
   I'm not sure if I should use SETB variant of upcase code.
   IMPORTANT NOTICE for someone reimplementing it:
   it must not touch memory after first mismatching byte. */
#ifdef __NO_INLINES
int __strcasexcmp(__const__ char *__s1, __const__ char *__s2, __const__ char *__e2);
#else
__static__ __finline__ int __strcasexcmp(__const__ char *__s1, __const__ char *__s2, __const__ char *__e2)
{
	__u32 __ret, __sink1, __sink2;
	__asm__ __volatile__ ("				\n\
		CMPL	%4, %5				\n\
		JE	3f				\n\
		.ALIGN	"__stringify(__CPU_LOOP_ALIGN)"	\n\
	2:	MOVZBL	(%4), %0			\n\
		ADDL	$1, %4				\n\
		CMPB	$0x61, %b0			\n\
		JAE	4f				\n\
	5:	SUBB	(%3), %b0			\n\
		JNZ	1f				\n\
		ADDL	$1, %3				\n\
		CMPL	%4, %5				\n\
		JNE	2b				\n\
	3:	MOVZBL	(%3), %0			\n\
	1:						\n\
		.SECTION .text.end			\n\
	4:	CMPB	$0x61 + 26, %b0			\n\
		JAE	6f				\n\
		SUBB	$0x20, %b0			\n\
	6:	JMP	5b				\n\
		.PREVIOUS				\n\
	":"=&q"(__ret),"=r"(__sink1),"=r"(__sink2):"1"(__s1),"2"(__s2),"r"(__e2):"cc","memory");
	return __ret;
#if 0		/* gcc generates lame code for this */
	while (__s2 < __e2) {
		if (__unlikely(__upcasechr(*__s2++) != *__s1++)) return 1;
	}
	return *__s1;
#endif
}
#endif

	/*****************
	 * __memcasexcmp *
	 *****************/

/* compare s1 and s2
   s2 is converted to upcase; length is e2 - s2
   s1 doesn't have to be NULL terminated
   returns 0 - match, nonzero - mismatch
   The specification is a bit crazy - it's because of maximizing performance
   of filesystem name lookups.
   I'm not sure if I should use SETB variant of upcase code.
   IMPORTANT NOTICE for someone reimplementing it:
   it must not touch memory after first mismatching byte. */
#ifdef __NO_INLINES
int __memcasexcmp(__const__ char *__s1, __const__ char *__s2, __const__ char *__e2);
#else
__static__ __finline__ int __memcasexcmp(__const__ char *__s1, __const__ char *__s2, __const__ char *__e2)
{
	__u32 __ret, __sink1, __sink2;
	__asm__ __volatile__ ("				\n\
		CMPL	%4, %5				\n\
		JE	3f				\n\
		.ALIGN	"__stringify(__CPU_LOOP_ALIGN)"	\n\
	2:	MOVZBL	(%4), %0			\n\
		ADDL	$1, %4				\n\
		CMPB	$0x61, %b0			\n\
		JAE	4f				\n\
	5:	SUBB	(%3), %b0			\n\
		JNZ	1f				\n\
		ADDL	$1, %3				\n\
		CMPL	%4, %5				\n\
		JNE	2b				\n\
	3:	XORL	%0, %0				\n\
	1:						\n\
		.SECTION .text.end			\n\
	4:	CMPB	$0x61 + 26, %b0			\n\
		JAE	6f				\n\
		SUBB	$0x20, %b0			\n\
	6:	JMP	5b				\n\
		.PREVIOUS				\n\
	":"=&q"(__ret),"=r"(__sink1),"=r"(__sink2):"1"(__s1),"2"(__s2),"r"(__e2):"cc","memory");
	return __ret;
#if 0		/* gcc generates lame code for this */
	while (__s2 < __e2) {
		if (__unlikely(__upcasechr(*__s2++) != *__s1++)) return 1;
	}
	return 0;
#endif
}
#endif

	/**************
	 * __byte_sum *
	 **************/

#ifdef __NO_INLINES
unsigned char __byte_sum(__const__ void *__ptr, int __len);
#else
__static__ __finline__ unsigned char __byte_sum(__const__ void *__ptr, int __len)
{
	__u32 __sum = 0;
	void *__e = (char *)__ptr + __len;
	__barrier();
	do {
		__sum ^= *(__u32 *)__ptr;
		__ptr = (char *)__ptr + 4;
	} while (__ptr < __e);
	__sum ^= __sum >> 16;
	__sum ^= __sum >> 8;
	__barrier();
	return __sum;
}
#endif

/* lookup in a table and avoid L1/2 cache footsteps.
Equivalent to return table[index] */
__u8 __secure_lookup_8(__const__ __u8 *__table, size_t __table_size, size_t __index);

__END_DECLS

#endif
