#ifndef __ARCH_VM_H
#define __ARCH_VM_H

#include <SPAD/VMDEF.H>
#include <SYS/TYPES.H>
#include <SPAD/WQ.H>

__BEGIN_DECLS

typedef struct __page PAGE;
typedef struct __spages SPAGES;
typedef struct __spage_entry SPAGE_ENTRY;
typedef struct __spage SPAGE;

#ifdef __WQ_DEBUG
#define ___PG_STRUCT_PAGE_PAD	0
#else
#define ___PG_STRUCT_PAGE_PAD	12
#endif

/* page is dirty if page->dirty_from < page->dirty_to */

extern char KERNEL$ZERO_BANK[];

void *KERNEL$MAP_PHYSICAL_BANK(__p_addr physaddr);
void *KERNEL$MAP_PHYSICAL_PAGE(PAGE *p);
void KERNEL$UNMAP_PHYSICAL_BANK(void *ptr);
__p_addr KERNEL$UNMAP_PHYSICAL_BANK_ADDR(void *ptr);
PAGE *KERNEL$UNMAP_PHYSICAL_BANK_PAGE(void *ptr);

void *KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(__p_addr physaddr, int length, int pat);
void KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(void *vaddr, int length);

__p_addr KERNEL$PAGE_2_PHYS(PAGE *p);
PAGE *KERNEL$PHYS_2_PAGE(__p_addr p);

unsigned long KERNEL$VIRT_2_PHYS(void *virt);
void *KERNEL$PHYS_2_VIRT(unsigned long phys);
void *KERNEL$DMA_2_VIRT(unsigned long dma);

__u32 KERNEL$MAP_PAGE_DMA(PAGE *p);
PAGE *KERNEL$UNMAP_PAGE_DMA(__u32 d);
__u64 KERNEL$MAP_PAGE_DMA64(PAGE *p);
PAGE *KERNEL$UNMAP_PAGE_DMA64(__u64 d);

__END_DECLS

#endif
