#ifndef __ARCH_VMDEF_H
#define __ARCH_VMDEF_H

#include <ARCH/PAGEDEF.H>

#define PG_SIZEOF_STRUCT_PAGE		128
#define PG_SIZEOF_STRUCT_PAGE_BITS	7

#define PG_SIZE_BITS			__PG_SIZE_BITS
#define PG_BANK_BITS			10

#define PG_MAX				0x01000000
#define PG_VMMAX			0x00100000

#define STRUCT_PAGE__ID		16
#define STRUCT_PAGE__ZONE	24
#define STRUCT_PAGE__RELEASE	28

#define VMSPACE				0xffc00000UL

/* these numbers are assigned so that you get acceptable results on
   CPU not supporting PAT */

#define PAT_WB			0
#define PAT_WT			1
#define PAT_UC_MINUS		2
#define PAT_UC			3
#define PAT_WC			6
#define PAT_WP			7
#define PAT_CACHE_MODE		7
#define PAT_HIGH_BIT		4	/* used internally */

#define PAT_RO			8

#endif
