#include <ARCH/CPUDEF.H>
#include <PRG/BIND_SYS/FSDCODE.H>
#include <KERNEL/RELEASE.H>

#define STARTUP_OFFSET	0x80
#define EXTRA_BYTES	4

BOOT_SECTOR_BASE = 0x7c00
SECTOR_BASE = 0x7e00
SETUP_BASE = 0x8000

.CODE16
.GLOBAL _start
_start:

	CLD
	PUSHW	$0
	POPW	%DS
	PUSHW	%DS
	POPW	%ES
	PUSHW	%DS
	POPW	%SS
	MOVW	$BOOT_SECTOR_BASE - 4, %SP
	MOVB	$0x80, %DL
2:	XORL	%EBP, %EBP
	CALL	TRY_PARTITION
	XORB	$0x01, %DL
	JP	2b
/* Warning:
   Some smart-ass bioses patch bootsector after loading it from USB.
   Patched offsets are: 28, 29, 30, 31, 36 (they are rewritten with 0).
   These MOVL $0, %EAX and MOVB $0, %AL instructions have argument placed at
   patched positions. If you change anything here, make sure that they are at
   correct addresses.
*/
	MOVB	$0, %DL
	MOVL	$0, %EAX
	JS	2b
	NOP
	MOVB	$0, %AL

	MOVW	$BOOT_SECTOR_BASE + NO_IMAGE_MSG, %SI
PRINT_STRING:
6:	LODSB
	TESTB	%AL, %AL
5:	JZ	5b
	MOVW	$0x0070, %BX
	MOVB	$0x0e, %AH
	INT	$0x10
	JMP	6b

TRY_PARTITION:
	CALL	LOAD_SECTOR
	JC	0f
	CALL	CMP_MARK
	MOVW	$SECTOR_BASE + 0x1BE, %BX
	XORW	%AX, %AX
	PUSHW	$1
	PUSHL	0x38(%BX)
	PUSHW	0x34(%BX)
	PUSHW	%AX
	PUSHL	0x28(%BX)
	PUSHW	0x24(%BX)
	PUSHW	%AX
	PUSHL	0x18(%BX)
	PUSHW	0x14(%BX)
	PUSHW	%AX
	PUSHL	0x08(%BX)
	PUSHW	0x04(%BX)
2:	POPW	%AX
	POPL	%ECX
	PUSHL	%EBP
	TESTL	%ECX, %ECX
	JZ	3f
	CMPB	$0x05, %AL
	JE	7f
	CMPB	$0x0f, %AL
	JE	7f
	CMPB	$0x85, %AL
	JNE	4f
7:	TESTL	%EBP, %EBP
	JNE	8f
	MOVL	%ECX, BOOT_SECTOR_BASE - 4
	JMP	9f
8:	ADDL	BOOT_SECTOR_BASE - 4, %ECX
9:	MOVL	%ECX, %EBP
	CALL	TRY_PARTITION
	JMP	3f
4:	ADDL	%ECX, %EBP
	CALL	LOAD_SECTOR
	JC	3f
	CALL	CMP_MARK
3:	POPL	%EBP
	POPW	%AX
	TESTW	%AX, %AX
	JZ	2b
0:	RET

LOAD_SECTOR:
	MOVW	$BOOT_SECTOR_BASE + PACKET, %SI
	MOVL	%EBP, 8(%SI)
	MOVB	$0x42, %AH
	INT	$0x13
	JNC	0f
	PUSHW	%DX
	MOVB	$0x08, %AH
	INT	$0x13
	MOVZBL	%DH, %ESI
	POPW	%DX
	PUSHW	%DS
	POPW	%ES
	JC	0f
	MOVB	%DL, %BL
	MOVL	%EBP, %EAX
	XORL	%EDX, %EDX
	ANDL	$0x3f, %ECX
	DIVL	%ECX
	MOVW	%DX, %CX
	INCW	%CX
	CDQ
	INCW	%SI
	DIVL	%ESI
	MOVB	%DL, %DH
	MOVB	%BL, %DL
	CMPW	$0x400, %AX
	JAE	0f
	XCHGB	%AL, %AH
	SHLB	$6, %AL
	ADDW	%AX, %CX
	MOVW	$SECTOR_BASE, %BX
	MOVW	$0x0201, %AX
	INT	$0x13
0:	RET

CMP_MARK:
	MOVW	$BOOT_SECTOR_BASE, %SI
	MOVW	$SECTOR_BASE, %DI
	MOVW	$END_COMPARE, %CX
	REPE
	CMPSB
	JNE	0b

	INCL	%EBP
	MOVB	$SETUP_SECTORS, %CL
	MOVW	$SETUP_BASE, %DI
1:	PUSHW	%CX
	PUSHW	%DI
	CALL	LOAD_SECTOR
2:	MOVW	$BOOT_SECTOR_BASE + LOAD_ERR, %SI
3:	JC	PRINT_STRING
	POPW	%DI
	MOVW	$SECTOR_BASE, %SI
	MOVW	$0x100, %CX
	REP
	MOVSW
	POPW	%CX
	INCL	%EBP
	LOOPW	1b

	PUSHW	%DX
#	MOVZWL	BOOT_SECTOR_BASE + SYSSIZE, %ECX
#	ADDL	$31, %ECX
#	SHRL	$5, %ECX
#		support kernels larger than 1MB
	MOVW	SETUP_BASE + 38, %CX
	MOVW	$0x10000/5, %AX
	MULW	%CX
	MOVW	%DX, %SI
	MOVW	%DX, %BX
	MOVW	$0x09b0, %AX
	POPW	%DX
1:	PUSHAW
	CALL	LOAD_SECTOR
	JC	2b
	MOVW	$BOOT_SECTOR_BASE + HIMEM, %SI
	MOVW	$0x100, %CX
	MOVB	$0x87, %AH
	INT	$0x15
	MOVW	$BOOT_SECTOR_BASE + HIMEM_ERR, %SI
	JC	3b
	ADDW	$0x200, BOOT_SECTOR_BASE + HIM_LO
	ADCB	$0, BOOT_SECTOR_BASE + HIM_HI
	POPAW
	DECW	%SI
	JNZ	3f
	PUSHAW
	MOVW	$0x0007, %BX
	MOVW	$1, %CX
	INT	$0x10
	POPAW
	CMPB	$0xb2, %AL
	INCW	%AX
	JB	4f
	MOVB	$0xdb, %AL
4:	MOVW	%BX, %SI
3:	INCL	%EBP
	LOOPW	1b
	MOVW	$18 * 5, %CX
5:	TESTB	$1, 0x43f
	JZ	6f
	CMPB	0x46c, %AL
	JE	5b
	MOVB	0x46c, %AL
	LOOPW	5b
6:	JMP	SETUP_BASE - BOOT_SECTOR_BASE

NO_IMAGE_MSG:
	.STRING	"NOT FOUND"
LOAD_ERR:
	.STRING	"LOAD ERROR"
HIMEM_ERR:
	.STRING	"HIMEM ERROR"

	.ORG	0x1a8
MAGIC_1:	.LONG	0x12345678
MAGIC_2:	.LONG	0x9abcdef0
END_COMPARE:
PACKET:	.BYTE	0x10, 0x00
	.WORD	0x0001
	.WORD	SECTOR_BASE
	.WORD	0
	.LONG	0
	.LONG	0
HIMEM:	.LONG	0, 0
	.LONG	0, 0

	.WORD	0xffff
	.WORD	SECTOR_BASE
	.BYTE	0
	.BYTE	0x93
	.WORD	0

	.WORD	0xffff
HIM_LO:	.WORD	0
HIM_HI:	.BYTE	0x10
	.BYTE	0x93
	.WORD	0

	.LONG	0, 0
	.LONG	0, 0

	.ORG	497

SETUP_SECTORS = (LOADER_END - _start - 512) >> 9

SETUP_SECTS:	.BYTE	SETUP_SECTORS
ROOT_FLAGS:	.WORD	0
SYSSIZE:	.WORD	-1	# BIND_SYS places system size here
SWAP_DEV:	.WORD	0
RAM_SIZE:	.WORD	0
VID_MODE:	.WORD	0
ROOT_DEV:	.WORD	0
BOOT_FLAG:	.WORD	0xAA55

LOADER_HDR:

	.BYTE	0xEB
	.BYTE	STARTUP - 1f
1:

			.ASCII	"HdrS"
			.WORD	0x0201
REALMODE_SWITCH:	.WORD	0, 0
START_SYS_SEG:		.WORD	0x1000
KERNEL_VERSION:		.WORD	VERSION - LOADER_HDR
TYPE_OF_LOADER:		.BYTE	0
LOADFLAGS:		.BYTE	1
SETUP_MOVE_SIZE:	.WORD	0x8000

CODE32_START:		.LONG	0x100000
RAMDISK_IMAGE:		.LONG	0
RAMDISK_SIZE:		.LONG	0
BOOTSECT_KLUDGE:	.LONG	0
HEAP_END_PTR:		.WORD	0

SIZE_IN_SECTORS:	.WORD	0

CMD_LINE_PTR:		.LONG	0

STARTUP:
	PUSHW	$0x0040
	POPW	%ES
	MOVW	$0xB800, %AX
	CMPB	$7, %ES:0x49
	JNE	CGA
	MOVB	$0xB0, %AH
CGA:	MOVW	%AX, %ES
	MOVL	$0x70507053, %ES:0
	MOVL	$0x70447041, %ES:4
	XORL	%EBP, %EBP
	XORL	%EBX, %EBX
	MOVW	%CS, %BP
	MOVW	%BP, %DS
	CALL	WHERE_AM_I
WHERE_AM_I:
	POPW	%BX
	MOVL	%EBP, %EAX
#	SHLL	$16, %EAX
#	MOVW	%BX, %AX
#	JMP	DEBUG16
	SHLL	$4, %EBP
	ADDL	%EBX, %EBP

#	ADDL	%EBP, SM_CODE + 2 - WHERE_AM_I(%BX)	# SELF MODIFYING
	.BYTE	0x66, 0x01, 0xaf
	.WORD	SM_CODE + 2 - WHERE_AM_I

	JMP	FLUSH_QUEUE
FLUSH_QUEUE:
#	ADDL	%EBP, G_BASE - WHERE_AM_I(%BX)
	.BYTE	0x66, 0x01, 0xaf
	.WORD	G_BASE - WHERE_AM_I

#	LGDTL	GDTR - WHERE_AM_I(%BX)
	.BYTE	0x66, 0x0F, 0x01, 0x97
	.WORD	GDTR - WHERE_AM_I

	CMPL	$0, REALMODE_SWITCH - WHERE_AM_I(%BX)
	JZ	1f
	PUSHAL
	LCALL	*REALMODE_SWITCH - WHERE_AM_I(%BX)
	POPAL
1:

	PUSHFL
	POPL	%EAX
	ANDL	$~(EFLAGS_TF|EFLAGS_IF|EFLAGS_DF|EFLAGS_IOPL0|EFLAGS_IOPL1|EFLAGS_NT|EFLAGS_RF|EFLAGS_VM|EFLAGS_AC|EFLAGS_VIF|EFLAGS_VIP), %EAX
	PUSHL	%EAX
	POPFL

	# STOP FLOPPY DISK MOTOR
	TESTB	$0xF, %ES:0x3F
	JZ	1f
	MOVB	$0x0C, %AL
	MOVW	$0x03F2, %DX
	OUTB	%AL, %DX
1:
	MOVL	%CR0, %EAX
	# ANDL	$0x1FFBFFF1, %EAX
	# ORL	$0x00010021, %EAX
	ANDL	$~(CR0_EM|CR0_PG), %EAX
	ORL	$CR0_PE|CR0_MP|CR0_TS|CR0_NE|CR0_WP|CR0_AM, %EAX
	MOVL	%EAX, %CR0	# REAL MODE SUCKS - GET QUICKLY OUT OF IT

SM_CODE:
	LJMPL	$8, $PM - WHERE_AM_I

#DEBUG16:
#	MOVL	%EAX, %EDX
#	MOVW	$160, %BX
#	MOVW	$8, %CX
#WRN:	MOVL	%EDX, %EAX
#	SHRL	$28, %EAX
#	CMPB	$10, %AL
#	JB	NN
#	ADDB	$7, %AL
#NN:	ADDW	$0x7030, %AX
#	MOVW	%AX, %ES:(%BX)
#	SHLL	$4, %EDX
#	INCW	%BX
#	INCW	%BX
#	LOOP	WRN
#STOP:	JMP	STOP
#
.CODE32

#DEBUG32:
#	MOVL	%EAX, %EDX
#	MOVL	$0x000B80A0, %EBX
#	MOVL	$8, %ECX
#WRN32:	MOVL	%EDX, %EAX
#	SHRL	$28, %EAX
#	CMPB	$10, %AL
#	JB	NN32
#	ADDB	$7, %AL
#NN32:	ADDW	$0x7030, %AX
#	MOVW	%AX, (%EBX)
#	SHLL	$4, %EDX
#	INCL	%EBX
#	INCL	%EBX
#	LOOP	WRN32
#STOP32:	JMP	STOP32

PM:
	MOVW	$0x10, %AX
	MOVW	%AX, %DS
	MOVW	%AX, %ES
	MOVW	%AX, %SS
	MOVL	$0xA0000, %ESP

	CALL	EMPTY_8042
	MOVB	$0xD1, %AL
	OUTB	%AL, $0x64
	CALL	EMPTY_8042
	MOVB	$0xDF, %AL
	OUTB	%AL, $0x60
	CALL	EMPTY_8042

	INB	$0x92, %AL
	ORB	$0x02, %AL
	OUTB	%AL, $0x92

	MOVL	$0x200, %EBX
	MOVL	(%EBX), %ECX
	XORL	%EAX, %EAX
1:	INCL	%EAX
	MOVL	%EAX, (%EBX)
	WBINVD
	CMPL	0x100200, %EAX
	JE	1b
	MOVL	%ECX, (%EBX)

	MOVL	CODE32_START - WHERE_AM_I(%EBP), %EAX
	CMPL	$0x100000, %EAX
	JE	1f
	MOVL	$0x100000, CODE32_START - WHERE_AM_I(%EBP)
	LEAL	PM - WHERE_AM_I(%EBP), %EDI
	JMP	*%EAX
1:

/* Loadlin somehow trashes low memory and BIOS calls don't work
   Except for this problem, SPAD could work with loadlin (I tried) */

	MOVB	TYPE_OF_LOADER - WHERE_AM_I(%EBP), %AL
	ANDB	$0xF0, %AL
	CMPB	$0x10, %AL
	LEAL	LOADLIN - WHERE_AM_I(%EBP), %EAX
	JE	XERROR

	MOVL	$0x100000 + STARTUP_OFFSET + EXTRA_BYTES, %ESI
	
	LEAL	ERROR_SM - WHERE_AM_I - 4(%EBP), %EAX
	PUSHL	%EAX
	PUSHL	%EAX

	LEAL	FILE_NAME - WHERE_AM_I(%EBP), %EDX
	MOVL	$FSD_STAT_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	STAT_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	CMPL	$-1, %EAX
	JE	ERROR
	POPL	%ECX
	POPL	%EDX
	POPL	%ECX
	PUSHL	%ECX
	PUSHL	%ECX
	LEAL	- STARTUP_OFFSET - EXTRA_BYTES(%ESI, %EAX), %EDI
	ADDL	$3, %EDI
	ANDL	$~3, %EDI
	XCHGL	%EAX, %EBX
	MOVL	$FSD_TOP_OF_HEAP_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	TOP_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	CMPL	$-1, %EAX
	JE	ERROR
	POPL	%ECX
	POPL	%EDX
	POPL	%ECX
	PUSHL	%ECX
	PUSHL	%ECX
	LEAL	STARTUP_OFFSET + 3(%EAX), %ECX
	ANDL	$~3, %ECX
	SUBL	%ESI, %ECX
	LEAL	- STARTUP_OFFSET - 4(%ESI, %ECX), %ESI
	LEAL	-4(%EDI, %ECX), %EDI
	SHRL	$2, %ECX
	STD
	REP
	MOVSL
	CLD
	XCHGL	%ESI, %EDI
	.IF	4 <> EXTRA_BYTES
	ADDL	$4 - EXTRA_BYTES, %EDI
	.ENDIF
	ADDL	$STARTUP_OFFSET + 4, %ESI
	MOVL	$0x100000, %ECX
	LEAL	INTERNAL_ERROR - WHERE_AM_I(%EBP), %EAX
	CMPL	%ECX, %EDI
	JNE	XERROR
	LEAL	FILE_NAME - WHERE_AM_I(%EBP), %EDX
	MOVL	$FSD_OPEN_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	OPEN_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	CMPL	$-1, %EAX
	JE	ERROR
	POPL	%ECX
	POPL	%EDX
	POPL	%ECX
	PUSHL	%ECX
	PUSHL	%ECX
	MOVL	%EBX, %ECX
	MOVL	%EDI, %EDX
	MOVL	$FSD_READ_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	READ_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	TESTL	%EAX, %EAX
	JNZ	ERROR
	POPL	%ECX
	POPL	%EDX
	POPL	%ECX
	PUSHL	%ECX
	PUSHL	%ECX
	LEAL	CORRUPT_FILE - WHERE_AM_I(%EBP), %EAX
	CMPL	$0x44415053, (%EDI)
	JNZ	XERROR
	LEAL	BAD_ARCH - WHERE_AM_I(%EBP), %EAX
	CMPL	$0x32334149, 8(%EDI)
	JNZ	XERROR
	MOVL	$FSD_CLOSE_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI
	LEAL	CLOSE_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	TESTL	%EAX, %EAX
	JNZ	ERROR
	POPL	%ECX
	POPL	%EDX
	MOVL	$FSD_TOP_OF_HEAP_CODE, %EAX
	PUSHL	%ESI
	CALL	*%ESI		# EAX - HEAP TOP
	LEAL	TOP_ERROR_MSG - WHERE_AM_I(%EBP), %ECX
	CMPL	$-1, %EAX
	JE	ERROR
	XCHGL	%EAX, %ECX
	POPL	%EBX
	POPL	%EDX
	LEAL	-STARTUP_OFFSET(%ESI), %EDX
	MOVL	%EDI, %EAX
	ADDL	$STARTUP_OFFSET, %EDI
	JMP	*%EDI

EMPTY_8042:
	MOVL	$0x00FFFFFF, %ECX
EMPTY_8042_LOOP:
	INB	$0x64, %AL
	TESTB	$1, %AL
	JZ	NO_OUTPUT
	INB	$0x60, %AL
	JMP	EMPTY_8042_LP
NO_OUTPUT:
	TESTB	$2, %AL
EMPTY_8042_LP:
	LOOPNZ	EMPTY_8042_LOOP
RT:	RET

ERROR:	MOVL	%ECX, %ESI
	MOVB	$0x70, %AH
	CALL	PRINT1
	MOVL	$0, %ESI
ERROR_SM:
	CALL	PRINT
LOCK_UP:JMP	LOCK_UP

XERROR:	MOVL	%EAX, %ESI
	MOVB    $0x70, %AH
	CALL	PRINT1
	JMP	LOCK_UP

PRINT1:	MOVL	$0xB80A0, %EDI
	CMPB	$7, 0x449
	JNE	1f
	BTR	$15, %EDI
1:	
PRINT:	LODSB
	TEST	%AL, %AL
	JZ	RT
	STOSW
	JMP	PRINT

VERSION:	.ASCII	"SPAD " SPAD_RELEASE " (" SPAD_VERSION ")"
		.BYTE	0
TOP_ERROR_MSG:	.STRING	"COULD NOT GET TOP OF HEAD: "
STAT_ERROR_MSG:	.STRING	"ERROR GETTING LENGTH OF KERNEL.SYS: "
OPEN_ERROR_MSG:	.STRING	"ERROR OPENING KERNEL.SYS: "
READ_ERROR_MSG:	.STRING	"ERROR READING KERNEL.SYS: "
CLOSE_ERROR_MSG:.STRING	"ERROR CLOSING KERNEL.SYS: "
FILE_NAME:	.STRING	"KERNEL.SYS"
CORRUPT_FILE:	.STRING	"KERNEL.SYS IS NOT EXECUTABLE FILE"
BAD_ARCH:	.STRING	"KERNEL.SYS IS NOT FOR IA32"
LOADLIN:	.STRING	"LOADLIN CAN'T BE USED TO LOAD THIS IMAGE"
INTERNAL_ERROR:	.STRING	"INTERNAL ERROR - POINTER MISMATCH"

.ALIGN 8, 0
GDT:

GDTR:	.WORD	GDT_END - GDT - 1
G_BASE:	.LONG	GDT - WHERE_AM_I
	.WORD	0

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0x9B
	.BYTE	0xCF, 0x00

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0x93
	.BYTE	0xCF, 0x00
GDT_END:

.ALIGN 512,0
LOADER_END:
	JMP	*%EDI
	.ORG	LOADER_END + EXTRA_BYTES
