#ifndef __KERNEL_ASM_H
#define __KERNEL_ASM_H

#include <ARCH/CPUDEF.H>
#include <ARCH/SETUP.H>
#include <ARCH/IRQ.H>
#include <ARCH/TIME.H>
#include <SPAD/VM.H>
#include <KERNEL/ASMDEF.H>
#include <KERNEL/PROC.H>
#include <SYS/TYPES.H>

void __NORET_ATTR__ VM_BOOT_ENABLE_PAGING(void *, void (*)(void), unsigned features);

void __NORET_ATTR__ HALT_KERNEL(void);
void __NORET_ATTR__ HALT_KERNEL_STKDUMP(void);

static __finline__ __NORET_ATTR__ void JMP_IDLE_LOOP(void)
{
	__asm__ volatile ("JMP IDLE_LOOP");
	while (1) ;
}

extern __u32 CR_0, CR_4;

typedef struct {
	char c[SIZEOF_IRQ_STUB];
} IRQ_TEMPLATE;

extern IRQ_TEMPLATE IRQ_STUBS[NO_OF_IRQS];
extern IRQ_TEMPLATE AST_STUB_TEMPLATES[NO_OF_IRQS];
extern IRQ_TEMPLATE RT_STUB_TEMPLATES[NO_OF_IRQS];
extern unsigned AST_PATCHES[NO_OF_IRQS];
extern unsigned RT_PTR_PATCHES[NO_OF_IRQS];
extern unsigned RT_CALL_PATCHES[NO_OF_IRQS];

extern char APAGE[];
extern char TSS_PAGE[];
extern char IDT[];
extern char IDT_END[];
extern struct {
	__u16 limit;
	__u16 base_lo;
	__u16 base_hi;
	__u16 pad;
} IDTR;


unsigned long PROC_HANDLE_XCPT(PROC *proc);
unsigned long PROC_POST_TIMER(PROC *proc);

unsigned long PROC_POST_AST(PROC *proc, IORQ *ast);
unsigned long PROC_POST_IO(PROC *proc, IORQ *ast, long status);

unsigned long PROC_POST_SIO(PROC *p, IORQ *usiorq, SIORQ *ksiorq);
unsigned long PROC_POST_AIO(PROC *p, IORQ *uaiorq, AIORQ *kaiorq);
unsigned long PROC_POST_IOCTL(PROC *p, IORQ *uciorq, IOCTLRQ *kciorq);

unsigned long PROC_GET_SIO(PROC *p, IORQ *usiorq, SIORQ *ksiorq);
unsigned long PROC_GET_AIO(PROC *p, IORQ *uaiorq, AIORQ *kaiorq);
unsigned long PROC_GET_IOCTL(PROC *p, IORQ *uciorq, IOCTLRQ *kciorq);

static __finline__ void LOCKDOWN_PROC(void)
{
	PROC_CURRENT_LOCK++;
	__barrier();
}

static __finline__ void UNLOCKDOWN_PROC(void)
{
	__barrier();
	if (__likely(!--PROC_CURRENT_LOCK)) WQ_WAKE_ALL(&PROC_CURRENT_LOCK_WAIT);
#if __DEBUG >= 1
	if (__unlikely(PROC_CURRENT_LOCK < 0))
		KERNEL$SUICIDE("UNLOCKDOWN_PROC: PROC_CURRENT_LOCK UNDERFLOW (%d)", PROC_CURRENT_LOCK);
#endif
}

#endif
