/* two tests to prevent miscompilation of kernel by broken binutils */

		/*********
		 * BUG 1 *
		 *********/

.IF 1|2*3 <> 7
MOVL %EAX, YOUR_ASSEMBLER_IS_BRAIN_DAMAGED__SEE_BEGINNING_OF_FILE_ASM.S___BUG_1
.ENDIF

/* if the above is triggered, apply the following patch to your binutils */

#if 0
--- gas/expr.c_	Tue Nov 28 14:50:13 2000
+++ gas/expr.c	Tue Nov 28 14:50:16 2000
@@ -1517,8 +1517,8 @@
    mode.  Also, MRI uses a different bit_not operator, and this fixes
    that as well.  */
 
-#define STANDARD_MUL_PRECEDENCE (7)
-#define MRI_MUL_PRECEDENCE (5)
+#define STANDARD_MUL_PRECEDENCE (8)
+#define MRI_MUL_PRECEDENCE (6)
 
 void
 expr_set_precedence ()
#endif


		/*********
		 * BUG 2 *
		 *********/

.IF (0x10 >> 2 << 3) <> 0x20
MOVL %EAX, YOUR_ASSEMBLER_IS_BRAIN_DAMAGED__SEE_BEGINNING_OF_FILE_ASM.S___BUG_2
.ENDIF

/* if the above is triggered, apply the following patch to your binutils */

#if 0
--- gas/expr.c_	Mon Feb 12 22:06:52 2001
+++ gas/expr.c	Mon Feb 12 22:51:10 2001
@@ -1654,6 +1654,8 @@
   operatorT op_left;
   operatorT op_right;
 
+  char *start_of_op;
+
   know (rank >= 0);
 
   retval = operand (resultP);
@@ -1661,6 +1663,7 @@
   /* operand () gobbles spaces.  */
   know (*input_line_pointer != ' ');
 
+  start_of_op = input_line_pointer;
   op_left = operator ();
   while (op_left != O_illegal && op_rank[(int) op_left] > rank)
     {
@@ -1706,6 +1709,7 @@
 	       )
 	as_bad (_("operation combines symbols in different segments"));
 
+      start_of_op = input_line_pointer;
       op_right = operator ();
 
       know (op_right == O_illegal
@@ -1871,6 +1875,7 @@
 
       op_left = op_right;
     }				/* While next operator is >= this rank.  */
+  input_line_pointer = start_of_op;
 
   /* The PA port needs this information.  */
   if (resultP->X_add_symbol)
#endif


		/*********
		 * BUG 3 *
		 *********/

/* BUGS 3 and 4 are checked at run time.
If the kernel reports one of these bugs on boot, apply the patches to your assembler */

#if 0
--- gas/write.c_	Fri Mar  2 15:33:45 2001
+++ gas/write.c	Fri Mar  2 17:04:35 2001
@@ -2558,14 +2558,12 @@
 		S_GET_VALUE (sub_symbolP);
 
 	      add_symbolP = NULL;
-	      pcrel = 0;	/* No further pcrel processing.  */
 
 	      /* Let the target machine make the final determination
 		 as to whether or not a relocation will be needed to
 		 handle this fixup.  */
 	      if (!TC_FORCE_RELOCATION_SECTION (fixP, this_segment_type))
 		{
-		  fixP->fx_pcrel = 0;
 		  fixP->fx_addsy = NULL;
 		  fixP->fx_subsy = NULL;
 		}
#endif

/* or this for binutils 2.14 */

#if 0
--- gas/write.c_	Fri Aug 15 20:29:31 2003
+++ gas/write.c	Fri Aug 15 20:29:36 2003
@@ -2645,16 +2645,8 @@
 	      fixP->fx_offset = add_number;
 	      /* If the back-end code has selected a pc-relative
 		 reloc, adjust the value to be pc-relative.  */
-	      if (1
-#ifdef TC_M68K
-		  /* See the comment below about 68k weirdness.  */
-		  && 0
-#endif
-		  && fixP->fx_pcrel)
-		add_number -= MD_PCREL_FROM_SECTION (fixP, this_segment); 
 	      fixP->fx_addsy = NULL;
 	      fixP->fx_subsy = NULL;
-	      fixP->fx_pcrel = 0;
 	    }
 	  else if (sub_symbol_segment == absolute_section
 		   && !TC_FORCE_RELOCATION_SUB_ABS (fixP))
#endif

		/*********
		 * BUG 4 *
		 *********/

#if 0
--- gas/config/tc-i386.c_	Sat Mar  3 14:00:22 2001
+++ gas/config/tc-i386.c	Sat Mar  3 14:16:25 2001
@@ -2274,6 +2274,9 @@
 	int code16;
 	int prefix;
 
+	symbolS *sym;
+	offsetT add_number;
+
 	code16 = 0;
 	if (flag_16bit_code)
 	  code16 = CODE16;
@@ -2307,14 +2310,24 @@
 	*p = i.tm.base_opcode;
 	/* 1 possible extra opcode + displacement go in var part.
 	   Pass reloc in fr_var.  */
+	if (i.op[0].disps->X_op == O_symbol)
+	  {
+	    sym = i.op[0].disps->X_add_symbol;
+	    add_number = i.op[0].disps->X_add_number;
+	  }
+	else
+	  {
+	    sym = make_expr_symbol(i.op[0].disps);
+	    add_number = 0;
+	  }
 	frag_var (rs_machine_dependent,
 		  1 + size,
 		  i.disp_reloc[0],
 		  ((unsigned char) *p == JUMP_PC_RELATIVE
 		   ? ENCODE_RELAX_STATE (UNCOND_JUMP, SMALL) | code16
 		   : ENCODE_RELAX_STATE (COND_JUMP, SMALL) | code16),
-		  i.op[0].disps->X_add_symbol,
-		  i.op[0].disps->X_add_number,
+		  sym,
+		  add_number,
 		  p);
       }
     else if (i.tm.opcode_modifier & (JumpByte | JumpDword))
#endif

#define _1U	1

#include <KERNEL/ASMDEF.H>
#include <KERNEL/VMDEF.H>
#include <ARCH/ACDEF.H>
#include <KERNEL/DEV_OFF.H>
#include <SPAD/ERRNODEF.H>
#include <KERNEL/UDATADEF.H>
#include <SPAD/SPLDEF.H>
#include <ARCH/SETUP.H>
#include <KERNEL/SEG.H>
#include <SPAD/SYSLDEF.H>

			/**********************
			 * PREPARE FOR INTMAP *
			 **********************/


#define INTMAP_ENTRY(X)	.SECTION .text; 9:; .PREVIOUS; .SECTION INTMAP; .LONG 9b - KERNEL_CRAWLOUT_SPACE; .BYTE (X); .PREVIOUS

#define FAULTMAP_ENTRY_NOTEST(X) .SECTION .text; 9:; .PREVIOUS; .SECTION FAULTMAP; .LONG 9b - KERNEL_CRAWLOUT_SPACE, X - 9b; .PREVIOUS

#define FAULTMAP_ENTRY_NOTEST_DEBUG(X)	FAULTMAP_ENTRY_NOTEST(X)

#define FAULTMAP_END		8: FAULTMAP_ENTRY_NOTEST(8b + 0x80000000)

#if __DEBUG_PAGEFAULTS == 0
#define FAULTMAP_ENTRY		FAULTMAP_ENTRY_NOTEST
#else
#define FAULTMAP_ENTRY(X)				\
	CLI;						\
	PUSHFL;						\
	ORL	$EFLAGS_IF, (%ESP);			\
	PUSHL	%EAX;					\
	PUSHL	%EDX;					\
	PUSHL	%ECX;					\
	CALL	random;					\
	CMPB	$__DEBUG_PAGEFAULTS, %AL;		\
	POPL	%ECX;					\
	POPL	%EDX;					\
	POPL	%EAX;					\
	JAE	8346f;					\
	POPFL;						\
	.BYTE	0xe9;					\
	.LONG	X - 8346f;				\
8346:	POPFL;						\
	FAULTMAP_ENTRY_NOTEST(X)
#endif

#define INTMAP_NO_INT	INTMAP_ENTRY(0)
#define INTMAP_NO_CRAWLOUT	INTMAP_ENTRY(1)
#define INTMAP_POP(X)	INTMAP_ENTRY(-(X) * 4)
#define INTMAP_JMP(X)	.SECTION .text; 9:; .PREVIOUS; .SECTION JMPTBL; 8:.LONG (X) - 9b; .PREVIOUS; INTMAP_ENTRY((8b - JMPTBL) / 4)
#define INTMAP_JMP_ABS(X)	.SECTION .text; 9:; .PREVIOUS; .SECTION JMPTBL; 8:.LONG (X); .PREVIOUS; INTMAP_ENTRY((8b - JMPTBL) / 4)
#define INTMAP_END	INTMAP_ENTRY(0x80)

	.SECTION JMPTBL
	.ALIGN	4
	.LONG	0, 0
	.PREVIOUS

	.SECTION INTMAP
	.GLOBAL	INTMAP$ENTRY
INTMAP$ENTRY:

KERNEL_CRAWLOUT_SPACE_ALIGN = 16384

	.SECTION FAULTMAP
	.GLOBAL	FAULTMAP$ENTRY
FAULTMAP$ENTRY:

	.SECTION .FINE_TICKS_FIXUP
	.ALIGN	4
	.GLOBAL	FINE_TICKS_SHIFT_FIXUP
FINE_TICKS_SHIFT_FIXUP:
	.SECTION .FINE_TICKS_FIXUP_END
	.LONG	0

	.SECTION .text
	.ALIGN	KERNEL_CRAWLOUT_SPACE_ALIGN, 0
	.GLOBAL	KERNEL_CRAWLOUT_SPACE
KERNEL_CRAWLOUT_SPACE:
	INTMAP_NO_INT


			/******************
			 * CPU STRUCTURES *
			 ******************/

/*
 * OFFSETS OF MAPS
 */

	.SECTION .rodata
	.ALIGN	4
	.GLOBAL	KERNEL_PAGE_MAP
	.GLOBAL	KERNEL$ZERO_BANK

KERNEL_PAGE_MAP = VM_KERNEL_PAGE_BANK * PG_SIZE * PG_BANK
KERNEL$ZERO_BANK = VM_KERNEL_DIRECT_OFFSET

/*
 * PAGE DIRECTORY
 */
	.SECTION .bss
	.ALIGN	4096, 0
	.GLOBAL	KERNEL$PROC_KERNEL
KERNEL$PROC_KERNEL:
	.SPACE	SIZEOF_PROC_ALIGNED

/*
 * DEVICE IOMAP
 * APAGE, TSS
 */

	.SECTION .bss
	.ALIGN	4096, 0
	.GLOBAL	VM_ZERO_PAGE_TABLE
VM_ZERO_PAGE_TABLE:
#if !__KERNEL_USE_PAE
	.SPACE	4096
#else
	.SPACE	8192
#endif

/*
 * MAP FIRST 8M ON A PROCESSOR WITHOUT BIG PAGES
 */

	.SECTION .bss
	.ALIGN	4096, 0
	.GLOBAL BASE_PHYSMAP_486
BASE_PHYSMAP_486:
	.SPACE	(PG_BANK * 4) * 2;

/*
 * VIRTUAL MAPPING FOR KERNEL_PAGE_MAP
 */

	.SECTION .bss
	.GLOBAL	PAGE_INIT
	.GLOBAL	PAGE_PGTABLE
	.ALIGN	4096, 0
PAGE_INIT:
	.SPACE	PAGE_CLUSTER_SIZE

#if !__KERNEL_USE_PAE
PAGE_PGTABLE:
	.SPACE	4096
#else
PAGE_PGTABLE:
	.SPACE	8192
#endif

/*
 * KERNEL STACK
 */
	.SECTION .bss
	.ALIGN	PAGE_CLUSTER_SIZE, 0
	.GLOBAL	KERNEL_STACK
	.GLOBAL	MAIN_THREAD
MAIN_THREAD:
	.SPACE	PAGE_CLUSTER_SIZE
KERNEL_STACK:

/*
 * ZERO_PAD
 * page containing zeros used to pad spage mappings
 */
	.SECTION .bss
	.ALIGN	PAGE_CLUSTER_SIZE, 0
	.GLOBAL	ZERO_PAD
ZERO_PAD:
	.SPACE	4096

/*
 * TSS
 */
	.SECTION .data
	.ALIGN	4096, 0
	.GLOBAL	TSS_PAGE
TSS_PAGE:
TSS_OFFSET = . - TSS_PAGE
	.LONG	0
	.LONG	KERNEL_STACK
	.LONG	SEG_KSTACK
	.LONG	0, 0	/* STACK 1 */
	.LONG	0, 0	/* STACK 2 */
TSS_CR3:.LONG	0	/* CR3 */
TSS_EIP:.LONG	0	/* EIP */
TSS_EFLAGS:.LONG 0	/* EFLAGS */
TSS_EAX:.LONG	0
TSS_ECX:.LONG	0
TSS_EDX:.LONG	0
TSS_EBX:.LONG	0
TSS_ESP:.LONG	0
TSS_EBP:.LONG	0
TSS_ESI:.LONG	0
TSS_EDI:.LONG	0
TSS_ES:	.LONG	0
TSS_CS:	.LONG	0
TSS_SS:	.LONG	0
TSS_DS:	.LONG	0
TSS_FS:	.LONG	0
TSS_GS:	.LONG	0
TSS_LDT:.LONG	0	/* LDTR */
	.WORD	0	/* T */
	.WORD	4096 - TSS_OFFSET + IOBMP_OFFSET
		     /* IOBITMAP ... VM86 SUCKS. I DOUBT I WILL USE
			SOFT INT REDIRECTION MAP ONE DAY, BUT I RESERVE SPACE
			FOR IT. 32 BYTES IS NOT TOO MUCH. */
/*
 * EXCEPTION TSS
 */
#define EXCEPTION_TSS(n,d)						\
EXCEPTION_##n##_TSS:							;\
EXCEPTION_##n##_TSS_OFFSET = . - TSS_PAGE				;\
	.LONG	0							;\
	.LONG	0	/* STACK 0 */					;\
	.LONG	0							;\
	.LONG	0, 0	/* STACK 1 */					;\
	.LONG	0, 0	/* STACK 2 */					;\
	.LONG	KERNEL$PROC_KERNEL - VM_KERNEL_DIRECT_OFFSET + PROC2PGTBL /* CR3 */									;\
	.LONG	d		/* EIP */				;\
	.LONG	EFLAGS_ONE	/* EFLAGS */				;\
	.LONG	0, 0, 0, n, KERNEL_STACK - 20, 0, 0, 0	/* REGS */	;\
	.LONG	SEG_KDATA, SEG_KCODE, SEG_KSTACK, SEG_KDATA, 0, 0   /* SREGS */;\
	.LONG	0	/* LDTR */					;\
	.WORD	0	/* T */						;\
	.WORD	EXCEPTION_##n##_TSS_LEN					;\
EXCEPTION_##n##_TSS_LEN = . - EXCEPTION_##n##_TSS			;\
EXCEPTION_##n##_TSS_VADDR = VM_KERNEL_RESERVED_BANK * PG_SIZE * PG_BANK + RESERVED_TSS * PG_SIZE + EXCEPTION_##n##_TSS_OFFSET

EXCEPTION_TSS(2, TASK_XCPT)
EXCEPTION_TSS(8, TASK_XCPT_ERR)
EXCEPTION_TSS(10, TASK_XCPT_ERR)

	.ALIGN	4096, 0

TSS_VADDR = VM_KERNEL_RESERVED_BANK * PG_SIZE * PG_BANK + RESERVED_TSS * PG_SIZE + TSS_OFFSET
LDT_VADDR = VM_KERNEL_RESERVED_BANK * PG_SIZE * PG_BANK + RESERVED_LDT * PG_SIZE



/*
 * IDT
 */
	.SECTION .data
	.ALIGN	4096, 0
	.GLOBAL	IDT
	.GLOBAL	IDT_END
IDT:

#define	XCPT_DESC(X)	.LONG	EXCEPTION_##X;				.WORD	SEG_KCODE, 0x8E00
#define	UXCPT_DESC(X)	.LONG	EXCEPTION_##X;				.WORD	SEG_KCODE, 0xEE00
#define	XCPT_TASK(X)	.LONG	0;					.WORD	SEG_XCPT_##X##_TSS, 0x8500
#define	INTR_DESC(X)	.LONG	IRQ_STUBS+(X-((X>2)&1))*SIZEOF_IRQ_STUB;.WORD	SEG_KCODE, 0x8E00
#define CALL_DESC	.LONG	SYSCALL;				.WORD	SEG_KCODE, 0xEF00

	XCPT_DESC(0)
	UXCPT_DESC(1)
	XCPT_TASK(2)
	UXCPT_DESC(3)
	UXCPT_DESC(4)
	XCPT_DESC(5)
	XCPT_DESC(6)
	XCPT_DESC(7)
	XCPT_TASK(8)
	XCPT_DESC(9)
	XCPT_TASK(10)
	XCPT_DESC(11)
	XCPT_DESC(12)
	XCPT_DESC(13)
	XCPT_DESC(14)
	XCPT_DESC(15)
	XCPT_DESC(16)
	XCPT_DESC(17)
	XCPT_DESC(18)
	XCPT_DESC(19)
	XCPT_DESC(20)
	XCPT_DESC(21)
	XCPT_DESC(22)
	XCPT_DESC(23)
	XCPT_DESC(24)
	XCPT_DESC(25)
	XCPT_DESC(26)
	XCPT_DESC(27)
	XCPT_DESC(28)
	XCPT_DESC(29)
	XCPT_DESC(30)
	XCPT_DESC(31)
IRQ_INT = 32
	INTR_DESC(0)
	INTR_DESC(1)
	XCPT_DESC(34)
	INTR_DESC(3)
	INTR_DESC(4)
	INTR_DESC(5)
	INTR_DESC(6)
	INTR_DESC(7)
	INTR_DESC(8)
	INTR_DESC(9)
	INTR_DESC(10)
	INTR_DESC(11)
	INTR_DESC(12)
	INTR_DESC(13)
	INTR_DESC(14)
	INTR_DESC(15)
SYSCALL_INT = 32 + 16
	CALL_DESC
IDT_END:
	.ALIGN	4096, 0	/* this may be mapped to work around Pentium F00F bug */

/*
 * IDTR
 */
 	.SECTION .data
	/* Pentium f00f bug protection writes into it */
	.ALIGN	8, 0
	.GLOBAL	IDTR
IDTR:	.WORD	IDT_END - IDT - 1
	.LONG	IDT
	.WORD	0

/*
  GDT
 */
 	.SECTION .rodata
	.LONG	0, 0
 	.ALIGN	64, 0
GDT:	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0x9B
	.BYTE	0xCF, 0x00

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0x93
	.BYTE	0xCF, 0x00

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0xFB
	.BYTE	0xCF, 0x00

	.WORD	0xFFFF, 0x0000
	.BYTE	0x00, 0xF3
	.BYTE	0xCF, 0x00

	.WORD	IOBMP_PAGES, TSS_VADDR & 0xFFFF
	.BYTE	(TSS_VADDR >> 16) & 0xFF, 0x89
	.BYTE	0x80, (TSS_VADDR >> 24) & 0xFF
	
	.WORD	LDT_PAGES - 1, LDT_VADDR & 0xFFFF
	.BYTE	(LDT_VADDR >> 16) & 0xFF, 0x82
	.BYTE	0x80, (LDT_VADDR >> 24) & 0xFF

#define EXCEPTION_TSS_GDT(n)						\
	.WORD	(EXCEPTION_##n##_TSS_LEN - 1), EXCEPTION_##n##_TSS_VADDR & 0xFFFF									;\
	.BYTE	(EXCEPTION_##n##_TSS_VADDR >> 16) & 0xFF, 0x89		;\
	.BYTE	(EXCEPTION_##n##_TSS_LEN - 1) >> 16, (EXCEPTION_##n##_TSS_VADDR >> 24) & 0xFF

EXCEPTION_TSS_GDT(2)
EXCEPTION_TSS_GDT(8)
EXCEPTION_TSS_GDT(10)

GDT_END:

/* Segment registers defined in ARCH/IA32/KERNEL/SEG.H */

/*
 * GDTR
 */
	.ALIGN	8, 0
GDTR:	.WORD	GDT_END - GDT + 8 - 1
	.LONG	GDT - 8
	.WORD	0


/*
 * INITIALIZE PAGING, GDT AND IDT
 */

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_NO_INT
	.GLOBAL	VM_BOOT_ENABLE_PAGING
VM_BOOT_ENABLE_PAGING:
	PUSHL	%EAX
	PUSHL	%EDX
	MOVL	%ECX, %EBP
	TESTL	$CPU_HAS_4M_PAGES, %EBP
	JZ	1f
	MOVL	%CR4, %EBX
	ORL	$CR4_PSE, %EBX
	MOVL	%EBX, %CR4
1:
	TESTL	$CPU_HAS_GLOBAL_PAGES, %EBP
	JZ	1f
	MOVL	%CR4, %EBX
	ORL	$CR4_PGE, %EBX
	MOVL	%EBX, %CR4
1:
	TESTL	$CPU_HAS_PAT, %EBP
	JZ	1f
	MOVL	$IA32_MEMORY_TYPE_WB | (IA32_MEMORY_TYPE_WT << 8) | (IA32_MEMORY_TYPE_UC_MINUS << 16) | (IA32_MEMORY_TYPE_UC << 24), %EAX
	MOVL	$IA32_MEMORY_TYPE_WB | (IA32_MEMORY_TYPE_WT << 8) | (IA32_MEMORY_TYPE_WC << 16) | (IA32_MEMORY_TYPE_WP << 24), %EDX
	MOVL	$IA32_CR_PAT, %ECX
	WRMSR
1:
	TESTL	$CPU_HAS_FXSR, %EBP
	JZ	1f
	MOVL	%CR4, %EBX
	ORL	$CR4_OSFXSR, %EBX
	MOVL	%EBX, %CR4
1:
	TESTL	$CPU_HAS_SSE, %EBP
	JZ	1f
	MOVL	%CR4, %EBX
	ORL	$CR4_OSXMMEXCPT, %EBX
	MOVL	%EBX, %CR4
1:

#if __KERNEL_USE_PAE == 1
	MOVL	%CR4, %EBX
	ORL	$CR4_PAE, %EBX
	MOVL	%EBX, %CR4
#endif

	POPL	%EDX
	POPL	%EAX
	MOVL	%EAX, %CR3

	/*
	cld
	movl	(%eax), %ebx
	andl	$0xfffff000, %ebx
	movl	(%ebx), %ebx
	movl	$0xb80a0, %edi
	movl	$8, %ecx
2:	movl	%ebx, %eax
	shrl	$24, %eax
	andb	$0xf, %al
	orb	$'0', %al
	cmpb	$'9', %al
	jbe	1f
	addb	$7, %al
1:	movb	$7, %ah
	stosw
	shll	$4, %ebx
	loop	2b
	*/


	MOVL	$4092, %ECX
	MOVL	(%ECX), %EBX
	MOVL	$0xC3C0220F, (%ECX)	/* MOVL %EAX, %CR0; RET */
	MOVL	%CR0, %EAX
	ORL	$CR0_PG | CR0_TS | CR0_AM | CR0_WP, %EAX
	PUSHL	$PAGING_IS_ENABLED
	JMP	*%ECX

PAGING_IS_ENABLED:
	MOVL	%EBX, (%ECX)
	MOVL	$KERNEL_STACK - 20, %ESP
	MOVL	%EAX, CR_0
#if __KERNEL_USE_PAE == 0
	TESTL	$CPU_HAS_4M_PAGES | CPU_HAS_GLOBAL_PAGES | CPU_HAS_FXSR | CPU_HAS_SSE, KERNEL$CPU_FEATURES
	JZ	1f
#endif
	MOVL	%CR4, %EAX
	MOVL	%EAX, CR_4
1:	MOVL	$0xFFFFFFFF, KERNEL$SPL
	PUSHL	$IDLE_LOOP
	PUSHL	%EDX
	LGDTL	GDTR
	TESTL	$CPU_HAS_SYSENTER, KERNEL$CPU_FEATURES
	JZ	1f
	XORL	%EDX, %EDX
	MOVL	$SEG_KCODE, %EAX
	MOVL	$IA32_SYSENTER_CS, %ECX
	WRMSR
	MOVL	$SYSCALL_SYSENTER, %EAX
	MOVL	$IA32_SYSENTER_EIP, %ECX
	WRMSR
	MOVL	$KERNEL_STACK - 20, %EAX
	MOVL	$IA32_SYSENTER_ESP, %ECX
	WRMSR
1:
	TESTL	$CPU_HAS_AMD_SYSCALL, KERNEL$CPU_FEATURES
	JZ	1f
	MOVL	$IA32_EFER, %ECX
	RDMSR
	ORL	$IA32_EFER_LO_SCE, %EAX
	WRMSR
	MOVL	$SEG_UCODE * 65536 + SEG_KCODE, %EDX
	MOVL	$SYSCALL_SYSCALL, %EAX
	MOVL	$IA32_STAR, %ECX
	WRMSR
1:
	MOVL	$SEG_KDATA, %EAX
	MOVL	%EAX, %DS
	MOVL	%EAX, %ES
	XORL	%EAX, %EAX
	MOVL	%EAX, %FS
	MOVL	%EAX, %GS
	MOVW	$SEG_TSS, %AX
	LTRW	%AX
	MOVW	$SEG_LDT, %AX
	LLDTW	%AX
	CALL	CONSOLE_INIT
	CALL	FIXUP_IDT
	LIDTL	IDTR

	/* GNU AS IS VERY BUGGY BEAST. HERE ARE SOME RUN-TIME CHECKS FOR ASSEMBLER BUGS */

	MOVL	8f - 4, %EAX
	JMP	9f
	CALL	9f - 8f
8:
9:
	/*TESTL	%EAX, %EAX*/
	/*JZ	AS_BUG_3*/
	NEG	%EAX
	CMPL	$8b, %EAX
	JNZ	AS_BUG_3


	MOVW	9f, %AX
	JMP	8f
9:	JMP	8f + ___AS_BUG_4
8:
___AS_BUG_4 = 2
	CMPW	$0x00EB, %AX
	JE	AS_BUG_4


	/* ASSEMBLER CANNOT DO THIS ARITHMETIC, SO I MUST CHECK IT AT RUN TIME */

	MOVL	$KERNEL_CRAWLOUT_END - KERNEL_CRAWLOUT_SPACE, %EAX
	CMPL	$KERNEL_CRAWLOUT_SPACE_ALIGN, %EAX
	JNZ	CRAWLOUT_OVERFLOW

	MOVL	$JMPTBL_END - JMPTBL, %EAX
	CMPL	$0x80 * 4, %EAX
	JA	JMPTBL_OVERFLOW

	FNINIT

	RET

AS_BUG_3:
	PUSHL	$3
	PUSHL	$1f
	CALL	KERNEL$SUICIDE
AS_BUG_4:
	PUSHL	$4
	PUSHL	$1f
	CALL	KERNEL$SUICIDE
CRAWLOUT_OVERFLOW:
	PUSHL	$KERNEL_CRAWLOUT_SPACE_ALIGN
	PUSHL	%EAX
	PUSHL	$3f
	CALL	KERNEL$SUICIDE
JMPTBL_OVERFLOW:
	PUSHL	$0x80 * 4
	PUSHL	%EAX
	PUSHL	$4f
	CALL	KERNEL$SUICIDE
	.SECTION .rodata
1:	.STRING	"YOUR ASSEMBLER IS BRAIN DAMAGED AND MISCOMPILED THE KERNEL. SEE BEGINNING OF FILE ASM.S. BUG %d!"
3:	.STRING	"CRAWLOUT SPACE OVERFLOW (SIZE = %d, ALIGN = %d)"
4:	.STRING	"JMPTBL OVERFLOW (SIZE = %d, LIMIT = %d)"

	.SECTION .text
FIXUP_IDT:
	MOVL	$IDT, %EAX
1:	MOVW	2(%EAX), %CX
	MOVW	4(%EAX), %DX
	MOVW	6(%EAX), %BX
	MOVW	%DX, 2(%EAX)
	MOVW	%BX, 4(%EAX)
	MOVW	%CX, 6(%EAX)
	ADDL	$8, %EAX
	CMPL	$IDT_END, %EAX
	JB	1b
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
	INTMAP_POP(1)
4:	PUSHL	PROC_CURRENT
	INTMAP_POP(2)
	CALL	SET_PROC_CURRENT
	CALL	*4(%ESP)
	PUSHL	%EAX
	INTMAP_POP(3)
	MOVL	4(%ESP), %EAX
	CALL	SET_PROC_CURRENT
	POPL	%EAX
	INTMAP_POP(2)
	LEAL	8(%ESP), %ESP
	INTMAP_POP(1)
	RET

	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
USE_PROC:
	CMPL	$KERNEL$PROC_KERNEL, %EAX
	JE	3f
	CMPL	$0, PROC_CURRENT_LOCK
#ifndef __NO_ASM_PREDICTIONS
	JNE,pn	4b
#else
	JNE	4b
#endif

	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	SET_PROC_CURRENT
	/* Must not modify registers, including flags */
SET_PROC_CURRENT:
	/* protect against wild pointers, they'd cause hard reset */
#if __DEBUG >= 2
	XCHGL	%EAX, %EDX
	PUSHL	%EAX
	INTMAP_POP(2)
	LAHF
	SETO	%AL
	PUSHL	%ECX
	INTMAP_POP(3)

#if !__KERNEL_USE_PAE
	MOVL	VM_KERNEL_DIRECT_BANK * 4(%EDX), %ECX
#else
	MOVL	VM_KERNEL_DIRECT_BANK * 8(%EDX), %ECX
#endif
	ANDL	$~PTE_G, %ECX
	CMPL	PHYSMAP_486, %ECX
	JNE	5f

	ADDB	$0x7f, %AL
	SAHF
	POPL	%ECX
	INTMAP_POP(2)
	POPL	%EAX
	INTMAP_POP(1)
	XCHGL	%EAX, %EDX

	.SECTION .text.end
5:	CLI
	PUSHL	PROC_CURRENT
	PUSHL	PHYSMAP_486
	PUSHL	%ECX
	PUSHL	%EDX
	PUSHL	$55f
	CALL	KERNEL$SUICIDE
	.PREVIOUS
	.SECTION .rodata
55:	.STRING	"SET_PROC_CURRENT: INVALID PROCESS %p (ZERO PAGE %08X, EXPECTED %08X), PROC_CURRENT %p"
	.PREVIOUS
#else
	/* test it unconditionally, rather crash than reset */
	PUSHL	(%EAX)
	INTMAP_POP(2)
	LEAL	4(%ESP), %ESP
	INTMAP_POP(1)
#endif
	MOVL	%EAX, PROC_CURRENT
	LEAL	-(VM_KERNEL_DIRECT_OFFSET - PROC2PGTBL)(%EAX), %EAX
	MOVL	%EAX, %CR3
	LEAL	(VM_KERNEL_DIRECT_OFFSET - PROC2PGTBL)(%EAX), %EAX
3:	RET


	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_JMP_ABS(IDLE_LOOP_SHADOW)
	.GLOBAL	IDLE_LOOP
IDLE_LOOP:
	MOVL	$KERNEL_STACK - 20, %ESP
	XORL	%EAX, %EAX
#if __DEBUG >= 1
	CMPL	$0xFFFFFFFF, KERNEL$SPL
	JNE	bad_idle_loop_spl
	CMPL	%EAX, PROC_CURRENT_LOCK
	JNE	idle_loop_locked
#endif
	MOVL	%EAX, IRQ_RDTSC
	MOVL	%EAX, KERNEL_HOLD_JIFFIES
	MOVB	%AL, KERNEL$LOCKUP_LEVEL
	MOVL	PROC_RUN, %EAX
	TESTL	%EAX, %EAX
	JZ	do_halt
	CMPL	KERNEL$PROC_ACCOUNT, %EAX
	JNE	switch_account
	CMPL	PROC_CURRENT, %EAX
	JNE	set_proc_current
2:	SUBL	PROC_FPU, %EAX
	MOVL	KERNEL$FPU_ENABLED, %EDX
	MOVL	$KUPLACE(UDATA_EIP), %ECX	/* make code size smaller */
	TESTL	%EDX, %EAX
	JNZ	10f
	ORL	%EDX, %EAX
	JZ	12f
11:	
	FAULTMAP_ENTRY(upage_fault)
	MOVL	(%ECX), %EAX
	FAULTMAP_ENTRY(upage_fault)
	MOVL	%EAX, (%ECX)	/* CHECK FOR WRITE ACCESS */

	/*
	movl	KUPLACE(UDATA_ESP), %eax
	pushl	KUPLACE(UDATA_PPL)
	pushl	KUPLACE(UDATA_SPL)
	pushl	KUPLACE(UDATA_EDI)
	pushl	KUPLACE(UDATA_ESI)
	pushl	KUPLACE(UDATA_EBP)
	pushl	KUPLACE(UDATA_EDX)
	pushl	KUPLACE(UDATA_ECX)
	pushl	KUPLACE(UDATA_EBX)
	pushl	KUPLACE(UDATA_EAX)
	pushl	(%eax)
	pushl	KUPLACE(UDATA_ESP)
	pushl	KUPLACE(UDATA_EIP)
	pushl	$8f
	cli
	call	__critical_printf
#	movl	PROC_CURRENT, %eax
#	call	dumpx
	sti
	addl	$44, %esp
	.section .rodata
8:	.string	"calling userspace: eip==%08x, esp==%08x, (esp)==%08x\neax=%08x, ebx=%08x, ecx=%08x, edx=%08x, ebp=%08x, esi=%08x, edi=%08x, spl=%08x, ppl=%08x\n"
88:	pushl	$-1
	jmp	888b
	.previous
	movl	KUPLACE(UDATA_EIP), %eax*/

	CMPL	$APLACE(APAGE_SYSCALL), %EAX
	JZ	4567f
	MOVL	KUPLACE(UDATA_EAX) - KUPLACE(UDATA_EIP) (%ECX), %EAX
	MOVL	KUPLACE(UDATA_EBX) - KUPLACE(UDATA_EIP) (%ECX), %EBX
	MOVL	KUPLACE(UDATA_EBP) - KUPLACE(UDATA_EIP) (%ECX), %EBP
	MOVL	KUPLACE(UDATA_ESI) - KUPLACE(UDATA_EIP) (%ECX), %ESI
	MOVL	KUPLACE(UDATA_EDI) - KUPLACE(UDATA_EIP) (%ECX), %EDI

	CMPL	$0, KUPLACE(UDATA_LDT) - KUPLACE(UDATA_EIP) (%ECX)
	JNZ	56f

	MOVL	%FS, %ECX
	MOVL	%GS, %EDX
	ORL	%EDX, %ECX
	JNZ	5f
6:	/* AMD SYSRET depends on EDX == 0 here */

	.SECTION .FEATURE_FIXUP
	.LONG	41f, 42f, 43f, 44f, CPU_HAS_SYSENTER, 0, 0, 0
	.LONG	41f, 42f, 45f, 46f, CPU_HAS_AMD_SYSCALL, 0, 0, 0
	.PREVIOUS

41:
	MOVL	KUPLACE(UDATA_EFLAGS), %ECX
	PUSHL	$SEG_USTACK
	ANDL	$EFLAGS_LEAVE, %ECX
	PUSHL	KUPLACE(UDATA_ESP)
	ORL	$EFLAGS_SET, %ECX
	PUSHL	%ECX
	MOVL	KUPLACE(UDATA_ECX), %ECX
	PUSHL	$SEG_UCODE
	MOVL	KUPLACE(UDATA_EDX), %EDX
	PUSHL	KUPLACE(UDATA_EIP)
	IRET
42:

	.SECTION	.rodata
43:
	MOVL	KUPLACE(UDATA_ESP), %ECX
	MOVL	$APLACE(APAGE_RETURN), %EDX
	SYSEXIT
44:
45:
	MOVL	$APLACE(APAGE_RETURN), %ECX
	/*XORL	%EDX, %EDX cleared by the seg reg code*/
	CLI
	MOVL	KUPLACE(UDATA_ESP), %ESP
	.BYTE	0x0F, 0x07
46:
	.PREVIOUS

	.ALIGN	__CPU_BRANCH_ALIGN
	/* must preserve ECX */
10:	CALL	DISABLE_FPU
	JMP	11b

	.ALIGN	__CPU_BRANCH_ALIGN
	/* must preserve ECX */
12:	CALL	KERNEL$ENABLE_FPU
	JMP	11b

	.ALIGN	__CPU_BRANCH_ALIGN
set_proc_current:
	CALL	SET_PROC_CURRENT
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
4567:	MOVL	KUPLACE(UDATA_EAX) - KUPLACE(UDATA_EIP) (%ECX), %EAX
	MOVL	KUPLACE(UDATA_EDX) - KUPLACE(UDATA_EIP) (%ECX), %EDX
	MOVL	KUPLACE(UDATA_ECX) - KUPLACE(UDATA_EIP) (%ECX), %ECX
	JMP	SYSCALL_SHORTCUT

	.ALIGN	__CPU_BRANCH_ALIGN
5:	XORL	%EDX, %EDX
	MOVL	%EDX, %FS
	MOVL	%EDX, %GS
	JMP	6b

	.ALIGN	__CPU_BRANCH_ALIGN
56:
	XORL	%EDX, %EDX
	MOVL	%EDX, %FS
	MOVL	%EDX, %GS

	.SECTION .FEATURE_FIXUP
	.LONG	441f, 442f, 443f, 444f, CPU_HAS_SYSENTER, 0, 0, 0
	.LONG	441f, 442f, 445f, 446f, CPU_HAS_AMD_SYSCALL, 0, 0, 0
	.PREVIOUS

441:
	MOVL	KUPLACE(UDATA_EFLAGS) - KUPLACE(UDATA_EIP) (%ECX), %ECX
	PUSHL	$SEG_USTACK
	ANDL	$EFLAGS_LEAVE, %ECX
	PUSHL	$KUPLACE(UDATA_TMP_STACK) + 4
	ORL	$EFLAGS_SET, %ECX
	PUSHL	%ECX
	PUSHL	$SEG_UCODE
	PUSHL	$APLACE(APAGE_SEG_RETURN)
	IRET
442:

	.SECTION .rodata
443:
	MOVL	$KUPLACE(UDATA_TMP_STACK) + 4, %ECX
	MOVL	$APLACE(APAGE_SEG_RETURN), %EDX
	SYSEXIT
444:
445:
	MOVL	$APLACE(APAGE_SEG_RETURN), %ECX
	/*XORL	%EDX, %EDX cleared by the seg reg code*/
	CLI
	MOVL	$KUPLACE(UDATA_TMP_STACK) + 4, %ESP
	.BYTE	0x0F, 0x07
446:
	.PREVIOUS

	.ALIGN	__CPU_BRANCH_ALIGN
upage_fault:
	MOVL	$(-1) << (SPL_DEV + 1), KERNEL$SPL
	INTMAP_NO_CRAWLOUT
	MOVL	%ECX, %EAX
	XORL	%ECX, %ECX
	LEAL	1(%ECX), %EDX
	JMP	VM_FAULT_EXCEPTION
	INTMAP_JMP_ABS(IDLE_LOOP_SHADOW)

	.ALIGN	__CPU_BRANCH_ALIGN
switch_account:
	MOVL	$(-1) << (SPL_VSPACE + 1), KERNEL$SPL
	INTMAP_NO_CRAWLOUT
	CALL	KERNEL$SWITCH_PROC_ACCOUNT
	JMP	DO_END_SYSCALL
	INTMAP_JMP_ABS(IDLE_LOOP_SHADOW)

	.ALIGN	__CPU_BRANCH_ALIGN
do_halt:
	MOVL	$KERNEL$PROC_KERNEL, %EAX
	CMPL	%EAX, KERNEL$PROC_ACCOUNT
#ifndef __NO_ASM_PREDICTIONS
	JNE,pn	switch_account
#else
	JNE	switch_account
#endif
	MOVL	$KERNEL$LOCKUP_EVENTS, %EAX
	CMPL	%EAX, (%EAX)
	JNE	1f
	/* !!! TODO: do idle processing here (i.e. zero pages on CPU with SSE2 and MOVNTA) */
	HLT
	JMP	IDLE_LOOP
1:
	MOVL	$(-1) << (SPL_ZERO + 1), KERNEL$SPL
	INTMAP_NO_CRAWLOUT
	CALL	KERNEL$WQ_WAKE_ALL
	JMP	DO_END_SYSCALL
	INTMAP_JMP_ABS(IDLE_LOOP_SHADOW)
	

	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_NO_INT
IDLE_LOOP_SHADOW:
	MOVL	$KERNEL_STACK - 20, %ESP
	MOVL	$IDLE_LOOP, CRAWLOUT_RETURN
	JMP	PROCESS_DEFERED_AST


#if __DEBUG >= 1
	.ALIGN	__CPU_BRANCH_ALIGN
	INTMAP_NO_CRAWLOUT
bad_idle_loop_spl:
	PUSHL	KERNEL$SPL
	PUSHL	$1f
	CALL	KERNEL$SUICIDE
	NOP
	.ALIGN	__CPU_BRANCH_ALIGN
	INTMAP_NO_CRAWLOUT
idle_loop_locked:
	PUSHL	PROC_CURRENT_LOCK
	PUSHL	$2f
	CALL	KERNEL$SUICIDE
	NOP
	.SECTION .rodata
1:	.STRING	"IDLE LOOP AT SPL %08X"
2:	.STRING	"IDLE LOOP WITH PROCESS LOCK LEFT (%d)"
	.PREVIOUS
#endif

#define FATAL_XCPT_HANDLER(X)		.ALIGN __CPU_CALL_ALIGN; EXCEPTION_##X: PUSHL $0; PUSHL $X; JMP FATAL_XCPT
#define FATAL_XCPT_HANDLER_ERR(X)	.ALIGN __CPU_CALL_ALIGN; EXCEPTION_##X: PUSHL $X; JMP FATAL_XCPT
#define USER_XCPT_HANDLER(X)		.ALIGN __CPU_CALL_ALIGN; EXCEPTION_##X: PUSHL $0; PUSHL $X; JMP USER_XCPT
#define USER_XCPT_HANDLER_ERR(X)	.ALIGN __CPU_CALL_ALIGN; EXCEPTION_##X: PUSHL $X; JMP USER_XCPT
#define USER_XCPT_HANDLER_ERR_NOJMP(X)	.ALIGN __CPU_CALL_ALIGN; EXCEPTION_##X: PUSHL $X

	INTMAP_NO_CRAWLOUT

USER_XCPT_HANDLER(0)
USER_XCPT_HANDLER(1)
/*FATAL_XCPT_HANDLER(2)*/
USER_XCPT_HANDLER(3)
USER_XCPT_HANDLER(4)
USER_XCPT_HANDLER(5)
USER_XCPT_HANDLER(6)
/*USER_XCPT_HANDLER(7)*/
/*FATAL_XCPT_HANDLER_ERR(8)*/
USER_XCPT_HANDLER(9)
/*FATAL_XCPT_HANDLER_ERR(10)*/
USER_XCPT_HANDLER_ERR(11)
USER_XCPT_HANDLER_ERR(12)
USER_XCPT_HANDLER_ERR(13)
FATAL_XCPT_HANDLER(15)
USER_XCPT_HANDLER(16)
USER_XCPT_HANDLER_ERR(17)
/*FATAL_XCPT_HANDLER(18)*/
USER_XCPT_HANDLER(19)
FATAL_XCPT_HANDLER(20)
FATAL_XCPT_HANDLER(21)
FATAL_XCPT_HANDLER(22)
FATAL_XCPT_HANDLER(23)
FATAL_XCPT_HANDLER(24)
FATAL_XCPT_HANDLER(25)
FATAL_XCPT_HANDLER(26)
FATAL_XCPT_HANDLER(27)
FATAL_XCPT_HANDLER(28)
FATAL_XCPT_HANDLER(29)
FATAL_XCPT_HANDLER(30)
FATAL_XCPT_HANDLER(31)
FATAL_XCPT_HANDLER(34)

	INTMAP_NO_CRAWLOUT
	.ALIGN	__CPU_CALL_ALIGN
USER_XCPT_HANDLER_ERR_NOJMP(14)
USER_XCPT:
	CMPL	$KERNEL_STACK - 28, %ESP
	JNE	1f
	MOVL	%EAX, %SS:KUPLACE(UDATA_EAX)
	CMPL	$0, %SS:KUPLACE(UDATA_LDT)
	JNZ	71f
	MOVL	%DS, %EAX
	CMPW	$SEG_KDATA, %AX
	JNE	711f
	MOVL	%ES, %EAX
	CMPW	$SEG_KDATA, %AX
711:	JNE	7f
8:	
USER_XCPT_SREG_OK:
	MOVL	%EBX, KUPLACE(UDATA_EBX)
	MOVL	16(%ESP), %EBX
	MOVL	%EBP, KUPLACE(UDATA_EBP)
	MOVL	8(%ESP), %EAX
	MOVL	%ESI, KUPLACE(UDATA_ESI)
	TESTB	$EFLAGS_DF >> 8, %BH
	JNZ	57f
58:	ANDL	$~(APAGE_RETURN_BLOCK_SIZE - 1), %EAX
	MOVL	%EDI, KUPLACE(UDATA_EDI)
	CMPL	$APLACE(APAGE_RETURN_BLOCK), %EAX
	JE	22f
24:	MOVL	%ECX, KUPLACE(UDATA_ECX)
	MOVL	8(%ESP), %ECX
	MOVL	%EDX, KUPLACE(UDATA_EDX)
	MOVL	20(%ESP), %EDX
	MOVL	%EBX, KUPLACE(UDATA_EFLAGS)
	MOVL	%ECX, KUPLACE(UDATA_EIP)
	MOVL	%EDX, KUPLACE(UDATA_ESP)
23:	CMPL	$ABASE, %ECX
	JAE	3f
2:	MOVL	(%ESP), %EAX
		/* Cyrix 486 pushes garbage in high 16 bits */
	MOVZWL	4(%ESP), %EDX
	CMPL	$XCPT_PF, %EAX
	JNE	4f
	MOVL	%CR2, %EAX
	MOVL	$(-1) << (SPL_DEV + 1), KERNEL$SPL
	STI
	XORL	$4, %EDX
	TESTL	$~3, %EDX
	JNZ	VM_KERNEL_FAULT_EXCEPTION
	SHRL	$1, %EDX
	JMP	VM_FAULT_EXCEPTION
	.ALIGN	__CPU_BRANCH_ALIGN
22:	CMPW	$SEG_UCODE, 12(%ESP)
#ifndef __NO_ASM_PREDICTIONS
	JNE,pn	24b
#else
	JNE	24b
#endif
	MOVL	KUPLACE(UDATA_EIP), %ECX
	JMP	23b
	.ALIGN	__CPU_BRANCH_ALIGN
3:	CALL	FIXUP_APAGE
	MOVL	KUPLACE(UDATA_EIP), %ECX
	JMP	2b
	.ALIGN	__CPU_BRANCH_ALIGN
4:	MOVL	$(-1) << (SPL_DEV + 1), KERNEL$SPL
	STI
	JMP	USER_EXCEPTION

	.ALIGN	__CPU_BRANCH_ALIGN
71:	MOVL	8(%ESP), %EAX
	ANDL	$~(APAGE_RETURN_BLOCK_SIZE - 1), %EAX
	CMPL	$APLACE(APAGE_RETURN_BLOCK), %EAX
	JE	72f
73:	MOVW	%DS, %SS:KUPLACE(UDATA_DS)
	MOVZWL	12(%ESP), %EAX
	MOVW	%ES, %SS:KUPLACE(UDATA_ES)
	MOVL	%EAX, %SS:KUPLACE(UDATA_CS)
	MOVW	%FS, %SS:KUPLACE(UDATA_FS)
	MOVZWL	24(%ESP), %EAX
	MOVW	%GS, %SS:KUPLACE(UDATA_GS)
	MOVL	%EAX, %SS:KUPLACE(UDATA_SS)
7:	MOVL	$SEG_KDATA, %EAX
	MOVL	%EAX, %DS
	MOVL	%EAX, %ES
	JMP	8b
72:	CMPW	$SEG_UCODE, 12(%ESP)
	JE	7b
	JMP	73b

	.ALIGN	__CPU_BRANCH_ALIGN
57:	CLD
	JMP	58b

	.ALIGN	__CPU_BRANCH_ALIGN
1:
	/* warning. DF maight be set here, but we don't call any C functions */

	/*
	pushal
	pushfl
	testw	$EFLAGS_IF, 52(%esp)
	jz	502f
	cld
	pushl	$0
	FAULTMAP_ENTRY(511f)
	movl	KUPLACE(UDATA_ESP), %eax
	FAULTMAP_ENTRY(511f)
	movl	(%eax), %eax
	movl	%eax, (%esp)
511:	pushl	$0
	FAULTMAP_ENTRY(510f)
	movl	KUPLACE(UDATA_EIP), %eax
	movl	%eax, (%esp)
510:	pushl	48(%esp)
	movl	%cr2, %eax
	pushl	%eax
	pushl	60(%esp)
	pushl	56(%esp)
	pushl	$500f
	call	__critical_printf
	addl	$28, %esp
	.section .rodata
500:	.string	"kernel fault %02x: eip %08x, cr2 %08x, error %08x, ueip %08x (uesp) %08x\n"
	.previous
502:	popfl
	popal
	*/

	CMPL	$XCPT_PF, (%ESP)
	JNE	76f
6:	PUSHL	%EAX
	MOVL	12(%ESP), %EAX
	SUBL    $KERNEL_CRAWLOUT_SPACE, %EAX
	JB	2f
	CMPL    $PAGEFAULT_MAP_LEN, %EAX
	JAE	2f
	MOVL	PAGEFAULT_MAP(,%EAX,4), %EAX
	TESTL	%EAX, %EAX
	JZ	2f
	MOVL	%EAX, 12(%ESP)
	POPL	%EAX
	ADDL	$4, %ESP
	MOVL	%EAX, (%ESP)
	JMP	END_OF_IRQ_EAX

	.ALIGN	__CPU_BRANCH_ALIGN
76:	CMPL	$XCPT_GP, (%ESP)
	JE	6b
	CMPL	$XCPT_MF, (%ESP)
	JE	6b
	JMP	FATAL_XCPT

2:	POPL	%EAX
	JMP	FATAL_XCPT

TASK_XCPT:
	PUSHL	$0
TASK_XCPT_ERR:
	PUSHL	KERNEL$BPL
	PUSHL	KERNEL$PPL
	PUSHL	KERNEL$SPL
	PUSHL	TSS_GS
	PUSHL	TSS_FS
	PUSHL	TSS_DS
	PUSHL	TSS_SS
	PUSHL	TSS_CS
	PUSHL	TSS_ES
	PUSHL	TSS_EDI
	PUSHL	TSS_ESI
	PUSHL	TSS_EBP
	PUSHL	TSS_ESP
	PUSHL	TSS_EBX
	PUSHL	TSS_EDX
	PUSHL	TSS_ECX
	PUSHL	TSS_EAX
	PUSHL	TSS_EFLAGS
	PUSHL	EXCEPTION_MESSAGES_END - EXCEPTION_MESSAGES - 16(%ESP)
	MOVL	%CR2, %EAX
	PUSHL	%EAX
	PUSHL	TSS_EIP
	PUSHL	%EBX
	JMP	PRINT_XCPT

FATAL_XCPT:
	CLI
	CLD
	PUSHL	%SS:KERNEL$BPL
	PUSHL	%SS:KERNEL$PPL
	PUSHL	%SS:KERNEL$SPL
	PUSHL	%GS	/* My Cyrix 486 CPU pushes garbage in high 16 bits */
	ANDL	$0xFFFF, (%ESP)
	PUSHL	%FS
	ANDL	$0xFFFF, (%ESP)
	PUSHL	%DS
	ANDL	$0xFFFF, (%ESP)
	PUSHL	%SS
	ANDL	$0xFFFF, (%ESP)
	PUSHL	10*4(%ESP)
	/*PUSHL	%CS*/
	ANDL	$0xFFFF, (%ESP)
	PUSHL	%ES
	ANDL	$0xFFFF, (%ESP)
	PUSHL	$SEG_KDATA
	POPL	%DS
	PUSHL	$SEG_KDATA
	POPL	%ES
	PUSHL	%EDI
	PUSHL	%ESI
	PUSHL	%EBP
	PUSHL	%ESP
	PUSHL	%EBX
	PUSHL	%EDX
	PUSHL	%ECX
	PUSHL	%EAX
	PUSHL	EXCEPTION_MESSAGES_END - EXCEPTION_MESSAGES - 4(%ESP)
	PUSHL	EXCEPTION_MESSAGES_END - EXCEPTION_MESSAGES - 12(%ESP)
	MOVL	%CR2, %EAX
	PUSHL	%EAX
	PUSHL	EXCEPTION_MESSAGES_END - EXCEPTION_MESSAGES(%ESP)
	PUSHL	EXCEPTION_MESSAGES_END - EXCEPTION_MESSAGES - 4(%ESP)

PRINT_XCPT:
	CMPL	$0, KERNEL$SUICIDE_RESTORE_VIDEOMODE
	JZ	33f
	CALL	*KERNEL$SUICIDE_RESTORE_VIDEOMODE
	CLI
33:

	MOVL	4(%ESP), %ESI	/* EIP for code dump */
	XORL	%EBX, %EBX

2:	PUSHL	(%ESP, %EBX, 4)
	PUSHL	EXCEPTION_MESSAGES(, %EBX, 4)
	CALL	__critical_printf
	POPL	%EAX
	POPL	%EAX
	MOVL	(%ESP, %EBX, 4), %EAX
	MOVL	$_SYM_OFFSET, %EDX
	XORL	%ECX, %ECX
	CALL	KERNEL$DL_GET_SYMBOL_NAME
	TESTL	%EAX, %EAX
	JZ	1f
	PUSHL	_SYM_OFFSET
	PUSHL	%EAX
	PUSHL	$SYM_MESSAGE
	CALL	__critical_printf
	ADDL	$12, %ESP
1:	ADDL	$1, %EBX
	CMPL	$(EXCEPTION_MESSAGES_END - EXCEPTION_MESSAGES) / 4, %EBX
	JB	2b

	PUSHL	$NL
	CALL	__critical_printf
	POPL	%EAX

	ADDL	$EXCEPTION_MESSAGES_END - EXCEPTION_MESSAGES, %ESP
	LEAL	4 * 5(%ESP), %EAX
	CALL	STACK_DUMP
	MOVL	%CR2, %EAX
	CMPL	%EAX, %ESI
	JE	HALT_KERNEL
	CALL	CODE_DUMP
	.GLOBAL	HALT_KERNEL
HALT_KERNEL:
	CLI
	MOVL	$1, %EBX
	CMPL	$0, KERNEL$SUICIDE_DUMP
	JE	4f
	MOVL	KERNEL$SUICIDE_DUMP, %ECX
	MOVL	$0, KERNEL$SUICIDE_DUMP
	CALL	*%ECX
	MOVL	%EAX, %EBX
4:	MOVL	$9f, %EAX
	CALL	getenv
	ORL	%EAX, %EBX
	JZ	3f
	TESTL	%EAX, %EAX
	JZ	1f
	MOVL	%EAX, %EDX
	DECL	%EDX
2:	INCL	%EDX
	CMPB	$0, (%EDX)
	JNZ	2b
	XORL	%ECX, %ECX
	PUSH	$8f
	CALL	__get_number
	ADDL	$4, %ESP
	TEST	%EAX, %EAX
	JNZ	3f
	INB	$0x60, %AL
	MOVB	%AL, %BL
	IMUL	$1000000, 8f, %EAX
	CALL	KERNEL$UDELAY
	INB	$0x60, %AL
	CMPB	%AL, %BL
	JNE	1f
3:	MOVB	$0xFE, %AL
	OUTB	%AL, $0x64
1:	HLT
	JMP	1b

	.SECTION .rodata
9:	.STRING	"@KERNEL$REIPL"
	.SECTION .data
	.ALIGN	4
8:	.LONG	0

	.SECTION .text

	.GLOBAL	HALT_KERNEL_STKDUMP
HALT_KERNEL_STKDUMP:
	MOVL	%ESP, %EAX
	CALL	STACK_DUMP
	JMP	HALT_KERNEL

	.COMM	_SYM_OFFSET, 4

	.SECTION .rodata

	.ALIGN	4
EXCEPTION_MESSAGES:
	.LONG	EM1
	.LONG	EM2
	.LONG	EM3
	.LONG	EM4
	.LONG	EM5
	.LONG	EM6
	.LONG	EM7
	.LONG	EM8
	.LONG	EM9
	.LONG	EM10
	.LONG	EM11
	.LONG	EM12
	.LONG	EM13
	.LONG	EM14
	.LONG	EM15
	.LONG	EM16
	.LONG	EM17
	.LONG	EM18
	.LONG	EM19
	.LONG	EM20
	.LONG	EM21
	.LONG	EM22
EXCEPTION_MESSAGES_END:

EM1:	.STRING	"FATAL EXCEPTION: %02X"
EM2:	.STRING	"\nEIP: %08X"
EM3:	.STRING	"  CR2: %08X"
EM4:	.STRING	"  ERR: %08X"
EM5:	.STRING	"  EFLAGS: %08X"
EM6:	.STRING	"\nEAX: %08X"
EM7:	.STRING	"  ECX: %08X"
EM8:	.STRING	"  EDX: %08X"
EM9:	.STRING	"  EBX: %08X"
EM10:	.STRING	"\nESP: %08X"
EM11:	.STRING	"  EBP: %08X"
EM12:	.STRING	"  ESI: %08X"
EM13:	.STRING	"  EDI: %08X"
EM14:	.STRING	"\nES: %04X"
EM15:	.STRING	"  CS: %04X"
EM16:	.STRING	"  SS: %04X"
EM17:	.STRING	"  DS: %04X"
EM18:	.STRING	"  FS: %04X"
EM19:	.STRING	"  GS: %04X"
EM20:	.STRING "\nSPL: %08X"
EM21:	.STRING "  PPL: %08X"
EM22:	.STRING "  BPL: %08X"

SYM_MESSAGE:
	.STRING	"<%s+%lX>"

	.SECTION .text
	.GLOBAL	KERNEL$STACK_DUMP
	.ALIGN	__CPU_CALL_ALIGN
KERNEL$STACK_DUMP:
	MOVL	%ESP, %EAX
	PUSHL	%EBX
	PUSHL	%EDI
	CALL	STACK_DUMP
	POPL	%EDI
	POPL	%EBX
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	STACK_DUMP
STACK_DUMP:
	MOVL	%EAX, %EDI
	ANDL	$~3, %EDI
	MOVB	$40, %BL
	PUSHL	$STACK_DUMP_MESSAGE
	CALL	__critical_printf
	POPL	%EAX
2:	MOVL	(%EDI), %EAX
	MOVL	$_SYM_OFFSET, %EDX
	MOVL	$1, %ECX
	CALL	KERNEL$DL_GET_SYMBOL_NAME
	TESTL	%EAX, %EAX
	JZ	3f
	CMPL	$0, _SYM_OFFSET
	JZ	3f
	PUSHL	_SYM_OFFSET
	PUSHL	%EAX
	PUSHL	(%EDI)
	PUSHL	$STACK_DUMP_VALUE
	CALL	__critical_printf
	ADDL	$16, %ESP
	DECB	%BL
	JZ	1f
3:	ADDL	$4, %EDI
	TESTL	$PAGE_CLUSTER_SIZE - 1, %EDI
	JNZ	2b
1:	PUSHL	$NL
	CALL	__critical_printf
	POPL	%EAX
	RET

	.ALIGN	__CPU_CALL_ALIGN
CODE_DUMP:
	MOVB	$20, %BL
	PUSHL	$CODE_DUMP_MESSAGE
	CALL	__critical_printf
	ADDL	$4, %ESP
2:	PUSHFL
	MOVL	%ESP, %EDX
	CLI
	MOVL	$KERNEL_STACK - 4, %ESP
	MOVZBL	(%ESI), %EAX
	MOVL	%EDX, %ESP
	POPFL
	PUSHL	%EAX
	PUSHL	$CODE_DUMP_VALUE
	CALL	__critical_printf
	ADDL	$8, %ESP
	INCL	%ESI
	DECB	%BL
	JNZ	2b
	JMP	1b

	.SECTION .rodata
STACK_DUMP_MESSAGE:
	.STRING	"STACK DUMP:"
STACK_DUMP_VALUE:
	.STRING	" %08X<%s+%lX>"
NL:
	.STRING	"\n"
CODE_DUMP_MESSAGE:
	.STRING "CODE DUMP:"
CODE_DUMP_VALUE:
	.STRING	" %02X"

	.SECTION .text
	INTMAP_NO_CRAWLOUT
	.ALIGN	__CPU_CALL_ALIGN
/* trashes segment registers if in-kernel recoverable error occurs at exception
or rt-irq entry. But there's no fix for that ... :-( */
EXCEPTION_18:
	CLD
	CMPL	$KERNEL_STACK - 20, %ESP
	PUSHL	%EAX
	PUSHL	%EDX
	PUSHL	%ECX
	MOVL	$1, %EAX
	JNE	3f
	MOVL	12(%ESP), %EAX
	ANDL	$~(APAGE_RETURN_BLOCK_SIZE - 1), %EAX
	CMPL	$APLACE(APAGE_RETURN_BLOCK), %EAX
	JE	6f
5:	MOVL	%ECX, %SS:KUPLACE(UDATA_ECX)
	MOVL	%EDX, %SS:KUPLACE(UDATA_EDX)
	MOVZWL	16(%ESP), %EAX
	MOVL	%EAX, %SS:KUPLACE(UDATA_CS)
	MOVZWL	28(%ESP), %EAX
	MOVL	%EAX, %SS:KUPLACE(UDATA_SS)
	MOVW	%DS, %SS:KUPLACE(UDATA_DS)
	MOVW	%ES, %SS:KUPLACE(UDATA_ES)
	MOVW	%FS, %SS:KUPLACE(UDATA_FS)
	MOVW	%GS, %SS:KUPLACE(UDATA_GS)
4:	XORL	%EAX, %EAX
3:	MOVL	$SEG_KDATA, %ECX
	MOVL	%ECX, %DS
	MOVL	%ECX, %ES
	CALL	MCE_HANDLER
	POPL	%ECX
	POPL	%EDX
	CMPL	$1, %EAX
	JE	1f
	JA	2f
	CMPL	$KERNEL_STACK - 24, %ESP
	JZ	EXIT_EXCEPTION_7_LDT_IRET
	POPL	%EAX
	IRET
1:	POPL	%EAX
	MOVL	%EAX, KUPLACE(UDATA_EAX)
	PUSHL	$0
	PUSHL	$XCPT_MC
	JMP	USER_XCPT_SREG_OK
2:	POPL	%EAX
	PUSHL	$0
	PUSHL	$XCPT_MC
	JMP	FATAL_XCPT
6:
	CMPW	$SEG_UCODE, 16(%ESP)
	JNE	5b
	MOVL	%SS:KUPLACE(UDATA_EIP), %EAX
	MOVL	%EAX, 12(%ESP)
	MOVL	%SS:KUPLACE(UDATA_EFLAGS), %EAX
	ANDL	$EFLAGS_LEAVE, %EAX
	ORL	$EFLAGS_SET, %EAX
	MOVL	%EAX, 20(%ESP)
	MOVL	%SS:KUPLACE(UDATA_ESP), %EAX
	MOVL	%EAX, 24(%ESP)
	JMP	4b

			/************
			 * SYSCALLS *
			 ************/

	.SECTION .text

	/* warning: code is shadowed below */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_JMP(SYSCALL_SHADOW)
SYSCALL:
	MOVL	%EBX, %SS:KUPLACE(UDATA_EBX)
	MOVL	%DS, %EBX
	CMPW	$SEG_KDATA, %BX
	JNE	221f
	MOVL	%ES, %EBX
	CMPW	$SEG_KDATA, %BX
221:	JNE	2f
3:	CMPL	$0, %SS:KUPLACE(UDATA_LDT)
	JNZ	21f
31:	MOVL	%EAX, KUPLACE(UDATA_EAX)
	MOVL	%ECX, KUPLACE(UDATA_ECX)
	MOVL	12(%ESP), %EBX
	MOVL	%EDX, KUPLACE(UDATA_EDX)
	MOVL	%EBX, KUPLACE(UDATA_ESP)
	MOVL	%EBP, KUPLACE(UDATA_EBP)
	MOVL	%ESI, KUPLACE(UDATA_ESI)
	MOVL	%EDI, KUPLACE(UDATA_EDI)
	MOVL	8(%ESP), %EBX
	MOVL	$APLACE(APAGE_SYSCALL), KUPLACE(UDATA_EIP)
	TESTB	$EFLAGS_DF >> 8, %BH
	JNZ	22f
23:	MOVL	%EBX, KUPLACE(UDATA_EFLAGS)
SYSCALL_SHORTCUT:
	MOVL	$(-1) << (SPL_DEV + 1), KERNEL$SPL
	INTMAP_NO_CRAWLOUT
1:	MOVL	%EAX, %EBX
	SHRL	$SYSCALL_SHIFT, %EBX
	JMP	*SYSCALLS(, %EBX, 4)
	.ALIGN	__CPU_BRANCH_ALIGN
	INTMAP_JMP(SYSCALL_SHADOW_2)
21:	MOVW	%FS, KUPLACE(UDATA_FS)
	MOVL	$SEG_UCODE, KUPLACE(UDATA_CS)
	MOVL	$SEG_USTACK, KUPLACE(UDATA_SS)
	MOVL	$SEG_UDATA + (SEG_UDATA << 16), KUPLACE(UDATA_DS)
	MOVW	%GS, KUPLACE(UDATA_GS)
	JMP	31b
2:	MOVL	$SEG_KDATA, %EBX
	MOVL	%EBX, %DS
	MOVL	%EBX, %ES
	JMP	3b
	.ALIGN	__CPU_CALL_ALIGN
22:	CLD
	JMP	23b
	INTMAP_NO_INT
SYSCALL_SHADOW:
	MOVL	%EBX, %SS:KUPLACE(UDATA_EBX)
	MOVL	%DS, %EBX
	CMPW	$SEG_KDATA, %BX
	JNE	221f
	MOVL	%ES, %EBX
	CMPW	$SEG_KDATA, %BX
221:	JNE	2f
3:	CMPL	$0, %SS:KUPLACE(UDATA_LDT)
	JNZ	21f
31:	MOVL	%EAX, KUPLACE(UDATA_EAX)
	MOVL	%ECX, KUPLACE(UDATA_ECX)
	MOVL	12(%ESP), %EBX
	MOVL	%EDX, KUPLACE(UDATA_EDX)
	MOVL	%EBX, KUPLACE(UDATA_ESP)
	MOVL	%EBP, KUPLACE(UDATA_EBP)
	MOVL	%ESI, KUPLACE(UDATA_ESI)
	MOVL	%EDI, KUPLACE(UDATA_EDI)
	MOVL	8(%ESP), %EBX
	MOVL	$APLACE(APAGE_SYSCALL), KUPLACE(UDATA_EIP)
	TESTB	$EFLAGS_DF >> 8, %BH
	JNZ	22f
23:	MOVL	%EBX, KUPLACE(UDATA_EFLAGS)
	MOVL	$(-1) << (SPL_DEV + 1), KERNEL$SPL
	MOVL	$1b, CRAWLOUT_RETURN
	JMP	PROCESS_DEFERED_AST
	.ALIGN	__CPU_BRANCH_ALIGN
SYSCALL_SHADOW_2:
21:	MOVW	%FS, KUPLACE(UDATA_FS)
	MOVL	$SEG_UCODE, KUPLACE(UDATA_CS)
	MOVL	$SEG_USTACK, KUPLACE(UDATA_SS)
	MOVL	$SEG_UDATA + (SEG_UDATA << 16), KUPLACE(UDATA_DS)
	MOVW	%GS, KUPLACE(UDATA_GS)
	JMP	31b
2:	MOVL	$SEG_KDATA, %EBX
	MOVL	%EBX, %DS
	MOVL	%EBX, %ES
	JMP	3b
	.ALIGN	__CPU_CALL_ALIGN
22:	CLD
	JMP	23b

	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_NO_CRAWLOUT
SYSCALL_SYSENTER:
	PUSHFL
	MOVL	%EBX, %SS:KUPLACE(UDATA_EBX)
	MOVL	%DS, %EBX
	CMPW	$SEG_KDATA, %BX
	JNE	221f
	MOVL	%ES, %EBX
	CMPW	$SEG_KDATA, %BX
221:	JNE	2f
3:	CMPL	$0, KUPLACE(UDATA_LDT)
	JNZ	21f
31:	MOVL	%EAX, KUPLACE(UDATA_EAX)
	MOVL	%ECX, KUPLACE(UDATA_ECX)
	MOVL	%EDX, KUPLACE(UDATA_EDX)
	POPL	%EBX
	MOVL	%EBP, KUPLACE(UDATA_EBP)
	MOVL	%ESI, KUPLACE(UDATA_ESI)
	MOVL	%EDI, KUPLACE(UDATA_EDI)
	TESTB	$EFLAGS_DF >> 8, %BH
	JNZ	22f
23:	MOVL	%EBX, KUPLACE(UDATA_EFLAGS)
	MOVL	$APLACE(APAGE_SYSCALL), KUPLACE(UDATA_EIP)
	MOVL	$(-1) << (SPL_DEV + 1), KERNEL$SPL
	STI
	MOVL	%EAX, %EBX
	SHRL	$SYSCALL_SHIFT, %EBX
	JMP	*SYSCALLS(, %EBX, 4)
	.ALIGN	__CPU_BRANCH_ALIGN
21:	MOVW	%FS, KUPLACE(UDATA_FS)
	MOVL	$SEG_UCODE, KUPLACE(UDATA_CS)
	MOVL	$SEG_USTACK, KUPLACE(UDATA_SS)
	MOVL	$SEG_UDATA + (SEG_UDATA << 16), KUPLACE(UDATA_DS)
	MOVW	%GS, KUPLACE(UDATA_GS)
	JMP	31b
2:	MOVL	$SEG_KDATA, %EBX
	MOVL	%EBX, %DS
	MOVL	%EBX, %ES
	JMP	3b
	.ALIGN	__CPU_BRANCH_ALIGN
22:	CLD
	JMP	23b

	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_NO_CRAWLOUT
SYSCALL_SYSCALL:
	MOVL	%ESP, %SS:KUPLACE(UDATA_ESP)
	MOVL	$KERNEL_STACK - 20, %ESP
	PUSHFL
	CLD		/* AMD has fast cld --- no need to test and set */
	MOVL	%DS, %ECX
	CMPW	$SEG_KDATA, %CX
	JNE	221f
	MOVL	%ES, %ECX
	CMPW	$SEG_KDATA, %CX
221:	JNE	2f
3:	CMPL	$0, KUPLACE(UDATA_LDT)
	JNZ	21f
31:	MOVL	%EAX, KUPLACE(UDATA_EAX)
	MOVL	%EBX, KUPLACE(UDATA_ECX)
	MOVL	%EDX, KUPLACE(UDATA_EDX)
	MOVL	%EBP, KUPLACE(UDATA_EBP)
	MOVL	%ESI, KUPLACE(UDATA_ESI)
	MOVL	%EDI, KUPLACE(UDATA_EDI)
	POPL	%ESI
	MOVL	$APLACE(APAGE_SYSCALL), KUPLACE(UDATA_EIP)
	MOVL	$(-1) << (SPL_DEV + 1), KERNEL$SPL
	MOVL	%ESI, KUPLACE(UDATA_EFLAGS)
	STI
	MOVL	%EBX, %ECX
	MOVL	%EAX, %EBX
	SHRL	$SYSCALL_SHIFT, %EBX
	JMP	*SYSCALLS(, %EBX, 4)
	.ALIGN	__CPU_BRANCH_ALIGN
21:	MOVW	%FS, KUPLACE(UDATA_FS)
	MOVL	$SEG_UCODE, KUPLACE(UDATA_CS)
	MOVL	$SEG_USTACK, KUPLACE(UDATA_SS)
	MOVL	$SEG_UDATA + (SEG_UDATA << 16), KUPLACE(UDATA_DS)
	MOVW	%GS, KUPLACE(UDATA_GS)
	JMP	31b
2:	MOVL	$SEG_KDATA, %ECX
	MOVL	%ECX, %DS
	MOVL	%ECX, %ES
	JMP	3b

			/*******
			 * FPU *
			 *******/

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	DISABLE_FPU
	INTMAP_POP(1)
	/* must preserve ECX */
DISABLE_FPU:
	/*MOVL	CR_0, %EAX*/
	MOVL	$0, KERNEL$FPU_ENABLED
	/* order is important! Think of RT IRQ enabling FPU between these two */
	/*MOVL	%EAX, %CR0*/
	LMSW	CR_0
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$ENABLE_FPU
	INTMAP_POP(1)
	/* must preserve ECX */
KERNEL$ENABLE_FPU:
	CLTS
	/* order is important! Think of RT IRQ disabling FPU between these two */
	MOVL	$-1, KERNEL$FPU_ENABLED
	RET

	INTMAP_NO_INT
	.ALIGN	__CPU_CALL_ALIGN
EXCEPTION_7:
	CLTS
	PUSHL	%EAX
	MOVL	$-1, %SS:KERNEL$FPU_ENABLED
	CMPL	$KERNEL_STACK - 24, %ESP
	JNE	END_OF_IRQ_EAX

	CMPL	$0, %SS:KUPLACE(UDATA_LDT)
	JNZ	71f
	MOVL	%DS, %EAX
61:	CMPW	$SEG_KDATA, %AX
	JNE	771f
	MOVL	%ES, %EAX
	CMPW	$SEG_KDATA, %AX
771:	JNE	7f
6:	
	/*pushal
	pushl	$0f
	call	__critical_printf
	popl	%eax
	popal
	.section .rodata
0:	.string	"f"
	.previous*/
	MOVL	%ECX, KUPLACE(UDATA_ECX)
	TESTB	$EFLAGS_DF >> 8, 13(%ESP)
	JNZ	27f
26:	MOVL	PROC_CURRENT, %EAX
	MOVL	%EDX, KUPLACE(UDATA_EDX)
	CMPL	PROC_FPU, %EAX
	JE	1f
	CALL	SAVE_FPU
	MOVL	PROC_CURRENT, %EAX
	MOVL	%EAX, PROC_FPU
	MOVL	$1, KUPLACE(UDATA_COPROCESSOR_USED)

	/* AMD doesn't save/restore few entries in FPU, so initialize them
	to prevent cross-process information leak */
	.SECTION .FEATURE_FIXUP
	.LONG	10f, 11f, 11f, 11f, 0, 0, CPU_FXSR_LEAK, 0
	.PREVIOUS
10:
	FNCLEX
	EMMS
	FILDL	(%ESP)
11:

	.SECTION .FEATURE_FIXUP
	.LONG	10f, 11f, 12f, 13f, CPU_HAS_FXSR, 0, 0, 0
	.PREVIOUS
10:
	FAULTMAP_ENTRY_NOTEST(112f)
	FRSTOR	KUPLACE(UDATA_COPROCESSOR)
	FAULTMAP_ENTRY_NOTEST(113f)
	NOP
11:
	FAULTMAP_ENTRY_NOTEST(113f)

	.SECTION .rodata
12:
	FXRSTOR	KUPLACE(UDATA_COPROCESSOR)
13:
	.PREVIOUS

1:

/* warning: this must not be called when userspace process is in apage.
   Fortunatelly Exception 7 can't happen there */
EXIT_EXCEPTION_7:

	CMPL	$0, KUPLACE(UDATA_LDT)
	JNZ	EXIT_EXCEPTION_7_LDT

	.SECTION .FEATURE_FIXUP
	.LONG	41f, 42f, 43f, 44f, 0, 0, CPU_HAS_SYSENTER, 0
	.LONG	41f, 42f, 45f, 46f, CPU_HAS_AMD_SYSCALL, 0, 0, 0
	.PREVIOUS

	.SECTION .rodata
43:
	MOVL	12(%ESP), %ECX
	MOVL	$SEG_UCODE, 8(%ESP)
	ANDL	$EFLAGS_LEAVE, %ECX
	ORL	$EFLAGS_SET, %ECX
	MOVL	%ECX, 12(%ESP)
	MOVL	KUPLACE(UDATA_ECX), %ECX
	MOVL	$SEG_USTACK, 20(%ESP)
	POPL	%EAX
	MOVL	KUPLACE(UDATA_EDX), %EDX
	IRET
44:

45:
	MOVL	12(%ESP), %ECX
	MOVL	4(%ESP), %EDX
	MOVL	%ECX, KUPLACE(UDATA_EFLAGS)
	MOVL	$APLACE(APAGE_RETURN), %ECX
	MOVL	(%ESP), %EAX
	MOVL	%EDX, KUPLACE(UDATA_EIP)
	MOVL	16(%ESP), %ESP
	MOVL	%ESP, KUPLACE(UDATA_ESP)
	.BYTE	0x0F, 0x07
46:
	.PREVIOUS

41:
	MOVL	12(%ESP), %ECX
	MOVL	4(%ESP), %EDX
	MOVL	%ECX, KUPLACE(UDATA_EFLAGS)
	MOVL	16(%ESP), %ECX
	MOVL	(%ESP), %EAX
	MOVL	%EDX, KUPLACE(UDATA_EIP)
	MOVL	$APLACE(APAGE_RETURN), %EDX
	MOVL	%ECX, KUPLACE(UDATA_ESP)
	STI
/* Intel says that interrupt won't happen one instruction after sti */
	SYSEXIT
	.SPACE	(44b-43b) - (. - 41b)	/* Note: some old assemblers
		(as 2.10.91) can't calculate difference of forward references
		--- they produce invalid result, so these references must be
		backward */
42:

	.ALIGN	__CPU_BRANCH_ALIGN
71:	
	MOVZWL	8(%ESP), %EAX
	MOVW	%ES, %SS:KUPLACE(UDATA_ES)
	MOVL	%EAX, %SS:KUPLACE(UDATA_CS)
	MOVZWL	20(%ESP), %EAX
	MOVW	%FS, %SS:KUPLACE(UDATA_FS)
	MOVL	%EAX, %SS:KUPLACE(UDATA_SS)
	MOVL	%DS, %EAX
	MOVW	%GS, %SS:KUPLACE(UDATA_GS)
	MOVW	%AX, %SS:KUPLACE(UDATA_DS)
	JMP	61b
	.ALIGN	__CPU_BRANCH_ALIGN
7:	MOVL	$SEG_KDATA, %EAX
	MOVL	%EAX, %DS
	MOVL	%EAX, %ES
	JMP	6b
	.ALIGN	__CPU_BRANCH_ALIGN
27:	CLD
	JMP	26b

	.ALIGN	__CPU_BRANCH_ALIGN
EXIT_EXCEPTION_7_LDT:
	.SECTION .FEATURE_FIXUP
	.LONG	441f, 442f, 443f, 444f, 0, 0, CPU_HAS_SYSENTER, 0
	.LONG	441f, 442f, 445f, 446f, CPU_HAS_AMD_SYSCALL, 0, 0, 0
	.PREVIOUS

443:
EXIT_EXCEPTION_7_LDT_IRET:
	POPL	%EAX
	MOVL	8(%ESP), %ECX
	MOVL	%ECX, KUPLACE(UDATA_EFLAGS)
	ANDL	$EFLAGS_LEAVE, %ECX
	ORL	$EFLAGS_SET, %ECX
	MOVL	(%ESP), %EDX
	MOVL	%ECX, 8(%ESP)
	MOVL	12(%ESP), %ECX
	MOVL	%EDX, KUPLACE(UDATA_EIP)
	MOVL	%ECX, KUPLACE(UDATA_ESP)
	MOVL	$APLACE(APAGE_SEG_RETURN), (%ESP)
	MOVL	$SEG_UCODE, 4(%ESP)
	MOVL	$KUPLACE(UDATA_TMP_STACK) + 4, 12(%ESP)
	MOVL	$SEG_USTACK, 16(%ESP)
	IRET
444:

	.SECTION .rodata
445:
	MOVL	12(%ESP), %ECX
	MOVL	4(%ESP), %EDX
	MOVL	%ECX, KUPLACE(UDATA_EFLAGS)
	MOVL	$APLACE(APAGE_SEG_RETURN), %ECX
	MOVL	(%ESP), %EAX
	MOVL	%EDX, KUPLACE(UDATA_EIP)
	MOVL	16(%ESP), %EDX
	MOVL	%EDX, KUPLACE(UDATA_ESP)
	MOVL	$KUPLACE(UDATA_TMP_STACK) + 4, %ESP
	.BYTE	0x0F, 0x07
446:
	.PREVIOUS

441:
	MOVL	12(%ESP), %ECX
	MOVL	4(%ESP), %EDX
	MOVL	%ECX, KUPLACE(UDATA_EFLAGS)
	MOVL	16(%ESP), %ECX
	MOVL	(%ESP), %EAX
	MOVL	%EDX, KUPLACE(UDATA_EIP)
	MOVL	$APLACE(APAGE_SEG_RETURN), %EDX
	MOVL	%ECX, KUPLACE(UDATA_ESP)
	MOVL	$KUPLACE(UDATA_TMP_STACK) + 4, %ECX
	STI
/* Intel says that interrupt won't happen one instruction after sti */
	SYSEXIT
	.SPACE	(444b-443b) - (. - 441b)	/* Note: some old assemblers
		(as 2.10.91) can't calculate difference of forward references
		--- they produce invalid result, so these references must be
		backward */
442:


	.ALIGN	__CPU_BRANCH_ALIGN
112:	CALL	DISABLE_FPU
	MOVL	$0, PROC_FPU
113:	POPL	%EDX
	POPL	%ECX
	POPL	%EAX
	MOVL	%EAX, KUPLACE(UDATA_EAX)
	PUSHL	$0
	PUSHL	$XCPT_MF
	JMP	USER_XCPT_SREG_OK


			/************************
			 * INTERRUPT DISPATCHER *
			 ************************/

#define I8259MASK_NEXT	8

	.SECTION .text
	.ALIGN	__CPU_CACHELINE_ALIGN
	INTMAP_NO_CRAWLOUT

#define ioff(X)	((X) % 8)
#define isub(X)	(3 - (ioff(X) / 4) * 3)
#define iadd(X)	(((X) / 8) * I8259MASK_NEXT)
#define ibit(X)	(isub(X) * 8 + ioff(X))
#define icnt(X)	((X) % 4 * 6 + (1 - isub(X) / 3) * 8)
#define iprt(X)	(0x21 + ((X) / 8) * 0x80)
#if __DEBUG < 1
#define idbg(X, r, m)
#else
#define idbg(X, r, m)						;\
	TESTL	$63 << icnt(X), r				;\
	JZ	10f						;\
	.SECTION .text.end					;\
10:	PUSHL	$X						;\
	PUSHL	$m						;\
	CALL	KERNEL$SUICIDE					;\
	.PREVIOUS

	.SECTION .rodata
irq_counter_overflow:
	.STRING	"IRQ %d COUNTER OVERFLOW"
irq_counter_underflow:
	.STRING	"IRQ %d COUNTER UNDERFLOW"
	.PREVIOUS
#endif

#if __DEBUG < 2
#define iassert(X)
#else
#define iassert(X)						;\
	PUSHFL							;\
	POPL	%EAX						;\
	TESTB	$EFLAGS_IF >> 8, %AH				;\
	JZ	10f						;\
	.SECTION .text.end					;\
10:	PUSHL	$X						;\
	PUSHL	$irq_enabled_with_cli				;\
	CALL	KERNEL$SUICIDE					;\
	.PREVIOUS

	.SECTION .rodata
irq_enabled_with_cli:
	.STRING	"IRQ %d ENABLED WITH INTERRUPTS DISABLED"
	.PREVIOUS
#endif

	.IF	__DEBUG_IRQ
	.SECTION .rodata
kernel_str:
	.STRING	"KERNEL"
	.PREVIOUS
	.ENDIF

#define I8259_CREATE_DISABLE(X)					;\
	.ALIGN	__CPU_CALL_ALIGN				;\
	.GLOBAL	I8259_DISABLE_##X				;\
I8259_DISABLE_##X:						;\
	PUSHL	%ESI						;\
	MOVL	$I8259MASK_1 + iadd(X), %ESI			;\
9:								;\
.IF -isub(X)<>0							;\
	MOVL	-isub(X)(%ESI), %EAX				;\
.ELSE								;\
	MOVL	(%ESI), %EAX					;\
.ENDIF								;\
	LEAL	1 << icnt(X)(%EAX), %EDX			;\
	idbg(X, %EDX, irq_counter_overflow)			;\
	.IF	1 << ibit(X) >= 0 && 1 << ibit(X) < 0x100	;\
	ORB	$1 << ibit(X), %DL				;\
	.ELSE							;\
	ORL	$1 << ibit(X), %EDX				;\
	.ENDIF							;\
.IF -isub(X)<>0							;\
	CMPXCHGL %EDX, -isub(X)(%ESI)				;\
.ELSE								;\
	CMPXCHGL %EDX, (%ESI)					;\
.ENDIF								;\
	MOVW	$iprt(X), %DX					;\
	JNZ	8f						;\
	.IF	1 << ibit(X) >= 0 && 1 << ibit(X) < 0x100	;\
	TESTB	$1 << ibit(X), %AL				;\
	.ELSE							;\
	TESTL	$1 << ibit(X), %EAX				;\
	.ENDIF							;\
	JE	6f						;\
7:	POPL	%ESI						;\
	RET							;\
6:	OUTSB							;\
	JMP	7b						;\
8:	JMP	9b

#define I8259_CREATE_ENABLE(X)					;\
	.ALIGN	__CPU_CALL_ALIGN				;\
	INTMAP_NO_CRAWLOUT					;\
	.GLOBAL	I8259_ENABLE_##X				;\
I8259_ENABLE_##X:						;\
	iassert(X)						;\
	PUSHL	%ESI						;\
	MOVL	$I8259MASK_1 + iadd(X), %ESI			;\
9:								;\
.IF -isub(X)<>0							;\
	MOVL	-isub(X)(%ESI), %EAX				;\
.ELSE								;\
	MOVL	(%ESI), %EAX					;\
.ENDIF								;\
	idbg(X, %EAX, irq_counter_underflow)			;\
	LEAL	-(1 << icnt(X))(%EAX), %EDX			;\
	.IF	63 << icnt(X) >= 0 && 63 << icnt(X) < 0x100	;\
	TESTB	$63 << icnt(X), %DL				;\
	.ELSEIF	63 << icnt(X) >= 0 && 63 << icnt(X) < 0x10000	;\
	TESTW	$63 << icnt(X), %DX				;\
	.ELSE							;\
	TESTL	$63 << icnt(X), %EDX				;\
	.ENDIF							;\
	JNZ	1f						;\
	.IF	1 << ibit(X) >= 0 && 1 << ibit(X) < 0x100	;\
	ANDB	$~(1 << ibit(X)), %DL				;\
	.ELSE							;\
	ANDL	$~(1 << ibit(X)), %EDX				;\
	.ENDIF							;\
1:								;\
.IF -isub(X)<>0							;\
	CMPXCHGL %EDX, -isub(X)(%ESI)				;\
.ELSE								;\
	CMPXCHGL %EDX, (%ESI)					;\
.ENDIF								;\
	JNZ	8f						;\
	.IF	1 << ibit(X) >= 0 && 1 << ibit(X) < 0x100	;\
	TESTB	$1 << ibit(X), %DL				;\
	.ELSE							;\
	TESTL	$1 << ibit(X), %EDX				;\
	.ENDIF							;\
	MOVW	$iprt(X), %DX					;\
	JZ	6f						;\
7:	POPL	%ESI						;\
	RET							;\
6:	OUTSB							;\
	.GLOBAL	I8259_PATCH_##X					;\
I8259_PATCH_##X:						;\
/* warning --- this location will be patched to EBFB - JMP 7b */;\
	MOVW	$0xFBEB, I8259_PATCH_##X			;\
	.IF	__DEBUG_IRQ					;\
	PUSHL	$X						;\
	PUSHL	$10f						;\
	PUSHL	$kernel_str					;\
	PUSHL	$__SYSLOG_SW_WARNING				;\
	CALL	KERNEL$SYSLOG					;\
	ADDL	$16, %ESP					;\
	.SECTION .rodata					;\
10:	.STRING	"REPLAYING IRQ %d"				;\
	.PREVIOUS						;\
	.ENDIF							;\
	INT	$IRQ_INT + X					;\
	JMP	7b						;\
8:	JMP	9b

#define I8259_AST_IRQ_STUB(X)					;\
1:	PUSHL	%EAX						;\
	PUSHL	%ECX						;\
	MOVL	$I8259MASK_1 + iadd(X) - isub(X), %ECX		;\
	MOVL	%SS:(%ECX), %EAX				;\
	.IF	63 << icnt(X) >= 0 && 63 << icnt(X) < 0x100	;\
	TESTB	$63 << icnt(X), %AL				;\
	.ELSE							;\
	.IF	63 << icnt(X) >= 0 && 63 << icnt(X) < 0x10000	;\
	TESTW	$63 << icnt(X), %AX				;\
	.ELSE							;\
	TESTL	$63 << icnt(X), %EAX				;\
	.ENDIF							;\
	.ENDIF							;\
	JNZ	IRQ_AST_SH + 0f					;\
	.SECTION .text.end					;\
0:								;\
/* it may be that interrupt happens after I8259MASK was */	\
/* written but before mask was written to PIC. Write mask now */\
/* to prevent further interrupts from hapenning. */		\
.IF isub(X)<>0							;\
	SHRL	$8 * isub(X), %EAX				;\
.ENDIF								;\
	OUTB	%AL, $iprt(X)					;\
/* Can't IRET here, so act as if this was rt irq */		;\
	PUSHL	%EDX						;\
	CALL	IRQ_SETUP					;\
	MOVW	$0xc766, I8259_PATCH_##X			;\
	.IF	__DEBUG_IRQ					;\
	PUSHL	$X						;\
	PUSHL	$10f						;\
	PUSHL	$kernel_str					;\
	PUSHL	$__SYSLOG_SW_WARNING				;\
	CALL	KERNEL$SYSLOG					;\
	ADDL	$16, %ESP					;\
	.ENDIF							;\
	XORL	%EDX, %EDX					;\
	MOVB	$0x60 + ioff(X), %AL				;\
	OUTB	%AL, $iprt(X) - 1				;\
	.IF	(X) < 8						;\
	JMP	RT_IRQ_END					;\
	.ELSE							;\
	JMP	CASCADE_EOI_RT_IRQ_END				;\
	.ENDIF							;\
	.PREVIOUS						;\
	.IF	__DEBUG_IRQ					;\
	.SECTION .rodata					;\
10:	.STRING	"DISABLED AST IRQ %d"				;\
	.PREVIOUS						;\
	.ENDIF							;\
	.IF	((1 << icnt(X)) | (1 << ibit(X))) >= 0 && ((1 << icnt(X)) | (1 << ibit(X))) < 0x10000						;\
	ORW	$(1 << icnt(X)) | (1 << ibit(X)), %AX		;\
	.ELSE							;\
	ORL	$(1 << icnt(X)) | (1 << ibit(X)), %EAX		;\
	.ENDIF							;\
	MOVL	%EAX, %SS:(%ECX)				;\
.IF isub(X)<>0							;\
	SHRL	$8 * isub(X), %EAX				;\
.ENDIF								;\
	OUTB	%AL, $iprt(X)					;\
	MOVB	$0x60 + ioff(X), %AL				;\
	OUTB	%AL, $iprt(X) - 1				;\
	MOVL	$0, %ECX					;\
I8259_##X##_AST = . - 4 - 1b					;\
	.IF	(X) < 8						;\
	JMP	POST_AST_FROM_IRQ_SEG + IRQ_AST_SH		;\
	.ELSE							;\
	JMP	CASCADE_EOI_AND_POST_AST_FROM_IRQ_SEG + IRQ_AST_SH	;\
	.ENDIF							;\
	.ORG	1b + SIZEOF_IRQ_STUB

#define I8259_RT_IRQ_STUB(X)					;\
1:	PUSHL	%EAX						;\
	PUSHL	%ECX						;\
	PUSHL	%EDX						;\
	CALL	IRQ_SETUP + IRQ_RT_SH				;\
	.IF	63 << icnt(X) >= 0 && 63 << icnt(X) < 0x100	;\
	TESTB	$63 << icnt(X), I8259MASK_1 + iadd(X) - isub(X)	;\
	.ELSE							;\
	.IF	63 << icnt(X) >= 0 && 63 << icnt(X) < 0x10000	;\
	TESTW	$63 << icnt(X), I8259MASK_1 + iadd(X) - isub(X)	;\
	.ELSE							;\
	TESTL	$63 << icnt(X), I8259MASK_1 + iadd(X) - isub(X)	;\
	.ENDIF							;\
	.ENDIF							;\
	JNZ	IRQ_RT_SH + 0f					;\
	.SECTION .text.end					;\
0:								;\
/* it may be that interrupt happens after I8259MASK was */	\
/* written but before mask was written to PIC. Write mask now */\
/* to prevent further interrupts from hapenning. */		\
	MOVB	I8259MASK_1 + iadd(X), %AL			;\
	OUTB	%AL, $iprt(X)					;\
	MOVW	$0xc766, I8259_PATCH_##X			;\
	.IF	__DEBUG_IRQ					;\
	PUSHL	$X						;\
	PUSHL	$10f						;\
	PUSHL	$kernel_str					;\
	PUSHL	$__SYSLOG_SW_WARNING				;\
	CALL	KERNEL$SYSLOG					;\
	ADDL	$16, %ESP					;\
	.ENDIF							;\
	XORL	%EDX, %EDX					;\
	MOVB	$0x60 + ioff(X), %AL				;\
	OUTB	%AL, $iprt(X) - 1				;\
	.IF	(X) < 8						;\
	JMP	RT_IRQ_END					;\
	.ELSE							;\
	JMP	CASCADE_EOI_RT_IRQ_END				;\
	.ENDIF							;\
	.PREVIOUS						;\
	.IF	__DEBUG_IRQ					;\
	.SECTION .rodata					;\
10:	.STRING	"DISABLED RT IRQ %d"				;\
	.PREVIOUS						;\
	.ENDIF							;\
	MOVL	$0, %EAX					;\
I8259_##X##_RT_PTR = . - 4 - 1b					;\
	CALL	IRQ_RT_SH					;\
I8259_##X##_RT_CALL = . - 4 - 1b				;\
	MOVL	%EAX, %EDX					;\
	MOVB	$0x60 + ioff(X), %AL				;\
	OUTB	%AL, $iprt(X) - 1				;\
	.IF	(X) < 8						;\
	JMP	RT_IRQ_END + IRQ_RT_SH				;\
	.ELSE							;\
	JMP	CASCADE_EOI_RT_IRQ_END + IRQ_RT_SH		;\
	.ENDIF							;\
	.ORG	1b + SIZEOF_IRQ_STUB

#define IRQ_AST_SH	(AST_STUB_TEMPLATES - IRQ_STUBS)
#define IRQ_RT_SH	(RT_STUB_TEMPLATES - IRQ_STUBS)

#define I8295_AST_PATCH(X)	.LONG I8259_##X##_AST
#define I8295_RT_PTR_PATCH(X)	.LONG I8259_##X##_RT_PTR
#define I8295_RT_CALL_PATCH(X)	.LONG I8259_##X##_RT_CALL

	.SECTION .text
	.ALIGN	__CPU_CACHELINE_ALIGN
	INTMAP_NO_INT
	.GLOBAL	AST_STUB_TEMPLATES
AST_STUB_TEMPLATES:
	I8259_AST_IRQ_STUB(0)
	I8259_AST_IRQ_STUB(1)
	I8259_AST_IRQ_STUB(3)
	I8259_AST_IRQ_STUB(4)
	I8259_AST_IRQ_STUB(5)
	I8259_AST_IRQ_STUB(6)
	I8259_AST_IRQ_STUB(7)
	I8259_AST_IRQ_STUB(8)
	I8259_AST_IRQ_STUB(9)
	I8259_AST_IRQ_STUB(10)
	I8259_AST_IRQ_STUB(11)
	I8259_AST_IRQ_STUB(12)
	I8259_AST_IRQ_STUB(13)
	I8259_AST_IRQ_STUB(14)
	I8259_AST_IRQ_STUB(15)

	.ALIGN	__CPU_CACHELINE_ALIGN
	.GLOBAL	RT_STUB_TEMPLATES
RT_STUB_TEMPLATES:
	I8259_RT_IRQ_STUB(0)
	I8259_RT_IRQ_STUB(1)
	I8259_RT_IRQ_STUB(3)
	I8259_RT_IRQ_STUB(4)
	I8259_RT_IRQ_STUB(5)
	I8259_RT_IRQ_STUB(6)
	I8259_RT_IRQ_STUB(7)
	I8259_RT_IRQ_STUB(8)
	I8259_RT_IRQ_STUB(9)
	I8259_RT_IRQ_STUB(10)
	I8259_RT_IRQ_STUB(11)
	I8259_RT_IRQ_STUB(12)
	I8259_RT_IRQ_STUB(13)
	I8259_RT_IRQ_STUB(14)
	I8259_RT_IRQ_STUB(15)

	.SECTION .rodata
	.ALIGN	4
	.GLOBAL	AST_PATCHES
AST_PATCHES:
	I8295_AST_PATCH(0)
	I8295_AST_PATCH(1)
	I8295_AST_PATCH(3)
	I8295_AST_PATCH(4)
	I8295_AST_PATCH(5)
	I8295_AST_PATCH(6)
	I8295_AST_PATCH(7)
	I8295_AST_PATCH(8)
	I8295_AST_PATCH(9)
	I8295_AST_PATCH(10)
	I8295_AST_PATCH(11)
	I8295_AST_PATCH(12)
	I8295_AST_PATCH(13)
	I8295_AST_PATCH(14)
	I8295_AST_PATCH(15)

	.ALIGN	4
	.GLOBAL	RT_PTR_PATCHES
RT_PTR_PATCHES:
	I8295_RT_PTR_PATCH(0)
	I8295_RT_PTR_PATCH(1)
	I8295_RT_PTR_PATCH(3)
	I8295_RT_PTR_PATCH(4)
	I8295_RT_PTR_PATCH(5)
	I8295_RT_PTR_PATCH(6)
	I8295_RT_PTR_PATCH(7)
	I8295_RT_PTR_PATCH(8)
	I8295_RT_PTR_PATCH(9)
	I8295_RT_PTR_PATCH(10)
	I8295_RT_PTR_PATCH(11)
	I8295_RT_PTR_PATCH(12)
	I8295_RT_PTR_PATCH(13)
	I8295_RT_PTR_PATCH(14)
	I8295_RT_PTR_PATCH(15)

	.ALIGN	4
	.GLOBAL	RT_CALL_PATCHES
RT_CALL_PATCHES:
	I8295_RT_CALL_PATCH(0)
	I8295_RT_CALL_PATCH(1)
	I8295_RT_CALL_PATCH(3)
	I8295_RT_CALL_PATCH(4)
	I8295_RT_CALL_PATCH(5)
	I8295_RT_CALL_PATCH(6)
	I8295_RT_CALL_PATCH(7)
	I8295_RT_CALL_PATCH(8)
	I8295_RT_CALL_PATCH(9)
	I8295_RT_CALL_PATCH(10)
	I8295_RT_CALL_PATCH(11)
	I8295_RT_CALL_PATCH(12)
	I8295_RT_CALL_PATCH(13)
	I8295_RT_CALL_PATCH(14)
	I8295_RT_CALL_PATCH(15)

	.SECTION .text
	.ALIGN	__CPU_CACHELINE_ALIGN
	INTMAP_NO_CRAWLOUT
I8259_CREATE_DISABLE(0)
I8259_CREATE_DISABLE(1)
I8259_CREATE_DISABLE(3)
I8259_CREATE_DISABLE(4)
I8259_CREATE_DISABLE(5)
I8259_CREATE_DISABLE(6)
I8259_CREATE_DISABLE(7)
I8259_CREATE_DISABLE(8)
I8259_CREATE_DISABLE(9)
I8259_CREATE_DISABLE(10)
I8259_CREATE_DISABLE(11)
I8259_CREATE_DISABLE(12)
I8259_CREATE_DISABLE(13)
I8259_CREATE_DISABLE(14)
I8259_CREATE_DISABLE(15)


	.SECTION .text
	.ALIGN	__CPU_CACHELINE_ALIGN
	INTMAP_NO_INT
	.GLOBAL	IRQ_STUBS
IRQ_STUBS:
	.SPACE	SIZEOF_IRQ_STUB * NO_OF_IRQS

	.SECTION .text
	.ALIGN	__CPU_CACHELINE_ALIGN
	INTMAP_NO_CRAWLOUT
I8259_CREATE_ENABLE(0)
I8259_CREATE_ENABLE(1)
I8259_CREATE_ENABLE(3)
I8259_CREATE_ENABLE(4)
I8259_CREATE_ENABLE(5)
I8259_CREATE_ENABLE(6)
I8259_CREATE_ENABLE(7)
I8259_CREATE_ENABLE(8)
I8259_CREATE_ENABLE(9)
I8259_CREATE_ENABLE(10)
I8259_CREATE_ENABLE(11)
I8259_CREATE_ENABLE(12)
I8259_CREATE_ENABLE(13)
I8259_CREATE_ENABLE(14)
I8259_CREATE_ENABLE(15)
#undef ioff
#undef isub
#undef iadd
#undef ibit
#undef icnt
#undef iprt
#undef idbg
#undef iassert



	.SECTION .text
	.ALIGN	__CPU_CACHELINE_ALIGN
	INTMAP_NO_INT

	.ALIGN	__CPU_BRANCH_ALIGN
CASCADE_EOI_RT_IRQ_END:
	MOVB	$0x62, %AL
	OUTB	%AL, $0x20
RT_IRQ_END:
	MOVL	PROC_RUN, %EAX
	SUBL	PROC_FPU, %EAX
	TESTL	KERNEL$FPU_ENABLED, %EAX
/* it may happen, that SSE in kernel enables FPU and FPU belongs to different
   process.
   Special care must be taken if we return to kernelspace just after FPU switch
   before return to userspace ... better turn it off than on.
   (If it's unexpectedly off in kernel or userspace, nothing serious happens,
   exception 7 will reeable FPU when first touched --- it it's unexpectedly on,
   bad things will happen) */
#ifndef __NO_ASM_PREDICTIONS
	JZ,pt	POST_AST_FROM_IRQ
#else
	JZ	POST_AST_FROM_IRQ
#endif
	CALL	DISABLE_FPU
	JMP	POST_AST_FROM_IRQ

	/* may touch EAX and EDX */
IRQ_SETUP:
	.SECTION .FEATURE_FIXUP
	.LONG	41f, 42f, 42f, 42f, 0, 0, CPU_HAS_TSC, 0
	.PREVIOUS
41:
	RDTSC
	/* if process abuses interrupts (for example using short fragments
	   with sound card), account interrupt time to it, not to the
	   innocent interrupted process */
	SHRDL	$0x1f, %EDX, %EAX
40:
	.SECTION .FINE_TICKS_FIXUP
	.LONG	40b - 1
	.PREVIOUS
	MOVL	%EAX, IRQ_RDTSC
42:
	MOVL	%DS, %EAX
	MOVL	%ES, %EDX
	CMPW	$SEG_KDATA, %AX
	JNE	111f
	CMPW	$SEG_KDATA, %DX
111:	JNE	1f
	MOVL	$(SEG_KDATA << 16) + SEG_KDATA, KERNEL_RT_IRQ_SEG
	.SECTION .text.end
1:	SHLL	$16, %EDX
	ORW	%AX, %DX
	MOVL	$SEG_KDATA, %EAX
	MOVL	%EDX, %SS:KERNEL_RT_IRQ_SEG
	MOVL	%EAX, %DS
	MOVL	%EAX, %ES
	JMP	2f
	.PREVIOUS
2:	TESTB	$EFLAGS_DF >> 8, 25(%ESP)
	JNE	1f
	.SECTION .text.end
1:	CLD
	JMP	2f
	.PREVIOUS
2:	RET

	.ALIGN	__CPU_BRANCH_ALIGN
CASCADE_EOI_AND_POST_AST_FROM_IRQ_SEG:
	MOVB	$0x62, %AL
	OUTB	%AL, $0x20
POST_AST_FROM_IRQ_SEG:
	PUSHL	%EDX
	CALL	IRQ_SETUP
	MOVL	%ECX, %EDX
POST_AST_FROM_IRQ:
	ADDL	$1, INTR_COUNT
	MOVL	12(%ESP), %EAX
	CMPL	$KERNEL_STACK - 20 - 12, %ESP
	JNE	POST_AST_FROM_IRQ_IN_KERNEL

	MOVL	%EBX, KUPLACE(UDATA_EBX)
	MOVL	%EAX, %ECX
	MOVL	%EBP, KUPLACE(UDATA_EBP)
	ANDL	$~(APAGE_RETURN_BLOCK_SIZE - 1), %ECX
	MOVL	%ESI, KUPLACE(UDATA_ESI)
	CMPL	$APLACE(APAGE_RETURN_BLOCK), %ECX
	MOVL	%EDI, KUPLACE(UDATA_EDI)
	MOVL	8(%ESP), %ECX
	MOVL	%ECX, KUPLACE(UDATA_EAX)
	JE	87f
	.SECTION .text.end
	.ALIGN	__CPU_BRANCH_ALIGN
87:	CMPW	$SEG_UCODE, 16(%ESP)
#ifndef __NO_ASM_PREDICTIONS
	JNE,pn	88f
#else
	JNE	88f
#endif
	CMPL	$ABASE, KUPLACE(UDATA_EIP)
	JMP	86f
	.PREVIOUS
88:	CMPL	$0, KUPLACE(UDATA_LDT)
	MOVL	(%ESP), %ECX
	MOVL	%EAX, KUPLACE(UDATA_EIP)
	MOVL	%ECX, KUPLACE(UDATA_EDX)
	JNZ	97f
	.SECTION .text.end
	.ALIGN	__CPU_BRANCH_ALIGN
97:	MOVL	KERNEL_RT_IRQ_SEG, %ECX
	MOVW	%FS, KUPLACE(UDATA_FS)
	MOVL	%ECX, KUPLACE(UDATA_DS)
	MOVZWL	16(%ESP), %ECX
	MOVW	%GS, KUPLACE(UDATA_GS)
	MOVL	%ECX, KUPLACE(UDATA_CS)
	MOVZWL	28(%ESP), %ECX
	MOVL	%ECX, KUPLACE(UDATA_SS)
	JMP	96f
	.PREVIOUS
96:	CMPL	$ABASE, %EAX
	MOVL	4(%ESP), %EAX
	MOVL	20(%ESP), %ECX
	MOVL	%EAX, KUPLACE(UDATA_ECX)
	MOVL	24(%ESP), %EAX
	MOVL	%ECX, KUPLACE(UDATA_EFLAGS)
	MOVL	%EAX, KUPLACE(UDATA_ESP)
86:	JAE	27f
	.SECTION .text.end
	.ALIGN	__CPU_BRANCH_ALIGN
27:	CALL	FIXUP_APAGE
	JMP	26f
	.PREVIOUS
26:	MOVL	%EDX, %EAX
	MOVL	$0xFFFFFFFF, %ESI
	TESTL	%EDX, %EDX
	JZ	28f
	MOVL	(%EDX), %EDX
	SUBL	$32, %EDX
	CALL	*%EDX
	INTMAP_NO_CRAWLOUT
	JMP	IDLE_LOOP
28:	STI
	JMP	IDLE_LOOP

	INTMAP_NO_INT
	.ALIGN	__CPU_BRANCH_ALIGN
POST_AST_FROM_IRQ_IN_KERNEL:
	CMPL	$RETURN_TO_KERNEL, %EAX
	JE	3f
4:	TESTL	%EDX, %EDX
	JZ	END_OF_IRQ
	ANDL	$~(KERNEL_CRAWLOUT_SPACE_ALIGN - 1), %EAX
	PUSHL	%ESI
	CMPL	$KERNEL_CRAWLOUT_SPACE, %EAX
	MOVL	%EDX, %EAX
	JE	CRAWLOUT_KERNEL
	MOVL	(%EAX), %EDX
	SUBL	$32, %EDX
	MOVL	KERNEL$SPL, %ESI
	CALL	*%EDX
	INTMAP_POP(5)	/* do not allow interrupts to happen recursively and eat stack indefinitely */
	CLI
	INTMAP_NO_INT
RETURN_AFTER_PATCH:
	POPL	%ESI

END_OF_IRQ:
	POPL	%EDX
	POPL	%ECX
END_OF_IRQ_EAX:
	MOVL	4(%ESP), %EAX
	CMPL	$RETURN_TO_KERNEL, %EAX
	JE	2f
	MOVL	%EAX, IRQ_RETURN_ADDR
2:	POPL	%EAX
	ADDL	$8, %ESP
	POPFL
	INTMAP_NO_CRAWLOUT
RETURN_TO_KERNEL:
	JMP	*IRQ_RETURN_ADDR		/* IRET SUCKS */
	INTMAP_NO_INT

	.ALIGN	__CPU_BRANCH_ALIGN
3:	MOVL	IRQ_RETURN_ADDR, %EAX
	MOVL	%EAX, 12(%ESP)
	JMP	4b

	/* MAY USE ALL REGISTERS EXCEPT %EDX */
	INTMAP_NO_INT
	.ALIGN	__CPU_CALL_ALIGN
FIXUP_APAGE:
	CMPW	$SEG_UCODE, KUPLACE(UDATA_CS)
	MOVL	KUPLACE(UDATA_EIP), %EAX
	JNE	a1
	CMPL	$APLACE(APAGE_START_FIXUP), %EAX
	JB	a1
	CMPL	$APLACE(APAGE_END_FIXUP), %EAX
	JAE	a1
	JMP	*FIXUP_APAGE_TABLE - APLACE(APAGE_START_FIXUP) * 4(, %EAX, 4)

a3:	MOVL	KUPLACE(UDATA_ESP), %ECX
	CMPL	$VM_KERNEL_COPY_OF_LAST_BANK << (PG_BANK_BITS + PG_SIZE_BITS), %ECX
	JAE	2f
	CMPL	$KUVMTOP, %ECX
	JAE	a2
2:	FAULTMAP_ENTRY_NOTEST(a2)
	MOVL	(%ECX), %ECX
	MOVL	%ECX, KUPLACE(UDATA_ECX)
a2:	ADDL	$4, KUPLACE(UDATA_ESP)
	MOVL	$APLACE(APAGE_QUEUE_AST), KUPLACE(UDATA_EIP)
a1:	RET
a4:	MOVL	KUPLACE(UDATA_EAX), %EAX
	MOVL	KUPLACE(UDATA_EDX), %ECX
	CMPL	$VM_KERNEL_COPY_OF_LAST_BANK << (PG_BANK_BITS + PG_SIZE_BITS), %ECX
	JAE	5f
	CMPL	$KUVMTOP, %ECX
	JAE	a5
5:	FAULTMAP_ENTRY_NOTEST(a5)
	MOVL	%EAX, (%ECX)
a5:	MOVL	KUPLACE(UDATA_ESP), %ECX
	ADDL	$4, KUPLACE(UDATA_ESP)
	CMPL	$VM_KERNEL_COPY_OF_LAST_BANK << (PG_BANK_BITS + PG_SIZE_BITS), %ECX
	JAE	6f
	CMPL	$KUVMTOP, %ECX
	JAE	a6
6:	FAULTMAP_ENTRY_NOTEST(a6)
	MOVL	(%ECX), %ECX
	MOVL	%ECX, KUPLACE(UDATA_ECX)
a6:	MOVL	KUPLACE(UDATA_ECX), %ECX
	ORL	%ECX, KUPLACE(UDATA_PPL)
a7:	MOVL	$APLACE(APAGE_PROCESS_PENDING_AST), KUPLACE(UDATA_EIP)
	RET
a8:	MOVL	KUPLACE(UDATA_ECX), %ECX
	CMPL	KUPLACE(UDATA_EDX), %ECX
	JNZ	a12
a9:	MOVL	KUPLACE(UDATA_ECX), %ECX
	CMPL	$VM_KERNEL_COPY_OF_LAST_BANK << (PG_BANK_BITS + PG_SIZE_BITS), %ECX
	JAE	10f
	CMPL	$KUVMTOP, %ECX
	JAE	a10
10:	FAULTMAP_ENTRY_NOTEST(a10)
	MOVL	%ECX, (%ECX)
a10:	MOVL	KUPLACE(UDATA_ECX), %ECX
	SHRL	$3, %ECX
	MOVL	%ECX, KUPLACE(UDATA_ECX)
a11:	MOVL	KUPLACE(UDATA_ECX), %ECX
	MOVL	KUPLACE(UDATA_PPL), %EAX
	BTRL	%ECX, %EAX
	MOVL	%EAX, KUPLACE(UDATA_PPL)
a12:	MOVL	$0xFFFFFFFE, %EAX
	MOVL	KUPLACE(UDATA_ECX), %ECX
	SHLL	%CL, %EAX
	MOVL	%EAX, KUPLACE(UDATA_SPL)
	MOVL	$APLACE(APAGE_JMP_EAX), KUPLACE(UDATA_EIP)
	RET
a13:	MOVL	KUPLACE(UDATA_ECX), %ECX
	SHRL	$3, %ECX
	MOVL	%ECX, KUPLACE(UDATA_ECX)
	JMP	a12
a15:	MOVL	KUPLACE(UDATA_EBX), %EAX
	MOVL	KUPLACE(UDATA_ECX), %ECX
	MOVL	%EAX, KUPLACE(UDATA_ECX)
	MOVL	%ECX, KUPLACE(UDATA_EBX)
a14:	MOVL	$APLACE(APAGE_SYSCALL), KUPLACE(UDATA_EIP)
	RET
a16:	MOVL	$APLACE(APAGE_SET_8), KUPLACE(UDATA_EIP)
	RET
a17:	MOVL	KUPLACE(UDATA_EAX), %EAX
	MOVL	KUPLACE(UDATA_ECX), %ECX
	CMPL	$VM_KERNEL_COPY_OF_LAST_BANK << (PG_BANK_BITS + PG_SIZE_BITS), %ECX
	JAE	18f
	CMPL	$KUVMTOP, %ECX
	JAE	19f
18:	FAULTMAP_ENTRY_NOTEST(19f)
	MOVL	%EAX, (%ECX)
19:	RET
a18:	MOVL	$APLACE(APAGE_POP_RET_SEG), KUPLACE(UDATA_EIP)
	RET
a19:	MOVL	$APLACE(APAGE_GET_TIME_OF_DAY) + 2, KUPLACE(UDATA_EIP)
	RET
a20:	MOVL	$APLACE(APAGE_GET_TIME_SEC), KUPLACE(UDATA_EIP)
	RET
aa40:	ADDL	$4, KUPLACE(UDATA_ESP)
aa36:	ADDL	$4, KUPLACE(UDATA_ESP)
aa32:	ADDL	$4, KUPLACE(UDATA_ESP)
aa28:	ADDL	$4, KUPLACE(UDATA_ESP)
aa24:	ADDL	$4, KUPLACE(UDATA_ESP)
aa20:	ADDL	$4, KUPLACE(UDATA_ESP)
aa16:	ADDL	$4, KUPLACE(UDATA_ESP)
aa12:	ADDL	$4, KUPLACE(UDATA_ESP)
aa8:	ADDL	$2, KUPLACE(UDATA_ESP)
aa6:	ADDL	$2, KUPLACE(UDATA_ESP)
aa4:	ADDL	$2, KUPLACE(UDATA_ESP)
aa2:	ADDL	$2, KUPLACE(UDATA_ESP)
	MOVL	$APLACE(APAGE_CHECK_ASTS), KUPLACE(UDATA_EIP)
	RET

a0:
	pushal
	pushl	%eax
	pushl	$1f
	call	__critical_printf
	addl	$8, %esp
	popal
	.section .rodata
1:	.string	"INVALID ADDRESS %08X"
	.previous		/* !!! FIXME: disable, just test */
	JMP	a1


	.SECTION .rodata
	.ALIGN	4
FIXUP_APAGE_TABLE:
	.LONG	a1,  a2, a0,  a3, a0, a0,  a3, a0, a0,  a4, a0,  a5,  a6, a0, a0, a0, a0, a0

	.LONG	a1, a0, a0, a0, a0,  a7, a0,  a7, a0,  a7, a0, a0, a0, a0, a0,  a1

	.LONG	a7, a0, a0,  a7, a0, a0, a0, a0, a0, a0,  a7, a0, a0
	.LONG   a7, a0, a0,  a7, a0, a0,  a8, a0,  a8, a0,  a9, a0,  a10, a0, a0
	.LONG	a11, a0, a0, a0, a0, a0,  a11, a0, a0,  a11, a0, a0, a0, a0, a0
	.LONG	a12, a0, a13, a0, a0,  a12, a0, a0,  a12, a0,  a12, a0, a0, a0, a0, a0
	.LONG	a1, a0
	.LONG	a0

	.SECTION .FEATURE_FIXUP
	.LONG	41f, 42f, 43f, 44f, CPU_HAS_SYSENTER, 0, 0, 0
	.LONG	41f, 42f, 45f, 46f, CPU_HAS_AMD_SYSCALL, 0, 0, 0
	.PREVIOUS
41:
	.LONG	a1, a0,  a0, a0, a0, a0, a0, a0, a0, a0
42:
	.LONG	a1, a1, a1, a1, a1, a1
	.LONG	a1, a0, a0,  a16, a0, a0,  a17, a0,  a1,  a0, a0, a0, a0, a0, a0, a0

	.LONG	a1, a0, a0, aa2, a0, a0, aa4, a0
	.LONG	aa6, a0, aa8, aa12, aa8, aa12, aa8, a0
	.LONG	a0, a0, a0, a0, aa12, a0, a0, a0
	.LONG	a0, a0, aa16, a0, a0, a0, a0, a0
	.LONG	aa20, aa24, aa28, aa32, aa36, a0, a0, a0
	.LONG	a0, a0, aa40, a0, a0, a0, a0, a0

	.LONG	a1, a0, a0, a0, a0, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18
	.LONG	a18, a18, a18, a18, a18, a18, a18, a18

	.LONG	a1, a0, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19
	.LONG	a19, a19, a19, a19, a19, a19, a19, a19

	.LONG	a20, a20, a20, a20, a20, a20, a20, a20
	.LONG	a20, a20, a20, a20, a20, a20, a20, a20

FIXUP_APAGE_END:
43:
	.LONG	a1, a0, a0, a0, a0, a0,  a14, a0,  a0, a0
44:
45:
	.LONG	a1, a0, a0, a0, a0, a0,  a14, a0,  a15, a0
46:

.IF (FIXUP_APAGE_END - FIXUP_APAGE_TABLE) / 4 <> APAGE_END_FIXUP - APAGE_START_FIXUP
	.LONG	bad_apage_fixup_table_size
.ENDIF


/*1:	.string	":%08x "
p:	pushal
	pushl	%eax
	pushl	$1b
	call	__critical_printf
	addl	$8, %esp
	popal
	ret*/


			/************
			 * CRAWLOUT *
			 ************/

	.SECTION .data
	.ALIGN	4
CRAWLOUT_RETURN:
	.LONG	0

CRAWLOUT_QUEUE:
	.LONG	0

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_NO_INT
CRAWLOUT_KERNEL:
	MOVL	CRAWLOUT_QUEUE, %EDX
	MOVL	%EAX, CRAWLOUT_QUEUE
	MOVL	%EDX, 4(%EAX)
	TESTL	%EDX, %EDX
	JNZ	7f
	LEAL	16(%ESP), %ESI

	/*
	movl	(%esi), %eax
	andl	$0xffffff80, %eax
	cmpl	$0xc1521280, %eax
	je	45f
	pushl	(%esi)
	pushl	$44f
	call	__critical_printf
	addl	$8, %esp
	.section .rodata
44:	.string	"[%08x]"
	.previous
45:*/

	LEAL	24(%ESP), %EDX
4:	MOVL	(%ESI), %ECX
	CMPL	$KERNEL_CRAWLOUT_SPACE, %ECX
	JB	1f
	CMPL	$KERNEL_CRAWLOUT_SPACE + KERNEL_CRAWLOUT_SPACE_ALIGN, %ECX
	JAE	1f
	MOVSBL	INTERRUPT_MAP - KERNEL_CRAWLOUT_SPACE(%ECX), %EAX
	CMPL	$1, %EAX
	JB	2f
	JE	1f
	JG	3f
	SUBL	%EAX, %EDX
	MOVL	%EDX, %ESI
	JMP	4b
	.ALIGN	__CPU_BRANCH_ALIGN
1:	MOVL	%ECX, CRAWLOUT_RETURN
	MOVL	$PROCESS_DEFERED_AST, (%ESI)
7:	JMP	RETURN_AFTER_PATCH
	.ALIGN	__CPU_BRANCH_ALIGN
3:	MOVL	JMPTBL(, %EAX, 4), %EAX
	CMPL	$KERNEL_CRAWLOUT_SPACE_ALIGN, %EAX
	JGE	8f
	CMPL	$-KERNEL_CRAWLOUT_SPACE_ALIGN, %EAX
	JLE	8f
	ADDL	%ECX, %EAX
8:	MOVL	%EAX, (%ESI)
	JMP	RETURN_AFTER_PATCH
2:	PUSHL	16(%ESP)
	PUSHL	%ECX
	PUSHL	$5f
	CALL	KERNEL$SUICIDE
	NOP
	.SECTION .rodata
5:	.STRING	"CRAWLOUT FROM UNEXPECTED ADDRESS %08X (EIP = %08X)"
	.PREVIOUS

	.ALIGN	__CPU_CALL_ALIGN
PROCESS_DEFERED_AST:
	PUSHL	CRAWLOUT_RETURN
	PUSHFL
	PUSHL	%EAX
	PUSHL	%ECX
	PUSHL	%EDX
	PUSHL	%ESI
	PUSHL	%EBX
	PUSHL	KERNEL$SPL
	MOVL	$0x80000000, %ESI
	CLI
	MOVL	CRAWLOUT_QUEUE, %EAX
1:	MOVL	(%EAX), %EDX
	MOVL	4(%EAX), %EBX
	CALL	*%EDX
	MOVL	%EBX, %EAX
	TESTL	%EBX, %EBX
	JNZ	1b
	MOVL	%EAX, CRAWLOUT_QUEUE
	STI
	INTMAP_NO_CRAWLOUT
	POPL	%ESI
	POPL	%EBX
	CALL	KERNEL$PROCESS_PENDING_AST
	INTMAP_POP(6)	/* do not allow interrupts to happen recursively and eat stack indefinitely */
	POPL	%ESI
	INTMAP_POP(5)
	POPL	%EDX
	INTMAP_POP(4)
	POPL	%ECX
	INTMAP_POP(3)
	POPL	%EAX
	INTMAP_POP(2)
	POPFL
	INTMAP_POP(1)
	RET

			/*************
			 * INT STATE *
			 *************/

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_NO_CRAWLOUT
	.GLOBAL	KERNEL$DI
KERNEL$DI:
	CLI
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$EI
KERNEL$EI:
	STI
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$SAVE_INT_STATE
KERNEL$SAVE_INT_STATE:
	PUSHFL
	POPL	%EAX
	SHRL	$P_EFLAGS_IF, %EAX
	ANDL	$1, %EAX
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$RESTORE_INT_STATE
KERNEL$RESTORE_INT_STATE:
	PUSHFL
	ANDL	$1, %EAX
	ANDL	$~EFLAGS_IF, (%ESP)
	SHLL	$P_EFLAGS_IF, %EAX
	ORL	%EAX, (%ESP)
	POPFL
	RET

			/*******
			 * MSR *
			 *******/

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_NO_CRAWLOUT
	.GLOBAL	KERNEL$READ_MSR
KERNEL$READ_MSR:
	TESTL	$CPU_HAS_MSR, KERNEL$CPU_FEATURES
	JZ	2f
	MOVL	%EAX, %ECX
	PUSHL	%EDX
	FAULTMAP_ENTRY_NOTEST(1f)
	RDMSR
	POPL	%ECX
	MOVL	%EAX, (%ECX)
	MOVL	%EDX, 4(%ECX)
	XORL	%EAX, %EAX
	RET
1:	ADDL	$4, %ESP
	MOVL	$-ENXIO, %EAX
	RET
2:	MOVL	$-EOPNOTSUPP, %EAX
	RET

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_NO_CRAWLOUT
	.GLOBAL	KERNEL$WRITE_MSR
KERNEL$WRITE_MSR:
	TESTL	$CPU_HAS_MSR, KERNEL$CPU_FEATURES
	JZ	2f
	XCHGL	%EAX, %ECX
	XCHGL	%EAX, %EDX
	FAULTMAP_ENTRY_NOTEST(1f)
	WRMSR
	XORL	%EAX, %EAX
	RET
1:	MOVL	$-ENXIO, %EAX
	RET
2:	MOVL	$-EOPNOTSUPP, %EAX
	RET


			/**********
			 * ACALLS *
			 **********/

	.SECTION .data
	.ALIGN	__CPU_CACHELINE_ALIGN
	.GLOBAL	I8259MASK_1
	.BYTE	0, 0, 0, 0	/* unalignes accesses are used for these two --- must not cross cache line or performance would be seriously degraded */
I8259MASK_1:
	.BYTE	0, 0, 0, 0
	.GLOBAL	I8259MASK_2
	.BYTE	0, 0, 0, 0
I8259MASK_2:
	.BYTE	0, 0, 0, 0
	/* must be valid: I8259MASK_2 - I8259MASK_1 == I8259MASK_NEXT (assembler can't do this arithmetic) */
	.GLOBAL	KERNEL$SPL
	.ALIGN	4
KERNEL$SPL:
	.LONG	0xFFFFFFFC
	.GLOBAL	KERNEL$PPL
	.ALIGN	4
KERNEL$PPL:
	.LONG	0
	.GLOBAL	KERNEL$LIST_END
	.ALIGN	4
KERNEL$LIST_END:
	.LONG	0
	.LONG	0
	.GLOBAL	IRQ_RDTSC
	.ALIGN	4
IRQ_RDTSC:
	.LONG	0
	.GLOBAL	KERNEL_HOLD_JIFFIES
	.ALIGN	4
KERNEL_HOLD_JIFFIES:
	.LONG	0
	.GLOBAL	KERNEL$LOCKUP_LEVEL
KERNEL$LOCKUP_LEVEL:
	.BYTE	0
	.GLOBAL	INTR_COUNT
	.ALIGN	4
INTR_COUNT:
	.LONG	0
IRQ_RETURN_ADDR:	/* IRQ_RETURN_ADDR REALLY DOES NOT BELONG HERE,
			   BUT I WANT IT TO BE IN THE SAME CACHELINE
			   AS SPL AND PPL */
	.LONG	0
KERNEL_RT_IRQ_SEG:
	.LONG	0
	.GLOBAL	CR_0
CR_0:	.LONG	0
	.GLOBAL	CR_4
CR_4:	.LONG	0

	.GLOBAL	KERNEL$AST_QUEUES
	.ALIGN	256	/* must be aligned on 256-byte boundary */
KERNEL$AST_QUEUES:
	.REPT	32
	.LONG	.
	.LONG	. - 4
	.ENDR

	.GLOBAL	KERNEL$BPL
	.ALIGN	4
KERNEL$BPL:
	.LONG	0xFFFFFFFF

	.SECTION .text
	.ALIGN	__CPU_MAX_ALIGN
	INTMAP_NO_INT
	.GLOBAL	KERNEL$QUEUE_IRQ_AST
KERNEL$QUEUE_IRQ_AST:
	ORL	%ECX, KERNEL$PPL
	MOVL	(%EDX), %ECX
	MOVL	%EDX, 4(%EAX)
	MOVL	%EAX, (%EDX)
	MOVL	%EAX, 4(%ECX)
	ADDL	$4, %ESP
	JMP	RETURN_AFTER_PATCH

/*
 * IN: %EAX - AST, %EDX - PTR TO KERNEL$AST_QUEUES, %ECX - OR BITMASK FOR PPL
 * THE CODE IS SHADOWED BELOW
 */
	.ALIGN	__CPU_MAX_ALIGN
	.GLOBAL	KERNEL$QUEUE_AST
	INTMAP_JMP(QUEUE_AST_SHADOW)
KERNEL$QUEUE_AST:
	ORL	%ECX, KERNEL$PPL
	MOVL	(%EDX), %ECX
	MOVL	%EDX, 4(%EAX)
	MOVL	%EAX, (%EDX)
	MOVL	%EAX, 4(%ECX)

	/* FALL THROUGH */

/*
 * IN: %ESI - ASTS BELOW OR AT THIS LEVEL SHOULD NOT BE PROCESSED
 * MUST PRESERVE ESI
 * CH: %EAX, %ECX, %EDX
 */
	.ALIGN	__CPU_BRANCH_ALIGN
	.GLOBAL	KERNEL$PROCESS_PENDING_AST
KERNEL$PROCESS_PENDING_AST:
	MOVL	KERNEL$PPL, %EAX
	TESTL	%EAX, %ESI
	JNZ	1f
	INTMAP_POP(1)
	MOVL	%ESI, KERNEL$SPL
	RET
	.ALIGN	__CPU_BRANCH_ALIGN
	INTMAP_JMP(QUEUE_AST_SHADOW_2)
1:	BSRL	%EAX, %ECX
	MOVL	$0xFFFFFFFE, %EDX
	SHLL	%CL, %EDX
	LEAL	KERNEL$AST_QUEUES(, %ECX, 8), %ECX
	MOVL	4(%ECX), %EAX
	MOVL	%EDX, KERNEL$SPL
	MOVL	4(%EAX), %EDX
	MOVL	%EDX, 4(%ECX)
	CMPL	%EDX, %ECX
	JNZ	2f
	MOVL	%ECX, (%ECX)
	SHRL	$3, %ECX
	MOVL	KERNEL$PPL, %EDX
	BTRL	%ECX, %EDX
	MOVL	%EDX, KERNEL$PPL
	.ALIGN	__CPU_BRANCH_ALIGN
2:	JMP	*(%EAX)

	/* INTMAP SHADOW */
	INTMAP_NO_INT
	.ALIGN	__CPU_MAX_ALIGN
QUEUE_AST_SHADOW:
	ORL	%ECX, KERNEL$PPL
	MOVL	(%EDX), %ECX
	MOVL	%EDX, 4(%EAX)
	MOVL	%EAX, (%EDX)
	MOVL	%EAX, 4(%ECX)

	/* FALL THROUGH */

/*
 * IN: %ESI - ASTS BELOW OR AT THIS LEVEL SHOULD NOT BE PROCESSED
 * MUST PRESERVE ESI
 * CH: %EAX, %ECX, %EDX
 */
	.ALIGN	__CPU_BRANCH_ALIGN
	MOVL	KERNEL$PPL, %EAX
	TESTL	%EAX, %ESI
	JNZ	1f
	JMP	4f
	NOP
	NOP
	NOP
	NOP
	NOP
	.ALIGN	__CPU_BRANCH_ALIGN
QUEUE_AST_SHADOW_2:
1:	BSRL	%EAX, %ECX
	MOVL	$0xFFFFFFFE, %EDX
	SHLL	%CL, %EDX
	LEAL	KERNEL$AST_QUEUES(, %ECX, 8), %ECX
	MOVL	4(%ECX), %EAX
	MOVL	%EDX, KERNEL$SPL
	MOVL	4(%EAX), %EDX
	MOVL	%EDX, 4(%ECX)
	CMPL	%EDX, %ECX
	JNZ	2f
	MOVL	%ECX, (%ECX)
	SHRL	$3, %ECX
	MOVL	KERNEL$PPL, %EDX
	BTRL	%ECX, %EDX
	MOVL	%EDX, KERNEL$PPL
	.ALIGN	__CPU_BRANCH_ALIGN
2:	MOVL	(%EAX), %EDX
	MOVL	%EDX, CRAWLOUT_RETURN
	JMP	PROCESS_DEFERED_AST
4:	MOVL	%ESI, KERNEL$SPL
	POPL	CRAWLOUT_RETURN
	JMP	PROCESS_DEFERED_AST



			/***************
			 * WAIT QUEUES *
			 ***************/

	.SECTION .text

/*
 * IN: %EAX - PTR TO MTX
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	KERNEL$MTX_LOCK_TEST
KERNEL$MTX_LOCK_TEST:
	MOVL	(%EAX), %EDX
	TESTL	%EDX, %EDX
	JNZ	1f
	MOVL	$1, (%EAX)
	XORL	%EAX, %EAX
1:	RET

/*
 * IN: %EAX - PTR TO MTX
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	KERNEL$MTX_UNLOCK_TEST
KERNEL$MTX_UNLOCK_TEST:
#if __DEBUG >= 1
	CMPL	$0, (%EAX)
	JZ	2f
#endif
	LEAL	4(%EAX), %EDX
	CMPL	%EDX, 4(%EAX)
	JNE	1f
	MOVL	$0, (%EAX)
	XORL	%EAX, %EAX
1:	RET
#if __DEBUG >= 1
2:	PUSHL	$7f
	CALL	KERNEL$SUICIDE
	NOP
	.SECTION .rodata
7:	.STRING	"KERNEL$MTX_UNLOCK_TEST: MUTEX NOT LOCKED"
	.PREVIOUS
#endif

			/**********
			 * TIMERS *
			 **********/

	.SECTION .text

/*
 * IN: %EDX:%EAX - TIME FROM CURRENT
 *     %ECX - PTR TO STRUCT TIMER
 * CH: %EAX, %EDX
 */

	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	KERNEL$SET_TIMER
KERNEL$SET_TIMER:
#if __DEBUG >= 1
	CMPL	$0, (%ECX)
	JNZ	6f
	CMPL	$0, OFF_TIMER_fn(%ECX)
	JZ	61f
#endif
	TESTL	%EDX, %EDX
	JNZ	1f
	CMPL	$0x80000000, %EAX
st_dword_fix_lshift:
	JAE	2f
	ADDL	__JIFFIES, %EAX
	ADDL	$0x80000000, %EAX
st_dword_fix_1:
2000:
5:	SHRL	$0, %EAX
st_byte_fix_1:
	ANDL	$SMALL_WHEEL_SIZE - 1, %EAX
	LEAL	SMALL_WHEEL(, %EAX, 8), %EDX
	MOVL	SMALL_WHEEL(, %EAX, 8), %EAX
3:	MOVL	%ECX, (%EDX)
	MOVL	%EAX, (%ECX)
	MOVL	%EDX, 4(%ECX)
	MOVL	%ECX, 4(%EAX)
	RET
	.ALIGN	__CPU_BRANCH_ALIGN
1:	JS	4f
	.ALIGN	__CPU_BRANCH_ALIGN
2:	ADDL	__JIFFIES, %EAX
	JC	50f
60:	ADDL	__JIFFIES + 4, %EDX
	ADDL	$0x80000000, %EAX
st_dword_fix_2:
	JC	51f
61:	ANDL	$0x80000000, %EAX
st_dword_fix_not:
	MOVL	%EAX, OFF_TIMER___time_lo(%ECX)
	MOVL	%EDX, OFF_TIMER___time_hi(%ECX)
	SHRL	$SMALL_WHEEL_BITS - 3, %EAX
st_byte_fix_2:
	ANDL	$(BIG_WHEEL_SIZE - 1) * 8, %EAX
	LEAL	BIG_WHEEL(%EAX), %EDX
	MOVL	BIG_WHEEL(%EAX), %EAX
	JMP	3b
	.ALIGN	__CPU_BRANCH_ALIGN
4:	MOVL	__JIFFIES, %EAX
	JMP	5b
50:	INCL	%EDX
	JMP	60b
51:	INCL	%EDX
	JMP	61b

#if __DEBUG >= 1
6:	PUSHL	%EDX
	PUSHL	%EAX
	PUSHL	%ECX
	PUSHL	$7f
	CALL	KERNEL$SUICIDE
	.SECTION .rodata
7:	.STRING	"KERNEL$SET_TIMER: ADDING ACTIVE TIMER %p:%LX"
	.PREVIOUS
61:	PUSHL	%EDX
	PUSHL	%EAX
	PUSHL	%ECX
	PUSHL	$71f
	CALL	KERNEL$SUICIDE
	NOP
	.SECTION .rodata
71:	.STRING	"KERNEL$SET_TIMER: ADDING TIMER %p:%LX WITH ZERO FUNCTION"
	.PREVIOUS
#endif

	.SECTION .text.end
	.GLOBAL	TIMER_FIXUP
/*
 * IN: %EAX JIFFIES STEP
 * FIX UP TIMER ACCORDING TO KERNEL$JIFFIES_STEP
 */
	.GLOBAL	FIXUP_TIMER_ASM
FIXUP_TIMER_ASM:
	BSFL	%EAX, %ECX
	MOVL	%EAX, KERNEL$JIFFIES_STEP
	DECL	%EAX
	MOVB	%CL, KERNEL$JIFFIES_STEP_BITS
	MOVL	%EAX, st_dword_fix_1 - 4
	MOVL	%EAX, st_dword_fix_2 - 4
	MOVL	$SMALL_WHEEL_SIZE, %EDX
	SHLL	%CL, %EDX
	SUBL	%EAX, %EDX
	MOVL	%EDX, st_dword_fix_lshift - 4
	NOTL	%EAX
	MOVL	%EAX, st_dword_fix_not - 4
	ADDB	%CL, st_byte_fix_1 - 1
	ADDB	%CL, st_byte_fix_2 - 1
	RET

 	.SECTION .text

/*
 * IN: %EAX - PTR TO STRUCT TIMER
 * CH: %ECX, %EDX
 */

	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	KERNEL$DEL_TIMER
KERNEL$DEL_TIMER:
	MOVL	(%EAX), %ECX
#if __DEBUG >= 1
	TESTL	%ECX, %ECX
	JZ	1f
#endif
	MOVL	4(%EAX), %EDX
	MOVL	%EDX, 4(%ECX)
	MOVL	%ECX, (%EDX)
	MOVL	$0, (%EAX)	/* WARNING: DO NOT MOVE THIS UP, THE LIST MIGHT BE EMPTY */
	RET

#if __DEBUG >= 1
1:	PUSHL	%EAX
	PUSHL	$2f
	CALL	KERNEL$SUICIDE
	NOP
	.SECTION .rodata
2:	.STRING	"KERNEL$DEL_TIMER: DELETING INACTIVE TIMER %p"
	.PREVIOUS
#endif

/*
 * KERNEL$GET_JIFFIES:	  OUT: %EDX:%EAX - JIFFIES
 * KERNEL$GET_JIFFIES_LO: OUT: %EAX - JIFFIES_LO
 */

	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	KERNEL$GET_JIFFIES
	.GLOBAL	KERNEL$GET_JIFFIES_LO
KERNEL$GET_JIFFIES:
	MOVL	__JIFFIES + 4, %EDX
KERNEL$GET_JIFFIES_LO:
	MOVL	__JIFFIES, %EAX
	RET

			/***********
			 * UACCESS *
			 ***********/

/*
 * _UREAD8:
 * IN: %EAX - PROC
 *     %EDX - ADDRESS
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 *	%EDX - VAL
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UREAD8
_UREAD8:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	6f
5:	FAULTMAP_ENTRY(4f)
	MOVZBL	(%EDX), %EDX
	XORL	%EAX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
6:	CMPL	$KERNEL$PROC_KERNEL, %EAX
	JE	5b
4:	MOVL	$1, %EAX
	RET


/*
 * _UWRITE8:
 * IN: %EAX - PROC
 *     %EDX - ADDRESS
 *     %CL - VAL
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UWRITE8
_UWRITE8:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	6f
5:	FAULTMAP_ENTRY(4f)
	MOVB	%CL, (%EDX)
	XORL	%EAX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
6:	CMPL	$KERNEL$PROC_KERNEL, %EAX
	JE	5b
4:	MOVL	$1, %EAX
	RET


/*
 * _UREAD32:
 * IN: %EAX - PROC
 *     %EDX - ADDRESS
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 *	%EDX - VAL
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UREAD32
_UREAD32:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	6f
5:	FAULTMAP_ENTRY(4f)
	MOVL	(%EDX), %EDX
	XORL	%EAX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
6:	CMPL	$KERNEL$PROC_KERNEL, %EAX
	JE	5b
4:	MOVL	$1, %EAX
	RET


/*
 * _UWRITE32:
 * IN: %EAX - PROC
 *     %EDX - ADDRESS
 *     %ECX - VAL
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UWRITE32
_UWRITE32:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	6f
5:	FAULTMAP_ENTRY(4f)
	MOVL	%ECX, (%EDX)
	XORL	%EAX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
6:	CMPL	$KERNEL$PROC_KERNEL, %EAX
	JE	5b
4:	MOVL	$1, %EAX
	RET


/*
 * _UREAD64:
 * IN: %EAX - PROC
 *     %EDX - ADDRESS
 *     %ECX - PTR TO DATA
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UREAD64
_UREAD64:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	6f
5:	FAULTMAP_ENTRY(4f)
	MOVL	(%EDX), %EAX
	MOVL	%EAX, (%ECX)
	FAULTMAP_ENTRY(4f)
	MOVL	4(%EDX), %EAX
	MOVL	%EAX, 4(%ECX)
	XORL	%EAX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
6:	CMPL	$KERNEL$PROC_KERNEL, %EAX
	JE	5b
4:	MOVL	$1, %EAX
	RET


/*
 * _UWRITE64:
 * IN: %EAX - PROC
 *     %EDX - ADDRESS
 *     %ECX - PTR TO DATA
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 */
	/* not needed anywhere */
#if 0
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UWRITE64
_UWRITE64:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	6f
5:	FAULTMAP_ENTRY(4f)
	MOVL	4(%EDX), %EAX	/* make sure that area is accessible */
	FAULTMAP_ENTRY(4f)
	MOVL	%EAX, 4(%EDX)	/* !!! SMPFIX: use CMPXCHG8B when porting to SMP */
	MOVL	(%ECX), %EAX
	FAULTMAP_ENTRY(4f)
	MOVL	%EAX, (%EDX)
	MOVL	4(%ECX), %EAX
	MOVL	%EAX, 4(%EDX)
	XORL	%EAX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
6:	CMPL	$KERNEL$PROC_KERNEL, %EAX
	JE	5b
4:	MOVL	$1, %EAX
	RET
#endif



			/*************
			 * UREAD_STR *
			 *************/

/*
 * _UREAD_STR:
 * IN: %EBX - PROC
 *     %ESI - ADDRESS IN PROC
 *     %ECX - LAST ACCEPTABLE ADDRESS IN PROC
 *     %EDI - WHERE TO PUT RESULT (MAX UREAD_STR_MAXLEN BYTES)
 *     %DL - END SEPARATOR
 * OUT: %ESI - POINTER TO END OF STR (OR POINTER TO FAULTING ADDRESS)
 *	%EDI - 0 - OK, != 0 - FAULT
 *	%C - C SET --- ABORTED DUE TO INTR, CALL AGAIN (%ESI AND %EDI INDICATE
 *		PROGRESS)
 * CHNG: %EAX
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UREAD_STR
_UREAD_STR:
	CMPL	PROC_CURRENT, %EBX
	JNZ	8f
19:	CMPL	$KUVMTOP, %ESI
	JAE	911f
199:	FAULTMAP_ENTRY(91f)
	MOVZBL	(%ESI), %EAX
	ADDL	$1, %ESI
	CMPB	%AL, %DL
	JE	1f
	JMP	2f

	.ALIGN	__CPU_LOOP_ALIGN
4:	CMPL	$0, CRAWLOUT_QUEUE
	JNE	5f
	MOVB	%AL, (%EDI)
	ADDL	$1, %EDI
	FAULTMAP_ENTRY_NOTEST(91f)
	MOVZBL	(%ESI), %EAX
	ADDL	$1, %ESI
	CMPL	%ECX, %ESI
	JAE	6f
2:	TESTB	%AL, %AL
	JE	13f
	CMPB	%AL, %DL
	JNE	4b
	XORB	%AL, %AL
	ADDL	$1, %ESI
13:
	MOVB	%AL, (%EDI)
	SUBL	$1, %ESI
	XORL	%EDI, %EDI		/* CF == 0 */
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	TESTB	%AL, %AL
	JZ	13b
7:	CMPL	$0, CRAWLOUT_QUEUE
	JNE	11f
	FAULTMAP_ENTRY_NOTEST(91f)
	MOVZBL	(%ESI), %EAX
	ADDL	$1, %ESI
	CMPB	%AL, %DL
	JNE	2b
	CMPL	%ECX, %ESI
	JNAE	7b

	.ALIGN	__CPU_BRANCH_ALIGN
6:	MOVL	$-ENAMETOOLONG, %ESI
	XORL	%EDI, %EDI		/* CF == 0 */
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
5:	SUBL	$1, %ESI
11:	STC
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
8:	XCHGL	%EBX, %EAX
	CALL	USE_PROC
	XCHGL	%EBX, %EAX
	JMP	19b

	.ALIGN	__CPU_BRANCH_ALIGN
911:
	CMPL	$KERNEL$PROC_KERNEL, %EBX
	JE	199b
91:
	MOVL	$1, %EDI
	CLC
	RET

/*
 * _UWRITE_STR:
 * IN: %EBX - PROC
 *     %ESI - SRC -- IN KERNELSPACE
 *     %EDI - DST -- IN TARGET PROCESS
 * OUT: %ESI - 0 -- OK, != 0 -- PAGE FAULT
 * CHNG: %EAX
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UWRITE_STR
_UWRITE_STR:
	CMPL	PROC_CURRENT, %EBX
	JNZ	8f
2:	CMPL	$KUVMTOP, %EDI
	JAE	6f
#if __DEBUG_PAGEFAULTS > 0
	FAULTMAP_ENTRY(4f)
#endif
5:	CMPL	$0, CRAWLOUT_QUEUE
	JNE	1f
	MOVZBL	(%ESI), %EAX
	ADDL	$1, %ESI
	FAULTMAP_ENTRY_NOTEST(4f)
	MOVB	%AL, (%EDI)
	ADDL	$1, %EDI
	TESTB	%AL, %AL
	JNZ	5b
	XORL	%EDI, %EDI
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	STC
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
8:	XCHGL	%EBX, %EAX
	CALL	USE_PROC
	XCHGL	%EBX, %EAX
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
6:
	CMPL	$KERNEL$PROC_KERNEL, %EBX
	JE	5b
4:	CLC
	RET



/*
 * _UTEST_BYTE:
 * IN: %EAX - PROC
 *     %EDX - ADDRESS
 *     %ECX - 0 - READ, 1 - WRITE
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	_UTEST_BYTE
_UTEST_BYTE:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	66f
5:	TESTL	%ECX, %ECX
	JNZ	6f
	FAULTMAP_ENTRY(4f)
	MOVB	(%EDX), %CL
	XORL	%EAX, %EAX
	RET
	.ALIGN	__CPU_BRANCH_ALIGN
6:	FAULTMAP_ENTRY(4f)
	MOVB	(%EDX), %CL	/* !!! SMPFIX: use atomic instruction */
	FAULTMAP_ENTRY(4f)
	MOVB	%CL, (%EDX)
	XORL	%EAX, %EAX
	RET
	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

	.ALIGN	__CPU_BRANCH_ALIGN
66:	CMPL	$KERNEL$PROC_KERNEL, %EAX
	JE	5b
4:	MOVL	$1, %EAX
	RET

/*
 * ARCH_SYSCALL_RETURN:
 * IN: %EAX - PROC
 *     %EDX - VALUE
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	ARCH_SYSCALL_RETURN
ARCH_SYSCALL_RETURN:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:
	FAULTMAP_ENTRY(4f)
	MOVL	KUPLACE(UDATA_EIP), %ECX
	CMPL	$APLACE(APAGE_SYSCALL), %ECX
	JNE	44f
	FAULTMAP_ENTRY(4f)
	MOVL	%EDX, KUPLACE(UDATA_EAX)
	MOVL	$APLACE(APAGE_RET), KUPLACE(UDATA_EIP)
	XORL	%EAX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

44:	MOVL	$1, %EAX
	RET

4:	MOVL	$KUPLACE(UDATA_EIP), %EAX
	RET


			/*****************
			 * PROC_POST_AST *
			 *****************/

/*
 * IN: %EAX - PROC
 *     %EDX - AST
 * OUT: %EAX == 0 ... OK
 *	%EAX != 0 && !(EAX & 1) ... READ FAULT
 *	%EAX != 0 && EAX & 1 ... WRITE FAULT
 */

/*
 * warning: to prevent a nasty VM deadlock (memory fills => processes are
 * swapped out => ASTs are posted => posting waits for free memory), this must
 * not allocate any memory. Unfortunatelly, stack growth can do that. Instead of
 * returning fault on stack address, implement a second slower AST posting
 * method. Use it also in case process has segments (these two features do not
 * depend on each other, but implementing 4 routines would be too complex).
 */

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PROC_POST_AST
	INTMAP_POP(1)
PROC_POST_AST:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:
PROC_POST_AST_X:
	PUSHL	%EDI
	INTMAP_POP(2)
#define EDIPTR	KUPLACE(UDATA_EIP)
	MOVL	$EDIPTR, %EDI
	CMPL	$KUVMTOP, %EDX
	JAE	ppa1
	FAULTMAP_ENTRY(ppa1)
	MOVL	(%EDX), %EAX
	FAULTMAP_ENTRY(ppa2)
	MOVL	12(%EDX), %ECX
	MOVL	$-2, %EAX
	SHLL	%CL, %EAX
	JE	300f

	/* probe for write access to UPAGE --- warning, if the AST was
	   temporarily canceled, this probe must not be performed (due to fork)
	*/
	FAULTMAP_ENTRY(ppa4)
	MOVL	%EDX, KUPLACE(UDATA_LIST_END) - EDIPTR(%EDI)

	CMPW	$SEG_UCODE, KUPLACE(UDATA_CS) - EDIPTR(%EDI)
	JNE	45f
	CMPL	$APLACE(APAGE_CHECK_ASTS), (%EDI)
	JE	44f
45:	CMPL	KUPLACE(UDATA_SPL) - EDIPTR(%EDI), %EAX
44:	JAE	4f

	MOVL	KUPLACE(UDATA_ESP) - EDIPTR(%EDI), %ECX
	SUBL	$28, %ECX
	CMPL	$0, KUPLACE(UDATA_LDT) - EDIPTR(%EDI)
	JNZ	ppa_stack
	CMPL	$KUVMTOP, %ECX
	JAE	ppa5

	MOVL	(%EDI), %EAX
	FAULTMAP_ENTRY(ppa_stack)
	MOVL	%EAX, 24(%ECX)
	MOVL	KUPLACE(UDATA_EAX) - EDIPTR(%EDI), %EAX
	FAULTMAP_ENTRY(ppa_stack)
	MOVL	%EAX, 20(%ECX)
	MOVL	KUPLACE(UDATA_ECX) - EDIPTR(%EDI), %EAX
	FAULTMAP_ENTRY(ppa_stack)
	MOVL	%EAX, 16(%ECX)
	MOVL	KUPLACE(UDATA_EDX) - EDIPTR(%EDI), %EAX
	FAULTMAP_ENTRY(ppa_stack)
	MOVL	%EAX, 12(%ECX)
	MOVL	KUPLACE(UDATA_ESI) - EDIPTR(%EDI), %EAX
	FAULTMAP_ENTRY(ppa_stack)
	MOVL	%EAX, 8(%ECX)
	MOVL	KUPLACE(UDATA_EFLAGS) - EDIPTR(%EDI), %EAX
	FAULTMAP_ENTRY(ppa_stack)
	MOVL	%EAX, 4(%ECX)
	MOVL	KUPLACE(UDATA_SPL) - EDIPTR(%EDI), %EAX
	FAULTMAP_ENTRY(ppa_stack)
	MOVL	$APLACE(APAGE_POP_RET), (%ECX)
	MOVL	%ECX, KUPLACE(UDATA_ESP) - EDIPTR(%EDI)
	MOVL	%EAX, KUPLACE(UDATA_ESI) - EDIPTR(%EDI)
	MOVL	12(%EDX), %ECX
	ANDL	$31, %ECX
	MOVL	$-2, %EAX
	SHLL	%CL, %EAX
	MOVL	%EAX, KUPLACE(UDATA_SPL) - EDIPTR(%EDI)
	XORL	%EAX, %EAX
	MOVL	%EAX, KUPLACE(UDATA_EFLAGS) - EDIPTR(%EDI)
	MOVL	(%EDX), %ECX
	MOVL	%EDX, KUPLACE(UDATA_EAX) - EDIPTR(%EDI)
	MOVL	%ECX, (%EDI)
	POPL	%EDI
	INTMAP_POP(1)
	RET
	INTMAP_POP(2)

	.ALIGN	__CPU_BRANCH_ALIGN
4:	ANDL	$31, %ECX
	MOVL	(%EDI), %EAX
	LEAL	UPLACE(UDATA_AST_QUEUES)(, %ECX, 8), %ECX
	MOVL	(%ECX), %EAX
	ADDL	$PG_SIZE * PG_BANK + 4, %EAX	/* allow it to point to the last bank */
	CMPL	$KUVMTOP + PG_SIZE * PG_BANK, %EAX
	JAE	ppa13
	FAULTMAP_ENTRY(ppa12)
	MOVL	%ECX, 4(%EDX)
#if __DEBUG_PAGEFAULTS > 0
	CMPL	(%ECX), %ECX
	JE	251f
#endif
	FAULTMAP_ENTRY(ppa_post_reverse)
251:	MOVL	%EDX, -PG_SIZE * PG_BANK(%EAX)
	MOVL	%EDX, (%ECX)
250:	SHRL	$3, %ECX
	MOVL	KUPLACE(UDATA_PPL) - EDIPTR(%EDI), %EAX
	BTSL	%ECX, %EAX
	MOVL	%EAX, KUPLACE(UDATA_PPL) - EDIPTR(%EDI)
301:	POPL	%EDI
	INTMAP_POP(1)
	XORL	%EAX, %EAX
	RET
	INTMAP_POP(2)

	/* Alternate routine --- for stack fault or segment registers */
	.ALIGN	__CPU_BRANCH_ALIGN
ppa_stack:	
	ADDL	$28, %ECX
	MOVL	%ECX, KUPLACE(UDATA_SAVED_ESP) - EDIPTR(%EDI)
	CMPW	$SEG_USTACK, KUPLACE(UDATA_SS) - EDIPTR(%EDI)
	JNE	202f
203:	
	MOVL	(%EDI), %EAX
	MOVL	$APLACE(APAGE_CHECK_ASTS), (%EDI)
	MOVL	%EAX, KUPLACE(UDATA_SAVED_EIP) - EDIPTR(%EDI)
	MOVL	KUPLACE(UDATA_SS) - EDIPTR(%EDI), %EAX
	MOVL	$SEG_USTACK, KUPLACE(UDATA_SS) - EDIPTR(%EDI)
	SHLL	$16, %EAX
	MOVW	KUPLACE(UDATA_CS) - EDIPTR(%EDI), %AX
	MOVL	$SEG_UCODE, KUPLACE(UDATA_CS) - EDIPTR(%EDI)
	MOVL	%EAX, KUPLACE(UDATA_SAVED_CS_SS) - EDIPTR(%EDI)
	MOVL	KUPLACE(UDATA_EFLAGS) - EDIPTR(%EDI), %EAX
	MOVL	%EAX, KUPLACE(UDATA_SAVED_EFLAGS) - EDIPTR(%EDI)
	XORL	%EAX, %EAX
	MOVL	%EAX, KUPLACE(UDATA_EFLAGS) - EDIPTR(%EDI)
	MOVL	12(%EDX), %ECX
	JMP	4b
	
	.ALIGN	__CPU_BRANCH_ALIGN
202:	MOVL	KUPLACE(UDATA_ALTSTACK) - EDIPTR(%EDI), %EAX
	MOVL	%EAX, KUPLACE(UDATA_ESP) - EDIPTR(%EDI)
	JMP	203b

	.ALIGN	__CPU_BRANCH_ALIGN
300:	ANDL	$~31, %ECX
	FAULTMAP_ENTRY(ppa2)
	MOVL	%ECX, 12(%EDX)
	JMP	301b

ppa_post_reverse:
	MOVL	4(%ECX), %EAX
	MOVL	%EDX, 4(%ECX)
	MOVL	%EAX, 4(%EDX)
	JMP	250b

ppa2:	ADDL	$8, %EDX
ppa12:	ADDL	$4, %EDX
ppa1:	XCHGL	%EDX, %EAX
ppa:	ORB	$1, %AL
	POPL	%EDI
	INTMAP_POP(1)
	CMPL	$VM_KERNEL_COPY_OF_LAST_BANK << (PG_BANK_BITS + PG_SIZE_BITS), %EAX
	JAE	ppao
	RET
ppao:	SUBL	$(VM_KERNEL_COPY_OF_LAST_BANK - __KERNEL_USER_VBANKS + 1) << (PG_BANK_BITS + PG_SIZE_BITS), %EAX
	RET
	INTMAP_POP(2)
ppa13:	SUBL	$PG_SIZE * PG_BANK, %EAX
	JMP	ppa
ppa5:	XCHGL	%ECX, %EAX
	JMP	ppa
ppa4:	POPL	%EDI
	INTMAP_POP(1)
	MOVL	$KUVMBASE | 1, %EAX
	RET

#undef EDIPTR

	INTMAP_POP(1)
	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b

			/********************
			 * PROC_HANDLE_XCPT *
			 ********************/

/*
 * PROC_HANDLE_XCPT:
 * IN: %EAX - PROC
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	PROC_HANDLE_XCPT
PROC_HANDLE_XCPT:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:
5:
	FAULTMAP_ENTRY(55f)
	MOVL	$KUPLACE(UDATA_STRUCT + OFF_UDATA_xcpt_handler), %EDX
	CALL	PROC_POST_AST
	TESTL	%EAX, %EAX
	JNZ	6f
	MOVB	$0, KUPLACE(UDATA_STRUCT + OFF_UDATA_xcpt_available)
6:	RET
	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b
55:	MOVL	$KUPLACE(UDATA_STRUCT + OFF_UDATA_xcpt_handler), %EAX
	RET

			/*******************
			 * PROC_POST_TIMER *
			 *******************/

/*
 * PROC_POST_TIMER
 * IN: %EAX - PROC
 * OUT: %EAX - 0 - OK, != 0 - FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	INTMAP_POP(1)
	.GLOBAL	PROC_POST_TIMER
PROC_POST_TIMER:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:
5:
	FAULTMAP_ENTRY(55f)
	MOVB	KUPLACE(UDATA_STRUCT + OFF_UDATA_timer_available), %DL
	TESTB	%DL, %DL
	JZ	66f
	MOVL	$KUPLACE(UDATA_STRUCT + OFF_UDATA_timer_handler), %EDX
	CALL	PROC_POST_AST
	TESTL	%EAX, %EAX
	JNZ	6f
	MOVB	$0, KUPLACE(UDATA_STRUCT + OFF_UDATA_timer_available)
6:	RET
	.ALIGN	__CPU_BRANCH_ALIGN
66:	XORL	%EAX, %EAX
	RET
	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b
55:	MOVL	$KUPLACE(UDATA_STRUCT + OFF_UDATA_timer_available), %EAX
	RET


			/****************
			 * PROC_GET_SIO *
			 ****************/

/*
 * IN: %EAX - PROC
 *     %EDX - SIORQ IN PROC
 *     %ECX - SIORQ IN KERNELSPACE
 * OUT: %EAX == 0 ... OK
 *	%EAX != 0 && !(EAX & 1) ... READ FAULT
 *	%EAX != 0 && EAX & 1 ... WRITE FAULT
 */

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PROC_GET_SIO
	INTMAP_POP(1)
PROC_GET_SIO:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	9989f
	FAULTMAP_ENTRY(9990f)
	MOVL	OFF_SIORQ_h(%EDX), %EAX
	MOVL	%EAX, OFF_SIORQ_h(%ECX)
	FAULTMAP_ENTRY(9991f)
	MOVL	OFF_SIORQ_v_ptr(%EDX), %EAX
	MOVL	%EAX, OFF_SIORQ_v_ptr(%ECX)
	FAULTMAP_ENTRY(9992f)
	MOVL	OFF_SIORQ_v_ptr + 4(%EDX), %EAX
	MOVL	%EAX, OFF_SIORQ_v_ptr + 4(%ECX)
	FAULTMAP_ENTRY(9993f)
	MOVL	OFF_SIORQ_v_len(%EDX), %EAX
	MOVL	%EAX, OFF_SIORQ_v_len(%ECX)
	FAULTMAP_ENTRY(9994f)
	MOVL	OFF_SIORQ_v_vspace(%EDX), %EAX
	MOVL	%EAX, OFF_SIORQ_v_vspace(%ECX)
	FAULTMAP_ENTRY(9995f)
	MOVL	OFF_SIORQ_progress(%EDX), %EAX
	MOVL	%EAX, OFF_SIORQ_progress(%ECX)
	XORL	%EAX, %EAX
	RET

9995:	ADDL	$OFF_SIORQ_progress - OFF_SIORQ_v_vspace, %EDX
9994:	ADDL	$OFF_SIORQ_v_vspace - OFF_SIORQ_v_len, %EDX
9993:	ADDL	$OFF_SIORQ_v_len - (OFF_SIORQ_v_ptr + 4), %EDX
9992:	ADDL	$4, %EDX
9991:	ADDL	$OFF_SIORQ_v_ptr - OFF_SIORQ_h, %EDX
9990:	ADDL	$OFF_SIORQ_h, %EDX
9989:	XCHGL	%EDX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
	INTMAP_POP(1)
1:	CALL	USE_PROC
	JMP	2b


			/*****************
			 * PROC_POST_SIO *
			 *****************/

/*
 * IN: %EAX - PROC
 *     %EDX - SIORQ IN PROC
 *     %ECX - SIORQ IN KERNELSPACE
 * OUT: %EAX == 0 ... OK
 *	%EAX != 0 && !(EAX & 1) ... READ FAULT
 *	%EAX != 0 && EAX & 1 ... WRITE FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PROC_POST_SIO
	INTMAP_POP(1)
PROC_POST_SIO:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:
	CMPL	$KUVMTOP, %EDX
	JAE	9990f
	MOVL	OFF_SIORQ_v_ptr(%ECX), %EAX
	FAULTMAP_ENTRY(9991f)
	MOVL	%EAX, OFF_SIORQ_v_ptr(%EDX)
	MOVL	OFF_SIORQ_v_ptr + 4(%ECX), %EAX
	FAULTMAP_ENTRY(9992f)
	MOVL	%EAX, OFF_SIORQ_v_ptr + 4(%EDX)
	MOVL	OFF_SIORQ_v_len(%ECX), %EAX
	FAULTMAP_ENTRY(9993f)
	MOVL	%EAX, OFF_SIORQ_v_len(%EDX)
	MOVL	OFF_SIORQ_progress(%ECX), %EAX
	FAULTMAP_ENTRY(9994f)
	MOVL	%EAX, OFF_SIORQ_progress(%EDX)
	MOVL	OFF_IORQ_status(%ECX), %ECX
	JMP	PROC_POST_IO_X

9994:	ADDL	$OFF_SIORQ_progress - OFF_SIORQ_v_len, %EDX
9993:	ADDL	$OFF_SIORQ_v_len - (OFF_SIORQ_v_ptr + 4), %EDX
9992:	ADDL	$4, %EDX
9991:	ADDL	$OFF_SIORQ_v_ptr, %EDX
9990:	XCHGL	%EDX, %EAX
	ORB	$1, %AL
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b


			/****************
			 * PROC_GET_AIO *
			 ****************/

/*
 * IN: %EAX - PROC
 *     %EDX - AIORQ IN PROC
 *     %ECX - AIORQ IN KERNELSPACE
 * OUT: %EAX == 0 ... OK
 *	%EAX != 0 && !(EAX & 1) ... READ FAULT
 *	%EAX != 0 && EAX & 1 ... WRITE FAULT
 */

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PROC_GET_AIO
	INTMAP_POP(1)
PROC_GET_AIO:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	9989f
	FAULTMAP_ENTRY(9990f)
	MOVL	OFF_AIORQ_h(%EDX), %EAX
	MOVL	%EAX, OFF_AIORQ_h(%ECX)
	FAULTMAP_ENTRY(9991f)
	MOVL	OFF_AIORQ_v_ptr(%EDX), %EAX
	MOVL	%EAX, OFF_AIORQ_v_ptr(%ECX)
	FAULTMAP_ENTRY(9992f)
	MOVL	OFF_AIORQ_v_ptr + 4(%EDX), %EAX
	MOVL	%EAX, OFF_AIORQ_v_ptr + 4(%ECX)
	FAULTMAP_ENTRY(9993f)
	MOVL	OFF_AIORQ_v_len(%EDX), %EAX
	MOVL	%EAX, OFF_AIORQ_v_len(%ECX)
	FAULTMAP_ENTRY(9994f)
	MOVL	OFF_AIORQ_v_vspace(%EDX), %EAX
	MOVL	%EAX, OFF_AIORQ_v_vspace(%ECX)
	FAULTMAP_ENTRY(99941f)
	MOVL	OFF_AIORQ_pos(%EDX), %EAX
	MOVL	%EAX, OFF_AIORQ_pos(%ECX)
	FAULTMAP_ENTRY(99942f)
	MOVL	OFF_AIORQ_pos + 4(%EDX), %EAX
	MOVL	%EAX, OFF_AIORQ_pos + 4(%ECX)
	FAULTMAP_ENTRY(9995f)
	MOVL	OFF_AIORQ_progress(%EDX), %EAX
	MOVL	%EAX, OFF_AIORQ_progress(%ECX)
	XORL	%EAX, %EAX
	RET

9995:	ADDL	$OFF_AIORQ_progress - (OFF_AIORQ_pos + 4), %EDX
99942:	ADDL	$4, %EDX
99941:	ADDL	$OFF_AIORQ_pos - OFF_AIORQ_v_vspace, %EDX
9994:	ADDL	$OFF_AIORQ_v_vspace - OFF_AIORQ_v_len, %EDX
9993:	ADDL	$OFF_AIORQ_v_len - (OFF_AIORQ_v_ptr + 4), %EDX
9992:	ADDL	$4, %EDX
9991:	ADDL	$OFF_AIORQ_v_ptr - OFF_AIORQ_h, %EDX
9990:	ADDL	$OFF_AIORQ_h, %EDX
9989:	XCHGL	%EDX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
	INTMAP_POP(1)
1:	CALL	USE_PROC
	JMP	2b


			/*****************
			 * PROC_POST_AIO *
			 *****************/

/*
 * IN: %EAX - PROC
 *     %EDX - AIORQ IN PROC
 *     %ECX - AIORQ IN KERNELSPACE
 * OUT: %EAX == 0 ... OK
 *	%EAX != 0 && !(EAX & 1) ... READ FAULT
 *	%EAX != 0 && EAX & 1 ... WRITE FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PROC_POST_AIO
	INTMAP_POP(1)
PROC_POST_AIO:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:
	CMPL	$KUVMTOP, %EDX
	JAE	9990f
	MOVL	OFF_AIORQ_v_ptr(%ECX), %EAX
	FAULTMAP_ENTRY(9991f)
	MOVL	%EAX, OFF_AIORQ_v_ptr(%EDX)
	MOVL	OFF_AIORQ_v_ptr + 4(%ECX), %EAX
	FAULTMAP_ENTRY(9992f)
	MOVL	%EAX, OFF_AIORQ_v_ptr + 4(%EDX)
	MOVL	OFF_AIORQ_v_len(%ECX), %EAX
	FAULTMAP_ENTRY(9993f)
	MOVL	%EAX, OFF_AIORQ_v_len(%EDX)
	MOVL	OFF_AIORQ_pos(%ECX), %EAX
	FAULTMAP_ENTRY(99931f)
	MOVL	%EAX, OFF_AIORQ_pos(%EDX)
	MOVL	OFF_AIORQ_pos + 4(%ECX), %EAX
	FAULTMAP_ENTRY(99932f)
	MOVL	%EAX, OFF_AIORQ_pos + 4(%EDX)
	MOVL	OFF_AIORQ_progress(%ECX), %EAX
	FAULTMAP_ENTRY(9994f)
	MOVL	%EAX, OFF_AIORQ_progress(%EDX)
	MOVL	OFF_IORQ_status(%ECX), %ECX
	JMP	PROC_POST_IO_X

9994:	ADDL	$OFF_AIORQ_progress - (OFF_AIORQ_pos + 4), %EDX
99932:	ADDL	$4, %EDX
99931:	ADDL	$OFF_AIORQ_pos - OFF_AIORQ_v_len, %EDX
9993:	ADDL	$OFF_AIORQ_v_len - (OFF_AIORQ_v_ptr + 4), %EDX
9992:	ADDL	$4, %EDX
9991:	ADDL	$OFF_AIORQ_v_ptr, %EDX
9990:	XCHGL	%EDX, %EAX
	ORB	$1, %AL
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b


			/******************
			 * PROC_GET_IOCTL *
			 ******************/

/*
 * IN: %EAX - PROC
 *     %EDX - IOCTLRQ IN PROC
 *     %ECX - IOCTLRQ IN KERNELSPACE
 * OUT: %EAX == 0 ... OK
 *	%EAX != 0 && !(EAX & 1) ... READ FAULT
 *	%EAX != 0 && EAX & 1 ... WRITE FAULT
 */

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PROC_GET_IOCTL
	INTMAP_POP(1)
PROC_GET_IOCTL:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:	CMPL	$KUVMTOP, %EDX
	JAE	9989f
	FAULTMAP_ENTRY(9990f)
	MOVL	OFF_IOCTLRQ_h(%EDX), %EAX
	MOVL	%EAX, OFF_IOCTLRQ_h(%ECX)
	FAULTMAP_ENTRY(9991f)
	MOVL	OFF_IOCTLRQ_v_ptr(%EDX), %EAX
	MOVL	%EAX, OFF_IOCTLRQ_v_ptr(%ECX)
	FAULTMAP_ENTRY(9992f)
	MOVL	OFF_IOCTLRQ_v_ptr + 4(%EDX), %EAX
	MOVL	%EAX, OFF_IOCTLRQ_v_ptr + 4(%ECX)
	FAULTMAP_ENTRY(9993f)
	MOVL	OFF_IOCTLRQ_v_len(%EDX), %EAX
	MOVL	%EAX, OFF_IOCTLRQ_v_len(%ECX)
	FAULTMAP_ENTRY(9994f)
	MOVL	OFF_IOCTLRQ_v_vspace(%EDX), %EAX
	MOVL	%EAX, OFF_IOCTLRQ_v_vspace(%ECX)
	FAULTMAP_ENTRY(9995f)
	MOVL	OFF_IOCTLRQ_ioctl(%EDX), %EAX
	MOVL	%EAX, OFF_IOCTLRQ_ioctl(%ECX)
	FAULTMAP_ENTRY(9996f)
	MOVL	OFF_IOCTLRQ_param(%EDX), %EAX
	MOVL	%EAX, OFF_IOCTLRQ_param(%ECX)
	XORL	%EAX, %EAX
	RET

9996:	ADDL	$OFF_IOCTLRQ_param - OFF_IOCTLRQ_ioctl, %EDX
9995:	ADDL	$OFF_IOCTLRQ_ioctl - OFF_IOCTLRQ_v_vspace, %EDX
9994:	ADDL	$OFF_IOCTLRQ_v_vspace - OFF_IOCTLRQ_v_len, %EDX
9993:	ADDL	$OFF_IOCTLRQ_v_len - (OFF_IOCTLRQ_v_ptr + 4), %EDX
9992:	ADDL	$4, %EDX
9991:	ADDL	$OFF_IOCTLRQ_v_ptr - OFF_IOCTLRQ_h, %EDX
9990:	ADDL	$OFF_IOCTLRQ_h, %EDX
9989:	XCHGL	%EDX, %EAX
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
	INTMAP_POP(1)
1:	CALL	USE_PROC
	JMP	2b


			/*******************
			 * PROC_POST_IOCTL *
			 *******************/

/*
 * IN: %EAX - PROC
 *     %EDX - IOCTLRQ IN PROC
 *     %ECX - IOCTLRQ IN KERNELSPACE
 * OUT: %EAX == 0 ... OK
 *	%EAX != 0 && !(EAX & 1) ... READ FAULT
 *	%EAX != 0 && EAX & 1 ... WRITE FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PROC_POST_IOCTL
	INTMAP_POP(1)
PROC_POST_IOCTL:
	MOVL	OFF_IORQ_status(%ECX), %ECX
	/*JMP	PROC_POST_IO --- is directly after this ! */

			/****************
			 * PROC_POST_IO *
			 ****************/
/*
 * IN: %EAX - PROC
 *     %EDX - IORQ IN PROC
 *     %ECX - STATUS
 * OUT: %EAX == 0 ... OK
 *	%EAX != 0 && !(EAX & 1) ... READ FAULT
 *	%EAX != 0 && EAX & 1 ... WRITE FAULT
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PROC_POST_IO
	INTMAP_POP(1)
PROC_POST_IO:
	CMPL	PROC_CURRENT, %EAX
	JNZ	1f
2:
	CMPL	$KUVMTOP, %EDX
	JAE	9990f
	.ALIGN	__CPU_BRANCH_ALIGN
PROC_POST_IO_X:
	CMPL	$-EINTR, %ECX
	JE	5f
6:
	FAULTMAP_ENTRY(9991f)
	MOVL	%ECX, OFF_IORQ_status(%EDX)
68:
	JMP	PROC_POST_AST_X

	.ALIGN	__CPU_BRANCH_ALIGN
5:
	FAULTMAP_ENTRY(9991f)
	MOVL	OFF_IORQ_status(%EDX), %EAX
	ANDL	$RQS_ACTION_MASK, %EAX
	CMPL	$RQS_KERNELCANCELABLE, %EAX
	JNE	66f
	FAULTMAP_ENTRY(9990f)
	MOVL	(%EDX), %EAX
	FAULTMAP_ENTRY(9990f)
	MOVL	%EAX, (%EDX)
	FAULTMAP_ENTRY(9992f)
	MOVL	%EAX, OFF_IORQ_tmp2(%EDX)
	FAULTMAP_ENTRY(9993f)
	MOVL	KUPLACE(UDATA_STRUCT + OFF_UDATA_repost_ast_spl), %EAX
	FAULTMAP_ENTRY(9994f)
	MOVL	OFF_IORQ_tmp3(%EDX), %EAX
	FAULTMAP_ENTRY(9994f)
	MOVL	%EAX, OFF_IORQ_tmp3(%EDX)
	SARL	$5, %EAX
	CMPL	$KERNEL_CALL_MAX, %EAX
#ifndef __NO_ASM_PREDICTIONS
	JAE,pn	6b
#else
	JAE	6b
#endif
	MOVL    OFF_IORQ_status(%EDX), %ECX
	ANDL	$RQS_PRIORITY_MASK, %ECX
	/* fault on UDATA checked above ... */
	MOVL	KUPLACE(UDATA_STRUCT + OFF_UDATA_repost_ast_fn)(, %EAX, 4), %EAX
	ORL	$RQS_PROCESSING, %ECX
	FAULTMAP_ENTRY(9991f)
	MOVL	%ECX, OFF_IORQ_status(%EDX)
	MOVL	KUPLACE(UDATA_STRUCT + OFF_UDATA_repost_ast_spl), %ECX
	MOVL	%EAX, (%EDX)
	MOVL	%ECX, OFF_IORQ_tmp3(%EDX)
	JMP	PROC_POST_AST_X
66:	CMPL	$RQS_PROCESSING, %EAX
	JNE	6b
	JMP	68b

9993:	MOVL	$KUVMBASE, %EAX
	RET
9991:	ADDL	$OFF_IORQ_status - OFF_IORQ_tmp3, %EDX
9994:	ADDL	$OFF_IORQ_tmp3 - OFF_IORQ_tmp2, %EDX
9992:	ADDL	$OFF_IORQ_tmp2, %EDX
9990:	XCHGL	%EDX, %EAX
	ORB	$1, %AL
	RET

	.ALIGN	__CPU_BRANCH_ALIGN
1:	CALL	USE_PROC
	JMP	2b


			/*******************
			 * PROC_VSPACE_GET *
			 *******************/
#define KREG	EDI
#define UREG	ESI
#define NAME	PROC_VSPACE_GET
#define NAME_SLOW	PROC_VSPACE_GET_SLOW
#include "ASMVSP.I"
			/*******************
			 * PROC_VSPACE_PUT *
			 *******************/
#define KREG	ESI
#define UREG	EDI
#define NAME	PROC_VSPACE_PUT
#define NAME_SLOW	PROC_VSPACE_PUT_SLOW
#include "ASMVSP.I"

			/**************
			 * READ/WRITE *
			 **************/

/*
 * IN: %EAX - SIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$READ
	INTMAP_NO_CRAWLOUT
KERNEL$READ:
	MOVL	OFF_SIORQ_h(%EAX), %EDX
	MOVL	FILES_PTR, %ECX
#if __DEBUG >= 1
	CMPL	N_FILES, %EDX
	JAE	INVALID_HANDLE
#endif
	MOVL	(%ECX, %EDX, 4), %EDX
#if __DEBUG >= 2
	TESTL	%EDX, %EDX
	JZ	INVALID_HANDLE
#endif
	MOVL	%EDX, OFF_SIORQ_handle(%EAX)
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_read(%ECX)

/*
 * IN: %EAX - SIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WRITE
	INTMAP_NO_CRAWLOUT
KERNEL$WRITE:
	MOVL	OFF_SIORQ_h(%EAX), %EDX
	MOVL	FILES_PTR, %ECX
#if __DEBUG >= 1
	CMPL	N_FILES, %EDX
	JAE	INVALID_HANDLE
#endif
	MOVL	(%ECX, %EDX, 4), %EDX
#if __DEBUG >= 2
	TESTL	%EDX, %EDX
	JZ	INVALID_HANDLE
#endif
	MOVL	%EDX, OFF_SIORQ_handle(%EAX)
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_write(%ECX)

/*
 * IN: %EAX - AIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$AREAD
	INTMAP_NO_CRAWLOUT
KERNEL$AREAD:
	MOVL	OFF_AIORQ_h(%EAX), %EDX
	MOVL	FILES_PTR, %ECX
#if __DEBUG >= 1
	CMPL	N_FILES, %EDX
	JAE	INVALID_HANDLE
#endif
	MOVL	(%ECX, %EDX, 4), %EDX
#if __DEBUG >= 2
	TESTL	%EDX, %EDX
	JZ	INVALID_HANDLE
#endif
	MOVL	%EDX, OFF_AIORQ_handle(%EAX)
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_aread(%ECX)

/*
 * IN: %EAX - AIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$AWRITE
	INTMAP_NO_CRAWLOUT
KERNEL$AWRITE:
	MOVL	OFF_AIORQ_h(%EAX), %EDX
	MOVL	FILES_PTR, %ECX
#if __DEBUG >= 1
	CMPL	N_FILES, %EDX
	JAE	INVALID_HANDLE
#endif
	MOVL	(%ECX, %EDX, 4), %EDX
#if __DEBUG >= 2
	TESTL	%EDX, %EDX
	JZ	INVALID_HANDLE
#endif
	MOVL	%EDX, OFF_AIORQ_handle(%EAX)
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_awrite(%ECX)

/*
 * IN: %EAX - IOCTLRQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$IOCTL
	INTMAP_NO_CRAWLOUT
KERNEL$IOCTL:
	MOVL	OFF_IOCTLRQ_h(%EAX), %EDX
	MOVL	FILES_PTR, %ECX
#if __DEBUG >= 1
	CMPL	N_FILES, %EDX
	JAE	INVALID_HANDLE
#endif
	MOVL	(%ECX, %EDX, 4), %EDX
#if __DEBUG >= 2
	TESTL	%EDX, %EDX
	JZ	INVALID_HANDLE
#endif
	MOVL	%EDX, OFF_IOCTLRQ_handle(%EAX)
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_ioctl(%ECX)

/*
 * IN: %EAX - BIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$BIO
	INTMAP_NO_CRAWLOUT
KERNEL$BIO:
	MOVL	OFF_BIORQ_h(%EAX), %EDX
	MOVL	FILES_PTR, %ECX
#if __DEBUG >= 1
	CMPL	N_FILES, %EDX
	JAE	INVALID_HANDLE
#endif
	MOVL	(%ECX, %EDX, 4), %EDX
#if __DEBUG >= 2
	TESTL	%EDX, %EDX
	JZ	INVALID_HANDLE
#endif
	MOVL	%EDX, OFF_BIORQ_handle(%EAX)
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_bio(%ECX)

/*
 * IN: %EAX - PACKET
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$PKTIO
	INTMAP_NO_CRAWLOUT
KERNEL$PKTIO:
	MOVL	OFF_PACKET_h(%EAX), %EDX
	MOVL	FILES_PTR, %ECX
#if __DEBUG >= 1
	CMPL	N_FILES, %EDX
	JAE	INVALID_HANDLE
#endif
	MOVL	(%ECX, %EDX, 4), %EDX
#if __DEBUG >= 2
	TESTL	%EDX, %EDX
	JZ	INVALID_HANDLE
#endif
	MOVL	%EDX, OFF_PACKET_handle(%EAX)
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_pktio(%ECX)


			/********
			 * WAKE *
			 ********/

/*
 * IN: %EAX - SIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WAKE_READ
	INTMAP_NO_CRAWLOUT
KERNEL$WAKE_READ:
	MOVL	OFF_SIORQ_handle(%EAX), %EDX
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_read(%ECX)

/*
 * IN: %EAX - SIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WAKE_WRITE
	INTMAP_NO_CRAWLOUT
KERNEL$WAKE_WRITE:
	MOVL	OFF_SIORQ_handle(%EAX), %EDX
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_write(%ECX)

/*
 * IN: %EAX - AIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WAKE_AREAD
	INTMAP_NO_CRAWLOUT
KERNEL$WAKE_AREAD:
	MOVL	OFF_AIORQ_handle(%EAX), %EDX
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_aread(%ECX)

/*
 * IN: %EAX - AIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WAKE_AWRITE
	INTMAP_NO_CRAWLOUT
KERNEL$WAKE_AWRITE:
	MOVL	OFF_AIORQ_handle(%EAX), %EDX
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_awrite(%ECX)

/*
 * IN: %EAX - IOCTLRQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WAKE_IOCTL
	INTMAP_NO_CRAWLOUT
KERNEL$WAKE_IOCTL:
	MOVL	OFF_IOCTLRQ_handle(%EAX), %EDX
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_ioctl(%ECX)

/*
 * IN: %EAX - BIORQ
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WAKE_BIO
	INTMAP_NO_CRAWLOUT
KERNEL$WAKE_BIO:
	MOVL	OFF_BIORQ_handle(%EAX), %EDX
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_bio(%ECX)

/*
 * IN: %EAX - PACKET
 */
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WAKE_PKTIO
	INTMAP_NO_CRAWLOUT
KERNEL$WAKE_PKTIO:
	MOVL	OFF_PACKET_handle(%EAX), %EDX
.IF OFF_HANDLE_op <> 0
	MOVL	OFF_HANDLE_op(%EDX), %ECX
.ELSE
	MOVL	(%EDX), %ECX
.ENDIF
	JMP	*OFF_HANDLE_OPERATIONS_pktio(%ECX)



			/******************
			 * HEAP & ENVIRON *
			 ******************/

	.SECTION .data
	.ALIGN	4
	.GLOBAL environ
environ:
	.LONG	0
	.GLOBAL	KERNEL$__STDHEAP_TOP
KERNEL$__STDHEAP_TOP:
	.LONG	-1
	.GLOBAL	SUBPROC_CTL
SUBPROC_CTL:
	.LONG	0

			/*******
			 * END *
			 *******/

	.SECTION JMPTBL
JMPTBL_END:

	.SECTION .text
	.ALIGN	KERNEL_CRAWLOUT_SPACE_ALIGN, 0
KERNEL_CRAWLOUT_END:

	INTMAP_END

	FAULTMAP_END

	.SECTION .text
	.ALIGN	4096
	.GLOBAL	APAGE
	.GLOBAL	APAGE_END
APAGE:

/* Apage must not contain FP instruction --- FP handler is not expecting being
   interrupted in apage */

/* RETURN */
	.ORG	APAGE + APAGE_RETURN, 0x90
	MOVL	$KUPLACE(UDATA_EFLAGS), %ECX
	PUSHL	(%ECX)
	MOVL	KUPLACE(UDATA_EDX)-KUPLACE(UDATA_EFLAGS)(%ECX), %EDX
	MOVL	KUPLACE(UDATA_ECX)-KUPLACE(UDATA_EFLAGS)(%ECX), %ECX
	POPFL
	JMP	*KUPLACE(UDATA_EIP)

/* SEG RETURN */
	.ORG	APAGE + APAGE_SEG_RETURN, 0x90
apage_seg_return_rel:
	MOVL	$KUPLACE(UDATA_EFLAGS), %ECX
	MOVW	KUPLACE(UDATA_ES)-KUPLACE(UDATA_EFLAGS)(%ECX), %ES
	PUSHL	(%ECX)
	MOVW	KUPLACE(UDATA_FS)-KUPLACE(UDATA_EFLAGS)(%ECX), %FS
	MOVL	KUPLACE(UDATA_EDX)-KUPLACE(UDATA_EFLAGS)(%ECX), %EDX
	MOVW	KUPLACE(UDATA_GS)-KUPLACE(UDATA_EFLAGS)(%ECX), %GS
	POPFL
	LSSL	KUPLACE(UDATA_ESP)-KUPLACE(UDATA_EFLAGS)(%ECX), %ESP
	MOVW	KUPLACE(UDATA_DS)-KUPLACE(UDATA_EFLAGS)(%ECX), %DS
	MOVL	%CS:KUPLACE(UDATA_ECX)-KUPLACE(UDATA_EFLAGS)(%ECX), %ECX
	LJMP	*%CS:KUPLACE(UDATA_EIP)	/* ljmp is faster than lret or iret */

	/* WARNING --- IF YOU TOUCH CODE BELOW, FIX ALSO FIXUP_APAGE_TABLE */

/* QUEUE_AST */
	.ORG	APAGE + APAGE_QUEUE_AST, 0x90
	PUSHL	%ECX
	MOVL	(%EDX), %ECX
	MOVL	%EDX, 4(%EAX)
	MOVL	%EAX, 4(%ECX)
	/* POINT OF NO RETURN */
	MOVL	%EAX, (%EDX)
	POPL	%ECX
	ORL	%ECX, KUPLACE(UDATA_PPL)
/* PROCESS_PENDING_AST */
process_pending_ast_rel:
	MOVL	KUPLACE(UDATA_PPL), %EAX
	TESTL	%EAX, %ESI
	JNZ	1f
	MOVL	%ESI, KUPLACE(UDATA_SPL)
	/* POINT OF NO RETURN */
	RET

1:	BSRL	%EAX, %ECX
	LEAL	UPLACE(UDATA_AST_QUEUES)(, %ECX, 8), %ECX
	MOVL	4(%ECX), %EAX
	MOVL	4(%EAX), %EDX
	MOVL	%EDX, 4(%ECX)
	/* POINT OF NO RETURN */
	CMPL	%EDX, %ECX
	JNZ	2f
	MOVL	%ECX, (%ECX)
	SHRL	$3, %ECX
	MOVL	KUPLACE(UDATA_PPL), %EDX
	BTRL	%ECX, %EDX
	MOVL	%EDX, KUPLACE(UDATA_PPL)
	.BYTE	0xBA
	.BYTE	0x00
2:	SHRL	$3, %ECX
	ORL	$0xFFFFFFFE, %EDX
	SHLL	%CL, %EDX
	MOVL	%EDX, KUPLACE(UDATA_SPL)
	JMP	*(%EAX)

/* SYSCALL */
	.ORG	APAGE + APAGE_SYSCALL, 0x90
	.SECTION .FEATURE_FIXUP
	.LONG	41f, 42f, 43f, 44f, CPU_HAS_SYSENTER, 0, 0, 0
	.LONG	41f, 42f, 45f, 46f, CPU_HAS_AMD_SYSCALL, 0, 0, 0
	.PREVIOUS
41:
	INT	$SYSCALL_INT
	.SPACE	8, 0x90
42:
	.SECTION .rodata
43:
	MOVL	%ESP, KUPLACE(UDATA_ESP)
	SYSENTER
44:
45:
	MOVL	%EBX, KUPLACE(UDATA_EBX)
	XCHGL	%ECX, %EBX
	.BYTE	0x0F, 0x05
46:
	.PREVIOUS

/* POP_RET */
	.ORG	APAGE + APAGE_POP_RET, 0x90
	POPFL
	POPL	%ESI
	POPL	%EDX
	POPL	%ECX
	POPL	%EAX
/* RET */
	RET

/* APAGE_SET_8 */
	.ORG	APAGE + APAGE_SET_8, 0x90
	ORL	$0, (%ECX)
	MOVL	%EDX, 4(%ECX)
	MOVL	%EAX, (%ECX)
	RET

/* APAGE_CHECK_ASTS */
	.ORG	APAGE + APAGE_CHECK_ASTS, 0x90
	PUSHW	%GS
	PUSHW	%FS
	PUSHW	%ES
	PUSHW	%DS
	PUSHL	%SS
	POPL	%DS
	PUSHL	%SS
	POPL	%ES
	PUSHL	KUPLACE(UDATA_SAVED_CS_SS)
	PUSHL	KUPLACE(UDATA_SAVED_ESP)
	PUSHL	KUPLACE(UDATA_SAVED_EIP)
	PUSHL	%EAX
	PUSHL	%ECX
	PUSHL	%EDX
	PUSHL	%ESI
	PUSHL	KUPLACE(UDATA_SAVED_EFLAGS)
	MOVL	KUPLACE(UDATA_SPL), %ESI
	CALL	process_pending_ast_rel

/* POP_RET_SEG */
	.ORG	APAGE + APAGE_POP_RET_SEG, 0x90
	MOVL	$KUPLACE(UDATA_EFLAGS), %ESI
	MOVL	36(%ESP), %EAX	/* try to avoid partial memory stall */
	MOVL	%EAX, KUPLACE(UDATA_FS)-KUPLACE(UDATA_EFLAGS)(%ESI)
	MOVL	32(%ESP), %EAX
	MOVL	%EAX, KUPLACE(UDATA_DS)-KUPLACE(UDATA_EFLAGS)(%ESI)
	MOVL	(%ESP), %EAX
	MOVL	%EAX, (%ESI)
	MOVL	8(%ESP), %EAX
	MOVL	%EAX, KUPLACE(UDATA_EDX)-KUPLACE(UDATA_EFLAGS)(%ESI)
	MOVL	12(%ESP), %EAX
	MOVL	%EAX, KUPLACE(UDATA_ECX)-KUPLACE(UDATA_EFLAGS)(%ESI)
	MOVL	20(%ESP), %EAX
	MOVL	%EAX, KUPLACE(UDATA_EIP)-KUPLACE(UDATA_EFLAGS)(%ESI)
	MOVL	28(%ESP), %EAX
	MOVW	%AX, KUPLACE(UDATA_CS)-KUPLACE(UDATA_EFLAGS)(%ESI)
	SHRL	$16, %EAX
	MOVL	%EAX, KUPLACE(UDATA_SS)-KUPLACE(UDATA_EFLAGS)(%ESI)
	MOVL	24(%ESP), %EAX
	MOVL	%EAX, KUPLACE(UDATA_ESP)-KUPLACE(UDATA_EFLAGS)(%ESI)
	MOVL	16(%ESP), %EAX
	MOVL	4(%ESP), %ESI
	JMP	apage_seg_return_rel

/* GET_TIME_OF_DAY */
	.ORG	APAGE + APAGE_GET_TIME_OF_DAY, 0x90
	MOVL	%EAX, %ECX

	.SECTION .FEATURE_FIXUP
	.LONG	41f, 42f, 42f, 42f, 0, 0, CPU_HAS_TSC, 0
	.PREVIOUS
41:
	RDTSC
	SHRDL	$0x1f, %EDX, %EAX
40:
	.SECTION .FINE_TICKS_FIXUP
	.LONG	40b - 1
	.PREVIOUS
42:
	IMULL	$15625, APLACE(APAGE_TIME_TICKS_SINCE_SECOND), %EDX
	SHRL	$10, %EDX
	
	.SECTION .FEATURE_FIXUP
	.LONG	43f, 44f, 44f, 44f, 0, 0, CPU_HAS_TSC, 0
	.PREVIOUS
43:
	SUBL	APLACE(APAGE_LAST_FINE_TICKS), %EAX
	CMPL	$0x90909090, %EAX
	.GLOBAL	TIME_MAX_FIXUP_1
TIME_MAX_FIXUP_1 = . - 4
	JA	9f
8:	IMUL	$0x90909090, %EAX
	.GLOBAL	TIME_MUL_FIXUP
TIME_MUL_FIXUP = . - 4
	SHRL	$0x90, %EAX
	.GLOBAL	TIME_SHR_FIXUP
TIME_SHR_FIXUP = . - 1
	ADDL	%EAX, %EDX
44:

	MOVL	%EDX, 8(%ECX)

	MOVL	APLACE(APAGE_TIME_SEC), %EAX
	MOVL	APLACE(APAGE_TIME_SEC) + 4, %EDX
	MOVL	%EAX, (%ECX)
	MOVL	%EDX, 4(%ECX)
	XORL	%EAX, %EAX
	RET
9:	MOVL	$0x90909090, %EAX
	.GLOBAL	TIME_MAX_FIXUP_2
TIME_MAX_FIXUP_2 = . - 4
	JMP	8b

/* GET_TIME_SEC */
	.ORG	APAGE + APAGE_GET_TIME_SEC, 0x90
	MOVL	$APLACE(APAGE_TIME_TICKS_SINCE_SECOND), %EDX
	MOVL	(%EDX), %ECX
	MOVL	APAGE_TIME_SEC - APAGE_TIME_TICKS_SINCE_SECOND(%EDX), %EAX
	MOVL	APAGE_TIME_SEC + 4 - APAGE_TIME_TICKS_SINCE_SECOND(%EDX), %EDX
	RET

/* END OF FIXUP_APAGE_TABLE */

	.ORG	APAGE + APAGE_END_FIXUP, 0x90

	.ORG	APAGE + APAGE_CPU_FEATURES
	.GLOBAL	KERNEL$CPU_FEATURES
KERNEL$CPU_FEATURES:
	.LONG	0

	.ORG	APAGE + APAGE_TIME_TICKS_SINCE_SECOND
	.GLOBAL	TIME_TICKS_SINCE_SECOND
TIME_TICKS_SINCE_SECOND:
	.LONG	0

	.ORG	APAGE + APAGE_TIME_SEC
	.GLOBAL	TIME_SEC
TIME_SEC:
	.LONG	0, 0

	.ORG	APAGE + APAGE_LAST_FINE_TICKS
	.GLOBAL	LAST_FINE_TICKS
LAST_FINE_TICKS:
	.LONG	0

	.ORG	APAGE + APAGE_JIFFIES_STEP
	.GLOBAL	KERNEL$JIFFIES_STEP
KERNEL$JIFFIES_STEP:
	.LONG	0

	.ORG	APAGE + APAGE_JIFFIES_STEP_BITS
	.GLOBAL	KERNEL$JIFFIES_STEP_BITS
KERNEL$JIFFIES_STEP_BITS:
	.BYTE	0

	.ORG	APAGE + APAGE_TIME_MINUTESWEST
	.GLOBAL	TIME_MINUTESWEST
TIME_MINUTESWEST:
	.WORD	0

	.ORG	APAGE + APAGE_TIME_DST
	.GLOBAL	TIME_DST
TIME_DST:
	.LONG	0

	.ORG	APAGE + 4096
APAGE_END:


