#ifndef __KERNEL_ASMDEF_H
#define __KERNEL_ASMDEF_H

#include <ARCH/CPUDEF.H>
#include <ARCH/SETUP.H>

#define NO_OF_IRQS		16
#define SIZEOF_IRQ_STUB 	48

#define SMALL_WHEEL_BITS	9
#define BIG_WHEEL_BITS		8

#define SMALL_WHEEL_SIZE	(1 << SMALL_WHEEL_BITS)
#define BIG_WHEEL_SIZE		(1 << BIG_WHEEL_BITS)

#if __KERNEL_USE_PAE == 0
#define PROC2PGTBL	0
#else
#define PROC2PGTBL	(1024 * 16)
#endif

#define SYSCALL_SHIFT	24
#define N_SYSCALLS	(1 << (32 - SYSCALL_SHIFT))

#define EFLAGS_LEAVE	(EFLAGS_CF | EFLAGS_PF | EFLAGS_AF | EFLAGS_ZF | EFLAGS_SF | EFLAGS_TF | EFLAGS_DF | EFLAGS_OF | EFLAGS_RF | EFLAGS_AC | EFLAGS_ID)
#define EFLAGS_SET	(EFLAGS_ONE | EFLAGS_IF)

#endif
