#include <SPAD/LIBC.H>
#include <ARCH/IO.H>
#include <SPAD/VM.H>
#include <SPAD/CONSOLE.H>
#include <STRING.H>
#include <SYS/TYPES.H>
#include <SPAD/SYSLOG.H>
#include <KERNEL/ASM.H>

#include <KERNEL/CONSOLE.H>

/*
#define __BOCHS__
*/

/* size must be power of 2, otherwise you can change it */
volatile char KERNEL$CONSOLE_BUFFER[16384] = { 0 };

__const__ unsigned KERNEL$CONSOLE_BUFFER_SIZE = sizeof KERNEL$CONSOLE_BUFFER;

volatile unsigned long KERNEL$CONSOLE_BUFFER_PTR;

__u16 *KERNEL$CONSOLE_ADDR;
int KERNEL$CONSOLE_PORT;

int KERNEL$CONSOLE_COLUMNS, KERNEL$CONSOLE_LINES;

volatile unsigned KERNEL$CONSOLE_X, KERNEL$CONSOLE_Y;

int KERNEL$CONSOLE_GFX;

static IO_RANGE iorange;

static __finline__ void SET_CURSOR(void)
{
	__u8 orig_port;
	int val = (KERNEL$CONSOLE_X >= KERNEL$CONSOLE_COLUMNS ? KERNEL$CONSOLE_COLUMNS - 1 : KERNEL$CONSOLE_X) + KERNEL$CONSOLE_Y * KERNEL$CONSOLE_COLUMNS;
	orig_port = io_inb_p(KERNEL$CONSOLE_PORT);
	io_outb_p(KERNEL$CONSOLE_PORT, 0x0e);
	io_outb_p(KERNEL$CONSOLE_PORT + 1, val >> 8);
	io_outb_p(KERNEL$CONSOLE_PORT, 0x0f);
	io_outb_p(KERNEL$CONSOLE_PORT + 1, val);
	io_outb_p(KERNEL$CONSOLE_PORT, orig_port);
}

void CONSOLE_INIT(void)
{
	int r;
	unsigned val;
	int intstate = KERNEL$SAVE_INT_STATE();
	memset((char *)KERNEL$CONSOLE_BUFFER, 0, sizeof KERNEL$CONSOLE_BUFFER);
	KERNEL$CONSOLE_BUFFER_PTR = 0;
	KERNEL$DI();
	KERNEL$CONSOLE_ADDR = (void *)(*(__u8 *)(KERNEL$ZERO_BANK + 0x449) == 7 ? KERNEL$ZERO_BANK + 0xb0000 : KERNEL$ZERO_BANK + 0xb8000);
	KERNEL$CONSOLE_PORT = *(__u8 *)(KERNEL$ZERO_BANK + 0x449) == 7 ? 0x3b4 : 0x3d4;
	KERNEL$CONSOLE_COLUMNS = *(__u16 *)(KERNEL$ZERO_BANK + 0x44a);
	KERNEL$CONSOLE_LINES = *(__u8 *)(KERNEL$ZERO_BANK + 0x484) + 1;
	if (!KERNEL$CONSOLE_LINES || KERNEL$CONSOLE_LINES == 1) KERNEL$CONSOLE_LINES = 25;
	if (!KERNEL$CONSOLE_COLUMNS || KERNEL$CONSOLE_COLUMNS == 1) KERNEL$CONSOLE_COLUMNS = 80;
	iorange.start = KERNEL$CONSOLE_PORT;
	iorange.len = 8;
	iorange.name = "CONSOLE";
	if (__unlikely(r = KERNEL$REGISTER_IO_RANGE(&iorange))) {
		__critical_printf("CAN'T REGISTER CONSOLE IO RANGE "IO_FORMAT" - "IO_FORMAT": %s\n", iorange.start, iorange.start + iorange.len - 1, strerror(-r));
		HALT_KERNEL();
	}
	io_outb_p(KERNEL$CONSOLE_PORT, 0x0e);
	val = io_inb_p(KERNEL$CONSOLE_PORT + 1) << 8;
	io_outb_p(KERNEL$CONSOLE_PORT, 0x0f);
	val |= io_inb_p(KERNEL$CONSOLE_PORT + 1);
	KERNEL$CONSOLE_X = 0;
	KERNEL$CONSOLE_Y = val / KERNEL$CONSOLE_COLUMNS % KERNEL$CONSOLE_LINES;
	if (!KERNEL$CONSOLE_Y) KERNEL$CONSOLE_Y = 1;
	SET_CURSOR();
	KERNEL$RESTORE_INT_STATE(intstate);
}

void CONSOLE_WRITE(__const__ char *str, int len)
{
#ifndef __BOCHS__
	int intstate = KERNEL$SAVE_INT_STATE();
	KERNEL$DI();
	while (len--) {
		unsigned char c = *str++;
		KERNEL$CONSOLE_BUFFER[KERNEL$CONSOLE_BUFFER_PTR++ & (KERNEL$CONSOLE_BUFFER_SIZE - 1)] = c;
		if (KERNEL$CONSOLE_GFX) continue;
		if (c == '\n' || KERNEL$CONSOLE_X >= KERNEL$CONSOLE_COLUMNS || KERNEL$CONSOLE_Y >= KERNEL$CONSOLE_LINES) {
			int i;
			int racing = 0;
			console_race:
			KERNEL$CONSOLE_X = 0;
			if (++KERNEL$CONSOLE_Y >= KERNEL$CONSOLE_LINES) {
				KERNEL$CONSOLE_Y = KERNEL$CONSOLE_LINES - 1;
				if (racing < 2) KERNEL$RESTORE_INT_STATE(intstate);
				memmove(KERNEL$CONSOLE_ADDR, KERNEL$CONSOLE_ADDR + KERNEL$CONSOLE_COLUMNS, KERNEL$CONSOLE_COLUMNS * (KERNEL$CONSOLE_LINES - 1) * 2);
				for (i = 0; i < KERNEL$CONSOLE_COLUMNS; i++)
					KERNEL$CONSOLE_ADDR[i + (KERNEL$CONSOLE_LINES - 1) * KERNEL$CONSOLE_COLUMNS] = 0x0720;
				/*memset(KERNEL$CONSOLE_ADDR + (KERNEL$CONSOLE_LINES - 1) * KERNEL$CONSOLE_COLUMNS, 0, KERNEL$CONSOLE_COLUMNS * 2);*/
				if (racing < 2) KERNEL$DI();
	/* test if someone messed with the screen while we were scrolling ...
	   race condition can mess the screen but it shouldn't cause access to
	   invalid memory.
	   Locking interrupts while scrolling causes inacceptable latency
	   (clicks in sound playback) */
				if (KERNEL$CONSOLE_X >= KERNEL$CONSOLE_COLUMNS || KERNEL$CONSOLE_Y >= KERNEL$CONSOLE_LINES) {
					racing++;
					goto console_race;
				}
			}
		}
		if (c != '\n') KERNEL$CONSOLE_ADDR[KERNEL$CONSOLE_X++ + KERNEL$CONSOLE_Y * KERNEL$CONSOLE_COLUMNS] = c | 0x7000;
		KERNEL$RESTORE_INT_STATE(intstate);
		KERNEL$DI();
	}
	if (!KERNEL$CONSOLE_GFX) SET_CURSOR();
	KERNEL$RESTORE_INT_STATE(intstate);
#else
	while (len--) io_outb(0xe9, *str++);
#endif
}


