#ifndef __KERNEL_DEV_OFF_H
#define __KERNEL_DEV_OFF_H

#include <ARCH/SETUP.H>
#include <KERNEL/VMDEF.H>

/* structure offsets for assembler. If you change layout of elements
   in any of these structures, you must fix offsets too, so that
   assembler code can access elements directly */

#define OFF_TIMER_fn			8
#define OFF_TIMER___time_lo		12
#define OFF_TIMER___time_hi		16

#define OFF_HANDLE_op			0

#define OFF_IORQ_fn			(0*4)
#define OFF_IORQ_tmp1			(1*4)
#define OFF_IORQ_tmp2			(2*4)
#define OFF_IORQ_tmp3			(3*4)
#define OFF_IORQ_status			(4*4)

#define OFF_SIORQ_h			(5*4)
#define OFF_SIORQ_v_ptr			(6*4)
#define OFF_SIORQ_v_len			(8*4)
#define OFF_SIORQ_v_vspace		(9*4)
#define OFF_SIORQ_progress		(10*4)
#define OFF_SIORQ_handle		(11*4)

#define OFF_AIORQ_h			(5*4)
#define OFF_AIORQ_v_ptr			(6*4)
#define OFF_AIORQ_v_len			(8*4)
#define OFF_AIORQ_v_vspace		(9*4)
#define OFF_AIORQ_pos			(10*4)
#define OFF_AIORQ_progress		(12*4)
#define OFF_AIORQ_handle		(13*4)

#define OFF_IOCTLRQ_h			(5*4)
#define OFF_IOCTLRQ_v_ptr		(6*4)
#define OFF_IOCTLRQ_v_len		(8*4)
#define OFF_IOCTLRQ_v_vspace		(9*4)
#define OFF_IOCTLRQ_ioctl		(10*4)
#define OFF_IOCTLRQ_param		(11*4)
#define OFF_IOCTLRQ_handle		(12*4)

#define OFF_BIORQ_h			(5*4)
#define OFF_BIORQ_handle		(6*4)

#define OFF_PACKET_h			(5*4)
#define OFF_PACKET_handle		(6*4)

#define OFF_HANDLE_OPERATIONS_read	(21*4)
#define OFF_HANDLE_OPERATIONS_write	(22*4)
#define OFF_HANDLE_OPERATIONS_aread	(23*4)
#define OFF_HANDLE_OPERATIONS_awrite	(24*4)
#define OFF_HANDLE_OPERATIONS_ioctl	(25*4)
#define OFF_HANDLE_OPERATIONS_bio	(26*4)
#define OFF_HANDLE_OPERATIONS_pktio	(27*4)

#define OFF_CLOSERQ_h			(5*4)
#define OFF_CLOSERQ_handle		(6*4)

#if !__KERNEL_USE_PAE
#define OFF_PROC			(4096 + (IOBMP_PAGES + LDT_PAGES) * 4)
#define SIZEOF_PROC_ALIGNED		(8192 + 4096)
#else
#define OFF_PROC			(4096 * 4 + 8 * 4 + (IOBMP_PAGES + LDT_PAGES) * 4)
#define SIZEOF_PROC_ALIGNED		(8192 + 16384)
#endif

#define OFF_PROC_vspace			(OFF_PROC + 0)

#define ARCH_CHECK_OFFSETS			\
	CHECK_OFFSET(TIMER, __time_lo);		\
	CHECK_OFFSET(TIMER, __time_hi);

#endif
