#include <STRING.H>
#include <SPAD/LIBC.H>
#include <ARCH/CPU.H>

#include <KERNEL/FIXUP.H>

__asm__("						\n\
	.SECTION .rodata				\n\
	.ALIGN	4					\n\
	.GLOBAL	aligns					\n\
aligns:							\n\
	.LONG	align_0, align_1, align_2, align_3	\n\
	.LONG	align_4, align_5, align_6, align_7	\n\
	.LONG	align_8, align_9, align_10, align_11	\n\
	.LONG	align_12, align_13, align_14, align_15	\n\
	.LONG	align_16, align_17			\n\
	.PREVIOUS					\n\
align_0:						\n\
align_1:						\n\
	NOP						\n\
align_2:						\n\
	MOVL	%EDI, %EDI				\n\
align_3:						\n\
	.BYTE	0x8d, 0x7f, 0x00			\n\
align_4:						\n\
	MOVL	%ESI, %ESI				\n\
	MOVL	%EDI, %EDI				\n\
align_5:						\n\
	MOVL	%EAX, KERNEL$LIST_END			\n\
align_6:						\n\
	.BYTE	0x8d, 0xbf				\n\
	.LONG	0					\n\
align_7:						\n\
	MOVW	%DI, KERNEL$LIST_END			\n\
align_8:						\n\
	MOVL	%ESI, %ESI				\n\
	.BYTE	0x8d, 0xbf				\n\
	.LONG	0					\n\
align_9:						\n\
	MOVW	$0, KERNEL$LIST_END			\n\
align_10:						\n\
	MOVL	$0, KERNEL$LIST_END			\n\
align_11:						\n\
	MOVL	$0, KERNEL$LIST_END			\n\
	NOP						\n\
align_12:						\n\
	.BYTE	0x8d, 0xb6				\n\
	.LONG	0					\n\
	.BYTE	0x8d, 0xbf				\n\
	.LONG	0					\n\
align_13:						\n\
	.BYTE	0x8d, 0xbf				\n\
	.LONG	0					\n\
	MOVW	%SI, KERNEL$LIST_END			\n\
align_14:						\n\
	MOVW	%DI, KERNEL$LIST_END			\n\
	MOVW	%SI, KERNEL$LIST_END + 2		\n\
align_15:						\n\
	.BYTE	0x8d, 0xbf				\n\
	.LONG	0					\n\
	MOVW	$0, KERNEL$LIST_END			\n\
align_16:						\n\
	.BYTE	0x8d, 0xbf				\n\
	.LONG	0					\n\
	MOVL	$0, KERNEL$LIST_END			\n\
align_17:						\n\
");

extern __const__ __u8 * __const__ aligns[18];

void FIXUP_FEATURES(struct feature_fixup *f, struct feature_fixup *end)
{
	if (__unlikely(KERNEL$KERNEL)) {
		int i;
		for (i = 0; i < 17; i++) if (__unlikely(aligns[i] + i != aligns[i + 1]))
			KERNEL$SUICIDE("FIXUP FEATURES: BAD ALIGNS");
	}
	for (; f != end; f++) {
		if (__unlikely(f->end2 - f->start2 > f->end1 - f->start1) || __unlikely((f->must_set & f->must_not_set) != 0) || !f->start1 || !f->start2 || !f->end1 || !f->end2)
			KERNEL$SUICIDE("BAD FEATURE FIXUP %p-%p %p-%p %X %X %X %X", f->start1, f->end1, f->start2, f->end2, f->must_set, f->must_set_2, f->must_not_set, f->must_not_set_2);
		if ((KERNEL$CPU_FEATURES & f->must_set) == f->must_set && (0 & f->must_set_2) == f->must_set_2 && (KERNEL$CPU_FEATURES & f->must_not_set) == 0 && (0 & f->must_not_set_2) == 0) {
			__u8 *padptr;
			unsigned padlen;
			memmove(f->start1, f->start2, f->end2 - f->start2);
			padptr = f->start1 + (f->end2 - f->start2);
			padlen = (f->end1 - f->start1) - (f->end2 - f->start2);
			if (padlen >= 17) {
				padptr[0] = 0xeb;
				padptr[1] = padlen - 2;
				memset(padptr + 2, 0x90, padlen - 2);
			} else {
				memcpy(padptr, aligns[padlen], padlen);
			}
		}
	}
}

