#ifndef __KERNEL_TIME_H
#define __KERNEL_TIME_H

#include <ARCH/CPU.H>
#include <ARCH/BSF.H>
#include <SYS/TYPES.H>
#include <ARCH/SCHED.H>
#include <SYS/TIME.H>

#include <ARCH/TIME.H>

void TIMER_INIT(void);

extern volatile unsigned TIME_TICKS_SINCE_SECOND;
extern volatile time_t TIME_SEC;
extern volatile short int TIME_MINUTESWEST;
extern volatile int TIME_DST;

extern volatile jiffies_t __JIFFIES;

static __finline__ jiffies_lo_t GET_JIFFIES_LO(void)
{
	return *(volatile jiffies_lo_t *)(void *)&__JIFFIES;
}

static __finline__ jiffies_t GET_JIFFIES(void)
{
	return KERNEL$GET_JIFFIES();
}

static __finline__ void INC_JIFFIES_LO(void)
{
	(*(u_jiffies_lo_t *)(void *)&__JIFFIES) += KERNEL$JIFFIES_STEP;
}

static __finline__ void INC_JIFFIES(void)
{
	__JIFFIES += KERNEL$JIFFIES_STEP;
}

extern sched_unsigned FINE_TICKS_PER_MINUTE;

#define _FINE_TICKS_SHIFT_WITHOUT_TSC	(__BSR_CONST(70000000 / (JIFFIES_PER_SECOND * 60)) + 1)

static __finline__ sched_unsigned GET_FINE_TICKS(void)
{
	long t;
	__asm__ volatile ("				\n\
		.SECTION .FEATURE_FIXUP			\n\
		.LONG	41f, 42f, 43f, 44f, 0, 0, "__stringify(CPU_HAS_TSC)", 0\n\
		.PREVIOUS				\n\
	41:						\n\
		MOVL	IRQ_RDTSC, %%EAX		\n\
		TESTL	%%EAX, %%EAX			\n"
#ifndef __NO_ASM_PREDICTIONS
"		JNE,pt	0f				\n"
#else
"		JNE	0f				\n"
#endif
"		RDTSC					\n\
		SHRDL	$0x1f, %%EDX, %%EAX		\n\
	0:	MOVL	$0, IRQ_RDTSC			\n\
	42:						\n\
		.SECTION .FINE_TICKS_FIXUP		\n\
		.LONG	0b - 1				\n\
		.PREVIOUS				\n\
		.SECTION .rodata			\n\
	43:						\n\
		MOVL	__JIFFIES, %%EAX		\n\
		SHLL	%b1, %%EAX			\n\
	44:						\n\
		.PREVIOUS				\n\
		":"=a"(t):"cn"(_FINE_TICKS_SHIFT_WITHOUT_TSC):"dx","cc");
	return t;
}

int GET_TIME_OF_DAY(struct timeval *tv);
time_t GET_TIME_SEC(void);

static __finline__ void ARCH_UPDATE_TIME(void)
{
	unsigned __tmp1;
	unsigned t = TIME_TICKS_SINCE_SECOND;
	if (__unlikely((t += KERNEL$JIFFIES_STEP) >= JIFFIES_PER_SECOND)) {
		TIME_TICKS_SINCE_SECOND = 0;
		TIME_SEC++;
	} else {
		TIME_TICKS_SINCE_SECOND = t;
	}
	__asm__ volatile ("				\n\
		.SECTION .FEATURE_FIXUP			\n\
		.LONG	41f, 42f, 42f, 42f, 0, 0, "__stringify(CPU_HAS_TSC)", 0\n\
		.PREVIOUS				\n\
	41:						\n\
		MOVL	IRQ_RDTSC, %0			\n\
		MOVL	%0, LAST_FINE_TICKS		\n\
	42:						\n\
		":"=r"(__tmp1):);
}

#endif
