#ifndef __KERNEL_UACCESS_H
#define __KERNEL_UACCESS_H

#include <SYS/TYPES.H>
#include <SPAD/AC.H>
#include <SPAD/PROC.H>

/* return: < 0 -- err, rq ASTed, == 0 -- ok, rq not touched, 1 -- rq queued */
int VM_FAULT(PROC *proc, void *addr, int wr, IORQ *rq); /* wr is PF_xxx */

#define uread_8(proc, address, var, fault_op)				\
do {									\
	int flt;							\
	__asm__ ("CALL _UREAD8":"=a"(flt),"=d"(var):"a"(proc),"d"(address):"cc");\
	if (__unlikely(flt)) { fault_op; }				\
} while (0)

#define uwrite_8(proc, address, var, fault_op)				\
do {									\
	int flt;							\
	__asm__ volatile ("CALL _UWRITE8":"=a"(flt):"a"(proc),"d"(address),"c"(var):"cc");\
	if (__unlikely(flt)) { fault_op; }				\
} while (0)

#define uread_32(proc, address, var, fault_op)				\
do {									\
	int flt;							\
	__asm__ ("CALL _UREAD32":"=a"(flt),"=d"(var):"a"(proc),"d"(address):"cc");\
	if (__unlikely(flt)) { fault_op; }				\
} while (0)

#define uwrite_32(proc, address, var, fault_op)				\
do {									\
	int flt;							\
	__asm__ volatile ("CALL _UWRITE32":"=a"(flt):"a"(proc),"d"(address),"c"(var):"cc");\
	if (__unlikely(flt)) { fault_op; }				\
} while (0)

#define uread_64(proc, address, var, fault_op)				\
do {									\
	int flt;							\
	__asm__ ("CALL _UREAD64":"=a"(flt):"a"(proc),"d"(address),"c"(&var):"cc","memory");\
	if (__unlikely(flt)) { fault_op; }				\
} while (0)

#define uwrite_64(proc, address, var, fault_op)				\
do {									\
	int flt;							\
	__asm__ volatile ("CALL _UWRITE64":"=a"(flt):"a"(proc),"d"(address),"c"(&var):"cc","memory");\
	if (__unlikely(flt)) { fault_op; }				\
} while (0)

/* usage:
Reads until end of string of sep. Skips characters==sep at the beginning.
If sep==0, it reads the whole string.
end_address points to the end of string or char with separator.
If fault_op is executed, end_address is fault address.
If __IS_ERR(end_address) is valid, there was error (-ENAMETOOLONG)
*/

#define uread_str(proc, address, dest, maxlen, sep, end_address, fault_op)\
do {									\
	int flt;							\
	__asm__ ("							\n\
1:	CALL	_UREAD_STR						\n\
	JC	2f							\n\
.SECTION .text.end							\n\
2:	JMP	1b							\n\
.PREVIOUS								\n\
":"=S"(end_address),"=D"(flt):"b"(proc),"S"(address),"D"(dest),"d"(sep),"c"((address) + (maxlen) - 1):"ax","cc","memory");\
	if (__unlikely(flt)) { fault_op; }				\
} while (0)

/* usage:
Writes src into dest in process.
On fault calls fault_op and sets fault
*/

#define uwrite_str(proc, dest, src, fault, fault_op)			\
do {									\
	long _dummy1;							\
	__asm__ volatile ("						\n\
1:	CALL	_UWRITE_STR						\n\
	JC	2f							\n\
.SECTION .text.end							\n\
2:	JMP	1b							\n\
.PREVIOUS								\n\
":"=D"(fault),"=S"(_dummy1):"b"(proc),"S"(src),"D"(dest):"ax","cc","memory");\
	if (__unlikely((fault) != 0)) { fault_op; }			\
} while (0)

int _UTEST_BYTE(PROC *p, void *addr, int wr);
#define utest_access _UTEST_BYTE

#define uread_char	uread_8
#define uwrite_char	uwrite_8
#define uread_int	uread_32
#define uwrite_int	uwrite_32
#define uread_long	uread_32
#define uwrite_long	uwrite_32
#define uread_ptr	uread_32
#define uwrite_ptr	uwrite_32
#define uread_size_t	uread_32
#define uwrite_size_t	uwrite_32
#if defined(__OFF_T_64)
#define uread_off_t	uread_64
#define uwrite_off_t	uwrite_64
#elif defined(__OFF_T_32)
#define uread_off_t	uread_32
#define uwrite_off_t	uwrite_32
#else
bad off_t size !!
#endif
#if defined(__VOFF_T_64)
#define uread___voff_t	uread_64
#define uwrite___voff_t	uwrite_64
#elif defined(__VOFF_T_32)
#define uread___voff_t	uread_32
#define uwrite___voff_t	uwrite_32
#else
bad voff_t size !!
#endif

#endif
