#ifndef __KERNEL_VM_ARCH
#define __KERNEL_VM_ARCH

#include <SPAD/VM.H>
#include <KERNEL/VMDEF.H>
#include <KERNEL/ASM.H>
#include <ARCH/SETUP.H>
#include <ARCH/CPUDEF.H>
#include <SPAD/WQ.H>

void *VM_BOOT_INIT(void);
void VM_BOOT_GETMEM(unsigned long code_bottom, unsigned long free_later, unsigned long code_top, unsigned long data_bottom, unsigned long data_top, unsigned long mem_top);
void VM_BOOT_GET_MORE_MEM(void);

#define PBANK_CODE		1
#define PBANK_DATA		2
#define PBANK_ISADMA		4
#define PBANK_OTHER		8
#define PBANK_HIGHMEM		16
#define PBANK_NOPCIDMA		32

extern int PBANKS[];
extern int N_PBANKS;

extern PAGE KERNEL_PAGE_MAP[];

#define PAGE_2_PHYS(p) 		((__p_addr)(unsigned long)((char *)(p) - (char *)KERNEL_PAGE_MAP) << (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS - PG_SIZEOF_STRUCT_PAGE_BITS))
#define PHYS_2_PAGE_ALIGNED(a)	((PAGE *)((char *)KERNEL_PAGE_MAP + ((a) >> (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS - PG_SIZEOF_STRUCT_PAGE_BITS))))
#define PHYS_2_PAGE(a)		(KERNEL_PAGE_MAP + ((a) >> (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS)))

#define PAGE_2_VIRT(p)	((char *)(((char *)(p) - (char *)KERNEL_PAGE_MAP) << (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS - PG_SIZEOF_STRUCT_PAGE_BITS)) + VM_KERNEL_DIRECT_OFFSET)
#define VIRT_2_PAGE_ALIGNED(a)	((PAGE *)((char *)KERNEL_PAGE_MAP + (((unsigned long)(a) - VM_KERNEL_DIRECT_OFFSET) >> (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS - PG_SIZEOF_STRUCT_PAGE_BITS))))
#define VIRT_2_PAGE(a)	(KERNEL_PAGE_MAP + (((unsigned long)(a) - VM_KERNEL_DIRECT_OFFSET) >> (PG_SIZE_BITS + __KERNEL_CLUSTER_BITS)))

#define KMAP_PHYS_2_VIRT(P) ((void *)((unsigned long)(P) + (unsigned long)VM_KERNEL_DIRECT_BANK * PG_SIZE * PG_BANK))
#define KMAP_PAGE_2_VIRT(P) KMAP_PHYS_2_VIRT(PAGE_2_PHYS(P))

#define IS_PAGE_POINTER(p)	((unsigned long)(p) < VM_KERNEL_DIRECT_OFFSET)

extern char ZERO_PAD[];
#define ZERO_PAD_PHYS		((unsigned long)ZERO_PAD - VM_KERNEL_DIRECT_OFFSET)

#define CACHE_WBINVD()							\
do {									\
	__asm__ volatile ("WBINVD":::"memory");				\
} while (0)

#define CACHE_WBINVD_WHEN_NO_SELFSNOOP()				\
do {									\
	__asm__ volatile ("						\n\
	.SECTION .FEATURE_FIXUP						\n\
	.LONG	41f, 42f, 42f, 42f, "__stringify(CPU_HAS_SELF_SNOOP)", 0, 0, 0\n\
	.PREVIOUS							\n\
41:	WBINVD								\n\
42:									\n\
	":::"memory");							\
} while (0)

#define TLB_INVD_NG()							\
do {									\
	__asm__ volatile ("MOVL %0, %%CR3"::"r"((unsigned long)PROC_CURRENT + PROC2PGTBL - VM_KERNEL_DIRECT_OFFSET):"memory");\
} while (0)

#define TLB_INVD_G()							\
do {									\
	__u32 tmp1;							\
	__asm__ volatile ("						\n\
	.SECTION .FEATURE_FIXUP						\n\
	.LONG	41f, 42f, 43f, 44f, 0, 0, "__stringify(CPU_HAS_GLOBAL_PAGES)", 0\n\
	.PREVIOUS							\n\
41:									\n\
	MOVL	CR_4, %0						\n\
	ANDL	$~"__stringify(CR4_PGE)", %0				\n\
	MOVL	%0, %%CR4						\n\
	MOVL	%1, %%CR3						\n\
	ORL	$"__stringify(CR4_PGE)", %0				\n\
	MOVL	%0, %%CR4						\n\
42:									\n\
	.SECTION .rodata						\n\
43:									\n\
	MOVL    %1, %%CR3						\n\
44:									\n\
	.PREVIOUS							\n\
	":"=&r"(tmp1):"r"((unsigned long)PROC_CURRENT + PROC2PGTBL - VM_KERNEL_DIRECT_OFFSET):"cc","memory");\
} while (0)

#define TLB_INVD_PG(addr)						\
do {									\
	__asm__ volatile ("INVLPG %0"::"m"(*(char *)(addr)):"memory");	\
} while (0)

int VM_ARCH_NEW_PBANK(int type, AST *ast);
int VM_ARCH_CHECK_HW_MEM(PAGE *p);

void VM_ARCH_INIT_PAGETABLES(void);

WQ *VM_ARCH_MAP_PAGE(PROC *p, unsigned long addr, PAGE *page, int wr);
WQ *VM_ARCH_UNMAP_RANGE(PROC *p, unsigned long addr, unsigned long len);
WQ *VM_ARCH_READ_ONLY(PROC *p);
WQ *VM_ARCH_UNMAP_MAPPING(XLIST_HEAD *mapping);
WQ *VM_ARCH_CHECK_MAPPING(XLIST_HEAD *mapping, int unw);
PAGE *VM_ARCH_GET_PAGE(PROC *p, unsigned long addr, int wr);
void VM_ARCH_AFTER_FORK(PROC *p);

int VM_ADD_MEMORY_HOLE(__u64 h0, __u64 h1);

extern int FOLD_DL;

void VM_KERNEL_FAULT_EXCEPTION(void *addr, int flags, void *ip);
void SYSCALL_INVD_EXTD_PAGE(unsigned long sys, unsigned long idx, unsigned long arg3);

void FLUSH_FPU(void);	/* may be called only from top-level */

#endif
