#define _1U	1

#include <ARCH/SETUP.H>
#include <KERNEL/VMDEF.H>
#include <SPAD/SPLDEF.H>

#if __DEBUG >= 1
	.SECTION .rodata
SPL_ERR:.STRING "%s AT SPL %08X"
#define SPLVSPACEASSERT(s)						\
	CMPL	$0xffffffff << (SPL_VSPACE + 1), KERNEL$SPL		;\
	JNE	1f							;\
	.SECTION .rodata;						;\
2:	.STRING s							;\
	.SECTION .text.end						;\
1:	PUSHL	KERNEL$SPL						;\
	PUSHL	$2b							;\
	PUSHL	$SPL_ERR						;\
	CALL	KERNEL$SUICIDE						;\
	.SECTION .text
#else
#define SPLVSPACEASSERT(s)
#endif

	.GLOBAL	KERNEL$NULL_VSPACE_UNMAP
	.GLOBAL	KERNEL$NULL_VSPACE_DMAUNLOCK
	.GLOBAL	KERNEL$NULL_VSPACE_DMA64UNLOCK
	.GLOBAL	KERNEL$NULL_VSPACE_PHYSUNLOCK

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
NULL_CALL:
KERNEL$NULL_VSPACE_UNMAP:
KERNEL$NULL_VSPACE_DMAUNLOCK:
KERNEL$NULL_VSPACE_DMA64UNLOCK:
KERNEL$NULL_VSPACE_PHYSUNLOCK:
	SPLVSPACEASSERT("*_UNLOCK")
	RET

/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO PTR TO UNLOCK
 * OUT: %EAX - PTR
 *	%EDX - LEN
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	VIRTUAL_DMALOCK
VIRTUAL_DMALOCK:
	SPLVSPACEASSERT("VIRTUAL_DMALOCK")
	MOVL	$NULL_CALL, (%ECX)
	MOVL	8(%EAX), %EDX
	MOVL	(%EAX), %EAX
	SUBL	$VM_KERNEL_DIRECT_OFFSET, %EAX
	RET

/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO PTR TO UNMAP
 * OUT: %EAX - PTR
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	VIRTUAL_MAP
VIRTUAL_MAP:
	SPLVSPACEASSERT("VIRTUAL_MAP")
	MOVL	$NULL_CALL, (%ECX)
	MOVL	(%EAX), %EAX
	RET

/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO VDMA64
 *     4(%ESP) - PTR TO PTR TO UNLOCK
 * OUT: NOTHING
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	VIRTUAL_DMA64LOCK
	.GLOBAL	VIRTUAL_PHYSLOCK
VIRTUAL_DMA64LOCK:
VIRTUAL_PHYSLOCK:
	SPLVSPACEASSERT("VIRTUAL_DMA64LOCK")
	MOVL	$0, 4(%ECX)
	MOVL	8(%EAX), %EDX
	MOVL	(%EAX), %EAX
	MOVL	%EDX, 8(%ECX)
	SUBL	$VM_KERNEL_DIRECT_OFFSET, %EAX
	MOVL	%EAX, (%ECX)
	MOVL	4(%ESP), %ECX
	MOVL	$NULL_CALL, (%ECX)
	RET


/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO PTR TO UNLOCK
 * OUT: %EAX - PTR
 *	%EDX - LEN
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PHYSICAL_DMALOCK
PHYSICAL_DMALOCK:
	SPLVSPACEASSERT("PHYSICAL_DMALOCK")
#if KERNEL_BOUNCE_NEEDED == 1
	CMPL	$0, 4(%EAX)
	JNZ	1f
#endif
	MOVL	$NULL_CALL, (%ECX)
	MOVL	8(%EAX), %EDX
	MOVL	(%EAX), %EAX
	RET
#if KERNEL_BOUNCE_NEEDED == 1
1:	
	!!! FIXME
	not implemented
#endif

/*
 * IN: %EAX - PTR TO VDESC
 *     %EDX - RW
 *     %ECX - PTR TO VDMA64
 *     4(%ESP) - PTR TO PTR TO UNLOCK
 * OUT: NOTHING
 */
	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	PHYSICAL_DMA64LOCK
	.GLOBAL	PHYSICAL_PHYSLOCK
PHYSICAL_DMA64LOCK:
PHYSICAL_PHYSLOCK:
	SPLVSPACEASSERT("PHYSICAL_DMA64LOCK")
	MOVL	(%EAX), %EDX
	MOVL	%EDX, (%ECX)
	MOVL	4(%EAX), %EDX
	MOVL	%EDX, 4(%ECX)
	MOVL	8(%EAX), %EDX
	MOVL	%EDX, 8(%ECX)
	MOVL	4(%ESP), %ECX
	MOVL	$NULL_CALL, (%ECX)
	RET


