#include <SPAD/LIBC.H>
#include <STRING.H>
#include <SPAD/VM.H>
#include <ARCH/CPUDEF.H>
/*
#include <ARCH/SPINLOCK.H>
#include <SMP.H>
*/
#include <ARCH/IO.H>
#include <ARCH/IRQ.H>
#include <SPAD/AC.H>
#include <SPAD/DL.H>

#include <ARCH/BIOS16.H>

/*
SPINLOCK_T *bios_lock;
*/

extern unsigned long BIOS_STUB_ADDRESS;

extern unsigned long STUB_EAX, STUB_ECX, STUB_EDX, STUB_EBX, STUB_EBP, STUB_ESI, STUB_EDI;
extern unsigned short STUB_ES, STUB_DS, STUB_FS, STUB_GS;
extern unsigned char STUB_FLAGS;
extern unsigned char STUB_INT;
extern unsigned char STUB_SAVE_CR4;

extern unsigned char REAL_MODE_STUB[], REAL_MODE_STUB_END[], REAL_MODE_STUB_ENTRY[];

int BIOS16$REAL_INT(int intnum, struct bios_regs *regs, void *ptr, unsigned len, int flags)
{
	int clen;
	int pae, cr4;
	unsigned long pgd_phys;
	unsigned long *vpgd;
	unsigned long saved_zero_pointer;
	unsigned long saved_zero_pointer_2;
	if (__unlikely(!KERNEL$KERNEL)) return -EUSER;
	if (BIOS_STUB_ADDRESS + (REAL_MODE_STUB_END - REAL_MODE_STUB) > BIOS_PTR_BASE) KERNEL$SUICIDE("BIOS STUB TOO LARGE (END AT %08lX, DATA AT %08lX)", BIOS_STUB_ADDRESS + (REAL_MODE_STUB_END - REAL_MODE_STUB), BIOS_PTR_BASE);
	if (len >= BIOS_MAX_LEN) KERNEL$SUICIDE("BIOSCALL$REAL_INT: len == %d", len);
	clen = 0;

	__asm__ volatile ("				\n\
		PUSHL	%%EBX				\n\
		PUSHFL					\n\
		POPL	%%EAX				\n\
		XORL	%2, %%EAX			\n\
		PUSHL	%%EAX				\n\
		POPFL					\n\
		PUSHFL					\n\
		POPL	%%ECX				\n\
		XORL	%%ECX, %%EAX			\n\
		ANDL	%2, %%EAX			\n\
		JNZ	1f				\n\
		XORL	%%EAX, %%EAX			\n\
		CPUID					\n\
		TESTL	%%EAX, %%EAX			\n\
		JZ	1f				\n\
		MOVL	$1, %%EAX			\n\
		CPUID					\n\
		TESTL	%3, %%EDX			\n\
		JZ	3f				\n\
		MOVL	%%CR4, %%EAX			\n\
		TESTL	%4, %%EAX			\n\
		JZ	3f				\n\
		MOVL	$1, %%EAX			\n\
		MOVL	$1, %%EDX			\n\
		JMP	2f				\n\
	3:	TESTL	%4, %%EDX			\n\
		MOVL	$1, %%EDX			\n\
		JNZ	4f				\n\
	1:	XORL	%%EDX, %%EDX			\n\
	4:	XORL	%%EAX, %%EAX			\n\
	2:	POPL	%%EBX				\n\
	":"=a"(pae),"=d"(cr4):"i"(EFLAGS_ID),"i"(CPU_FEATURE_PAE),"i"(CR4_PAE),"i"(CPU_FEATURE_VME|CPU_FEATURE_DE|CPU_FEATURE_PSE|CPU_FEATURE_PAE|CPU_FEATURE_MCE|CPU_FEATURE_PGE):"cx","cc");
	__asm__ volatile ("MOVL	%%CR3, %0":"=r"(pgd_phys):);
	vpgd = KERNEL$MAP_PHYSICAL_BANK(pgd_phys);
	KERNEL$DI_HW();	/* if some jerk enables interrupts in real mode, we
		don't want to crash because of unexpected interrupt
		note: it does really happen --- Trident int 10h routine enables
		interrupts
		*/
	/* now we are mucking with page tables ... the rest of the kernel must not run !!! */
	if (flags & BIOS_DATA_PUT) memcpy((char *)KERNEL$ZERO_BANK + BIOS_PTR_BASE, ptr, len), clen = len;
	/*memset((char *)KERNEL$ZERO_BANK + BIOS_PTR_BASE + clen, 0, BIOS_MAX_LEN - clen);*/
	/*SPIN_LOCK(bios_lock);*/
	/* code needs to be in page with same physical and virtual address when enabling or disabling paging */
	if (__likely(!pae)) {
		saved_zero_pointer = vpgd[0];
		saved_zero_pointer_2 = 0;	/* useless, but the compiler complains about possibly uninitialized variable ... */
		vpgd[0] = vpgd[(unsigned)KERNEL$ZERO_BANK >> (PG_BANK_BITS + PG_SIZE_BITS)];
	} else {
		saved_zero_pointer = vpgd[1024];
		saved_zero_pointer_2 = vpgd[1025];
		vpgd[1024] = vpgd[1024 + ((unsigned)KERNEL$ZERO_BANK >> (PG_BANK_BITS + PG_SIZE_BITS)) * 2];
		vpgd[1025] = vpgd[1024 + ((unsigned)KERNEL$ZERO_BANK >> (PG_BANK_BITS + PG_SIZE_BITS)) * 2 + 1];
	}
	__asm__ volatile ("MOVL %%CR3, %%EAX; MOVL %%EAX, %%CR3":::"ax");
	memcpy((char *)KERNEL$ZERO_BANK + BIOS_STUB_ADDRESS, REAL_MODE_STUB, REAL_MODE_STUB_END - REAL_MODE_STUB);
	STUB_EAX = regs->eax;
	STUB_ECX = regs->ecx;
	STUB_EDX = regs->edx;
	STUB_EBX = regs->ebx;
	STUB_EBP = regs->ebp;
	STUB_ESI = regs->esi;
	STUB_EDI = regs->edi;
	STUB_ES = regs->es;
	STUB_DS = regs->ds;
	STUB_FS = regs->fs;
	STUB_GS = regs->gs;
	STUB_FLAGS = regs->flags;
	STUB_INT = intnum;
	STUB_SAVE_CR4 = cr4;
			/* GCC is buggy and cannot save %EBP register
			   it also can't save %EBX when compiled with -fPIC */
	__asm__ volatile ("PUSHL %%EBX; PUSHL %%EBP; CALL REAL_MODE_STUB_ENTRY; POPL %%EBP; POPL %%EBX":::"ax","cx","dx","si","di","cc","memory");
	regs->eax = STUB_EAX;
	regs->ecx = STUB_ECX;
	regs->edx = STUB_EDX;
	regs->ebx = STUB_EBX;
	regs->ebp = STUB_EBP;
	regs->esi = STUB_ESI;
	regs->edi = STUB_EDI;
	regs->es = STUB_ES;
	regs->ds = STUB_DS;
	regs->fs = STUB_FS;
	regs->gs = STUB_GS;
	regs->flags = STUB_FLAGS;
	if (__likely(!pae)) {
		vpgd[0] = saved_zero_pointer;
	} else {
		vpgd[1024] = saved_zero_pointer;
		vpgd[1025] = saved_zero_pointer_2;
	}
	__asm__ volatile ("MOVL %%CR3, %%EAX; MOVL %%EAX, %%CR3":::"ax");
	/* so ... page tables are back in consistent state and we can enable interrupts */
	if (flags & BIOS_DATA_GET) memcpy(ptr, (char *)KERNEL$ZERO_BANK + BIOS_PTR_BASE, len), clen = len;
	/*SPIN_UNLOCK(bios_lock);*/
	KERNEL$EI_HW();
	KERNEL$UNMAP_PHYSICAL_BANK(vpgd);
	return 0;
}

/*static SMPRQ s;*/
static DLINITRQ *dlrq;

extern AST_STUB LOCK_ALLOCATED;
extern AST_STUB LOCK_FREED;

/*
static void init_spinlock(void *p)
{
	SPIN_LOCK_INIT((SPINLOCK_T *)p);
}
*/

DECL_IOCALL(DLL$LOAD, SPL_DEV, DLINITRQ)
{
	dlrq = RQ;
/*
	s.fn = &LOCK_ALLOCATED;
	s.size = sizeof(SPINLOCK_T);
	s.name = "BIOSCALL.DLL$BIOS_SPIN_LOCK";
	s.ctor = &init_spinlock;
	s.dtor = NULL;
	RETURN_IORQ(&s, &KERNEL$GRAB_SHARED_AREA);
}

DECL_AST(LOCK_ALLOCATED, SPL_DEV, SMPRQ)
{
	if (s.status < 0) {
		_snprintf(dlrq->error, __MAX_STR_LEN, "FAILED TO ALLOCATE SHARED LOCK");
		dlrq->status = RQ->status;
		RETURN_IORQ(dlrq, &KERNEL$DL_LOAD_CANCEL);
	}
	bios_lock = s.ptr;*/
	dlrq->status = 0;
	RETURN_AST(dlrq);
}

DECL_IOCALL(DLL$UNLOAD, SPL_DEV, DLINITRQ)
{
	dlrq = RQ;
	/*
	s.fn = &LOCK_FREED;
	RETURN_IORQ(&s, &KERNEL$RELEASE_SHARED_AREA);
}

DECL_AST(LOCK_FREED, SPL_DEV, SMPRQ)
{*/
	dlrq->status = 0;
	RETURN_AST(dlrq);
}


