#include <SYS/TYPES.H>
#include <ERRNO.H>
#include <SPAD/SYSLOG.H>
#include <SPAD/VM.H>

#include <ARCH/BIOS32.H>

/* based on linux/arch/i386/kernel/pci-pc.c (c) 1999--2000 Martin Mares <mj@suse.cz> */

struct bios32_entry {
	__u32 signature;
	__u32 entry;
	__u8 revision;
	__u8 length;
	__u8 checksum;
	__u8 reserved[5];
};

#define BIOS32_SIGNATURE	(('_' << 0) + ('3' << 8) + ('2' << 16) + ('_' << 24))

static struct bios32_entry *entr = NULL;
static unsigned long call = -1;

int BIOS32$ENTRY(unsigned long name, unsigned long *addr)
{
	unsigned char return_code;	/* %al */
	unsigned long address;		/* %ebx */
	unsigned long length;		/* %ecx */
	unsigned long entry;		/* %edx */
	if (__unlikely(!KERNEL$KERNEL)) return -EUSER;
	if (call == -1) {
		struct bios32_entry *e;
		for (e = (struct bios32_entry *)(KERNEL$ZERO_BANK + 0xe0000); e <= (struct bios32_entry *)(KERNEL$ZERO_BANK + 0xffff0); e++) {
			__u8 sum;
			int i;
			if (e->signature != BIOS32_SIGNATURE) continue;
			if (!e->length /*|| e->length >= 0x10000*/ || (char *)e + e->length * 16 > (char *)(KERNEL$ZERO_BANK + 0x100000)) continue;
			sum = 0;
			for (i = 0; i < e->length * 16; i++) sum += ((char *)e)[i];
			if (sum) continue;
			if (e->revision) {
				KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, "BIOS32", "UNSUPPORTED REVISION %d AT 0x%08lX", (int)e->revision, (unsigned long)e);
				continue;
			}
			if (e->entry >= 0x100000) {
				KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, "BIOS32", "ENTRY IN HIGH MEMORY (0x%08lX) - I DON'T KNOW WHAT TO DO WITH IT", (unsigned long)e);
				continue;
			}
			entr = e;
			call = (unsigned long)KERNEL$ZERO_BANK + e->entry;
			goto ok;
		}
		return -ENODEV;
	}
	ok:
	/*__debug_printf("BIOS32 ENTRY: %08lX\n", call);*/
	__asm__ volatile("		\n\
		xchgl	%%ebx, %%esi	\n\
		pushfl			\n\
		cli			\n\
		pushl	%%cs		\n\
		call	*%%edi		\n\
		popfl			\n\
		xchgl	%%ebx, %%esi	\n\
	" : "=a"(return_code), "=S"(address), "=c"(length), "=d"(entry)
	: "0" (name), "1" (0), "D" (call));
	/*__debug_printf("RETURNED ENTRY FOR %08lX: %08lX + %08lX\n", name, address, entry);*/
	address += entry;
	if (!return_code) {
		if (address >= 0x100000) {
			KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, "BIOS32", "RETURNED ENTRY IN HIGH MEMORY (0x%08lX) - I DON'T KNOW WHAT TO DO WITH IT", address);
			return -EINVAL;
		}
		*addr = (unsigned long)KERNEL$ZERO_BANK + address;
		return 0;
	}
	if (return_code == 0x80) return -ENOENT;
	KERNEL$SYSLOG(__SYSLOG_HW_BUG, "BIOS32", "RETURNED 0x%02X", (int)return_code);
	return -EINVAL;
}
