#include <SPAD/AC.H>
#include <ARCH/IO.H>
#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>
#include <SPAD/DL.H>

#include <SPAD/CMOS.H>

/* !!! SMPFIX: lock for other cpus */

static IO_RANGE range;

int CMOS$READ(__u8 addr)
{
	int r;
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DMA), spl)))
		KERNEL$SUICIDE("CMOS_READ AT SPL %08X", spl);
	RAISE_SPL(SPL_DMA);
	io_outb_p(0x70, addr);
	r = io_inb_p(0x71);
	LOWER_SPLX(spl);
	return r;
}

int CMOS$WRITE(__u8 addr, __u8 val)
{
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DMA), spl)))
		KERNEL$SUICIDE("CMOS_WRITE AT SPL %08X", spl);
	RAISE_SPL(SPL_DMA);
	io_outb_p(0x70, addr);
	io_outb_p(0x71, val);
	LOWER_SPLX(spl);
	return 0;
}

DECL_IOCALL(DLL$LOAD, SPL_DEV, DLINITRQ)
{
	int r;
	range.start = 0x70;
	range.len = 2;
	range.name = "CMOS";
	if (__unlikely(r = KERNEL$REGISTER_IO_RANGE(&range))) {
		_snprintf(RQ->error, __MAX_STR_LEN, "CAN'T REGISTER CMOS PORT RANGE: %s", strerror(-r));
		RQ->status = r;
		RETURN_AST(RQ);
	}
	RQ->status = 0;
	RETURN_AST(RQ);
}

DECL_IOCALL(DLL$UNLOAD, SPL_DEV, DLINITRQ)
{
	KERNEL$UNREGISTER_IO_RANGE(&range);
	RQ->status = 0;
	RETURN_AST(RQ);
}
