#include <SPAD/VM.H>
#include <SYS/MMAN.H>
#include <STDLIB.H>
#include <STRING.H>
#include <ARCH/CPU.H>
#include <LIB/KERNEL/UASM.H>

#define UNBLOCK_CODE_SIZE	(4 + 12)

struct ___thread {
	THREAD_ENTRIES_1
	void *esp;
	unsigned long altstack;
	unsigned long altstack_size;
#ifdef ALWAYS_SAVE_FPU
		/* FPU save/restore on thread switch is not needed, because
		   at function entries, FPU is always in sane state with
		   empty stack */
	char *fpu_state;
#endif
	THREAD_ENTRIES_2
	void *stack_base;
	size_t stack_len;
#ifdef ALWAYS_SAVE_FPU
	char fpu_state_data[512 + FPU_ALIGN - 1];
#endif
	char unblock_code[UNBLOCK_CODE_SIZE];
};

int SWITCH_THREAD(THREAD *t);
void END_THREAD(THREAD *t, THREAD_RQ *rq, void *thread);

static unsigned long stacksize = 2 * 1024 * 1024;

int KERNEL$SET_THREAD_STACK_SIZE(size_t size)
{
	if (__unlikely(!size)) return -EINVAL;
	stacksize = (size + PAGE_CLUSTER_SIZE + PAGE_CLUSTER_SIZE - 1) & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1);
	return 0;
}

size_t KERNEL$GET_THREAD_STACK_SIZE(void)
{
	return stacksize;
}

extern AST_STUB __UNBLOCK;

static THREAD *ALLOC_THREAD(void)
{
	int e;
	THREAD *t;
	void *stack;
	stack = mmap(NULL, stacksize, PROT_NONE, MAP_PRIVATE | MAP_ANONYMOUS | _MAP_IMMEDIATE, -1, 0);
	if (__unlikely(__IS_ERR(stack))) return stack;
	if (__unlikely(e = mprotect((char *)stack + PAGE_CLUSTER_SIZE, stacksize - PAGE_CLUSTER_SIZE, PROT_READ | PROT_WRITE | _MAP_IMMEDIATE))) {
		unm:
		munmap(stack, stacksize);
		return __ERR_PTR(e);
	}
	if (__unlikely(!(t = malloc(sizeof(THREAD))))) {
		e = -ENOMEM;
		goto unm;
	}
	memset(t, 0, sizeof(THREAD));
	t->unblock_fn = (AST_STUB *)((char *)t->unblock_code + 4);
	*(__u32 *)((char *)t->unblock_code) = SPL_THREAD;
	*(__u32 *)((char *)t->unblock_code + 4) = 0x0840c7 | ((__u32)t << 24);
	*(__u32 *)((char *)t->unblock_code + 8) = ((__u32)t >> 8) | 0xe9000000;
	*(__u32 *)((char *)t->unblock_code + 12) = (__u32)__UNBLOCK - ((__u32)t->unblock_code + 16);
	t->stack_base = stack;
	t->stack_len = stacksize;
	t->esp = (char *)stack + stacksize - __CPU_MAX_ALIGN - 24;
#ifdef ALWAYS_SAVE_FPU
	t->fpu_state = (char *)((unsigned long)(t->fpu_state_data + FPU_ALIGN - 1) & ~(unsigned long)(FPU_ALIGN - 1));
	INIT_FPU(t->fpu_state, 0);
#endif
	*((void **)t->esp + 5) = START_THREAD;
	ADD_TO_XLIST(&udata.all_threads, &t->all_threads);
	return t;
}

void FREE_THREAD(THREAD *t);
void FREE_THREAD(THREAD *t)
{
	DEL_FROM_LIST(&t->all_threads);
	munmap(t->stack_base, t->stack_len);
	free(t);
}

void THREAD_UPDATE_ALTSTACK(void)
{
	THREAD *t = udata.current_thread;
	t->altstack = altstack;
	t->altstack_size = altstack_size;
}

static __finline__ void MD_THREAD_INIT(THREAD *t)
{
	if (THREAD_ESP != (int)(unsigned long)&((THREAD *)NULL)->esp) KERNEL$SUICIDE("MD_THREAD_INIT: THREAD_ESP == %d, SHOULD BE %d", THREAD_ESP, (int)(unsigned long)&((THREAD *)NULL)->esp);
#ifdef ALWAYS_SAVE_FPU
	if (THREAD_FPU != (int)(unsigned long)&((THREAD *)NULL)->fpu_state) KERNEL$SUICIDE("MD_THREAD_INIT: THREAD_FPU == %d, SHOULD BE %d", THREAD_FPU, (int)(unsigned long)&((THREAD *)NULL)->fpu_state);
#endif
	if (THREAD_ALTSTACK != (int)(unsigned long)&((THREAD *)NULL)->altstack) KERNEL$SUICIDE("MD_THREAD_INIT: THREAD_ALTSTACK == %d, SHOULD BE %d", THREAD_ALTSTACK, (int)(unsigned long)&((THREAD *)NULL)->altstack);
	if (THREAD_ALTSTACK_SIZE != (int)(unsigned long)&((THREAD *)NULL)->altstack_size) KERNEL$SUICIDE("MD_THREAD_INIT: THREAD_ALTSTACK_SIZE == %d, SHOULD BE %d", THREAD_ALTSTACK_SIZE, (int)(unsigned long)&((THREAD *)NULL)->altstack_size);
	INIT_XLIST(&udata.all_threads);
	ADD_TO_XLIST(&udata.all_threads, &t->all_threads);
#ifdef ALWAYS_SAVE_FPU
	t->fpu_state = (char *)((unsigned long)(t->fpu_state_data + FPU_ALIGN - 1) & ~(unsigned long)(FPU_ALIGN - 1));
#endif
	t->unblock_fn = INIT_THREAD_UNBLOCK;
	/*t->altstack = 0;
	t->altstack_size = 0;*/
#ifdef ALWAYS_SAVE_FPU
	INIT_FPU(t->fpu_state, 0);
#endif
}

void THREAD_FORK(void)
{
	THREAD *t;
	XLIST_FOR_EACH(t, &udata.all_threads, THREAD, all_threads) {
		if (__unlikely(t != udata.current_thread)) {
			if (t->sleep == S_READY) {
				DEL_FROM_LIST(&t->run_list);
			}
			*((long *)t->esp + 4) = 1;
			t->sleep = S_DEAD;
		}
	}
	INIT_XLIST(&udata.all_threads);
	ADD_TO_XLIST(&udata.all_threads, &udata.current_thread->all_threads);
}
