#include <ARCH/SETUP.H>
#include <SPAD/ERRNODEF.H>
#include <KERNEL/DEV_OFF.H>
#include <KERNEL/SYSDEF.H>
#include <KERNEL/UDATADEF.H>
#include <SPAD/SPLDEF.H>
#include <ARCH/ACDEF.H>

	.GLOBAL	KERNEL$PROC_KERNEL
KERNEL$PROC_KERNEL = -1

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$AWRITE
KERNEL$AWRITE:
	MOVL	(%EAX), %EDX
	MOVL	$SYS_AWRITE, %ECX
	MOVL	-4(%EDX), %EDX
.IF KERNEL_CALL_AWRITE <> 0
	ORL	$KERNEL_CALL_AWRITE << 5, %EDX
.ENDIF
	ORL	$0, OFF_AIORQ_progress(%EAX)	/* probe write access */
	JMP	do_io

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$AREAD
KERNEL$AREAD:
	MOVL	(%EAX), %EDX
	MOVL	$SYS_AREAD, %ECX
	MOVL	-4(%EDX), %EDX
.IF KERNEL_CALL_AREAD <> 0
	ORL	$KERNEL_CALL_AREAD << 5, %EDX
.ENDIF
	ORL	$0, OFF_AIORQ_progress(%EAX)	/* probe write access */
	JMP	do_io

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$IOCTL
KERNEL$IOCTL:
	MOVL	(%EAX), %EDX
	MOVL	$SYS_IOCTL, %ECX
	MOVL	-4(%EDX), %EDX
.IF KERNEL_CALL_IOCTL <> 0
	ORL	$KERNEL_CALL_IOCTL << 5, %EDX
.ENDIF
	JMP	do_io

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WRITE
KERNEL$WRITE:
	MOVL	(%EAX), %EDX
	MOVL	$SYS_WRITE, %ECX
	MOVL	-4(%EDX), %EDX
.IF KERNEL_CALL_WRITE <> 0
	ORL	$KERNEL_CALL_WRITE << 5, %EDX
.ENDIF
	JMP	do_sio

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$READ
KERNEL$READ:
	MOVL	(%EAX), %EDX
	MOVL	$SYS_READ, %ECX
	MOVL	-4(%EDX), %EDX
.IF KERNEL_CALL_READ <> 0
	ORL	$KERNEL_CALL_READ << 5, %EDX
.ENDIF
do_sio:
	ORL	$0, OFF_SIORQ_progress(%EAX)	/* probe write access */
do_io:
	MOVL	%EAX, OFF_IORQ_tmp1(%EAX)	/* random value, just test for write access, we can take COW fault here but not in kernel */
	MOVL	%EDX, OFF_IORQ_tmp3(%EAX)
	MOVL	OFF_IORQ_status(%EAX), %EDX
	ANDL	$RQS_ACTION_MASK, %EDX
	CMPL	$RQS_PROCESSING, %EDX
	JNE	1f
	MOVL	$RQS_KERNELCANCELABLE, OFF_IORQ_status(%EAX)
2:	MOVL	%EAX, %EDX
	MOVL	%ECX, %EAX
	CALL	SYSCALL2
	JMP	KERNEL$PROCESS_PENDING_AST
	.ALIGN	__CPU_BRANCH_ALIGN
1:	ORL	$0, OFF_IORQ_status(%EAX)	/* probe write access */
	CMPL	$RQS_WANTCANCEL, %EDX
	JNZ	2b
	MOVL	$-EINTR, OFF_IORQ_status(%EAX)
	JMP	*(%EAX)

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$MTX_LOCK_TEST
KERNEL$MTX_LOCK_TEST:
	MOVL	%EAX, %EDX
	MOVL	$1, %ECX
	XORL	%EAX, %EAX
	CMPXCHGL %ECX, (%EDX)
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$MTX_UNLOCK_TEST
KERNEL$MTX_UNLOCK_TEST:
#if __DEBUG >= 1
	CMPL	$0, (%EAX)
	JZ	2f
#endif
	TESTL	$CPU_HAS_CMPXCHG8B, KERNEL$CPU_FEATURES
	PUSHL	%EDI
	LEAL	4(%EAX), %EDX
	MOVL	%EAX, %EDI
	JZ	1f
	MOVL	(%EAX), %EAX
	PUSHL	%EBX
	XORL	%EBX, %EBX
	MOVL	%EDX, %ECX
	CMPXCHG8B (%EDI)
	SETNZ	%AL
	POPL	%EBX
	MOVZBL	%AL, %EAX
1:	POPL	%EDI
	RET

#if __DEBUG >= 1
2:	PUSHL	$7f
	CALL	KERNEL$SUICIDE
	NOP
	.SECTION .rodata
7:	.STRING	"KERNEL$MTX_UNLOCK_TEST: MUTEX NOT LOCKED"
	.PREVIOUS
#endif

	.ALIGN	4
	.GLOBAL	INIT_THREAD_UNBLOCK
	.LONG	SPL_THREAD
INIT_THREAD_UNBLOCK:
	MOVL	KUPLACE(UDATA_STRUCT + OFF_UDATA_init_thread), %EDX
	MOVL	%EDX, 8(%EAX)
	JMP	__UNBLOCK

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$BIO
KERNEL$BIO:
	JMP	KERNEL$BIO_EMU

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$PKTIO
KERNEL$PKTIO:
	MOVL	$-ENOOP, OFF_IORQ_status(%EAX)
	JMP	*(%EAX)

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$GET_JIFFIES
KERNEL$GET_JIFFIES:
	CALL	GET_TIME_SEC
	SHLDL	$16, %EAX, %EDX
	SHLL	$16, %EAX
	ORL	%ECX, %EAX
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$GET_JIFFIES_LO
KERNEL$GET_JIFFIES_LO:
	CALL	GET_TIME_SEC
	SHLL	$16, %EAX
	ORL	%ECX, %EAX
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$READ_MSR
KERNEL$READ_MSR:
	MOVL	$-EUSER, %EAX
	RET

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	KERNEL$WRITE_MSR
KERNEL$WRITE_MSR:
	MOVL	$-EUSER, %EAX
	RET

	.SECTION .bss
	.ALIGN	4
	.GLOBAL	INTR_COUNT
INTR_COUNT:
	.LONG	0
