#include <SPAD/LIBC.H>
#include <SPAD/DL.H>
#include <KERNEL/UDATADEF.H>
#include <STRING.H>

void KERNEL$STACK_DUMP(void)
{
	int x = 0;
	void **esp;
	__const__ char *s;
	unsigned long off;
	__asm__ ("movl %%esp, %0":"=r"(esp));
	while ((unsigned long)esp < *(unsigned long *)UPLACE(UDATA_ORIG_ESP)) {
		if ((s = KERNEL$DL_GET_SYMBOL_NAME(*esp, &off, 1))) {
			if (__likely(off != 0)) {
				__critical_printf("%s%s+%lX", x ? ", " : "", s, off);
				if (__unlikely(x++ >= 50)) break;
				if (__unlikely(strstr(s, "START_THREAD") != NULL)) break;
			}
		}
		esp++;
	}
	__critical_printf("\n\r");	/* we might be in raw tty mode */
}

