#include <ARCH/SETUP.H>
#include <LIB/KERNEL/UTHREADA.H>
#include <KERNEL/UDATADEF.H>
#include <ARCH/CPUDEF.H>

/*
 * IN: %EAX - POINTER TO NEW THREAD
 */

	.SECTION .text
	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	SWITCH_THREAD
SWITCH_THREAD:
	PUSHL	$0
	PUSHL	%EBX
	PUSHL	%ESI
	MOVL	UPLACE(UDATA_STRUCT + OFF_UDATA_current_thread), %ECX
#ifdef ALWAYS_SAVE_FPU
	CMPL	$0, UPLACE(UDATA_COPROCESSOR_USED)
#endif
	PUSHL	%EDI
	PUSHL	%EBP
#ifdef ALWAYS_SAVE_FPU
	JNZ	1f
3:
#endif
	MOVL	%ESP, THREAD_ESP(%ECX)
	MOVL	THREAD_ESP(%EAX), %ESP
	MOVL	%EAX, UPLACE(UDATA_STRUCT + OFF_UDATA_current_thread)
	MOVL	THREAD_ALTSTACK(%EAX), %EDX
	POPL	%EBP
	POPL	%EDI
	MOVL	THREAD_ALTSTACK_SIZE(%EAX), %EAX
	MOVL	%EDX, UPLACE(UDATA_ALTSTACK)
	POPL	%ESI
	POPL	%EBX
	MOVL	%EAX, UPLACE(UDATA_ALTSTACK_SIZE)
	POPL	%EAX
	RET
#ifdef ALWAYS_SAVE_FPU
	.ALIGN	__CPU_BRANCH_ALIGN
1:	MOVL	THREAD_FPU(%ECX), %EDI
	MOVL	THREAD_FPU(%EAX), %ESI
	TESTL	$CPU_HAS_FXSR, KERNEL$CPU_FEATURES
	JZ	2f
	FXSAVE	(%EDI)
	FXRSTOR	(%ESI)
	JMP	3b
	.ALIGN	__CPU_BRANCH_ALIGN
2:	FNSAVE	(%EDI)
	FWAIT
	FRSTOR	(%ESI)
	JMP	3b
#endif

	.ALIGN	__CPU_CALL_ALIGN
	.GLOBAL	END_THREAD
END_THREAD:
	MOVL	UPLACE(UDATA_STRUCT + OFF_UDATA_init_thread), %EBX
#ifdef ALWAYS_SAVE_FPU
	CMPL	$0, UPLACE(UDATA_COPROCESSOR_USED)
	JNZ	1f
3:
#endif
	MOVL	THREAD_ESP(%EBX), %ESP
	MOVL	%EBX, UPLACE(UDATA_STRUCT + OFF_UDATA_current_thread)
	MOVL	THREAD_ALTSTACK(%EBX), %ESI
	MOVL	THREAD_ALTSTACK_SIZE(%EBX), %EDI
	MOVL	%ESI, UPLACE(UDATA_ALTSTACK)
	MOVL	%EDI, UPLACE(UDATA_ALTSTACK_SIZE)
	MOVL	KERNEL$SPL, %ESI
	MOVL	%EAX, %EDI
	MOVL	%EDX, %EAX
	MOVL	%ECX, %EBP
	CALL	*(%EAX)
	TESTL	%EBP, %EBP
	JNZ	4f
	MOVL	%EDI, %EAX
	CALL	FREE_THREAD
4:	POPL	%EBP
	POPL	%EDI
	POPL	%ESI
	POPL	%EBX
	POPL	%EAX
	MOVL	$1, %EAX
	RET
#ifdef ALWAYS_SAVE_FPU
	.ALIGN	__CPU_BRANCH_ALIGN
1:	MOVL	THREAD_FPU(%EBX), %ESI
	TESTL	$CPU_HAS_FXSR, KERNEL$CPU_FEATURES
	JZ	2f
	FXRSTOR	(%ESI)
	JMP	3b
	.ALIGN	__CPU_BRANCH_ALIGN
2:	FRSTOR	(%ESI)
	JMP	3b
#endif

