#include <SPAD/VM.H>
#include <STRING.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <SPAD/SYSLOG.H>

#include <ARCH/BIOS16.H>

#define N_HOLES		128

static __u64 holes[N_HOLES * 2];
static int n_holes = 0;

struct e820desc {
	__u64 base;
	__u64 len;
	__u32 type;
};

#define MAX_E820	128

static __u64 detect_memory(void)
{
	struct e820desc e820desc[MAX_E820];
	struct bios_regs regs;
	__u32 e820state;
	int n, i, mb;
	__u64 cm;

	e820state = 0;
	n = 0;
	e820next:
	memset(&regs, 0, sizeof regs);
	regs.eax = 0xe820;
	regs.edx = 0x534d4150;
	regs.ecx = 20;
	regs.ebx = e820state;
	regs.es = 0;
	regs.edi = BIOS_PTR_BASE;
	if (BIOS16$REAL_INT(0x15, &regs, &e820desc[n], sizeof(struct e820desc), BIOS_DATA_GET)) goto skipe820;
	if (regs.flags & FLAGS_CF) goto skipe820;
	if (regs.eax != 0x534d4150) goto skipe820;
	e820state = regs.ebx;
	n++;
	if (e820state) {
		if (n < MAX_E820) goto e820next;
		KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, "SETMEM", "TOO MANY MEMORY ENTRIES, SKIPPING");
	}

	cm = 0;

	/*
	for (i = 0; i < n; i++) {
		__debug_printf("e820: %Lx, %Lx, %x\n", e820desc[i].base, e820desc[i].len, e820desc[i].type);
	}
	*/

	scan_entries:
	mb = -1;
	for (i = 0; i < n; i++) if (e820desc[i].type == 1 && e820desc[i].len && e820desc[i].base >= cm && (mb == -1 || e820desc[i].base < e820desc[mb].base)) mb = i;
	if (mb == -1) {
		nmh:
		if (!cm) {
			KERNEL$SYSLOG(__SYSLOG_SW_WARNING, "SETMEM", "E820 DIDN'T RETURN ANY MEMORY, TRYING E801");
			goto skipe820;
		}
		return cm;
	}
	if (e820desc[mb].base > cm) {
		if (n_holes == N_HOLES) {
			KERNEL$SYSLOG(__SYSLOG_HW_INCOMPATIBILITY, "SETMEM", "TOO MANY HOLES, SKIPPING");
			goto nmh;
		}
		holes[n_holes * 2] = cm;
		holes[n_holes * 2 + 1] = e820desc[mb].base;
		n_holes++;
	}
	cm = e820desc[mb].base + e820desc[mb].len;
	goto scan_entries;

	skipe820:
	memset(&regs, 0, sizeof regs);
	regs.eax = 0xe801;
	if (BIOS16$REAL_INT(0x15, &regs, NULL, 0, 0)) goto skipe801;
	if (regs.flags & FLAGS_CF) goto skipe801;
	regs.eax &= 0xffff;
	regs.ebx &= 0xffff;
	regs.ecx &= 0xffff;
	regs.edx &= 0xffff;
	if (!regs.ecx) regs.ecx = regs.eax;
	if (!regs.edx) regs.edx = regs.ebx;
	if (!regs.ecx) goto skipe801;
	if (regs.edx) {
		if (regs.ecx != 0x3c00) {
			holes[0] = 0x100000 + regs.ecx * 1024;
			holes[1] = 0x1000000;
			n_holes = 1;
		}
		return 0x1000000 + (__u64)regs.edx * 65536;
	}
	return 0x100000 + regs.ecx * 1024;

	skipe801:
	memset(&regs, 0, sizeof regs);
	regs.eax = 0x8800;
	if (BIOS16$REAL_INT(0x15, &regs, NULL, 0, 0)) goto skip88;
	if (regs.flags & FLAGS_CF) goto skip88;
	regs.eax &= 0xffff;
	if (!regs.eax) goto skip88;
	return 0x100000 + regs.eax * 1024;

	skip88:
	return 0;
}

int main(int argc, char *argv[])
{
	int r;
	__u64 mem64, dmem64;
	if (__likely(argc < 2)) {
		mem64 = detect_memory();
		if (__unlikely(!mem64)) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETMEM: UNABLE TO DETECT MEMORY SIZE");
			r = -EIO;
			goto retn;
		} else {
			_printf("SETMEM: DETECTED %"__64_format"d BYTES OF MEMORY\n", mem64);
		}
	} else {
		if (__unlikely(argc != 2) || __get_64_number(argv[1], argv[1] + strlen(argv[1]), 0, &mem64)) {
			r = -EBADSYN;
			goto err;
		}
		dmem64 = detect_memory();
		if (__likely(dmem64 > 0) && __unlikely(mem64 > dmem64)) {
			_eprintf("SETMEM: WARNING: SETTING MORE MEMORY (%"__64_format"d) THAN DETECTED (%"__64_format"d)\n", mem64, dmem64);
			_eprintf("SETMEM: EXPECT PROCESSES CRASH OR SYSTEM CRASH OR CORRUPTED FILESYSTEM\n");
		}
	}
	RAISE_SPL(SPL_BOTTOM);
	r = KERNEL$SET_MEMORY_LIMIT(mem64, holes, n_holes);
	LOWER_SPL(SPL_ZERO);
	err:
	if (r) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SETMEM: %s", strerror(-r));
	retn:
	return r;
}


