#include <DOC.H>

$DOC_INTERFACE(CALL_AST,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(CALL_AST($ARG(ast));)

$DESCRIPTION(
This is a preprocessor macro that expands to machine- and compiler-dependent
code to call an AST. If current $LINK(KERNEL$SPL, SPL) is lower than AST's SPL,
the AST function is executed immediatelly, otherwise the AST is queued. There
is no way to cancel an AST $MDASH once queued, the $CODE(AST) structure must be
valid and unchanged until AST function is entered. The structure may be freed or
modified in the AST function.
)

$ARGUMENTS(
$ARGUMENT(ast,
Pointer to structure $LINK(AST, AST) (or any structure that begins with
$LINK(AST_HEAD, AST_HEAD)) that will be called. The structure must
have valid entry $CODE(fn) pointing to AST function declared with
$LINK(DECL_AST, DECL_AST).
)
)

$IMPLEMENTATION(ASTs on the same SPL are called in the same order they were
queued, but the programmer must not depend on it for correctness. The programmer
may
depend on this feature for good performance (for example networking packets are
queued with this call $MDASH the protocols are required to handle out-of-order
packets correctly, altough it causes performance degradation).)

$SEE_ALSO($LINK(DECL_AST, DECL_AST), $LINK(CALL_IORQ, CALL_IORQ),
$LINK(KERNEL$SPL, KERNEL$SPL))

)

$IGNORE(
vim: textwidth=80
)
