#include <DOC.H>

$DOC_INTERFACE(CALL_IORQ_LSTAT,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(CALL_IORQ_LSTAT($ARG(iorq), $ARG(handler));)

$DESCRIPTION(
This is a preprocessor macro that expands to machine- and compiler-dependent
code to call an IORQ. Its functionality is similar to
$LINK(CALL_IORQ,CALL_IORQ), except that it expects that the IORQ status was
already initialized and leaves it untouched.
)

$ARGUMENTS(
$ARGUMENT(iorq,
Pointer to structure $LINK(IORQ,IORQ) (or any structure that begins with
$LINK(IORQ_HEAD,IORQ_HEAD)) that will be called. The structure must
have valid entry $CODE(fn) pointing to AST function declared with
$LINK(DECL_AST,DECL_AST). The status field of this structure must have been
already initialized with
$LINK(CALL_IORQ,CALL_IORQ),
$LINK(CALL_IORQ_CANCELABLE,CALL_IORQ_CANCELABLE),
$LINK(RETURN_IORQ,RETURN_IORQ) or
$LINK(RETURN_IORQ_CANCELABLE,RETURN_IORQ_CANCELABLE).
)
$ARGUMENT(handler,
A function declared with $LINK(DECL_IOCALL,DECL_IOCALL). It must not be a
pointer (if you need a handler specified with pointer, use
$LINK(CALL_IORQ_LSTAT_EXPR,CALL_IORQ_LSTAT_EXPR)$).
)
)

$IMPLEMENTATION(IORQs on the same SPL are called in the same order they were
queued, but the programmer must not depend on it for correctness. The programmer
may
depend on this feature for good performance (for example networking packets are
queued with this call $MDASH the protocols are required to handle out-of-order
packets correctly, altough it causes performance degradation).)

$EXAMPLE(

$CODE(
$LINK(DECL_IOCALL,DECL_IOCALL)(FUNCTION, SPL_DEV, IORQ)$NL
{$NL
$TAB()some code...$NL
$TAB()CALL_IORQ_LSTAT(RQ, FUNCTION2);$NL
$TAB()RETURN;$NL
}$NL
$NP
$LINK(DECL_IOCALL,DECL_IOCALL)(FUNCTION2, SPL_DEV, IORQ)$NL
...
)

$NP

In this example, $CODE(FUNCTION) passes its IORQ to $CODE(FUNCTION2). IORQ was
already initialized when the caller posted it to $CODE(FUNCTION).

$NP

If there were $LINK(CALL_IORQ,CALL_IORQ), the code would be buggy with respect
to canceling an IO request. If cancel was attempted after entry to
$CODE(FUNCTION) but before $CODE(CALL_IORQ), $CODE(CALL_IORQ) would erase the
cancel status and the cancel request would be missed. $CODE(CALL_IORQ_LSTAT)
doesn't change status $MDASH so the cancel status will be pending until
$CODE(FUNCTION2) either returns the request immediatelly or attempt to add it to
a wait queue 
(at which point it discovers the pending cancel and returns $CODE(-EINTR)
instead of queueing it).

)

$SEE_ALSO(
$LINK(CALL_IORQ, CALL_IORQ),
$LINK(DECL_IOCALL, DECL_IOCALL))

)

$IGNORE(
vim: textwidth=80
)
