#include <DOC.H>

$DOC_INTERFACE(CALL_IORQ_LSTAT_EXPR,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(CALL_IORQ_LSTAT_EXPR($ARG(iorq), $ARG(handler));)

$DESCRIPTION(
This macro has the same functionality as $LINK(CALL_IORQ_LSTAT,CALL_IORQ_LSTAT),
except that
$ARG(handler) may be an expression. When $ARG(handler) is a simple function, use
$LINK(CALL_IORQ_LSTAT,CALL_IORQ_LSTAT) $MDASH it generates faster code.
)

$ARGUMENTS(
$ARGUMENT(iorq,
See definition of $LINK(CALL_IORQ_LSTAT,CALL_IORQ_LSTAT).
)
$ARGUMENT(handler,
A poitner with type $LINK(IO_STUB,IO_STUB). It points to a function
declared with $LINK(DECL_IOCALL,DECL_IOCALL).
$NL
Note: The expression itself is evaluated at $CODE(SPL_TOP), so all rules for
this SPL apply. It shouldn't contain a loop and it can only call functions that
don't block and that can be called on SPL_TOP. If you need more complex
expression, evaluate it outside $CODE(CALL_IORQ_EXPR), store it to a variable
and pass the variable to $CODE(CALL_IORQ_EXPR).
)
)

$SEE_ALSO($LINK(CALL_IORQ_LSTAT, CALL_IORQ_LSTAT), $LINK(IO_STUB, IO_STUB))

)

$IGNORE(
vim: textwidth=80
)
