#include <DOC.H>

$DOC_INTERFACE(DECL_IOCALL,

$TYPE_MACRO_FUNCTION_HEADER

$ENVIRONMENT(User/kernel, Async, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/AC.H)
)

$FORMAT(DECL_AST($ARG(function_name), $ARG(spl), $ARG(structure)))$NL
$CODE({$NL
$TAB()$AUX_TEXT(function code...)$NL
$TAB()$LINK(RETURN, RETURN) $AUX_TEXT( or )
$LINK(RETURN_AST, RETURN_AST) $AUX_TEXT( or )
$LINK(RETURN_IORQ, RETURN_IORQ) $AUX_TEXT( or )
$LINK(RETURN_IORQ_LSTAT, RETURN_IORQ_LSTAT) $AUX_TEXT( or )
$LINK(RETURN_IORQ_CANCELABLE, RETURN_IORQ_CANCELABLE)
$NL
})

$DESCRIPTION(
Declares function usable for IORQ handler. Macro $CODE(DECL_IOCALL) expands to
machine-dependent and compiler-dependent function header. The function must
return with one of $CODE(RETURN*) macros (they expand to machine- and
compiler-dependent return code). There may be more $CODE(RETURN) statements. The
function has one argument, $CODE(RQ), that points to IORQ being posted.
)

$ARGUMENTS(
$ARGUMENT(function_name,
Name of the IORQ handler. The macro declares $ARG(function_name) as global
function of
type $LINK(IO_STUB, IO_STUB *). The function may be assigned to other
variables of type $LINK(IO_STUB, IO_STUB *) or it may be passed to
$LINK(CALL_IORQ,CALL_IORQ)... or $LINK(RETURN_IORQ,RETURN_IORQ)... family of
macros.
The return type, arguments and
attributes of the function are machine- and compiler-dependent.
)
$ARGUMENT(spl, Spl at which the function runs. It is one of SPL_* constants or
numeric constant between 0 and 30. During execution of the function, SPL must
not be
lowered below value specified in $ARG(spl) argument. SPL may be raised or
lowered down to $ARG(spl).)
$ARGUMENT(structure, This is a type that begins with $LINK(IORQ_HEAD,
IORQ_HEAD). Or it can be $LINK(IORQ).
Function has one argument, named $CODE(RQ) that has this type.
The $ARG(structure) argument doesn't have effect on behavior of code, it is
just a convenience, so that the programmer doesn't have to cast $CODE(RQ)
argument each time it is used.
)
)

$SEE_ALSO($LINK(DECL_AST, DECL_AST), $LINK(IORQ, IORQ),
$LINK(AST_HEAD, AST_HEAD), $LINK(IORQ_HEAD, IORQ_HEAD))

)

$IGNORE(
vim: textwidth=80
)
