#include <DOC.H>

$DOC_INTERFACE(IORQ_HEAD,

$TYPE_MACRO_STRUCTURE_ENTRIES

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(struct s { IORQ_HEAD; more entries ...; };)

$DESCRIPTION(
This macro can be prepended at the beginning of a structure to add IORQ entries.
The strucure with $CODE(IORQ_HEAD) at the beginning can be cast to structure
$CODE(AST) or structure $CODE(IORQ) and can be passed to functions and macros
that expect $CODE(AST) or $CODE(IORQ).

$NP

$CODE(IORQ_HEAD) adds these entries to the structure:$NL
$CODE($LINK(AST_STUB,AST_STUB) *fn;)$NL
$CODE(unsigned long tmp1;)$NL
$CODE(unsigned long tmp2;)$NL
$CODE(unsigned long tmp3;)$NL
$CODE(unsigned long status;)$NL
It may add additional architecture-specific entries.
)

$SEE_ALSO($LINK(AST_HEAD, AST_HEAD), $LINK(AST, AST), $LINK(IORQ, IORQ))

)

$IGNORE(
vim: textwidth=80
)
