#include <DOC.H>

$DOC_INTERFACE(KERNEL$CIO,

$TYPE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(void KERNEL$CIO($LINK(IORQ,IORQ) *$ARG(iorq));)

$DESCRIPTION(
This function requests cancel of a pending IORQ.
$CODE(KERNEL$CIO) will return immediatelly but the cancel may take some time
and the caller must wait for an AST to arrive. If the IORQ was canceled, AST
will be called with status $CODE(-EINTR). Even after a call to $CODE(KERNEL$CIO)
AST may return with status different from $CODE(-EINTR) $MDASH in this case the
request was completed normally.

$NL

When $CODE(KERNEL$CIO) is called after the status has been set and AST posted,
it performs nothing.

$NP

$CODE(KERNEL$CIO) guarantees that the request will terminate in finite time, but
it doesn't force immediate cancel. The cancelation possibility differs from
device to device.
$NL
For example, when canceling a direct IO request on disk, there
is very little possibility to stop already running bus-master controller $MDASH
thus the request is not canceled immediatelly and normal transferred byte count
is returned. In this case, the specification is not violated because we know
that the transfer must finish in finite time.
$NL
When canceling read request on a network socket, the request can take infinite
time (when the other side is not sending anything) and cancel possibility must
be implemented.
$NL
The caller of $CODE(KERNEL$CIO) shouldn't expect one of these cases happen
$MDASH it is up to the device driver to choose if it wants to cancel the request
or wants to finish it.
)

$ARGUMENTS(
$ARGUMENT(iorq,
Pointer to structure $LINK(IORQ,IORQ) (or any structure that begins with
$LINK(IORQ_HEAD,IORQ_HEAD)) that will be canceled. The IORQ must have been
already posted with $LINK(CALL_IORQ,CALL_IORQ)... or
$LINK(RETURN_IORQ,RETURN_IORQ)... family of macros.
)
)

$SEE_ALSO($LINK(DECL_AST, DECL_AST), $LINK(CALL_IORQ, CALL_IORQ))

)

$IGNORE(
vim: textwidth=80
)
