#include <DOC.H>

$DOC_INTERFACE(LOWER_SPLX,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(LOWER_SPLX($ARG(splx)))

$DESCRIPTION(
Lowers SPL to a given value. $ARG(splx) must be lower or equal than current SPL
($LINK(KERNEL$SPL,KERNEL$SPL)). This macro issues a proper compiler
memory-barrier, so that the compiler doesn't try to reorder code around
SPL-lowering instruction. After lowering the SPL, this macro calls immediatelly
any ASTs or IORQs that were pending above the new SPL.
)

$ARGUMENTS(
$ARGUMENT(splx,
This must be valid internal SPL, as obtained from $CODE(SPL_X) or
by other means (reading $CODE(KERNEL$SPL)). It must be lower or equal than
current SPL.
)
)

$IMPLEMENTATION(When $LINK(__DEBUG,__DEBUG) is $GT()= 2, the macro performs a
check if current SPL is higher or equal than new SPL. It also performs a check
if the argument is correct.
)

$SEE_ALSO($LINK(RAISE_SPL, RAISE_SPL), $LINK(RAISE_SPLX, RAISE_SPLX),
$LINK(LOWER_SPL, LOWER_SPL)
$LINK(SPL_X, SPL_X))

)

$IGNORE(
vim: textwidth=80
)
