#include <DOC.H>

$DOC_INTERFACE(RETURN,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Async, No, Higher or equal than SPL of AST or IORQ, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(RETURN;)

$DESCRIPTION(
Returns out of function declared with $LINK(DECL_AST, DECL_AST) or
$LINK(DECL_IOCALL, DECL_IOCALL). After the return, next pending AST with highest
SPL
is executed or return to synchronous context is made.
$NP
Use of this macro outside function bodies declared with $LINK(DECL_AST,
DECL_AST) or $LINK(DECL_IOCALL, DECL_IOCALL) is prohobited.
$NP
SPL doesn't have to be lowered before call to $CODE(RETURN).
)

$SEE_ALSO($LINK(DECL_IOCALL, DECL_IOCALL), $LINK(DECL_AST, DECL_AST))

)

$IGNORE(
vim: textwidth=80
)
