#include <DOC.H>

$DOC_INTERFACE(RETURN_AST,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Async, No, Higher or equal than SPL of AST or IORQ, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(RETURN_AST($ARG(ast));)

$DESCRIPTION(
The behavior of $CODE(RETURN_AST($ARG(ast))) is equivalent to $NL $CODE(
$LINK(CALL_AST, CALL_AST)($ARG(ast)));$NL
$CODE($LINK(RETURN, RETURN);$NL)
$CODE(RETURN_AST) is faster than the above sequence, because in most cases AST
doesn't have to be queued and then extracted from the queue.
)

$ARGUMENTS(
$ARGUMENT(ast, See arguments in $LINKTAG(CALL_AST, ARGTAG, CALL_AST))
)

$IMPLEMENTATION(
There is slight difference between $LINK(CALL_AST, CALL_AST); $LINK(RETURN,
RETURN) and $CODE(RETURN_AST): $LINK(CALL_AST, CALL_AST) and $LINK(RETURN,
RETURN) queue the AST after all ASTs on a given SPL, but $CODE(RETURN_AST)
executes the AST directly, jumping the queue. Because order of executing ASTs is
not defined, code must be written in such a way that this difference doesn't
change behavior.
)

$SEE_ALSO($LINK(CALL_AST, CALL_AST), $LINK(RETURN, RETURN), $LINK(DECL_AST,
DECL_AST))

)

$IGNORE(
vim: textwidth=80
)
