#include <DOC.H>

$DOC_INTERFACE(struct bios_regs,

$TYPE_TYPE

$INCLUDES(
$INCLUDE(ARCH/BIOS16.H)
)

$FORMAT(struct bios_regs variable;)

$DESCRIPTION(
This structure declares bios registers that will be passed to and from real-mode
interrupt.

$NP

It contains the following entries:$NL
$CODE($LINK(__U32,__u32) eax, ecx, edx, ebx, ebp, esi, edi;)$NL
$CODE($LINK(__U16,__u16) es, ds, fs, gs;)$NL
$CODE($LINK(__U8,__u8) flags;)$NL
Flags are OR of the following constants:$NL
$CODE(FLAGS_CF), $CODE(FLAGS_PF), $CODE(FLAGS_AF), $CODE(FLAGS_ZF),
$CODE(FLAGS_SF).$NL
The constants are equivalent to:$NL
$CODE(1 << P_FLAGS_CF), $CODE(1 << P_FLAGS_PF), $CODE(1 << P_FLAGS_AF), $CODE(1
<< P_FLAGS_ZF), $CODE(1 << P_FLAGS_SF).
)

$SEE_ALSO($LINK(BIOS16$REAL_INT, BIOS16$REAL_INT))

)

$IGNORE(
vim: textwidth=80
)
