#include <DOC.H>

$DOC_INTERFACE(TEST_SPL,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(TEST_SPL($ARG(spllow), $ARG(splhigh)))

$DESCRIPTION(
$ARG(splhigh) must be equivalent to current SPL.
This is the equivalent of
$CODE($LINK(TEST_SPLX,TEST_SPLX)($LINK(SPL_X,SPL_X)($ARG(spllow)),
$LINK(SPL_X,SPL_X)($ARG(splhigh)))). See definition of
$LINK(TEST_SPLX,TEST_SPLX).
)

$ARGUMENTS(
$ARGUMENT(spllow,
A constant number in the range 0 $NDASH 30. It must be lower of equal than
current SPL.
)
$ARGUMENT(splhigh,
A constant number in the range 0 $NDASH 30. It must be equal to the current SPL.
)
)

$IMPLEMENTATION(The macro performs a
compile-time check for correct argument.
$NP
When $LINK(__DEBUG,__DEBUG) is $GT()= 2, the macro performs a
check if current SPL is higher or equal than new SPL.
)

$SEE_ALSO($LINK(SPL_X, SPL_X),
$LINK(TEST_SPLX, TEST_SPLX))

)

$IGNORE(
vim: textwidth=80
)
