#include <DOC.H>

$DOC_INTERFACE(TEST_SPLX,

$TYPE_MACRO_COMMAND

$ENVIRONMENT(User/kernel, Sync/async, No, Any, No)

$INCLUDES(
$INCLUDE(SPAD/AC.H)
)

$FORMAT(TEST_SPLX($ARG(splxlow), $ARG(splxhigh)))

$DESCRIPTION(
$ARG(splxhigh) must be equal to current SPL.
This is equivalent to $CODE(LOWER_SPLX($ARG(splxlow));
RAISE_SPLX($ARG(splxhigh))) $MDASH i.e. it tests if there are some events
pending above $ARG(splxlow), performs the events and raises SPL back. This macro
is slightly faster than the above code sequence, because it doesn't lower and
raise SPL if there are no events.
)

$ARGUMENTS(
$ARGUMENT(splxlow,
This must be valid internal SPL, as obtained from $CODE(SPL_X) or
by other means (reading $CODE(KERNEL$SPL)). Must be lower or equal than current
SPL.
)
$ARGUMENT(splxhigh,
This must be valid internal SPL, as obtained from $CODE(SPL_X) or
by other means (reading $CODE(KERNEL$SPL)). Must be equal to current SPL.
)
)

$IMPLEMENTATION(
If the arguments are constant, compile-time check for correctness is made.
When $LINK(__DEBUG,__DEBUG) is $GT()= 2, the macro performs a
run-time check if the current SPL is equal to $ARG(splxhigh) and if
$ARG(splxlow) is lower.
)

$SEE_ALSO($LINK(RAISE_SPLX, RAISE_SPLX),
$LINK(LOWER_SPLX, LOWER_SPLX)
$LINK(SPLX_BUSY, SPLX_BUSY)
$LINK(TEST_SPL, TEST_SPL)
$LINK(SPL_X, SPL_X))

)

$IGNORE(
vim: textwidth=80
)
