#include <DOC.H>

$DOC_INTERFACE(__PrefixOpSuffixCondition,

$TYPE_INLINE_FUNCTION

$ENVIRONMENT(User/kernel, Sync/async/rt-irq, No, Any, No)

$INCLUDES(
$INCLUDE(ARCH/BITOPS.H)
)

$FORMAT(static $LINK(__FINLINE__,__finline__) int
$NOP(__)$ARG(Prefix)$ARG(Op)$ARG(Suffix)$ARG(Condition)(type *$ARG(ptr), type
$ARG(val));)

$DESCRIPTION(
This family of inline functions perform an atomic logical operation on
memory. The operation will be performed between $ARG(val) and $ARG(ptr) location
and the result will be stored at $ARG(ptr) location. Additionally, they return a
status returned by the operation.
$NP
Parts of function name $MDASH $ARG(Op), $ARG(Suffix), $ARG(Prefix) and
$ARG(Condition) determine
logical operation, data type, atomicity requirements and returned condition.
)

$ARGUMENTS(
$ARGUMENT(Prefix, This is the part of function name. It specifies atomicity of
the operation.
$CONSTANTS(
$CONSTANT(empty, Perform an operation that is atomic with respect to events on
the CPU itself (ASTs or real time interrupts) but it is not atomic with respect
to other CPUs or busmasters.)
$CONSTANT(LOCK_, The operation will contain lock prefix, making it atomic with
respect to other CPUs and bus mastering devices.)
)
)
$ARGUMENT(Op, Determine the operation itself. Possibilities:
$CONSTANTS(
$CONSTANT(ADD, Adding two values.)
$CONSTANT(SUB, Subtract $ARG(val) from memory location.)
)
)
$ARGUMENT(Suffix, This is the part of function name. It determines argument
types:
$CONSTANTS(
$CONSTANT(C, argument has the type signed or unsigned char or $LINK(__S8, __s8)
or $LINK(__U8, __u8).)
$CONSTANT(I, argument has the type signed or unsigned int.)
$CONSTANT(L, argument has the type signed or unsigned long.)
$CONSTANT(32, argument has the type $LINK(__U32, __u32) or $LINK(__S32, __s32).)
)
)
$ARGUMENT(Condition, This is the part of functino name. It determines condition
that will be returned:
$CONSTANTS(
$CONSTANT(C, a carry flag was set)
$CONSTANT(NZ, the result is non-zero)
$CONSTANT(S, the result is negative)
)
)
$ARGUMENT(ptr, Pointer pointing to a memory location that should be atomically
changed.)
$ARGUMENT(val, A value that will be bitwise-ORed at location $ARG(ptr).)
)

$RETURNS(If the condition was true after the operation, 1 is returned.
Otherwise, 0 is returned.)

$SEE_ALSO(
$LINK(__BITOPS,__PrefixOpSuffix)
$LINK(__CMPXCHG,__PrefixCMPXCHGSuffix)
)

)

$IGNORE(
vim: textwidth=80
)
